/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.GoAnnotations;
import edu.cmu.cs.sb.core.StatUtil;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui;
import edu.cmu.cs.sb.drem.DREMGui_FilterGOModel;
import edu.cmu.cs.sb.drem.DREMGui_KeyInputs;
import edu.cmu.cs.sb.drem.DREM_DataSet;
import edu.cmu.cs.sb.drem.DREM_GoAnnotations;
import edu.cmu.cs.sb.drem.DREM_Timeiohmm;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class DREMGui_GOFilter
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener {
    static final Color bgColor = Color.white;
    static final Color fgColor = Color.black;
    int ninitval = 0;
    boolean bsplitgolabels = false;
    boolean ballgenes = true;
    JSlider theSlider;
    Hashtable theDictionary;
    String szGO;
    double[] tfVals;
    DREMGui_FilterGOModel hmst;
    TableSorter sorter;
    DREM_Timeiohmm theTimeiohmm;
    DREMGui theDREMGui;
    int numrows;
    int numcols;
    JButton unapplyButton;
    JButton hideButton;
    JFrame theFrame;
    ListSelectionModel rowSM;
    JFrame defineframe;
    JRadioButton pathButton;
    JRadioButton splitButton;
    JRadioButton allButton;
    JRadioButton selectButton;
    ButtonGroup enrichmentGroup = new ButtonGroup();
    ButtonGroup countGroup = new ButtonGroup();
    double dgopval = 0.001;
    JLabel pvalLabel;
    JButton colorButton;
    DREM_DataSet theDataSet;
    GoAnnotations tga;
    DREM_Timeiohmm.Treenode rootptr;

    public DREMGui_GOFilter(JFrame jFrame, DREMGui dREMGui, DREM_GoAnnotations.RecIDdrem[] recIDdremArray, final DREM_Timeiohmm.Treenode treenode) {
        this.theFrame = jFrame;
        this.theDREMGui = dREMGui;
        this.theTimeiohmm = dREMGui.theTimeiohmm;
        this.theDataSet = dREMGui.theTimeiohmm.theDataSet;
        this.tga = this.theDataSet.tga;
        this.rootptr = treenode;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        int n = (int)Math.round(-10.0 * Math.log(this.dgopval) / Math.log(10.0));
        this.pvalLabel = new JLabel("X = " + (double)n / 10.0 + "; p-value threshold is " + DREMGui_KeyInputs.doubleToSz(Math.pow(10.0, (double)(-n) / 10.0)));
        this.theSlider = new JSlider(0, 120, n);
        this.theDictionary = new Hashtable();
        for (int i = 0; i <= 12; ++i) {
            this.theDictionary.put(new Integer(i * 10), new JLabel("" + i));
        }
        this.theSlider.setLabelTable(this.theDictionary);
        this.theSlider.setMajorTickSpacing(10);
        this.theSlider.setMinorTickSpacing(5);
        this.theSlider.setPaintTicks(true);
        this.theSlider.setPaintLabels(true);
        this.theSlider.addChangeListener(this);
        this.theSlider.setPaintTicks(true);
        this.numcols = 4;
        this.numrows = recIDdremArray.length;
        Object[][] objectArray = new Object[this.numrows][this.numcols];
        String[] stringArray = new String[this.numcols];
        stringArray[0] = "GO ID";
        stringArray[1] = "GO Category";
        stringArray[2] = "p-val overall";
        stringArray[3] = "p-val split";
        for (int i = 0; i < this.numrows; ++i) {
            objectArray[i][0] = recIDdremArray[i].szID;
            objectArray[i][1] = recIDdremArray[i].szName;
            objectArray[i][2] = Util.doubleToSz(recIDdremArray[i].dminoverallpval);
            objectArray[i][3] = Util.doubleToSz(recIDdremArray[i].dminsplitpval);
        }
        this.hmst = new DREMGui_FilterGOModel(objectArray, stringArray);
        this.sorter = new TableSorter(this.hmst);
        JTable jTable = new JTable(this.sorter);
        this.sorter.setTableHeader(jTable.getTableHeader());
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(60);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(180);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(50);
        tableColumn = jTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(50);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(340, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 200)));
        jTable.setSelectionMode(0);
        this.rowSM = jTable.getSelectionModel();
        final DREMGui dREMGui2 = dREMGui;
        this.rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    return;
                }
                int n = listSelectionModel.getMinSelectionIndex();
                DREMGui_GOFilter.this.szGO = (String)DREMGui_GOFilter.this.sorter.getValueAt(n, 0);
                dREMGui2.selectGO(DREMGui_GOFilter.this.szGO);
                DREMGui_GOFilter.this.addGOLabels(treenode);
                DREMGui_GOFilter.this.setGOLabelTextVisible(treenode, dREMGui2.bshowgolabels && (dREMGui2.bglobalnode || !dREMGui2.battachlabels));
                DREMGui_GOFilter.this.hideButton.setEnabled(true);
                DREMGui_GOFilter.this.unapplyButton.setEnabled(true);
            }
        });
        this.add(jScrollPane);
        jScrollPane.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel("  Only display GO enrichments with a p-value less than 10^-X where X is:");
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
        this.add(this.theSlider);
        this.theSlider.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.pvalLabel);
        jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel2);
        jPanel2.setBackground(Color.white);
        jPanel2.setAlignmentX(0.0f);
        JPanel jPanel3 = new JPanel();
        JLabel jLabel2 = new JLabel("counts should be based on ");
        jPanel3.setBackground(Color.white);
        jPanel3.add(jLabel2);
        this.selectButton = new JRadioButton("Selected Genes");
        this.allButton = new JRadioButton("All Genes");
        this.pathButton = new JRadioButton("Overall Enrichments");
        this.splitButton = new JRadioButton("Split Enrichments");
        this.countGroup.add(this.selectButton);
        this.countGroup.add(this.allButton);
        this.selectButton.addItemListener(this);
        this.allButton.addItemListener(this);
        this.selectButton.setBackground(Color.white);
        this.allButton.setBackground(Color.white);
        jPanel3.add(this.allButton);
        jPanel3.add(this.selectButton);
        this.add(jPanel3);
        if (this.ballgenes) {
            this.allButton.setSelected(true);
        } else {
            this.selectButton.setSelected(true);
        }
        jPanel3.setAlignmentX(0.0f);
        jPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        JPanel jPanel4 = new JPanel();
        JLabel jLabel3 = new JLabel("p-values should be");
        jPanel4.setBackground(Color.white);
        jPanel4.add(jLabel3);
        this.enrichmentGroup.add(this.pathButton);
        this.enrichmentGroup.add(this.splitButton);
        this.pathButton.addItemListener(this);
        this.splitButton.addItemListener(this);
        if (this.bsplitgolabels) {
            this.splitButton.setSelected(true);
        } else {
            this.pathButton.setSelected(true);
        }
        this.pathButton.setBackground(Color.white);
        this.splitButton.setBackground(Color.white);
        jPanel4.add(this.pathButton);
        jPanel4.add(this.splitButton);
        this.add(jPanel4);
        jPanel4.setAlignmentX(0.0f);
        jPanel4.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        JPanel jPanel5 = new JPanel();
        jPanel5.setBackground(Color.white);
        this.hideButton = new JButton("Hide GO Labels");
        this.hideButton.setEnabled(false);
        this.hideButton.setActionCommand("hide");
        this.hideButton.addActionListener(this);
        this.colorButton = new JButton("Change Labels Color");
        this.colorButton.setActionCommand("color");
        this.colorButton.setMinimumSize(new Dimension(800, 20));
        this.colorButton.addActionListener(this);
        this.colorButton.setForeground(dREMGui.goLabelColor);
        jPanel5.add(this.hideButton);
        jPanel5.add(this.colorButton);
        jPanel5.setAlignmentX(0.0f);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel5.add(jButton);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(Color.white);
        jPanel6.setAlignmentX(0.0f);
        this.unapplyButton = new JButton("Unapply GO Selection Constraints");
        this.unapplyButton.setActionCommand("unapply");
        this.unapplyButton.addActionListener(this);
        if (this.tga.szSelectedGO == null) {
            this.unapplyButton.setEnabled(false);
        } else {
            this.unapplyButton.setEnabled(true);
        }
        jPanel6.add(this.unapplyButton);
        jPanel6.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        jPanel5.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel6);
        this.add(jPanel5);
    }

    void setGOLabelTextColor(DREM_Timeiohmm.Treenode treenode, Color color) {
        if (treenode != null) {
            treenode.goText.setTextPaint(color);
            for (int i = 0; i < treenode.numchildren; ++i) {
                this.setGOLabelTextColor(treenode.nextptr[i], color);
            }
        }
    }

    void setGOLabelTextVisible(DREM_Timeiohmm.Treenode treenode, boolean bl) {
        if (treenode != null) {
            treenode.goText.setVisible(bl);
            for (int i = 0; i < treenode.numchildren; ++i) {
                this.setGOLabelTextVisible(treenode.nextptr[i], bl);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting()) {
            this.dgopval = Math.pow(10.0, (double)(-jSlider.getValue()) / 10.0);
            this.pvalLabel.setText("X = " + (double)jSlider.getValue() / 10.0 + "; p-value threshold is " + DREMGui_KeyInputs.doubleToSz(this.dgopval));
            this.addGOLabels(this.rootptr);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.bsplitgolabels = !this.pathButton.isSelected();
        this.ballgenes = this.allButton.isSelected();
        this.addGOLabels(this.rootptr);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        boolean bl = false;
        if (string.equals("color")) {
            Color color = JColorChooser.showDialog(this, "Choose Color", this.theDREMGui.goLabelColor);
            if (color != null) {
                this.theDREMGui.goLabelColor = color;
                this.colorButton.setForeground(color);
                this.setGOLabelTextColor(this.rootptr, color);
            }
        } else if (string.equals("help")) {
            String string2 = "This window allows one to reduce the set of genes currently displayed on the main interface to those that also belong to a certain GO category.  The GO category is selected by clicking on a row of the table. To change the GO category one simply needs to click on a different row of the the table.  To no longer select genes by any GO category press the 'Unapply GO Selection Constraints' button. When genes are selected by a GO category, significant p-values appear on the map to the immediate right of nodes on the map. The threshold for significant p-values is defined based on the value on the slider. Let X be the value of the slider then 10^(-X) is the p-value threshold. The 'counts should be based on' can be set to 'All Genes' or 'Selected Genes'. Under the 'All Genes' options the counts and enrichments calculations consider all genes going through the path. Under the 'Selected Genes' option counts and enrichments calculations consider only the set of genes going through the path and meeting the other selection constraints (Selection by TF and Gene Set). There is also the option 'p-values should be', which can be 'Overall Enrichments' or 'Split Enrichments'. Overall enrichments compute p-value where the base set of genes is all genes in the expression data file or the 'Pre-filtered Gene File'. Split enrichments are based on just the genes assigned to the prior split. Pressing the 'Hide Labels' button hides these labels on the map. To change the colors of these labels press the 'Change Labels' button. The color of the text of this button will match the color of the GO labels on the map.";
            Util.renderDialog(this.theFrame, string2, -300, -100);
        } else if (string.equals("hide")) {
            if (this.theDREMGui.bshowgolabels) {
                this.theDREMGui.bshowgolabels = false;
                this.hideButton.setText("Show GO Labels");
                this.setGOLabelTextVisible(this.rootptr, false);
            } else {
                this.theDREMGui.bshowgolabels = true;
                this.hideButton.setText("Hide GO Labels");
                this.setGOLabelTextVisible(this.rootptr, true);
            }
        } else if (string.equals("unapply")) {
            this.theDREMGui.bapplygolabels = false;
            this.unapplyButton.setEnabled(false);
            this.hideButton.setEnabled(false);
            this.theDREMGui.unselectGO();
            this.rowSM.clearSelection();
            this.setGOLabelTextVisible(this.rootptr, false);
        }
    }

    public void addGOLabels(DREM_Timeiohmm.Treenode treenode) {
        int n;
        if (treenode != null && (n = this.rowSM.getMinSelectionIndex()) >= 0) {
            double d;
            int n2;
            int n3;
            this.theDREMGui.bapplygolabels = true;
            int n4 = 0;
            int n5 = 0;
            DREM_GoAnnotations dREM_GoAnnotations = this.theDREMGui.theTimeiohmm.theDataSet.tga;
            String string = (String)this.sorter.getValueAt(n, 0);
            if (!this.bsplitgolabels) {
                for (n3 = 0; n3 < treenode.bInNode.length; ++n3) {
                    if (!treenode.bInNode[n3] || !this.ballgenes && (!this.theDREMGui.bTFVisible[n3] || !this.theDREMGui.bSetVisible[n3])) continue;
                    ++n5;
                    if (!this.theDREMGui.bGOVisible[n3]) continue;
                    ++n4;
                }
                n2 = n4 - 1;
                n3 = (Integer)dREM_GoAnnotations.htFullCount.get(string);
                d = StatUtil.hypergeometrictail(n2, n3, dREM_GoAnnotations.numtotalgenes - n3, n5);
                treenode.szgolabel = d <= this.dgopval ? n4 + ";" + Util.doubleToSz(d) : "";
            } else if (treenode.parent != null && treenode.parent.numchildren >= 2) {
                int n6;
                n3 = 0;
                n2 = 0;
                for (n6 = 0; n6 < treenode.bInNode.length; ++n6) {
                    if (!treenode.parent.bInNode[n6]) continue;
                    ++n3;
                    if (this.theDREMGui.bGOVisible[n6]) {
                        ++n2;
                    }
                    if (!this.ballgenes && (!this.theDREMGui.bTFVisible[n6] || !this.theDREMGui.bSetVisible[n6]) || !treenode.bInNode[n6]) continue;
                    ++n5;
                    if (!this.theDREMGui.bGOVisible[n6]) continue;
                    ++n4;
                }
                n6 = n4 - 1;
                d = StatUtil.hypergeometrictail(n6, n2, n3 - n2, n5);
                treenode.szgolabel = d <= this.dgopval ? n4 + ";" + Util.doubleToSz(d) : "";
            } else {
                treenode.szgolabel = "";
            }
            treenode.goText.setText(treenode.szgolabel);
            for (n3 = 0; n3 < treenode.numchildren; ++n3) {
                this.addGOLabels(treenode.nextptr[n3]);
            }
        }
    }
}

