/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.GoAnnotations;
import edu.cmu.cs.sb.core.StatUtil;
import edu.cmu.cs.sb.core.TableModelSetST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui;
import edu.cmu.cs.sb.drem.DREMGui_KeyInputs;
import edu.cmu.cs.sb.drem.DREM_IO;
import edu.cmu.cs.sb.drem.DREM_Timeiohmm;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;

public class DREMGui_DefineGeneSet
extends JPanel
implements ItemListener,
ActionListener,
ChangeListener {
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    JButton colorButton;
    static final String SZDELIM = ";|,";
    GoAnnotations tga;
    TableModelSetST tms;
    boolean bcluster;
    JFrame theFrame;
    JButton unapplyButton;
    JButton hideButton;
    static final int NMAXBAD = 30;
    TableSorter sorter;
    JButton selectgenesButton;
    DREMGui theDREMGui;
    HashSet hsTFGeneList = new HashSet();
    HashSet hsList;
    boolean bsplitgolabels = false;
    JSlider theSlider;
    Hashtable theDictionary;
    JLabel pvalLabel;
    int ninitval = 30;
    JRadioButton pathButton;
    JRadioButton splitButton;
    ButtonGroup enrichmentGroup = new ButtonGroup();
    double dsetpval;
    boolean bapplyset = false;
    DREM_Timeiohmm.Treenode rootptr;

    public DREMGui_DefineGeneSet(JFrame jFrame, GoAnnotations goAnnotations, DREMGui dREMGui, DREM_Timeiohmm.Treenode treenode) {
        this.theFrame = jFrame;
        this.tga = goAnnotations;
        this.theDREMGui = dREMGui;
        this.rootptr = treenode;
        this.loadTFGeneList();
        this.makewindow();
    }

    void setGeneSetLabelTextColor(DREM_Timeiohmm.Treenode treenode, Color color) {
        if (treenode != null) {
            treenode.genesetText.setTextPaint(color);
            for (int i = 0; i < treenode.numchildren; ++i) {
                this.setGeneSetLabelTextColor(treenode.nextptr[i], color);
            }
        }
    }

    public void addSetLabels(DREM_Timeiohmm.Treenode treenode) {
        if (treenode != null && this.bapplyset) {
            double d;
            int n;
            int n2;
            int n3 = 0;
            int n4 = 0;
            if (!this.bsplitgolabels) {
                for (n2 = 0; n2 < treenode.bInNode.length; ++n2) {
                    if (!this.theDREMGui.bSetVisible[n2] || !treenode.bInNode[n2]) continue;
                    ++n3;
                }
                n = n3 - 1;
                n2 = treenode.numPath;
                d = StatUtil.hypergeometrictail(n, n2, this.tga.numtotalgenes - n2, this.tga.nGeneSet);
                treenode.szgenesetlabel = d <= this.dsetpval ? n3 + ";" + Util.doubleToSz(d) : "";
            } else if (treenode.parent != null && treenode.parent.numchildren >= 2) {
                int n5;
                n2 = 0;
                n = 0;
                for (n5 = 0; n5 < treenode.bInNode.length; ++n5) {
                    if (!treenode.parent.bInNode[n5]) continue;
                    ++n2;
                    if (treenode.bInNode[n5]) {
                        ++n;
                    }
                    if (!this.theDREMGui.bSetVisible[n5]) continue;
                    ++n4;
                    if (!treenode.bInNode[n5]) continue;
                    ++n3;
                }
                n5 = n3 - 1;
                d = StatUtil.hypergeometrictail(n5, n, n2 - n, n4);
                treenode.szgenesetlabel = d <= this.dsetpval ? n3 + ";" + Util.doubleToSz(d) : "";
            } else {
                treenode.szgenesetlabel = "";
            }
            treenode.genesetText.setText(treenode.szgenesetlabel);
            for (n2 = 0; n2 < treenode.numchildren; ++n2) {
                this.addSetLabels(treenode.nextptr[n2]);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.bsplitgolabels = !this.pathButton.isSelected();
        this.addSetLabels(this.rootptr);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting()) {
            this.dsetpval = Math.pow(10.0, (double)(-jSlider.getValue()) / 10.0);
            this.pvalLabel.setText("X = " + (double)jSlider.getValue() / 10.0 + "; p-value threshold is " + DREMGui_KeyInputs.doubleToSz(this.dsetpval));
            this.addSetLabels(this.rootptr);
        }
    }

    void loadTFGeneList() {
        this.hsList = new HashSet();
        for (int i = 0; i < this.theDREMGui.theTimeiohmm.bindingData.regNames.length; ++i) {
            String string = this.theDREMGui.theTimeiohmm.bindingData.regNames[i].toUpperCase(Locale.ENGLISH);
            this.hsList.add(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, SZDELIM);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.hsList.add(string2);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "_");
                if (stringTokenizer2.countTokens() <= 1) continue;
                this.hsList.add(stringTokenizer2.nextToken());
            }
        }
    }

    boolean handleInputTF(String string) {
        String string2 = string;
        if (this.hsList.contains(string2)) {
            this.hsTFGeneList.add(string);
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, SZDELIM);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (this.hsList.contains(string3)) {
                this.hsTFGeneList.add(string);
                return true;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "_");
            if (stringTokenizer2.countTokens() <= 1 || !this.hsList.contains(stringTokenizer2.nextToken())) continue;
            this.hsTFGeneList.add(string);
        }
        return false;
    }

    void setComplement() {
        for (int i = 0; i < this.tms.data.length; ++i) {
            this.tms.setValueAt((Boolean)this.tms.getValueAt(i, 2) == false, i, 2);
        }
    }

    void setAll(boolean bl) {
        for (int i = 0; i < this.tms.data.length; ++i) {
            this.tms.setValueAt(bl, i, 2);
        }
    }

    void setAllInputs(boolean bl) {
        for (int i = 0; i < this.tms.data.length; ++i) {
            if (!this.hsTFGeneList.contains(this.tms.data[i][0])) continue;
            this.tms.setValueAt(bl, i, 2);
        }
        if (bl) {
            this.sorter.setSortingStatus(2, -1);
        }
    }

    void setGeneSetLabelTextVisible(DREM_Timeiohmm.Treenode treenode, boolean bl) {
        if (treenode != null) {
            treenode.genesetText.setVisible(bl);
            for (int i = 0; i < treenode.numchildren; ++i) {
                this.setGeneSetLabelTextVisible(treenode.nextptr[i], bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = 0;
        if (string.equals("color")) {
            Color color = JColorChooser.showDialog(this, "Choose Color", this.theDREMGui.genesetLabelColor);
            if (color != null) {
                this.theDREMGui.genesetLabelColor = color;
                this.colorButton.setForeground(color);
                this.setGeneSetLabelTextColor(this.rootptr, color);
            }
        } else if (string.equals("hide")) {
            if (this.theDREMGui.bshowgenesetlabels) {
                this.theDREMGui.bshowgenesetlabels = false;
                this.hideButton.setText("Show Labels");
                this.setGeneSetLabelTextVisible(this.rootptr, false);
            } else {
                this.theDREMGui.bshowgenesetlabels = true;
                this.hideButton.setText("Hide Labels");
                this.setGeneSetLabelTextVisible(this.rootptr, true);
            }
        } else if (string.equals("unapply")) {
            this.theDREMGui.bapplygenesetlabels = false;
            this.unapplyButton.setEnabled(false);
            this.hideButton.setEnabled(false);
            for (int i = 0; i < this.theDREMGui.bSetVisible.length; ++i) {
                this.theDREMGui.bSetVisible[i] = true;
                boolean bl = this.theDREMGui.bglobalVisible && this.theDREMGui.bPathVisible[i] && this.theDREMGui.bGOVisible[i] && this.theDREMGui.bTFVisible[i];
                this.theDREMGui.plArray[i].setVisible(bl);
                this.theDREMGui.plArray[i].setPickable(bl);
            }
            this.theDREMGui.bfiltergeneset = false;
            this.theDREMGui.setFilterText();
            if (this.theDREMGui.theGOFilter != null) {
                this.theDREMGui.theGOFilter.addGOLabels(this.rootptr);
            }
            this.setGeneSetLabelTextVisible(this.rootptr, false);
            this.bapplyset = false;
        } else if (string.equals("selectcomplement")) {
            this.setComplement();
        } else if (string.equals("selectall")) {
            this.setAll(true);
        } else if (string.equals("selectnone")) {
            this.setAll(false);
        } else if (string.equals("selecttf")) {
            this.setAllInputs(true);
        } else if (string.equals("unselecttf")) {
            this.setAllInputs(false);
        } else if (string.equals("save")) {
            try {
                int n2 = DREM_IO.theChooser.showSaveDialog(this);
                if (n2 == 0) {
                    File file = DREM_IO.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    this.printFile(printWriter);
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                final FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException2.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("load") || string.equals("query")) {
            Serializable serializable;
            Object object;
            this.theDREMGui.bapplygenesetlabels = true;
            int n3 = -100;
            if (string.equals("load")) {
                n3 = DREM_IO.fc.showOpenDialog(this);
                object = "";
                serializable = new StringBuffer();
                if (n3 == 0) {
                    this.setAll(false);
                    BufferedReader bufferedReader = null;
                    try {
                        String string2;
                        File file = DREM_IO.fc.getSelectedFile();
                        FileReader fileReader = new FileReader(file);
                        bufferedReader = new BufferedReader(fileReader);
                        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
                        while ((string2 = bufferedReader.readLine()) != null) {
                            String string3 = string2.trim().toUpperCase(Locale.ENGLISH);
                            if (this.tga.htGeneNames.get(string3) != null) {
                                hashMap.put(string3, true);
                                continue;
                            }
                            if (string3.equals("0") || hashMap2.get(string3) != null || n >= 30) continue;
                            ((StringBuffer)serializable).append(string2 + "\n");
                            hashMap2.put(string3, true);
                            ++n;
                        }
                        object = ((StringBuffer)serializable).toString();
                        for (int i = 0; i < this.tms.data.length; ++i) {
                            if (hashMap.get(this.tms.data[i][0]) == null) continue;
                            this.tms.setValueAt(true, i, 2);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        JOptionPane.showMessageDialog(this, fileNotFoundException.getMessage(), "Exception thrown", 0);
                        fileNotFoundException.printStackTrace(System.out);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, iOException.getMessage(), "Exception thrown", 0);
                        iOException.printStackTrace(System.out);
                    }
                    finally {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(this, iOException.getMessage(), "Exception thrown", 0);
                                iOException.printStackTrace(System.out);
                            }
                        }
                    }
                    this.sorter.setSortingStatus(2, -1);
                }
                if (!object.equals("")) {
                    object = n < 30 ? "The following genes from the loaded gene set are not in the data file:\n" + (String)object : "The following are the first 30 genes from the loaded gene set that are not in the data file:\n" + (String)object;
                    JOptionPane.showMessageDialog(this, object, "Genes Not in the Data File", 2);
                }
            }
            if (string.equals("load") && n3 == 0 || string.equals("query")) {
                object = this.theDREMGui.theTimeiohmm.theDataSet.genenames;
                serializable = this.tga.htGeneNames;
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (((Boolean)((HashMap)serializable).get(object[i])).booleanValue()) {
                        this.theDREMGui.bSetVisible[i] = true;
                        boolean bl = this.theDREMGui.bglobalVisible && this.theDREMGui.bGOVisible[i] && this.theDREMGui.bPathVisible[i] && this.theDREMGui.bTFVisible[i];
                        this.theDREMGui.plArray[i].setVisible(bl);
                        this.theDREMGui.plArray[i].setPickable(bl);
                        continue;
                    }
                    this.theDREMGui.bSetVisible[i] = false;
                    this.theDREMGui.plArray[i].setVisible(false);
                    this.theDREMGui.plArray[i].setPickable(false);
                }
                this.unapplyButton.setEnabled(true);
                this.theDREMGui.bfiltergeneset = true;
                this.theDREMGui.setFilterText();
                if (this.theDREMGui.theGOFilter != null) {
                    this.theDREMGui.theGOFilter.addGOLabels(this.rootptr);
                }
                this.bapplyset = true;
                this.addSetLabels(this.rootptr);
                this.setGeneSetLabelTextVisible(this.rootptr, this.theDREMGui.bshowgenesetlabels && (this.theDREMGui.bglobalnode || !this.theDREMGui.battachlabels));
                this.hideButton.setEnabled(true);
            }
        } else if (string.equals("help")) {
            String string4 = "The above dialog allows a user to select a subset of genes based on the gene names.  In order to select a subset one must select the corresponding boxes of the desired genes, and then press the Apply Selection Constraints button. Pressing the button Unapply Selection Constraints removes the filter based on the gene set but does not clear the checkboxes. When a gene set is selected labels for paths enriched for the gene set at a p-value determined by the slider appear. P-values can either be Split enrichments which uses the genes going into the prior split as the base set for the enrichment caculation, or Overall Enrichments which uses all the genes on the microarray as a base set.\n\nBelow are a description of the additional buttons on this window:\n*Select All - checks all the gene boxes\n*Unselect All - unchecks all the gene boxes\n*Select Complement - checks all currently unchecked boxes and unchecks all currently checked boxes\n*Select All TFs - checks all the genes which also appear in a column header of the TF-gene interaction file\n*Unselect All TFs - unchecks all the genes which also appear in a column header of the TF-gene interaction file\n*Apply Selection Constraints - requires any gene that is displayed on the main interface to be currently checked\n*Unapply Selection Constraints - removes any selection requirement from the last time the apply selection constraints button was pressed\n*Change Label Colors - pressing the button opens a dialog window to change color of gene set p-value significance labels. The current color of the significance labels are the same of the text of the button.\n*Hide Labels - hides the p-value significance labels\n*Load Gene Set - option to select the genes listed in a file\n*Save Gene Set - option to export to a file the list of genes currently checked";
            Util.renderDialog(this.theFrame, string4, -200, -100);
        }
    }

    public void printFile(PrintWriter printWriter) {
        for (int i = 0; i < this.tms.data.length; ++i) {
            if (!((Boolean)this.tms.data[i][2]).booleanValue()) continue;
            printWriter.println(this.tms.data[i][0]);
        }
    }

    private void makewindow() {
        int n;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bg);
        this.setForeground(fg);
        Iterator iterator = this.tga.htGeneNames.keySet().iterator();
        int n2 = this.tga.htGeneNames.size();
        Object[][] objectArray = new Object[n2][3];
        String[] stringArray = new String[]{"Gene Name", "TF", "In Gene Set"};
        Object[] objectArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            objectArray2[n] = (String)iterator.next();
        }
        Arrays.sort(objectArray2);
        n = 0;
        for (int i = 0; i < n2; ++i) {
            objectArray[i][0] = objectArray2[i];
            objectArray[i][2] = this.tga.htGeneNames.get(objectArray2[i]);
            n = n != 0 || (Boolean)objectArray[i][2] != false ? 1 : 0;
            objectArray[i][1] = this.handleInputTF((String)objectArray2[i]) ? "Yes" : "";
        }
        this.tms = new TableModelSetST(objectArray, stringArray, this.tga);
        this.sorter = new TableSorter(this.tms);
        if (n != 0) {
            this.sorter.setSortingStatus(2, -1);
        }
        JTable jTable = new JTable(this.sorter);
        this.sorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 175));
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(8);
        tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(200);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(50);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add(jScrollPane);
        JLabel jLabel = new JLabel("  Only display enrichments with a p-value less than 10^-X where X is:");
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
        this.pvalLabel = new JLabel("X = " + (double)this.ninitval / 10.0 + "; p-value threshold is " + DREMGui_KeyInputs.doubleToSz(Math.pow(10.0, (double)(-this.ninitval) / 10.0)));
        this.dsetpval = Math.pow(10.0, (double)(-this.ninitval) / 10.0);
        this.theSlider = new JSlider(0, 120, this.ninitval);
        this.theDictionary = new Hashtable();
        for (int i = 0; i <= 12; ++i) {
            this.theDictionary.put(new Integer(i * 10), new JLabel("" + i));
        }
        this.theSlider.setLabelTable(this.theDictionary);
        this.theSlider.setMajorTickSpacing(10);
        this.theSlider.setMinorTickSpacing(5);
        this.theSlider.setPaintTicks(true);
        this.theSlider.setPaintLabels(true);
        this.theSlider.addChangeListener(this);
        this.theSlider.setPaintTicks(true);
        this.add(this.theSlider);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.pvalLabel);
        jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel2);
        jPanel2.setBackground(Color.white);
        JPanel jPanel3 = new JPanel();
        JLabel jLabel2 = new JLabel("p-values should be");
        jPanel3.setBackground(Color.white);
        jPanel3.add(jLabel2);
        this.pathButton = new JRadioButton("Overall Enrichments");
        this.splitButton = new JRadioButton("Split Enrichments");
        this.enrichmentGroup.add(this.pathButton);
        this.enrichmentGroup.add(this.splitButton);
        this.pathButton.addItemListener(this);
        this.splitButton.addItemListener(this);
        if (this.bsplitgolabels) {
            this.splitButton.setSelected(true);
        } else {
            this.pathButton.setSelected(true);
        }
        this.pathButton.setBackground(Color.white);
        this.splitButton.setBackground(Color.white);
        jPanel3.add(this.pathButton);
        jPanel3.add(this.splitButton);
        this.add(jPanel3);
        jPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(Color.white);
        JButton jButton = new JButton("Select All");
        jButton.setActionCommand("selectall");
        jButton.addActionListener(this);
        jPanel4.add(jButton);
        JButton jButton2 = new JButton("Unselect All");
        jButton2.setActionCommand("selectnone");
        jButton2.addActionListener(this);
        jPanel4.add(jButton2);
        jPanel4.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel4);
        JButton jButton3 = new JButton("Select Complement");
        jButton3.setActionCommand("selectcomplement");
        jButton3.addActionListener(this);
        jPanel4.add(jButton3);
        jPanel4.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBackground(Color.white);
        JButton jButton4 = new JButton("Select All TFs");
        jButton4.setActionCommand("selecttf");
        jButton4.addActionListener(this);
        jPanel5.add(jButton4);
        JButton jButton5 = new JButton("Unselect All TFs");
        jButton5.setActionCommand("unselecttf");
        jButton5.addActionListener(this);
        jPanel5.add(jButton5);
        this.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(Color.white);
        JPanel jPanel7 = new JPanel();
        jPanel7.setBackground(Color.white);
        JButton jButton6 = new JButton("Apply  Selection Constraints");
        jButton6.setActionCommand("query");
        jButton6.addActionListener(this);
        jPanel7.add(jButton6);
        this.unapplyButton = new JButton("Unapply  Selection Constraints");
        this.unapplyButton.setActionCommand("unapply");
        this.unapplyButton.addActionListener(this);
        this.unapplyButton.setEnabled(false);
        jPanel7.add(this.unapplyButton);
        jPanel7.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel7);
        this.hideButton = new JButton("Hide Labels");
        this.hideButton.setEnabled(false);
        this.hideButton.setActionCommand("hide");
        this.hideButton.addActionListener(this);
        jPanel6.add(this.hideButton);
        this.colorButton = new JButton("Change Labels Color");
        this.colorButton.setActionCommand("color");
        this.colorButton.setMinimumSize(new Dimension(800, 20));
        this.colorButton.addActionListener(this);
        this.colorButton.setForeground(this.theDREMGui.genesetLabelColor);
        jPanel6.add(this.colorButton);
        JButton jButton7 = new JButton("Load Gene Set", Util.createImageIcon("Open16.gif"));
        jButton7.setActionCommand("load");
        jButton7.addActionListener(this);
        jPanel5.add(jButton7);
        JButton jButton8 = new JButton("Save Gene Set", Util.createImageIcon("Save16.gif"));
        jButton8.setActionCommand("save");
        jButton8.addActionListener(this);
        jPanel6.add(jButton8);
        JButton jButton9 = new JButton(Util.createImageIcon("Help16.gif"));
        jButton9.addActionListener(this);
        jButton9.setActionCommand("help");
        jPanel6.add(jButton9);
        jPanel6.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel6);
    }
}

