/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.GoAnnotations;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui_DefineGeneSet;
import edu.cmu.cs.sb.drem.DREMGui_EdgeTable;
import edu.cmu.cs.sb.drem.DREMGui_FilterStatic;
import edu.cmu.cs.sb.drem.DREMGui_GOFilter;
import edu.cmu.cs.sb.drem.DREMGui_GOTable;
import edu.cmu.cs.sb.drem.DREMGui_GeneTable;
import edu.cmu.cs.sb.drem.DREMGui_InterfaceOptions;
import edu.cmu.cs.sb.drem.DREMGui_KeyInputs;
import edu.cmu.cs.sb.drem.DREMGui_Predict;
import edu.cmu.cs.sb.drem.DREMGui_SaveDREM;
import edu.cmu.cs.sb.drem.DREMGui_SaveModel;
import edu.cmu.cs.sb.drem.DREMGui_SplitTable;
import edu.cmu.cs.sb.drem.DREM_GoAnnotations;
import edu.cmu.cs.sb.drem.DREM_Timeiohmm;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.PFrame;
import edu.umd.cs.piccolox.nodes.PLine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.TreeSet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DREMGui
extends PFrame
implements ComponentListener {
    boolean battachlabels = true;
    static int SCREENWIDTH = 800;
    static int SCREENHEIGHT = 600;
    static int LEFTBUFFER = 25;
    static int RIGHTBUFFER = 75;
    static double TOPBUFFER = 10.0;
    static double BOTTOMBUFFER = 80.0;
    double REALHEIGHT = 0.0;
    static int TICKLENGTH = 15;
    static double INITKEYLEVEL = 0.001;
    static int BUTTONRECWIDTH = 110;
    double INITLEFT;
    boolean binit = true;
    static Object datasetlock = new Object();
    static Color buttonColor = new Color(255, 246, 143);
    DREM_Timeiohmm theTimeiohmm;
    double[][] data;
    int[][] pmavalues;
    String[] genenames;
    PCanvas canvas;
    PLine[] plArray;
    PLayer theLayer;
    boolean displayTF = true;
    boolean displayMIRNA = true;
    boolean colorSigTFs = true;
    Hashtable<PPath, Point2D> lineendpoints = new Hashtable();
    ArrayList<PNode> hideList = new ArrayList();
    ArrayList<SigInfoRec> hidesigList;
    ArrayList<PText> hidegolabelsList;
    ArrayList<PText> hidetfsetlabelsList;
    ArrayList<PText> hidepredictlabelsList;
    ArrayList<PText> hidegenesetlabelsList;
    TreeSet<CircleRec> circleSet = new TreeSet<CircleRec>(new CircleRecCompare());
    Hashtable<PNode, Color> htColors;
    Hashtable<BigInteger, Integer> htHidden = new Hashtable();
    HashSet<CircleID> htRequired = new HashSet();
    Hashtable<PNode, CircleID> htNodes = new Hashtable();
    Hashtable<BigInteger, ArrayList<Integer>> htPathToLineSet = new Hashtable();
    Hashtable<String, Boolean> htTextVisible;
    JFrame filterStaticFrame;
    JFrame filterGOFrame;
    JFrame defineFrame;
    JFrame predictFrame;
    JFrame keyinputFrame;
    JFrame yscaleFrame;
    JFrame saveDREMFrame;
    JFrame saveModelFrame;
    SelectedNodeRec theSelectedRec = new SelectedNodeRec();
    DREMGui_GOFilter theGOFilter;
    DREMGui_InterfaceOptions theYScalegui;
    DREM_Timeiohmm.Treenode treecopy;
    PNode genetableButton;
    PNode setButton;
    PNode gotableButton;
    PNode staticButton;
    PNode gofilterButton;
    PNode scaleButton;
    PNode predictButton;
    PNode hideButton;
    PNode timeButton;
    PNode siginButton;
    PNode saveDREMButton;
    PNode saveModelButton;
    PText hideText;
    PImage helpButton;
    int nheight;
    int nwidth;
    int ncolortime = 0;
    int ncircleID = 0;
    double dheightunits;
    double dminheightunits;
    double dwidthunits;
    double dnodek = 1.0;
    double[] dwidthunitsInterval;
    double[] dwidthunitsCum;
    double dmax;
    double dmin;
    double dkeyinputpvalue = INITKEYLEVEL;
    double dkeymiRNAinputpvalue = INITKEYLEVEL;
    double dsplitpercent = 0.0;
    Color SPLITCOLOR = Color.green;
    boolean bapplygenesetlabels = false;
    boolean bapplytfsetlabels = false;
    boolean bapplygolabels = false;
    boolean bholdedge = false;
    boolean bfiltergo = false;
    boolean bfiltergeneset = false;
    boolean bfilterinput = false;
    boolean brealXaxis = false;
    PText filterText;
    Color keyInputLabelColor = Color.black;
    Color goLabelColor = Color.black;
    Color predictLabelColor = Color.black;
    Color genesetLabelColor = Color.orange;
    Color tfLabelColor = Color.red;
    boolean binvalidreal = false;
    boolean[] bGOVisible;
    boolean[] bSetVisible;
    boolean[] bPathVisible;
    boolean[] bTFVisible;
    boolean bglobalVisible;
    boolean blowestbelow = true;
    boolean blowestabove = true;
    boolean bmiddlebelow = true;
    boolean bmiddleabove = true;
    boolean bhighestbelow = true;
    boolean bhighestabove = true;
    boolean blowbelow = true;
    boolean blowabove = true;
    boolean bglobalnode = true;
    boolean bshowpredict = false;
    boolean bshowkeyinputs = true;
    boolean bshowgolabels = true;
    boolean bshowtfsetlabels = true;
    boolean bshowgenesetlabels = true;
    int nKeyInputType;
    NumberFormat nf3;
    int numcolor = 0;
    int nparentcolorindex = 0;
    Hashtable<Integer, ArrayList<PPath>> htColorIDtoLinesList = new Hashtable();
    double dscaley;
    double dscalex = 0.5;
    Hashtable<Integer, Color> htColorIDtoColor = new Hashtable();
    Hashtable<String, Integer> htLineIDtoColorID = new Hashtable();
    Hashtable<Integer, ArrayList<PNode>> htColorIDtoCircleList = new Hashtable();
    HashSet<String> sigRegs = new HashSet();
    BigInteger[] storedbestpath;
    boolean bsavedchange;
    double dinitmin;
    double dinitmax;
    Color[] lineColorsA;
    Color[][] edgeColorsTriples = new Color[][]{{new Color(0.1254902f, 0.69803923f, 0.6666667f, 1.0f), new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(1.0f, 0.0f, 1.0f, 1.0f)}, {new Color(1.0f, 0.5019608f, 0.0f, 1.0f), new Color(0.5019608f, 0.5019608f, 0.5019608f, 1.0f), new Color(0.8039216f, 0.2f, 0.2f, 1.0f)}, {new Color(0.0f, 0.6f, 0.6f, 1.0f), new Color(0.54509807f, 0.4509804f, 0.33333334f, 1.0f), new Color(0.8f, 0.0f, 0.8f, 1.0f)}, {new Color(0.18039216f, 0.54509807f, 0.34117648f, 1.0f), new Color(0.5019608f, 0.0f, 1.0f, 1.0f), new Color(0.5019608f, 0.0f, 0.5019608f, 1.0f)}, {new Color(0.8039216f, 0.35686275f, 0.27058825f, 1.0f), new Color(0.05490196f, 0.23137255f, 0.23137255f, 1.0f), new Color(1.0f, 0.5019608f, 1.0f, 1.0f)}, {new Color(0.33333334f, 0.41960785f, 0.18431373f, 1.0f), new Color(0.5019608f, 0.5019608f, 1.0f, 1.0f), new Color(1.0f, 0.0f, 0.5019608f, 1.0f)}, {new Color(0.63529414f, 0.63529414f, 0.40784314f, 1.0f), new Color(0.0f, 0.4f, 0.4f, 1.0f), new Color(1.0f, 0.4f, 0.4f, 1.0f)}, {new Color(0.6f, 0.6f, 1.0f, 1.0f), new Color(0.6f, 0.4f, 0.0f, 1.0f), new Color(0.0f, 0.4f, 0.4f, 1.0f)}, {new Color(1.0f, 0.0f, 0.4f, 1.0f), new Color(0.2f, 0.2f, 0.2f, 1.0f), new Color(0.4f, 1.0f, 0.4f, 1.0f)}, {new Color(0.0f, 0.4f, 0.6f, 1.0f), new Color(0.60784316f, 0.0f, 0.0f, 1.0f), new Color(0.4f, 0.0f, 0.4f, 1.0f)}, {new Color(0.4f, 0.0f, 0.4f, 1.0f), new Color(0.57254905f, 0.36078432f, 0.24313726f, 1.0f), new Color(1.0f, 0.8f, 0.8f, 1.0f)}, {new Color(0.81960785f, 0.52156866f, 0.0f, 1.0f), new Color(0.28627452f, 0.15294118f, 0.32941177f, 1.0f), new Color(0.94509804f, 0.40784314f, 0.40784314f, 1.0f)}, {new Color(0.6666667f, 0.05882353f, 0.6392157f, 1.0f), new Color(0.8039216f, 0.4f, 0.11372549f, 1.0f), new Color(0.8039216f, 0.36078432f, 0.36078432f, 1.0f)}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DREMGui(DREM_Timeiohmm dREM_Timeiohmm, DREM_Timeiohmm.Treenode treenode, boolean bl, double d, double d2, int n, double d3, double d4, String string, double d5) {
        super("DREM - Main Interface " + string);
        this.treecopy = treenode;
        this.storedbestpath = new BigInteger[dREM_Timeiohmm.storedbestpath.length];
        this.bsavedchange = dREM_Timeiohmm.bsavedchange;
        for (int i = 0; i < this.storedbestpath.length; ++i) {
            this.storedbestpath[i] = dREM_Timeiohmm.storedbestpath[i];
        }
        Object object = datasetlock;
        synchronized (object) {
            this.dscaley = d;
            this.dscalex = d2;
            this.dnodek = d5;
            this.brealXaxis = bl;
            this.nKeyInputType = n;
            this.dsplitpercent = d4 / 100.0;
            this.dkeyinputpvalue = Math.pow(10.0, (double)(-Math.round(10.0 * d3)) / 10.0);
            this.dkeymiRNAinputpvalue = Math.pow(10.0, (double)(-Math.round(10.0 * d3)) / 10.0);
            this.theTimeiohmm = dREM_Timeiohmm;
            this.data = dREM_Timeiohmm.theDataSet.data;
            this.pmavalues = dREM_Timeiohmm.theDataSet.pmavalues;
            this.genenames = dREM_Timeiohmm.theDataSet.genenames;
            this.bPathVisible = new boolean[this.data.length];
            this.bTFVisible = new boolean[this.data.length];
            this.bGOVisible = new boolean[this.data.length];
            this.bSetVisible = new boolean[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                this.bTFVisible[i] = true;
                this.bPathVisible[i] = true;
                this.bGOVisible[i] = true;
                this.bSetVisible[i] = true;
            }
            this.plArray = new PLine[this.data.length];
            this.bglobalVisible = true;
            this.htColors = new Hashtable();
            this.addComponentListener(this);
            this.nf3 = NumberFormat.getInstance(Locale.ENGLISH);
            this.nf3.setMinimumFractionDigits(3);
            this.nf3.setMaximumFractionDigits(3);
            this.dmax = Math.abs(this.data[0][0]);
            this.dmin = Math.abs(this.data[0][0]);
            double[] dArray = new double[this.data.length];
            double[] dArray2 = new double[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                dArray[i] = 0.0;
                dArray2[i] = 0.0;
                for (int j = 0; j < this.data[0].length; ++j) {
                    if (this.pmavalues[i][j] == 0) continue;
                    if (this.data[i][j] < dArray2[i]) {
                        dArray2[i] = this.data[i][j];
                    }
                    if (!(this.data[i][j] > dArray[i])) continue;
                    dArray[i] = this.data[i][j];
                }
            }
            Arrays.sort(dArray2);
            Arrays.sort(dArray);
            this.dmin = dArray2[0];
            this.dmax = dArray[dArray.length - 1];
            this.dinitmin = this.dmin;
            this.dinitmax = this.dmax;
            this.nheight = this.getHeight();
            this.REALHEIGHT = (double)this.nheight - TOPBUFFER - BOTTOMBUFFER;
            this.dminheightunits = this.REALHEIGHT / (this.dmax - this.dmin);
            treenode.dsigma = (this.dmax - this.dmin) * 0.02;
            this.binit = true;
            datasetlock.notifyAll();
        }
    }

    public void setGeneColors() {
        if (this.ncolortime == 0) {
            for (int i = 0; i < this.plArray.length; ++i) {
                this.plArray[i].setStrokePaint(this.lineColorsA[i]);
            }
        } else {
            BigInteger bigInteger = new BigInteger("" + this.theTimeiohmm.nmaxchild).pow(this.data[0].length - this.ncolortime);
            for (int i = 0; i < this.plArray.length; ++i) {
                BigInteger bigInteger2 = bigInteger.multiply(this.storedbestpath[i].divide(bigInteger));
                Integer n = this.htLineIDtoColorID.get(this.ncolortime + ";" + bigInteger2);
                if (n == null || this.htColorIDtoColor == null) {
                    // empty if block
                }
                Color color = this.htColorIDtoColor.get(n);
                this.plArray[i].setStrokePaint(color);
            }
        }
    }

    public void closeWindows() {
        if (this.filterStaticFrame != null) {
            this.filterStaticFrame.setVisible(false);
            this.filterStaticFrame.dispose();
            this.filterStaticFrame = null;
        }
        if (this.filterGOFrame != null) {
            this.filterGOFrame.setVisible(false);
            this.filterGOFrame.dispose();
            this.filterGOFrame = null;
        }
        if (this.defineFrame != null) {
            this.defineFrame.setVisible(false);
            this.defineFrame.dispose();
            this.defineFrame = null;
        }
        if (this.predictFrame != null) {
            this.predictFrame.setVisible(false);
            this.predictFrame.dispose();
            this.predictFrame = null;
        }
        if (this.keyinputFrame != null) {
            this.keyinputFrame.setVisible(false);
            this.keyinputFrame.dispose();
            this.keyinputFrame = null;
        }
        if (this.yscaleFrame != null) {
            this.yscaleFrame.setVisible(false);
            this.yscaleFrame.dispose();
            this.yscaleFrame = null;
        }
    }

    public String saveColors() {
        StringBuffer stringBuffer = new StringBuffer();
        float[] fArray = new float[4];
        for (int i = 0; i < this.numcolor; ++i) {
            Color color = this.htColorIDtoColor.get(new Integer(i));
            color.getRGBComponents(fArray);
            stringBuffer.append(fArray[0] + "\t" + fArray[1] + "\t" + fArray[2] + "\t" + fArray[3] + "\n");
        }
        return stringBuffer.toString();
    }

    public void unselectGO() {
        for (int i = 0; i < this.bGOVisible.length; ++i) {
            this.bGOVisible[i] = true;
            boolean bl = this.bglobalVisible && this.bSetVisible[i] && this.bPathVisible[i] && this.bTFVisible[i];
            this.plArray[i].setVisible(bl);
            this.plArray[i].setPickable(bl);
        }
        this.bfiltergo = false;
        this.setFilterText();
    }

    public void selectGO(String string) {
        DREM_GoAnnotations dREM_GoAnnotations = this.theTimeiohmm.theDataSet.tga;
        dREM_GoAnnotations.szSelectedGO = string;
        String[] stringArray = this.theTimeiohmm.theDataSet.genenames;
        for (int i = 0; i < stringArray.length; ++i) {
            HashSet hashSet = dREM_GoAnnotations.labelsForID(stringArray[i]);
            if (hashSet.contains(string)) {
                this.bGOVisible[i] = true;
                boolean bl = this.bglobalVisible && this.bSetVisible[i] && this.bPathVisible[i] && this.bTFVisible[i];
                this.plArray[i].setVisible(bl);
                this.plArray[i].setPickable(bl);
                continue;
            }
            this.bGOVisible[i] = false;
            this.plArray[i].setVisible(false);
            this.plArray[i].setPickable(false);
        }
        this.bfiltergo = true;
        this.setFilterText();
    }

    public void setFilterText() {
        boolean bl;
        String string = "Genes selected based on ";
        int n = 0;
        if (this.bfiltergo) {
            ++n;
        }
        if (this.bfiltergeneset) {
            ++n;
        }
        if (this.bfilterinput) {
            ++n;
        }
        boolean bl2 = bl = this.theSelectedRec.theCircleID != null;
        if (bl) {
            string = string + "a path constraint";
            if (n == 1) {
                string = string + " and ";
            } else if (n >= 2) {
                string = string + ", ";
            }
        }
        if (this.bfiltergo) {
            DREM_GoAnnotations dREM_GoAnnotations = this.theTimeiohmm.theDataSet.tga;
            String string2 = "the GO category " + ((GoAnnotations.Rec)dREM_GoAnnotations.htGO.get((Object)dREM_GoAnnotations.szSelectedGO)).sztermName;
            string = this.bfiltergeneset ? (this.bfilterinput ? string + "a gene set, TF input, and " + string2 : (bl ? string + "a gene set, and " + string2 : string + "a gene set and " + string2)) : (this.bfilterinput ? (bl ? string + "TF input, and " + string2 : string + "TF input and " + string2) : string + string2);
        } else if (this.bfiltergeneset) {
            string = this.bfilterinput ? (bl ? string + "a gene set, and TF input" : string + "a gene set and TF input") : string + "a gene set";
        } else if (this.bfilterinput) {
            string = string + "TF input";
        } else if (!bl) {
            string = "";
        }
        this.filterText.setText(string);
    }

    public void renderFilterText() {
        this.filterText = new PText();
        this.setFilterText();
        this.filterText.translate(LEFTBUFFER + 15, 2.0);
        this.filterText.setPickable(false);
        this.filterText.setFont(new Font("times", 0, 14));
        if (!this.bglobalnode) {
            this.filterText.setVisible(false);
            this.filterText.setPickable(false);
        }
        this.canvas.getCamera().addChild(this.filterText);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.drawmain();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.drawmain();
    }

    @Override
    public void beforeInitialize() {
        this.setSize(SCREENWIDTH, SCREENHEIGHT);
    }

    @Override
    public void initialize() {
        this.drawmain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawmain() {
        Object object = datasetlock;
        synchronized (object) {
            int n;
            int n2;
            int n3;
            int n4;
            Object object3;
            Object object4;
            PLine pLine;
            double d;
            double d2;
            int n5;
            while (!this.binit) {
                try {
                    datasetlock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.hideList = new ArrayList();
            this.ncircleID = 0;
            this.numcolor = 0;
            this.nparentcolorindex = 0;
            this.htColorIDtoLinesList = new Hashtable();
            this.circleSet = new TreeSet<CircleRec>(new CircleRecCompare());
            this.htColors = new Hashtable();
            this.htNodes = new Hashtable();
            this.htPathToLineSet = new Hashtable();
            if (this.hidesigList != null) {
                this.htTextVisible = new Hashtable();
                int n6 = this.hidesigList.size();
                for (int i = 0; i < n6; ++i) {
                    SigInfoRec sigInfoRec = this.hidesigList.get(i);
                    this.htTextVisible.put(sigInfoRec.ndepth + ";" + sigInfoRec.npathscore + ";" + sigInfoRec.ntype, sigInfoRec.border.getChild(0).getVisible());
                }
            } else {
                this.htTextVisible = null;
            }
            this.hidesigList = new ArrayList();
            this.hidegolabelsList = new ArrayList();
            this.hidetfsetlabelsList = new ArrayList();
            this.hidegenesetlabelsList = new ArrayList();
            this.hidepredictlabelsList = new ArrayList();
            this.canvas = this.getCanvas();
            ToolTipManager.sharedInstance().registerComponent(this.canvas);
            this.theLayer = this.canvas.getLayer();
            PCamera pCamera = this.canvas.getCamera();
            this.theLayer.removeAllChildren();
            pCamera.removeAllChildren();
            this.dmin = this.dinitmin / this.dscaley;
            this.dmax = this.dinitmax / this.dscaley;
            double d3 = this.dmax - this.dmin;
            this.nheight = this.getHeight();
            this.REALHEIGHT = (double)this.nheight - TOPBUFFER - BOTTOMBUFFER;
            this.dheightunits = this.REALHEIGHT / d3;
            this.nwidth = this.getWidth();
            int n7 = this.data[0].length - 1;
            this.dwidthunits = (double)(this.nwidth - LEFTBUFFER - RIGHTBUFFER) * this.dscalex;
            this.dwidthunitsInterval = new double[n7];
            this.dwidthunitsCum = new double[n7 + 1];
            this.dwidthunitsCum[0] = 0.0;
            boolean bl = true;
            try {
                double d4 = Util.removeUnits(this.theTimeiohmm.theDataSet.dsamplemins[0]);
                for (int i = 0; i < this.dwidthunitsInterval.length; ++i) {
                    double d5 = Util.removeUnits(this.theTimeiohmm.theDataSet.dsamplemins[i + 1]);
                    this.dwidthunitsInterval[i] = d5 - d4;
                    if (this.dwidthunitsInterval[i] < 0.0) {
                        bl = false;
                        this.brealXaxis = false;
                        this.binvalidreal = true;
                    }
                    this.dwidthunitsCum[i + 1] = this.dwidthunitsCum[i] + this.dwidthunitsInterval[i];
                    d4 = d5;
                }
                double d6 = this.dwidthunitsCum[this.dwidthunitsCum.length - 1];
                for (int i = 1; i < this.dwidthunitsCum.length; ++i) {
                    this.dwidthunitsInterval[i - 1] = this.dwidthunits * this.dwidthunitsInterval[i - 1] / d6;
                    this.dwidthunitsCum[i] = this.dwidthunits * this.dwidthunitsCum[i] / d6;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.binvalidreal = true;
                this.brealXaxis = false;
                for (int i = 1; i < this.dwidthunitsCum.length; ++i) {
                    this.dwidthunitsInterval[i - 1] = this.dwidthunits / (double)n7;
                    this.dwidthunitsCum[i] = (double)i * this.dwidthunits / (double)n7;
                }
            }
            if (!this.brealXaxis || !bl) {
                for (int i = 1; i < this.dwidthunitsCum.length; ++i) {
                    this.dwidthunitsInterval[i - 1] = this.dwidthunits / (double)n7;
                    this.dwidthunitsCum[i] = (double)i * this.dwidthunits / (double)n7;
                }
            }
            PLine pLine2 = new PLine();
            double d7 = this.REALHEIGHT + this.dheightunits * this.dmin;
            pLine2.addPoint(0, LEFTBUFFER, d7);
            pLine2.addPoint(1, this.dscalex * (double)this.nwidth - (double)(RIGHTBUFFER / 2), d7);
            pLine2.setStroke(new BasicStroke(4.0f));
            pLine2.setStrokePaint(Color.gray);
            this.theLayer.addChild(pLine2);
            for (n5 = 0; n5 < this.theTimeiohmm.theDataSet.dsamplemins.length; ++n5) {
                PLine pLine3 = new PLine();
                d2 = this.dwidthunitsCum[n5] + (double)LEFTBUFFER;
                pLine3.addPoint(0, d2, d7);
                pLine3.addPoint(1, d2, d7 + (double)TICKLENGTH);
                pLine3.setStroke(new BasicStroke(4.0f));
                pLine3.setStrokePaint(Color.gray);
                this.theLayer.addChild(pLine3);
                PText pText = new PText("" + this.theTimeiohmm.theDataSet.dsamplemins[n5]);
                pText.translate(d2 + 4.0, d7 + 4.0);
                this.theLayer.addChild(pText);
            }
            n5 = (int)Math.floor(Math.log(Math.max(Math.abs(this.dmin), this.dmax)) / Math.log(10.0));
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
            if (n5 < 0) {
                numberFormat.setMaximumFractionDigits(-n5);
                numberFormat.setMinimumFractionDigits(-n5);
            }
            d2 = Math.pow(10.0, n5);
            double d8 = d2 * this.dheightunits;
            double d9 = d7 + d8;
            for (d = -d2; d < this.dinitmax; d += d2) {
                pLine = new PLine();
                pLine.addPoint(0, LEFTBUFFER - TICKLENGTH, d9 -= d8);
                pLine.addPoint(1, LEFTBUFFER, d9);
                pLine.setStroke(new BasicStroke(4.0f));
                pLine.setStrokePaint(Color.gray);
                this.theLayer.addChild(pLine);
                object4 = numberFormat.format(d);
                object3 = new PText((String)object4);
                ((PNode)object3).translate(LEFTBUFFER - TICKLENGTH - 4 * ((String)object4).length() + 6, d9 - 17.0);
                this.theLayer.addChild((PNode)object3);
            }
            pLine = new PLine();
            pLine.addPoint(0, LEFTBUFFER, d9);
            d9 = d7;
            for (d = 0.0; d > this.dinitmin; d -= d2) {
                object4 = new PLine();
                ((PLine)object4).addPoint(0, LEFTBUFFER - TICKLENGTH, d9 += d8);
                ((PLine)object4).addPoint(1, LEFTBUFFER, d9);
                ((PLine)object4).setStroke(new BasicStroke(4.0f));
                ((PLine)object4).setStrokePaint(Color.gray);
                this.theLayer.addChild((PNode)object4);
                object3 = numberFormat.format(d);
                PText object22 = new PText((String)object3);
                object22.translate(LEFTBUFFER - TICKLENGTH - 3 * ((String)object3).length() + 3, d9 - 17.0);
                this.theLayer.addChild(object22);
            }
            pLine.addPoint(1, LEFTBUFFER, d9);
            pLine.setStroke(new BasicStroke(4.0f));
            pLine.setStrokePaint(Color.gray);
            this.theLayer.addChild(pLine);
            object4 = new Random(74312L);
            if (this.lineColorsA == null) {
                this.lineColorsA = new Color[this.data.length];
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.lineColorsA[i] == null) {
                    Color color;
                    this.lineColorsA[i] = color = new Color(((Random)object4).nextInt(226), ((Random)object4).nextInt(226), ((Random)object4).nextInt(226));
                }
                PLine pLine3 = new PLine();
                pLine3.addInputEventListener(new ToolTipTextUpdater(this.canvas, pLine3, this.genenames[i]));
                n4 = 0;
                for (int j = 0; j < this.data[i].length; ++j) {
                    if (this.pmavalues[i][j] == 0) continue;
                    double d4 = this.dwidthunitsCum[j] + (double)LEFTBUFFER;
                    double d5 = this.REALHEIGHT - this.dheightunits * (this.data[i][j] - this.dmin);
                    pLine3.addPoint(n4, d4, d5);
                    ++n4;
                }
                ArrayList<Integer> arrayList = this.htPathToLineSet.get(this.storedbestpath[i]);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new Integer(i));
                this.htPathToLineSet.put(this.storedbestpath[i], arrayList);
                this.plArray[i] = pLine3;
                n3 = this.bglobalVisible && this.bPathVisible[i] && this.bTFVisible[i] && this.bGOVisible[i] && this.bSetVisible[i] ? 1 : 0;
                pLine3.setVisible(n3 != 0);
                pLine3.setPickable(n3 != 0);
                this.theLayer.addChild(pLine3);
            }
            this.drawNodes(this.treecopy, 0, 0.0, 0.0, new BigInteger("0"), 0, null, null, -1, this.nparentcolorindex, this.treecopy.nminparentlevel);
            this.setGeneColors();
            for (CircleRec circleRec : this.circleSet) {
                this.theLayer.addChild(circleRec.circle);
                if (this.bglobalnode) continue;
                circleRec.circle.setVisible(false);
                circleRec.circle.setPickable(false);
            }
            int n6 = this.hidepredictlabelsList.size();
            for (n2 = 0; n2 < n6; ++n2) {
                this.theLayer.addChild(this.hidepredictlabelsList.get(n2));
            }
            n2 = this.hidetfsetlabelsList.size();
            for (n4 = 0; n4 < n2; ++n4) {
                this.theLayer.addChild(this.hidetfsetlabelsList.get(n4));
            }
            n4 = this.hidegenesetlabelsList.size();
            for (n = 0; n < n4; ++n) {
                this.theLayer.addChild(this.hidegenesetlabelsList.get(n));
            }
            n = this.hidegolabelsList.size();
            for (n3 = 0; n3 < n; ++n3) {
                this.theLayer.addChild(this.hidegolabelsList.get(n3));
            }
            this.genetableButton = PPath.createRectangle(0.0f, 0.0f, BUTTONRECWIDTH, 18.0f);
            PText pText = new PText("Gene Table");
            pText.setFont(new Font("times", 0, 12));
            pText.translate(26.0, 2.0);
            this.genetableButton.setPaint(buttonColor);
            this.genetableButton.addChild(pText);
            this.genetableButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JFrame jFrame = new JFrame("Table of Selected Genes");
                            jFrame.setDefaultCloseOperation(2);
                            jFrame.setLocation(20, 50);
                            boolean[] blArray = new boolean[DREMGui.this.plArray.length];
                            for (int i = 0; i < DREMGui.this.plArray.length; ++i) {
                                blArray[i] = DREMGui.this.bPathVisible[i] && DREMGui.this.bTFVisible[i] && DREMGui.this.bGOVisible[i] && DREMGui.this.bSetVisible[i];
                            }
                            DREMGui_GeneTable dREMGui_GeneTable = new DREMGui_GeneTable(jFrame, DREMGui.this.theTimeiohmm.theDataSet, DREMGui.this.theTimeiohmm, DREMGui.this.theTimeiohmm.bindingData.gene2RegBinding, DREMGui.this.theTimeiohmm.bindingData.gene2RegBindingIndex, DREMGui.this.theTimeiohmm.bindingData.reg2GeneBinding, DREMGui.this.theTimeiohmm.bindingData.reg2GeneBindingIndex, DREMGui.this.theTimeiohmm.bindingData.gene2RegMaxBinding, DREMGui.this.theTimeiohmm.bindingData.gene2RegMaxBindingIndex, DREMGui.this.theTimeiohmm.bindingData.regNames, blArray);
                            dREMGui_GeneTable.setOpaque(true);
                            jFrame.setContentPane(dREMGui_GeneTable);
                            jFrame.pack();
                            jFrame.setVisible(true);
                        }
                    });
                }
            });
            final DREMGui dREMGui = this;
            this.setButton = PPath.createRectangle(0.0f, 0.0f, BUTTONRECWIDTH, 18.0f);
            PText pText2 = new PText("Select by Gene Set");
            pText2.setFont(new Font("times", 0, 12));
            pText2.translate(4.0, 2.0);
            this.setButton.setPaint(buttonColor);
            this.setButton.addChild(pText2);
            this.setButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (DREMGui.this.defineFrame == null) {
                                DREMGui.this.defineFrame = new JFrame("Select Genes Based on Defined Gene Set");
                                DREMGui.this.defineFrame.setDefaultCloseOperation(2);
                                DREMGui.this.defineFrame.setLocation(400, 200);
                                DREMGui_DefineGeneSet dREMGui_DefineGeneSet = new DREMGui_DefineGeneSet(DREMGui.this.defineFrame, DREMGui.this.theTimeiohmm.theDataSet.tga, dREMGui, dREMGui.treecopy);
                                dREMGui_DefineGeneSet.setOpaque(true);
                                DREMGui.this.defineFrame.setContentPane(dREMGui_DefineGeneSet);
                                DREMGui.this.defineFrame.pack();
                            } else {
                                DREMGui.this.defineFrame.setExtendedState(0);
                            }
                            DREMGui.this.defineFrame.setVisible(true);
                        }
                    });
                }
            });
            this.gotableButton = PPath.createRectangle(0.0f, 0.0f, BUTTONRECWIDTH, 18.0f);
            PText pText3 = new PText("GO Table");
            pText3.setFont(new Font("times", 0, 12));
            pText3.translate(30.0, 2.0);
            this.gotableButton.setPaint(buttonColor);
            this.gotableButton.addChild(pText3);
            this.gotableButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JFrame jFrame = new JFrame("GO Enrichment for Selected Genes");
                            jFrame.setDefaultCloseOperation(2);
                            jFrame.setLocation(20, 50);
                            jFrame.setSize(826, 509);
                            jFrame.setVisible(true);
                            boolean[] blArray = new boolean[DREMGui.this.plArray.length];
                            for (int i = 0; i < DREMGui.this.plArray.length; ++i) {
                                blArray[i] = DREMGui.this.bPathVisible[i] && DREMGui.this.bTFVisible[i] && DREMGui.this.bGOVisible[i] && DREMGui.this.bSetVisible[i];
                            }
                            DREMGui_GOTable dREMGui_GOTable = new DREMGui_GOTable(dREMGui, jFrame, DREMGui.this.theTimeiohmm.theDataSet, DREMGui.this.theTimeiohmm.bindingData.gene2RegMaxBinding, DREMGui.this.theTimeiohmm.bindingData.gene2RegMaxBindingIndex, DREMGui.this.theTimeiohmm.bindingData.reg2GeneMaxBinding, DREMGui.this.theTimeiohmm.bindingData.reg2GeneMaxBindingIndex, DREMGui.this.theTimeiohmm.bindingData.regNames, blArray);
                            dREMGui_GOTable.setOpaque(true);
                            jFrame.setContentPane(dREMGui_GOTable);
                            jFrame.pack();
                        }
                    });
                }
            });
            this.staticButton = PPath.createRectangle(0.0f, 0.0f, BUTTONRECWIDTH, 18.0f);
            PText pText4 = new PText("Select by TFs");
            pText4.setFont(new Font("times", 0, 12));
            pText4.translate(14.0, 2.0);
            this.staticButton.setPaint(buttonColor);
            this.staticButton.addChild(pText4);
            this.staticButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (DREMGui.this.filterStaticFrame == null) {
                                DREMGui.this.filterStaticFrame = new JFrame("Select Genes based on TF Input Constraints");
                                DREMGui.this.filterStaticFrame.setDefaultCloseOperation(2);
                                DREMGui.this.filterStaticFrame.setLocation(500, 200);
                                DREMGui_FilterStatic dREMGui_FilterStatic = new DREMGui_FilterStatic(DREMGui.this.filterStaticFrame, dREMGui, DREMGui.this.theTimeiohmm.theDataSet.tga, dREMGui.treecopy);
                                dREMGui_FilterStatic.setOpaque(true);
                                DREMGui.this.filterStaticFrame.setContentPane(dREMGui_FilterStatic);
                                DREMGui.this.filterStaticFrame.pack();
                            } else {
                                DREMGui.this.filterStaticFrame.setExtendedState(0);
                            }
                            DREMGui.this.filterStaticFrame.setVisible(true);
                        }
                    });
                }
            });
            this.gofilterButton = PPath.createRectangle(0.0f, 0.0f, BUTTONRECWIDTH, 18.0f);
            this.gofilterButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (DREMGui.this.filterGOFrame == null) {
                                DREMGui.this.filterGOFrame = new JFrame("Select Genes based on GO Category");
                                DREMGui.this.filterGOFrame.setDefaultCloseOperation(2);
                                DREMGui.this.filterGOFrame.setLocation(500, 250);
                                DREMGui.this.theGOFilter = new DREMGui_GOFilter(DREMGui.this.filterGOFrame, dREMGui, dREMGui.theTimeiohmm.theDataSet.tga.theRecIDdrem, dREMGui.treecopy);
                                DREMGui.this.theGOFilter.setOpaque(true);
                                DREMGui.this.filterGOFrame.setContentPane(DREMGui.this.theGOFilter);
                                DREMGui.this.filterGOFrame.pack();
                            } else {
                                DREMGui.this.filterGOFrame.setExtendedState(0);
                            }
                            DREMGui.this.filterGOFrame.setVisible(true);
                        }
                    });
                }
            });
            PText pText5 = new PText("Select by GO");
            pText5.setFont(new Font("times", 0, 12));
            pText5.translate(22.0, 2.0);
            this.gofilterButton.setPaint(buttonColor);
            this.gofilterButton.addChild(pText5);
            this.scaleButton = PPath.createRectangle(0.0f, 0.0f, BUTTONRECWIDTH, 18.0f);
            PText pText6 = new PText("Interface Options");
            pText6.setFont(new Font("times", 0, 12));
            pText6.translate(10.0, 2.0);
            this.scaleButton.setPaint(buttonColor);
            this.scaleButton.addChild(pText6);
            this.scaleButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (DREMGui.this.yscaleFrame == null) {
                                DREMGui.this.yscaleFrame = new JFrame("Interface Options");
                                DREMGui.this.yscaleFrame.setDefaultCloseOperation(2);
                                DREMGui.this.yscaleFrame.setLocation(650, 150);
                                DREMGui.this.theYScalegui = new DREMGui_InterfaceOptions(DREMGui.this.yscaleFrame, dREMGui);
                                DREMGui.this.theYScalegui.setOpaque(true);
                                DREMGui.this.yscaleFrame.setContentPane(DREMGui.this.theYScalegui);
                                DREMGui.this.yscaleFrame.pack();
                            } else {
                                DREMGui.this.yscaleFrame.setExtendedState(0);
                            }
                            DREMGui.this.yscaleFrame.setVisible(true);
                        }
                    });
                }
            });
            this.predictButton = PPath.createRectangle(0.0f, 0.0f, BUTTONRECWIDTH, 18.0f);
            PText pText7 = new PText("Predict");
            pText7.setFont(new Font("times", 0, 12));
            pText7.translate(35.0, 2.0);
            this.predictButton.setPaint(buttonColor);
            this.predictButton.addChild(pText7);
            this.predictButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (DREMGui.this.predictFrame == null) {
                                DREMGui.this.predictFrame = new JFrame("Predict Time Series based on TF Input");
                                DREMGui.this.predictFrame.setDefaultCloseOperation(2);
                                DREMGui.this.predictFrame.setLocation(400, 300);
                                DREMGui_Predict dREMGui_Predict = new DREMGui_Predict(DREMGui.this.predictFrame, dREMGui, dREMGui.treecopy);
                                dREMGui_Predict.setOpaque(true);
                                DREMGui.this.predictFrame.setContentPane(dREMGui_Predict);
                                DREMGui.this.predictFrame.pack();
                            } else {
                                DREMGui.this.predictFrame.setExtendedState(0);
                            }
                            DREMGui.this.predictFrame.setVisible(true);
                        }
                    });
                }
            });
            this.hideButton = PPath.createRectangle(0.0f, 0.0f, BUTTONRECWIDTH, 18.0f);
            this.hideText = this.bglobalnode ? new PText("Hide Nodes") : new PText("Show Nodes");
            this.hideText.setFont(new Font("times", 0, 12));
            this.hideText.translate(23.0, 2.0);
            this.hideButton.setPaint(buttonColor);
            this.hideButton.addChild(this.hideText);
            this.hideButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    int n = DREMGui.this.hideList.size();
                    if (DREMGui.this.bglobalnode) {
                        DREMGui.this.hideText.setText("Show Nodes");
                        for (int i = 0; i < n; ++i) {
                            PNode pNode = DREMGui.this.hideList.get(i);
                            pNode.setVisible(false);
                            pNode.setPickable(false);
                        }
                        if (DREMGui.this.battachlabels) {
                            DREMGui.this.hidelabels();
                        }
                        DREMGui.this.bglobalnode = false;
                    } else {
                        DREMGui.this.hideText.setText("Hide Nodes");
                        for (int i = 0; i < n; ++i) {
                            PNode pNode = DREMGui.this.hideList.get(i);
                            pNode.setVisible(true);
                            pNode.setPickable(true);
                        }
                        if (DREMGui.this.battachlabels) {
                            DREMGui.this.showlabels();
                        }
                        DREMGui.this.bglobalnode = true;
                    }
                }
            });
            this.saveDREMButton = PPath.createRectangle(0.0f, 0.0f, BUTTONRECWIDTH, 18.0f);
            PText pText8 = new PText(" Save Image ");
            pText8.setFont(new Font("times", 0, 12));
            pText8.translate(18.0, 2.0);
            this.saveDREMButton.setPaint(buttonColor);
            this.saveDREMButton.addChild(pText8);
            this.saveDREMButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (DREMGui.this.saveDREMFrame == null) {
                                DREMGui.this.saveDREMFrame = new JFrame("Save as Image");
                                DREMGui.this.saveDREMFrame.setDefaultCloseOperation(2);
                                DREMGui.this.saveDREMFrame.setLocation(400, 300);
                                DREMGui_SaveDREM dREMGui_SaveDREM = new DREMGui_SaveDREM(dREMGui, DREMGui.this.saveDREMFrame);
                                dREMGui_SaveDREM.setOpaque(true);
                                DREMGui.this.saveDREMFrame.setContentPane(dREMGui_SaveDREM);
                                DREMGui.this.saveDREMFrame.pack();
                            } else {
                                DREMGui.this.saveDREMFrame.setExtendedState(0);
                            }
                            DREMGui.this.saveDREMFrame.setVisible(true);
                        }
                    });
                }
            });
            this.saveModelButton = PPath.createRectangle(0.0f, 0.0f, BUTTONRECWIDTH, 18.0f);
            PText pText9 = new PText(" Save Model ");
            pText9.setFont(new Font("times", 0, 12));
            pText9.translate(18.0, 2.0);
            this.saveModelButton.setPaint(buttonColor);
            this.saveModelButton.addChild(pText9);
            this.saveModelButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (DREMGui.this.saveModelFrame == null) {
                                DREMGui.this.saveModelFrame = new JFrame("Save Model to File");
                                DREMGui.this.saveModelFrame.setDefaultCloseOperation(2);
                                DREMGui.this.saveModelFrame.setLocation(400, 300);
                                DREMGui_SaveModel dREMGui_SaveModel = new DREMGui_SaveModel(dREMGui.theTimeiohmm, DREMGui.this.treecopy, DREMGui.this.saveModelFrame, dREMGui);
                                dREMGui_SaveModel.setOpaque(true);
                                DREMGui.this.saveModelFrame.setContentPane(dREMGui_SaveModel);
                                DREMGui.this.saveModelFrame.pack();
                            } else {
                                DREMGui.this.saveModelFrame.setExtendedState(0);
                            }
                            DREMGui.this.saveModelFrame.setVisible(true);
                        }
                    });
                }
            });
            this.timeButton = PPath.createRectangle(0.0f, 0.0f, BUTTONRECWIDTH, 18.0f);
            PText pText10 = this.bglobalVisible ? new PText("Hide Time Series") : new PText("Show Time Series");
            pText10.setFont(new Font("times", 0, 12));
            pText10.translate(7.0, 2.0);
            this.timeButton.setPaint(buttonColor);
            this.timeButton.addChild(pText10);
            final PText pText11 = pText10;
            final PNode[] pNodeArray = this.plArray;
            this.timeButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    if (DREMGui.this.bglobalVisible) {
                        pText11.setText("Show Time Series");
                        for (int i = 0; i < pNodeArray.length; ++i) {
                            pNodeArray[i].setVisible(false);
                            pNodeArray[i].setPickable(false);
                        }
                        DREMGui.this.bglobalVisible = false;
                    } else {
                        pText11.setText("Hide Time Series");
                        for (int i = 0; i < pNodeArray.length; ++i) {
                            boolean bl = DREMGui.this.bPathVisible[i] && DREMGui.this.bTFVisible[i] && DREMGui.this.bGOVisible[i] && DREMGui.this.bSetVisible[i];
                            pNodeArray[i].setVisible(bl);
                            pNodeArray[i].setPickable(bl);
                        }
                        DREMGui.this.bglobalVisible = true;
                    }
                }
            });
            this.siginButton = PPath.createRectangle(0.0f, 0.0f, BUTTONRECWIDTH, 18.0f);
            PText pText12 = new PText("Key TFs Labels");
            pText12.setFont(new Font("times", 0, 12));
            pText12.translate(10.0, 2.0);
            this.siginButton.setPaint(buttonColor);
            this.siginButton.addChild(pText12);
            this.nheight = this.getHeight();
            int n8 = 10;
            int n9 = n8 + BUTTONRECWIDTH;
            this.nwidth = this.getWidth();
            this.INITLEFT = (double)this.nwidth / 2.0 - (double)(3 * n9);
            this.helpButton = new PImage(Util.getImageURL("Help24.gif"));
            PImage pImage = new PImage(Util.getImageURL("Save24.gif"));
            final DREMGui dREMGui2 = this;
            pImage.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    try {
                        int n = Util.theChooser.showSaveDialog(dREMGui2);
                        if (n == 0) {
                            File file = Util.theChooser.getSelectedFile();
                            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                            DREMGui.this.printDefaults(printWriter);
                            printWriter.close();
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        final FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(null, fileNotFoundException2.getMessage(), "Exception thrown", 0);
                            }
                        });
                        fileNotFoundException.printStackTrace(System.out);
                    }
                }
            });
            this.helpButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JDialog jDialog = new JDialog(dREMGui2, "Help", false);
                            Container container = jDialog.getContentPane();
                            jDialog.setBackground(Color.white);
                            container.setBackground(Color.white);
                            String string = "This is the main interface window of DREM. The window shows a plot of the expression profiles of genes that were not filtered along with the map learned by DREM, and associated TF labels.  Green nodes are split nodes, and nodes size is proportional to the standard deviation of their assocoated gaussian emission distribution.  Left clicking on an edge of the map shows only genes assigned to that path through the model.  Right clicking on an edge on TF label box brings up info about the TFs regulating genes assigned to the path.\n\nThe buttons along the bottom function as follows: \nPredict - displays for a given TF input vector the probability of transitioning to each state \nInterface Options - displays menu to adjust interface options \nGO Table - displays a GO enrichment analysis for the currently selected genes\nGene Table - displays a gene table for the currently selected genes\nKey TFs Labels - adjust the criteria and threshold for display TF labels on the map\nSelect by TFs - select genes by which TFs they regulated by \nSelect by GO - selects genes based on the GO category to which they are annotated\nSelect by Gene Set - selects genes based on a defined set\nHide Nodes/Show Nodes - hide/shows the nodes \nHide Time Series/Show Time Series - hide/shows the time series expression patterns on the interface\nSave Model - exports the model to a file can then be loaded later under the 'Saved Model File' option\nSave Image - saves the interface window to a graphics file\nSave Disk - saves model parameters used to generate the current results out to a default text file.";
                            JTextArea jTextArea = new JTextArea(string, 10, 60);
                            jTextArea.setLineWrap(true);
                            jTextArea.setWrapStyleWord(true);
                            jTextArea.setBackground(Color.white);
                            jTextArea.setEditable(false);
                            JScrollPane jScrollPane = new JScrollPane(jTextArea);
                            container.add(jScrollPane);
                            container.setSize(820, 600);
                            container.validate();
                            jDialog.setLocation(dREMGui2.getX() + 50, dREMGui2.getY() + 25);
                            jDialog.setSize(820, 600);
                            jDialog.setDefaultCloseOperation(2);
                            jDialog.setVisible(true);
                        }
                    });
                }
            });
            pCamera.addChild(this.saveDREMButton);
            pCamera.addChild(this.saveModelButton);
            pCamera.addChild(this.helpButton);
            pCamera.addChild(pImage);
            pCamera.addChild(this.staticButton);
            pCamera.addChild(this.setButton);
            pCamera.addChild(this.gofilterButton);
            pCamera.addChild(this.scaleButton);
            pCamera.addChild(this.predictButton);
            pCamera.addChild(this.hideButton);
            pCamera.addChild(this.timeButton);
            pCamera.addChild(this.siginButton);
            pCamera.addChild(this.genetableButton);
            pCamera.addChild(this.gotableButton);
            this.scaleButton.translate(this.INITLEFT, this.nheight - 55);
            this.predictButton.translate(this.INITLEFT, this.nheight - 77);
            this.genetableButton.translate(this.INITLEFT + (double)n9, this.nheight - 55);
            this.gotableButton.translate(this.INITLEFT + (double)n9, this.nheight - 77);
            this.siginButton.translate(this.INITLEFT + (double)(2 * n9), this.nheight - 77);
            this.staticButton.translate(this.INITLEFT + (double)(2 * n9), this.nheight - 55);
            this.setButton.translate(this.INITLEFT + (double)(3 * n9), this.nheight - 55);
            this.gofilterButton.translate(this.INITLEFT + (double)(3 * n9), this.nheight - 77);
            this.helpButton.translate(this.INITLEFT + (double)(6 * n9), this.nheight - 59);
            pImage.translate(this.INITLEFT + (double)(6 * n9), this.nheight - 81);
            this.saveDREMButton.translate(this.INITLEFT + (double)(5 * n9), this.nheight - 55);
            this.saveModelButton.translate(this.INITLEFT + (double)(5 * n9), this.nheight - 77);
            this.hideButton.translate(this.INITLEFT + (double)(4 * n9), this.nheight - 77);
            this.timeButton.translate(this.INITLEFT + 4.0 * (double)n9, this.nheight - 55);
            this.siginButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (DREMGui.this.keyinputFrame == null) {
                                DREMGui.this.keyinputFrame = new JFrame("Key Transcription Factors (TFs) Labels");
                                DREMGui.this.keyinputFrame.setDefaultCloseOperation(2);
                                DREMGui.this.keyinputFrame.setLocation(600, 350);
                                DREMGui_KeyInputs dREMGui_KeyInputs = new DREMGui_KeyInputs(DREMGui.this.keyinputFrame, dREMGui);
                                dREMGui_KeyInputs.setOpaque(true);
                                DREMGui.this.keyinputFrame.setContentPane(dREMGui_KeyInputs);
                                DREMGui.this.keyinputFrame.pack();
                            } else {
                                DREMGui.this.keyinputFrame.setExtendedState(0);
                            }
                            DREMGui.this.keyinputFrame.setVisible(true);
                        }
                    });
                }
            });
            int n10 = this.hidesigList.size();
            for (int i = 0; i < n10; ++i) {
                SigInfoRec sigInfoRec = this.hidesigList.get(i);
                this.theLayer.addChild(sigInfoRec.border);
                double d6 = sigInfoRec.border.getWidth();
                this.setSigText(sigInfoRec.theSigTF, (PPath)sigInfoRec.border, sigInfoRec.ntype, sigInfoRec.ndepth, this.displayTF, this.displayMIRNA, sigInfoRec.node, this.colorSigTFs);
                sigInfoRec.border.translate(d6 - sigInfoRec.border.getWidth(), 0.0);
            }
            this.renderFilterText();
        }
    }

    public void hidelabels() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.hidegolabelsList.size();
        for (n4 = 0; n4 < n5; ++n4) {
            PText pText = this.hidegolabelsList.get(n4);
            pText.setVisible(false);
            pText.setPickable(false);
        }
        n4 = this.hidegenesetlabelsList.size();
        for (n3 = 0; n3 < n4; ++n3) {
            PText pText = this.hidegenesetlabelsList.get(n3);
            pText.setVisible(false);
            pText.setPickable(false);
        }
        n3 = this.hidetfsetlabelsList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            PText pText = this.hidetfsetlabelsList.get(n2);
            pText.setVisible(false);
            pText.setPickable(false);
        }
        n2 = this.hidepredictlabelsList.size();
        for (n = 0; n < n2; ++n) {
            PText pText = this.hidepredictlabelsList.get(n);
            pText.setVisible(false);
            pText.setPickable(false);
        }
        n = this.hidesigList.size();
        for (int i = 0; i < n; ++i) {
            SigInfoRec sigInfoRec = this.hidesigList.get(i);
            PPath pPath = (PPath)sigInfoRec.border;
            pPath.setVisible(false);
            pPath.setPickable(false);
            for (Object e : pPath.getChildrenReference()) {
                PNode pNode = (PNode)e;
                pNode.setVisible(false);
                pNode.setPickable(false);
                for (Object e2 : pNode.getChildrenReference()) {
                    PNode pNode2 = (PNode)e2;
                    pNode2.setVisible(false);
                    pNode2.setPickable(false);
                }
            }
        }
        this.filterText.setVisible(false);
        this.filterText.setPickable(false);
    }

    public void showlabels() {
        Object object;
        int n;
        int n2;
        if (this.bshowgolabels && this.bapplygolabels) {
            n2 = this.hidegolabelsList.size();
            for (n = 0; n < n2; ++n) {
                object = this.hidegolabelsList.get(n);
                ((PNode)object).setVisible(true);
            }
        }
        if (this.bshowgenesetlabels && this.bapplygenesetlabels) {
            n2 = this.hidegenesetlabelsList.size();
            for (n = 0; n < n2; ++n) {
                object = this.hidegenesetlabelsList.get(n);
                ((PNode)object).setVisible(true);
            }
        }
        if (this.bshowtfsetlabels && this.bapplytfsetlabels) {
            n2 = this.hidetfsetlabelsList.size();
            for (n = 0; n < n2; ++n) {
                object = this.hidetfsetlabelsList.get(n);
                ((PNode)object).setVisible(true);
            }
        }
        if (this.bshowpredict) {
            n2 = this.hidepredictlabelsList.size();
            for (n = 0; n < n2; ++n) {
                object = this.hidepredictlabelsList.get(n);
                ((PNode)object).setVisible(true);
            }
        }
        if (this.bshowkeyinputs) {
            n2 = this.hidesigList.size();
            for (n = 0; n < n2; ++n) {
                object = this.hidesigList.get(n);
                PPath pPath = (PPath)((SigInfoRec)object).border;
                pPath.setVisible(true);
                pPath.setPickable(true);
                for (Object e : pPath.getChildrenReference()) {
                    PNode pNode = (PNode)e;
                    pNode.setVisible(true);
                    pNode.setPickable(true);
                    for (Object e2 : pNode.getChildrenReference()) {
                        PNode pNode2 = (PNode)e2;
                        pNode2.setVisible(true);
                        pNode2.setPickable(true);
                    }
                }
            }
        }
        this.filterText.setVisible(true);
        this.filterText.setPickable(false);
    }

    public void setSigText(TreeSet<DREM_Timeiohmm.SigTFRecv2> treeSet, PPath pPath, int n, int n2, boolean bl, boolean bl2, DREM_Timeiohmm.Treenode treenode, boolean bl3) {
        Object object;
        Cloneable cloneable;
        Cloneable cloneable2;
        this.displayTF = bl;
        this.displayMIRNA = bl2;
        PPath pPath2 = new PPath();
        PPath pPath3 = new PPath();
        PPath pPath4 = new PPath();
        PPath pPath5 = new PPath();
        PPath pPath6 = new PPath();
        PPath pPath7 = new PPath();
        pPath2.setPickable(false);
        pPath3.setPickable(false);
        pPath4.setPickable(false);
        pPath5.setPickable(false);
        pPath6.setPickable(false);
        pPath7.setPickable(false);
        pPath.addChild(pPath2);
        pPath.addChild(pPath3);
        pPath.addChild(pPath4);
        pPath.addChild(pPath5);
        pPath.addChild(pPath6);
        pPath.addChild(pPath7);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        if (n == this.nKeyInputType) {
            cloneable2 = new HashSet();
            cloneable = treenode.getAncestorActivityScores();
            for (DREM_Timeiohmm.SigTFRecv2 sigTFRecv2 : treeSet) {
                Object object2;
                object = sigTFRecv2;
                Integer n3 = this.theTimeiohmm.bindingData.regTypeMap.get(((DREM_Timeiohmm.SigTFRecv2)object).szname);
                boolean bl4 = false;
                int n4 = 0;
                if (this.nKeyInputType != 778 && this.nKeyInputType != 777) {
                    switch (n3) {
                        case 1: {
                            if (!(((DREM_Timeiohmm.SigTFRecv2)object).dpval <= this.dkeymiRNAinputpvalue) || this.nKeyInputType == 1 && !(((DREM_Timeiohmm.SigTFRecv2)object).dpercent >= this.dsplitpercent) || ((HashSet)cloneable2).contains(((DREM_Timeiohmm.SigTFRecv2)object).szname) || !bl2) break;
                            bl4 = true;
                            break;
                        }
                        case 0: {
                            if (!(((DREM_Timeiohmm.SigTFRecv2)object).dpval <= this.dkeyinputpvalue) || this.nKeyInputType == 1 && !(((DREM_Timeiohmm.SigTFRecv2)object).dpercent >= this.dsplitpercent) || ((HashSet)cloneable2).contains(((DREM_Timeiohmm.SigTFRecv2)object).szname) || !bl) break;
                            bl4 = true;
                        }
                    }
                } else if (((DREM_Timeiohmm.SigTFRecv2)object).dpval <= this.dkeyinputpvalue) {
                    object2 = ((DREM_Timeiohmm.SigTFRecv2)object).szname;
                    if (this.nKeyInputType == 777 || !((HashMap)cloneable).containsKey(object2) || (Double)((HashMap)cloneable).get(object2) > this.dkeyinputpvalue) {
                        bl4 = true;
                    }
                }
                if (!bl4) continue;
                this.sigRegs.add(((DREM_Timeiohmm.SigTFRecv2)object).szname);
                switch (n3) {
                    case 1: {
                        Integer n5 = this.theTimeiohmm.reg2DataSetIndex.get(((DREM_Timeiohmm.SigTFRecv2)object).szname.toUpperCase());
                        if (n5 == null) break;
                        double d = this.theTimeiohmm.miRNADataSet.data[n5][n2];
                        n4 = (int)Math.signum(d);
                        break;
                    }
                    case 0: {
                        Integer n5 = this.theTimeiohmm.reg2DataSetIndex.get(((DREM_Timeiohmm.SigTFRecv2)object).szname.toUpperCase());
                        if (n5 == null) break;
                        double d = this.theTimeiohmm.theDataSet.data[n5][n2];
                        n4 = (int)Math.signum(d);
                    }
                }
                object2 = new PText("");
                ((PText)object2).setFont(new Font("Arial", 1, 14));
                ((PText)object2).setText(" " + ((DREM_Timeiohmm.SigTFRecv2)object).szname + " ");
                ((PNode)object2).setPickable(false);
                if (((PNode)object2).getWidth() > (double)f) {
                    f = (float)((PNode)object2).getWidth();
                }
                f2 += (float)((PNode)object2).getHeight();
                switch (n4) {
                    case -1: {
                        ((PText)object2).setTextPaint(Color.RED);
                        if (n3 == 1) {
                            pPath7.addChild((PNode)object2);
                            ((PNode)object2).translate(0.0, f8);
                            f8 += (float)((PNode)object2).getHeight();
                            break;
                        }
                        pPath4.addChild((PNode)object2);
                        ((PNode)object2).translate(0.0, f5);
                        f5 += (float)((PNode)object2).getHeight();
                        break;
                    }
                    case 0: {
                        if (n3 == 1) {
                            pPath6.addChild((PNode)object2);
                            ((PNode)object2).translate(0.0, f7);
                            f7 += (float)((PNode)object2).getHeight();
                            break;
                        }
                        pPath3.addChild((PNode)object2);
                        ((PNode)object2).translate(0.0, f4);
                        f4 += (float)((PNode)object2).getHeight();
                        break;
                    }
                    case 1: {
                        ((PText)object2).setTextPaint(Color.BLUE);
                        if (n3 == 1) {
                            pPath5.addChild((PNode)object2);
                            ((PNode)object2).translate(0.0, f6);
                            f6 += (float)((PNode)object2).getHeight();
                            break;
                        }
                        pPath2.addChild((PNode)object2);
                        ((PNode)object2).translate(0.0, f3);
                        f3 += (float)((PNode)object2).getHeight();
                    }
                }
                if (!bl3) {
                    ((PText)object2).setTextPaint(Color.BLACK);
                }
                ((HashSet)cloneable2).add(((DREM_Timeiohmm.SigTFRecv2)object).szname);
            }
        }
        pPath.reset();
        pPath2.reset();
        pPath3.reset();
        pPath4.reset();
        pPath5.reset();
        pPath6.reset();
        pPath7.reset();
        if (f != 0.0f) {
            pPath.setPathToRectangle(0.0f, 0.0f, f, f2);
            pPath.setPaint(Color.WHITE);
            cloneable2 = new PPath();
            ((PNode)cloneable2).setPickable(false);
            pPath.addChild(0, (PNode)cloneable2);
            if (this.lineendpoints.get(pPath) == null) {
                cloneable = pPath.localToGlobal(new Point2D.Double(0.0, 0.0));
                this.lineendpoints.put(pPath, (Point2D)cloneable);
                ((PPath)cloneable2).setPathToPolyline(new float[]{0.0f, 0.0f}, new float[]{0.0f, 0.0f});
            } else {
                cloneable = this.lineendpoints.get(pPath);
                Point2D[] point2DArray = new Point2D[]{pPath.globalToLocal((Point2D)((Point2D)cloneable).clone()), new Point2D.Double(pPath.getX(), pPath.getY())};
                ((PPath)cloneable2).setPathToPolyline(point2DArray);
                ((PNode)cloneable2).setVisible(true);
            }
            float f9 = 0.0f;
            pPath2.setPathToRectangle(0.0f, f9, f, f3);
            pPath3.setPathToRectangle(0.0f, f9 += f3, f, f4);
            for (DREM_Timeiohmm.SigTFRecv2 sigTFRecv2 : pPath3.getChildrenReference()) {
                object = (PNode)((Object)sigTFRecv2);
                ((PNode)object).translate(0.0, f9);
            }
            pPath4.setPathToRectangle(0.0f, f9 += f4, f, f5);
            for (DREM_Timeiohmm.SigTFRecv2 sigTFRecv2 : pPath4.getChildrenReference()) {
                object = (PNode)((Object)sigTFRecv2);
                ((PNode)object).translate(0.0, f9);
            }
            pPath5.setPathToRectangle(0.0f, f9 += f5, f, f6);
            for (DREM_Timeiohmm.SigTFRecv2 sigTFRecv2 : pPath5.getChildrenReference()) {
                object = (PNode)((Object)sigTFRecv2);
                ((PNode)object).translate(0.0, f9);
            }
            pPath6.setPathToRectangle(0.0f, f9 += f6, f, f7);
            for (DREM_Timeiohmm.SigTFRecv2 sigTFRecv2 : pPath6.getChildrenReference()) {
                object = (PNode)((Object)sigTFRecv2);
                ((PNode)object).translate(0.0, f9);
            }
            pPath7.setPathToRectangle(0.0f, f9 += f7, f, f8);
            for (DREM_Timeiohmm.SigTFRecv2 sigTFRecv2 : pPath7.getChildrenReference()) {
                object = (PNode)((Object)sigTFRecv2);
                ((PNode)object).translate(0.0, f9);
            }
        }
    }

    public PBasicInputEventHandler drawNodes(DREM_Timeiohmm.Treenode treenode, int n, double d, double d2, BigInteger bigInteger, int n2, Color color, Color color2, int n3, int n4, int n5) {
        PBasicInputEventHandler pBasicInputEventHandler = null;
        if (treenode != null) {
            Object object;
            Serializable serializable;
            Object object2;
            Object object3;
            Object object4;
            EventListener eventListener;
            ArrayList<PPath> arrayList;
            double d3 = this.dwidthunitsCum[n] + (double)LEFTBUFFER;
            double d4 = this.REALHEIGHT - this.dheightunits * (treenode.dmean - this.dmin);
            double d5 = Math.sqrt(this.dnodek) * this.dminheightunits * Math.sqrt(treenode.dsigma) / 2.0;
            PPath pPath = null;
            int n6 = this.numcolor - 1;
            boolean bl = true;
            if (treenode.parent != null && treenode.parent.parentptrA != null && treenode.parent.parentptrA.length != 1) {
                color = color2;
                n6 = n3;
                bl = false;
            }
            if (color == null) {
                color = this.htColorIDtoColor.get(new Integer(this.numcolor));
                if (color == null) {
                    if (this.numcolor < this.theTimeiohmm.savedColors.size()) {
                        color = this.theTimeiohmm.savedColors.get(this.numcolor);
                    } else if (n2 == 0) {
                        color = n2 < this.edgeColorsTriples[0].length ? this.edgeColorsTriples[this.nparentcolorindex % this.edgeColorsTriples.length][n2] : this.edgeColorsTriples[(this.nparentcolorindex + n2 - this.edgeColorsTriples[0].length + 1) % this.edgeColorsTriples[0].length][this.edgeColorsTriples[0].length - 1];
                        if (treenode.parent != null) {
                            treenode.parent.nparentcolorindex = this.nparentcolorindex;
                        }
                        ++this.nparentcolorindex;
                        n4 = this.nparentcolorindex;
                    } else {
                        color = n2 < this.edgeColorsTriples[0].length ? this.edgeColorsTriples[treenode.parent.nparentcolorindex % this.edgeColorsTriples.length][n2] : this.edgeColorsTriples[(treenode.parent.nparentcolorindex + n2 - this.edgeColorsTriples[0].length + 1) % this.edgeColorsTriples[0].length][this.edgeColorsTriples[0].length - 1];
                    }
                }
                n6 = this.numcolor++;
            }
            if (bl) {
                this.htColorIDtoColor.put(new Integer(n6), color);
            }
            this.htLineIDtoColorID.put(n + ";" + bigInteger, new Integer(n6));
            PDragEventHandler pDragEventHandler = new PDragEventHandler(){
                PPath border;
                Point2D zero;

                public void startDrag(PInputEvent pInputEvent) {
                    super.startDrag(pInputEvent);
                    this.border = (PPath)pInputEvent.getPickedNode();
                    this.zero = DREMGui.this.lineendpoints.get(this.border);
                    pInputEvent.setHandled(true);
                }

                public void drag(PInputEvent pInputEvent) {
                    super.drag(pInputEvent);
                    this.border = (PPath)pInputEvent.getPickedNode();
                    PPath pPath = (PPath)this.border.getChild(0);
                    Point2D[] point2DArray = new Point2D[]{this.border.globalToLocal((Point2D)this.zero.clone()), new Point2D.Double(this.border.getX(), this.border.getY())};
                    pPath.setPathToPolyline(point2DArray);
                    pInputEvent.setHandled(true);
                }

                public void endDrag(PInputEvent pInputEvent) {
                    super.endDrag(pInputEvent);
                    this.border = (PPath)pInputEvent.getPickedNode();
                    PPath pPath = (PPath)this.border.getChild(0);
                    Point2D[] point2DArray = new Point2D[]{this.border.globalToLocal((Point2D)this.zero.clone()), new Point2D.Double(this.border.getX(), this.border.getY())};
                    pPath.setPathToPolyline(point2DArray);
                    pInputEvent.setHandled(true);
                }
            };
            if (n == 0) {
                int n7 = n2;
                arrayList = treenode;
                eventListener = this;
                pBasicInputEventHandler = new PBasicInputEventHandler((DREMGui)eventListener, (DREM_Timeiohmm.Treenode)((Object)arrayList), bigInteger, n, n7){
                    final /* synthetic */ DREMGui val$theDREMGui;
                    final /* synthetic */ DREM_Timeiohmm.Treenode val$fptr;
                    final /* synthetic */ BigInteger val$ncurrscore;
                    final /* synthetic */ int val$ndepth;
                    final /* synthetic */ int val$fnchild;
                    {
                        this.val$theDREMGui = dREMGui2;
                        this.val$fptr = treenode;
                        this.val$ncurrscore = bigInteger;
                        this.val$ndepth = n;
                        this.val$fnchild = n2;
                    }

                    public void mousePressed(PInputEvent pInputEvent) {
                        if (pInputEvent.getButton() == 3) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JFrame jFrame = new JFrame("Path Table " + DREMGui.this.nKeyInputType);
                                    jFrame.setDefaultCloseOperation(2);
                                    jFrame.setLocation(200, 200);
                                    DREMGui_EdgeTable dREMGui_EdgeTable = new DREMGui_EdgeTable(val$theDREMGui, jFrame, DREMGui.this.theTimeiohmm, val$fptr, val$ncurrscore, val$ndepth, val$fnchild, DREMGui.this.nKeyInputType, true);
                                    dREMGui_EdgeTable.setOpaque(true);
                                    jFrame.setContentPane(dREMGui_EdgeTable);
                                    jFrame.pack();
                                    jFrame.setVisible(true);
                                }
                            });
                        }
                    }
                };
            } else if (n > 0) {
                pPath = PPath.createLine((float)d, (float)d2, (float)d3, (float)d4);
                PPath pPath2 = PPath.createLine((float)d, (float)d2, (float)d3, (float)d4);
                pPath2.setStroke(new BasicStroke(8.0f));
                pPath2.setStrokePaint(Color.black);
                this.canvas.getLayer().addChild(pPath2);
                pPath.setStroke(new BasicStroke(5.0f));
                pPath.setStrokePaint(color);
                arrayList = this.htColorIDtoLinesList.get(new Integer(n6));
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    arrayList.add(pPath);
                    this.htColorIDtoLinesList.put(new Integer(n6), arrayList);
                } else {
                    arrayList.add(pPath);
                }
                if (!this.bglobalnode) {
                    pPath.setVisible(false);
                    pPath.setPickable(false);
                    pPath2.setVisible(false);
                    pPath2.setPickable(false);
                }
                this.canvas.getLayer().addChild(pPath);
                this.hideList.add(pPath);
                this.hideList.add(pPath2);
                int n8 = n2;
                object4 = treenode;
                final DREMGui dREMGui = this;
                pBasicInputEventHandler = new PBasicInputEventHandler((DREM_Timeiohmm.Treenode)object4, bigInteger, n, n8){
                    final /* synthetic */ DREM_Timeiohmm.Treenode val$fptr;
                    final /* synthetic */ BigInteger val$ncurrscore;
                    final /* synthetic */ int val$ndepth;
                    final /* synthetic */ int val$fnchild;
                    {
                        this.val$fptr = treenode;
                        this.val$ncurrscore = bigInteger;
                        this.val$ndepth = n;
                        this.val$fnchild = n2;
                    }

                    public void mousePressed(PInputEvent pInputEvent) {
                        if (pInputEvent.getButton() == 3) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JFrame jFrame = new JFrame("Path Table " + DREMGui.this.nKeyInputType);
                                    jFrame.setDefaultCloseOperation(2);
                                    jFrame.setLocation(200, 200);
                                    DREMGui_EdgeTable dREMGui_EdgeTable = new DREMGui_EdgeTable(dREMGui, jFrame, DREMGui.this.theTimeiohmm, val$fptr.parent, val$ncurrscore, val$ndepth, val$fnchild, DREMGui.this.nKeyInputType, false);
                                    dREMGui_EdgeTable.setOpaque(true);
                                    jFrame.setContentPane(dREMGui_EdgeTable);
                                    jFrame.pack();
                                    jFrame.setVisible(true);
                                }
                            });
                        }
                    }
                };
                pPath.addInputEventListener(pBasicInputEventHandler);
            }
            PPath pPath3 = PPath.createEllipse((float)(d3 - d5 / 2.0), (float)(d4 - d5 / 2.0), (float)d5, (float)d5);
            arrayList = "Mean " + this.nf3.format(treenode.dmean) + "; Std. Dev. " + this.nf3.format(treenode.dsigma);
            eventListener = new ToolTipTextUpdater(this.canvas, pPath3, (String)((Object)arrayList));
            pPath3.addInputEventListener((PInputEventListener)eventListener);
            if (treenode.numchildren <= 1) {
                object4 = this.htColorIDtoCircleList.get(new Integer(n6));
                if (object4 == null) {
                    object4 = new ArrayList();
                    ((ArrayList)object4).add(pPath3);
                    this.htColorIDtoCircleList.put(new Integer(n6), (ArrayList<PNode>)object4);
                } else {
                    ((ArrayList)object4).add(pPath3);
                }
                if (treenode.parentptrA == null || treenode.parentptrA.length == 1) {
                    pPath3.setPaint(color);
                } else {
                    pPath3.setPaint(color2);
                }
            } else {
                pPath3.setPaint(this.SPLITCOLOR);
            }
            object4 = new PBasicInputEventHandler[treenode.numchildren];
            for (int i = 0; i < treenode.numchildren; ++i) {
                object3 = bigInteger.add(new BigInteger("" + i).multiply(new BigInteger("" + this.theTimeiohmm.nmaxchild).pow(this.data[0].length - n - 1)));
                object4[i] = treenode.numchildren == 1 ? this.drawNodes(treenode.nextptr[i], n + 1, d3, d4, (BigInteger)object3, i, color, color2, n3, n4, treenode.nminparentlevel) : this.drawNodes(treenode.nextptr[i], n + 1, d3, d4, (BigInteger)object3, i, null, color, n6, n4, treenode.nminparentlevel);
            }
            final PPath pPath4 = pPath3;
            object3 = treenode;
            if (treenode.parentptrA == null || treenode.parentptrA.length == 1) {
                this.htNodes.put(pPath3, new CircleID(n, treenode.nminparentlevel, treenode.nminparentlevel, bigInteger, this.ncircleID));
            } else {
                this.htNodes.put(pPath3, new CircleID(n, treenode.nminparentlevel, n5, bigInteger, this.ncircleID));
            }
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
            if (treenode.dpredictweight < 1.0) {
                numberFormat.setMaximumIntegerDigits(0);
                numberFormat.setMinimumFractionDigits(2);
                numberFormat.setMaximumFractionDigits(2);
            } else {
                numberFormat.setMinimumFractionDigits(1);
                numberFormat.setMaximumFractionDigits(1);
            }
            (treenode.thepredictText = new PText(numberFormat.format(treenode.dpredictweight))).setVisible(this.bshowpredict && (this.bglobalnode || !this.battachlabels));
            treenode.thepredictText.translate(d3 - d5 / 2.0, d4 - d5 / 3.0);
            treenode.thepredictText.setFont(new Font("times", 1, 10));
            treenode.thepredictText.setTextPaint(this.predictLabelColor);
            treenode.thepredictText.setPickable(false);
            treenode.goText = new PText(treenode.szgolabel);
            treenode.goText.setVisible(this.bshowgolabels && this.bapplygolabels && (this.bglobalnode || !this.battachlabels));
            treenode.goText.setFont(new Font("times", 1, 14));
            treenode.goText.setTextPaint(Color.black);
            treenode.goText.setPickable(false);
            treenode.goText.translate(d3 + d5 / 2.0, d4 - d5 / 2.0);
            this.hidegolabelsList.add(treenode.goText);
            treenode.genesetText = new PText(treenode.szgenesetlabel);
            treenode.genesetText.setVisible(this.bshowgenesetlabels && this.bapplygenesetlabels && (this.bglobalnode || !this.battachlabels));
            treenode.genesetText.setFont(new Font("times", 1, 14));
            treenode.genesetText.setTextPaint(this.genesetLabelColor);
            treenode.genesetText.setPickable(false);
            treenode.genesetText.translate(d3 + d5 / 2.0, d4 - d5 / 2.0);
            this.hidegenesetlabelsList.add(treenode.genesetText);
            treenode.tfsetText = new PText(treenode.sztfsetlabel);
            treenode.tfsetText.setVisible(this.bshowtfsetlabels && this.bapplytfsetlabels && (this.bglobalnode || !this.battachlabels));
            treenode.tfsetText.setFont(new Font("times", 1, 14));
            treenode.tfsetText.setTextPaint(this.tfLabelColor);
            treenode.tfsetText.setPickable(false);
            treenode.tfsetText.translate(d3 + d5 / 2.0, d4 - d5 / 2.0);
            this.hidetfsetlabelsList.add(treenode.tfsetText);
            this.hidepredictlabelsList.add(treenode.thepredictText);
            for (int i = 0; i < treenode.numchildren; ++i) {
                object2 = new PPath();
                if (!this.bglobalnode && this.battachlabels || !this.bshowkeyinputs) {
                    ((PNode)object2).setVisible(false);
                    ((PNode)object2).setPickable(false);
                }
                double d6 = this.REALHEIGHT - this.dheightunits * (treenode.nextptr[i].dmean - this.dmin);
                double d7 = this.REALHEIGHT - this.dheightunits * (treenode.dmean - this.dmin);
                if (treenode.tsSigTFFull == null) continue;
                this.setSigText(treenode.tsSigTFFull[i], (PPath)object2, 3, treenode.ndepth, this.displayTF, this.displayMIRNA, treenode, this.colorSigTFs);
                ((PNode)object2).translate(d3 + this.dwidthunitsInterval[n] / 2.0, (d6 + d7) / 2.0);
                serializable = bigInteger.add(new BigInteger("" + i).multiply(new BigInteger("" + this.theTimeiohmm.nmaxchild).pow(this.data[0].length - n - 1)));
                this.hidesigList.add(new SigInfoRec((PNode)object2, treenode.tsSigTFFull[i], 2, (BigInteger)serializable, n, treenode));
                ((PNode)object2).addInputEventListener(pDragEventHandler);
                ((PNode)object2).addInputEventListener((PInputEventListener)object4[i]);
                if (this.htTextVisible == null) continue;
                boolean bl2 = this.htTextVisible.get(n + ";" + serializable + ";" + 2);
                for (Serializable serializable2 : ((PNode)object2).getChildrenReference()) {
                    PNode pNode = serializable2;
                    pNode.setVisible(bl2);
                    for (PNode pNode2 : pNode.getChildrenReference()) {
                        object = pNode2;
                        ((PNode)object).setVisible(bl2);
                    }
                }
            }
            if (treenode.numchildren >= 2) {
                PNode pNode;
                PNode pNode3;
                Object object52;
                int n9;
                Serializable serializable2;
                object2 = this;
                PBasicInputEventHandler pBasicInputEventHandler2 = new PBasicInputEventHandler((DREM_Timeiohmm.Treenode)object3, (DREMGui)object2){
                    final /* synthetic */ DREM_Timeiohmm.Treenode val$fptr;
                    final /* synthetic */ DREMGui val$ftheDREMGui;
                    {
                        this.val$fptr = treenode;
                        this.val$ftheDREMGui = dREMGui2;
                    }

                    public void mousePressed(PInputEvent pInputEvent) {
                        if (pInputEvent.getButton() == 3) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JFrame jFrame = new JFrame("Split Table");
                                    jFrame.setDefaultCloseOperation(2);
                                    jFrame.setLocation(200, 200);
                                    CircleID circleID = DREMGui.this.htNodes.get(pPath4);
                                    if (val$fptr.numchildren == 2) {
                                        DREMGui_SplitTable dREMGui_SplitTable = new DREMGui_SplitTable(val$ftheDREMGui, jFrame, DREMGui.this.theTimeiohmm, val$fptr, circleID.nscore);
                                        dREMGui_SplitTable.setOpaque(true);
                                        jFrame.setContentPane(dREMGui_SplitTable);
                                    } else {
                                        JTabbedPane jTabbedPane = new JTabbedPane();
                                        for (int i = 0; i < val$fptr.numchildren; ++i) {
                                            String string;
                                            String string2;
                                            DREMGui_SplitTable dREMGui_SplitTable = new DREMGui_SplitTable(val$ftheDREMGui, jFrame, DREMGui.this.theTimeiohmm, val$fptr, circleID.nscore, i, val$fptr.orderA[i]);
                                            if (val$fptr.numchildren == 3) {
                                                if (i == 0) {
                                                    string2 = "Low vs. Others ";
                                                    string = "Low";
                                                } else if (i == 1) {
                                                    string2 = "Middle vs. Others ";
                                                    string = "Middle";
                                                } else {
                                                    string2 = "High vs. Others ";
                                                    string = "High";
                                                }
                                            } else {
                                                string2 = "Child " + i + " vs. Others ";
                                                string = "Child " + i;
                                            }
                                            jTabbedPane.addTab(string2, null, dREMGui_SplitTable, string);
                                        }
                                        jTabbedPane.setOpaque(true);
                                        jFrame.setContentPane(jTabbedPane);
                                    }
                                    jFrame.pack();
                                    jFrame.setVisible(true);
                                }
                            });
                        }
                    }
                };
                PPath pPath5 = new PPath();
                if (!this.bglobalnode && this.battachlabels || !this.bshowkeyinputs) {
                    pPath5.setVisible(false);
                    pPath5.setPickable(false);
                }
                pPath5.translate(d3 + d5 / 2.0, d4 - d5 / 2.0);
                this.setSigText(treenode.tsSigTF, pPath5, 0, treenode.ndepth, this.displayTF, this.displayMIRNA, treenode, this.colorSigTFs);
                if (this.htTextVisible != null) {
                    n9 = this.htTextVisible.get(n + ";" + bigInteger + ";" + 0).booleanValue();
                    for (Object e : pPath5.getChildrenReference()) {
                        serializable = (PNode)e;
                        serializable.setVisible(n9 != 0);
                        for (Object object6 : serializable.getChildrenReference()) {
                            serializable2 = (PNode)object6;
                            ((PNode)serializable2).setVisible(n9 != 0);
                        }
                    }
                }
                this.hidesigList.add(new SigInfoRec(pPath5, treenode.tsSigTF, 0, bigInteger, n, treenode));
                for (n9 = 0; n9 < treenode.numchildren; ++n9) {
                    PNode pNode2;
                    PPath pPath6 = new PPath();
                    if (!this.bglobalnode && this.battachlabels || !this.bshowkeyinputs) {
                        pPath6.setVisible(false);
                        pPath6.setPickable(false);
                    }
                    double d8 = this.REALHEIGHT - this.dheightunits * (treenode.nextptr[n9].dmean - this.dmin);
                    double d9 = this.REALHEIGHT - this.dheightunits * (treenode.dmean - this.dmin);
                    pPath6.translate(d3 + this.dwidthunitsInterval[n] / 2.0, (d8 + d9) / 2.0);
                    this.setSigText(treenode.tsSigTFActivity[n9], pPath6, 777, treenode.ndepth, this.displayTF, this.displayMIRNA, treenode, this.colorSigTFs);
                    if (this.htTextVisible != null) {
                        boolean bl3 = this.htTextVisible.get(n + ";" + bigInteger + ";" + 777);
                        for (Iterator iterator : pPath6.getChildrenReference()) {
                            pNode2 = (PNode)((Object)iterator);
                            pNode2.setVisible(bl3);
                            for (Object object52 : pNode2.getChildrenReference()) {
                                pNode3 = (PNode)object52;
                                pNode3.setVisible(bl3);
                            }
                        }
                    }
                    this.hidesigList.add(new SigInfoRec(pPath6, treenode.tsSigTFActivity[n9], 777, bigInteger, n, treenode));
                    serializable2 = new PPath();
                    if (!this.bglobalnode && this.battachlabels || !this.bshowkeyinputs) {
                        ((PNode)serializable2).setVisible(false);
                        ((PNode)serializable2).setPickable(false);
                    }
                    ((PNode)serializable2).translate(d3 + this.dwidthunitsInterval[n] / 2.0, (d8 + d9) / 2.0);
                    this.setSigText(treenode.tsSigTFActivity[n9], (PPath)serializable2, 778, treenode.ndepth, this.displayTF, this.displayMIRNA, treenode, this.colorSigTFs);
                    if (this.htTextVisible != null) {
                        Iterator iterator;
                        boolean bl4 = this.htTextVisible.get(n + ";" + bigInteger + ";" + 778);
                        iterator = ((PNode)serializable2).getChildrenReference().iterator();
                        while (iterator.hasNext()) {
                            pNode2 = iterator.next();
                            object = pNode2;
                            ((PNode)object).setVisible(bl4);
                            object52 = ((PNode)object).getChildrenReference().iterator();
                            while (object52.hasNext()) {
                                pNode = pNode3 = object52.next();
                                pNode.setVisible(bl4);
                            }
                        }
                    }
                    this.hidesigList.add(new SigInfoRec((PNode)serializable2, treenode.tsSigTFActivity[n9], 778, bigInteger, n, treenode));
                    pPath6.addInputEventListener(pBasicInputEventHandler2);
                    ((PNode)serializable2).addInputEventListener(pBasicInputEventHandler2);
                    pPath6.addInputEventListener(pDragEventHandler);
                    ((PNode)serializable2).addInputEventListener(pDragEventHandler);
                }
                for (n9 = 0; n9 < treenode.numchildren; ++n9) {
                    PPath pPath7 = new PPath();
                    if (!this.bglobalnode && this.battachlabels || !this.bshowkeyinputs) {
                        pPath7.setVisible(false);
                        pPath7.setPickable(false);
                    }
                    this.setSigText(treenode.tsSigTFEdgeSplit[n9], pPath7, 3, treenode.ndepth, this.displayTF, this.displayMIRNA, treenode, this.colorSigTFs);
                    double d10 = this.REALHEIGHT - this.dheightunits * (treenode.nextptr[n9].dmean - this.dmin);
                    double d11 = this.REALHEIGHT - this.dheightunits * (treenode.dmean - this.dmin);
                    pPath7.translate(d3 + this.dwidthunitsInterval[n] / 2.0, (d10 + d11) / 2.0);
                    pPath7.addInputEventListener((PInputEventListener)object4[n9]);
                    pPath7.addInputEventListener(pDragEventHandler);
                    serializable2 = bigInteger.add(new BigInteger("" + n9).multiply(new BigInteger("" + this.theTimeiohmm.nmaxchild).pow(this.data[0].length - n - 1)));
                    if (this.htTextVisible != null) {
                        boolean bl5 = this.htTextVisible.get(n + ";" + serializable2 + ";" + 1);
                        for (PNode pNode2 : pPath7.getChildrenReference()) {
                            object = pNode2;
                            ((PNode)object).setVisible(bl5);
                            object52 = ((PNode)object).getChildrenReference().iterator();
                            while (object52.hasNext()) {
                                pNode = pNode3 = object52.next();
                                pNode.setVisible(bl5);
                            }
                        }
                    }
                    this.hidesigList.add(new SigInfoRec(pPath7, treenode.tsSigTFEdgeSplit[n9], 1, (BigInteger)serializable2, n, treenode));
                }
                pPath3.addInputEventListener(pBasicInputEventHandler2);
                pPath5.addInputEventListener(pBasicInputEventHandler2);
                pPath5.addInputEventListener(pDragEventHandler);
            } else {
                pPath3.addInputEventListener(pBasicInputEventHandler);
            }
            if (this.theSelectedRec.theCircleID != null && this.theSelectedRec.theCircleID.nid == this.ncircleID) {
                if (this.theSelectedRec.bcircle) {
                    this.htColors.put(pPath3, (Color)pPath3.getPaint());
                    pPath3.setPaint(Color.yellow);
                    this.theSelectedRec.selectedNode = pPath3;
                } else {
                    this.htColors.put(pPath, (Color)pPath.getStrokePaint());
                    pPath.setStrokePaint(Color.yellow);
                    this.theSelectedRec.selectedNode = pPath;
                }
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class MyPBasicInputEventHandler
            extends PBasicInputEventHandler {
                boolean bcircle;

                MyPBasicInputEventHandler(boolean bl) {
                    this.bcircle = bl;
                }

                @Override
                public void mousePressed(PInputEvent pInputEvent) {
                    if (pInputEvent.getButton() == 1) {
                        int n;
                        int n2;
                        Number number;
                        BigInteger bigInteger;
                        Object object;
                        Object object2;
                        CircleID circleID;
                        boolean bl = true;
                        PNode pNode = pInputEvent.getPickedNode();
                        if (DREMGui.this.theSelectedRec.selectedNode != null) {
                            circleID = DREMGui.this.theSelectedRec.theCircleID;
                            DREMGui.this.htRequired.remove(circleID);
                            object2 = DREMGui.this.htColors.get(DREMGui.this.theSelectedRec.selectedNode);
                            if (DREMGui.this.theSelectedRec.bcircle) {
                                DREMGui.this.theSelectedRec.selectedNode.setPaint((Paint)object2);
                            } else {
                                ((PPath)DREMGui.this.theSelectedRec.selectedNode).setStrokePaint((Paint)object2);
                            }
                            object = DREMGui.this.htHidden.keys();
                            while (object.hasMoreElements()) {
                                bigInteger = object.nextElement();
                                number = new BigInteger("" + DREMGui.this.theTimeiohmm.nmaxchild);
                                number = DREMGui.this.theSelectedRec.bcircle ? ((BigInteger)number).pow(DREMGui.this.data[0].length - circleID.nminparentlevel) : ((BigInteger)number).pow(DREMGui.this.data[0].length - circleID.nprevminparentlevel);
                                if (circleID.nscore.divide((BigInteger)number).equals(bigInteger.divide((BigInteger)number))) continue;
                                int n3 = DREMGui.this.htHidden.get(bigInteger);
                                DREMGui.this.htHidden.put(bigInteger, new Integer(--n3));
                                if (n3 != 0) continue;
                                ArrayList<Integer> arrayList = DREMGui.this.htPathToLineSet.get(bigInteger);
                                n2 = arrayList.size();
                                for (n = 0; n < n2; ++n) {
                                    int n4 = arrayList.get(n);
                                    DREMGui.this.bPathVisible[n4] = true;
                                    boolean bl2 = DREMGui.this.bglobalVisible && DREMGui.this.bTFVisible[n4] && DREMGui.this.bGOVisible[n4] && DREMGui.this.bSetVisible[n4];
                                    DREMGui.this.plArray[n4].setVisible(bl2);
                                    DREMGui.this.plArray[n4].setPickable(bl2);
                                }
                            }
                            if (pNode.equals(DREMGui.this.theSelectedRec.selectedNode)) {
                                DREMGui.this.theSelectedRec.selectedNode = null;
                                DREMGui.this.theSelectedRec.theCircleID = null;
                                bl = false;
                                DREMGui.this.setFilterText();
                            }
                        }
                        if (bl) {
                            circleID = DREMGui.this.htNodes.get(pPath4);
                            DREMGui.this.htRequired.add(circleID);
                            if (this.bcircle) {
                                DREMGui.this.htColors.put(pNode, (Color)pNode.getPaint());
                                pNode.setPaint(Color.yellow);
                            } else {
                                DREMGui.this.htColors.put(pNode, (Color)((PPath)pNode).getStrokePaint());
                                ((PPath)pNode).setStrokePaint(Color.yellow);
                            }
                            DREMGui.this.theSelectedRec.selectedNode = pNode;
                            DREMGui.this.theSelectedRec.bcircle = this.bcircle;
                            DREMGui.this.theSelectedRec.theCircleID = circleID;
                            DREMGui.this.setFilterText();
                            object2 = DREMGui.this.htPathToLineSet.keys();
                            while (object2.hasMoreElements()) {
                                object = (BigInteger)object2.nextElement();
                                bigInteger = new BigInteger("" + DREMGui.this.theTimeiohmm.nmaxchild);
                                bigInteger = this.bcircle ? bigInteger.pow(DREMGui.this.data[0].length - circleID.nminparentlevel) : bigInteger.pow(DREMGui.this.data[0].length - circleID.nprevminparentlevel);
                                if (circleID.nscore.divide(bigInteger).equals(((BigInteger)object).divide(bigInteger))) continue;
                                number = DREMGui.this.htHidden.get(object);
                                if (number == null || (Integer)number == 0) {
                                    ArrayList<Integer> arrayList = DREMGui.this.htPathToLineSet.get(object);
                                    int n5 = arrayList.size();
                                    for (n2 = 0; n2 < n5; ++n2) {
                                        n = arrayList.get(n2);
                                        DREMGui.this.bPathVisible[n] = false;
                                        DREMGui.this.plArray[n].setVisible(false);
                                        DREMGui.this.plArray[n].setPickable(false);
                                    }
                                    DREMGui.this.htHidden.put((BigInteger)object, new Integer(1));
                                    continue;
                                }
                                int n6 = (Integer)number;
                                DREMGui.this.htHidden.put((BigInteger)object, new Integer(n6 + 1));
                            }
                            if (!DREMGui.this.bholdedge) {
                                DREMGui.this.ncolortime = this.bcircle ? Math.min(circleID.ndepth + 1, DREMGui.this.data[0].length - 1) : circleID.ndepth;
                                if (DREMGui.this.theYScalegui != null) {
                                    DREMGui.this.theYScalegui.theColorSlider.setValue(DREMGui.this.ncolortime);
                                }
                                DREMGui.this.setGeneColors();
                            }
                        }
                    }
                }
            }
            object2 = new MyPBasicInputEventHandler(true);
            pPath3.addInputEventListener((PInputEventListener)object2);
            if (pPath != null) {
                MyPBasicInputEventHandler myPBasicInputEventHandler = new MyPBasicInputEventHandler(false);
                pPath.addInputEventListener(myPBasicInputEventHandler);
            }
            this.hideList.add(pPath3);
            this.circleSet.add(new CircleRec(pPath3, d5, this.ncircleID));
            ++this.ncircleID;
        }
        return pBasicInputEventHandler;
    }

    public void printSigRegs(PrintWriter printWriter) {
        printWriter.println("This file contains all the significant regulators displayed on the model in no particular order.");
        printWriter.println("Significant regulators: ");
        for (String string : this.sigRegs) {
            printWriter.println(string);
        }
    }

    public void printDefaults(PrintWriter printWriter) {
        printWriter.println("#Main Input:");
        printWriter.println("TF-gene_Interaction_Source\t" + this.theTimeiohmm.szstaticsourceval);
        printWriter.println("TF-gene_Interactions_File\t" + this.theTimeiohmm.szbinding);
        printWriter.println("Expression_Data_File\t" + this.theTimeiohmm.theDataSet.szInputFile);
        printWriter.println("Saved_Model_File\t" + this.theTimeiohmm.szinitfileval);
        printWriter.println("Gene_Annotation_Source\t" + this.theTimeiohmm.theDataSet.tga.szorganismsourceval);
        printWriter.println("Gene_Annotation_File\t" + this.theTimeiohmm.theDataSet.tga.szGoFile);
        printWriter.println("Cross_Reference_Source\t" + this.theTimeiohmm.theDataSet.tga.szxrefsourceval);
        printWriter.println("Cross_Reference_File\t" + this.theTimeiohmm.theDataSet.tga.szxrefval);
        printWriter.print("Normalize_Data[Log normalize data,Normalize data,No normalization/add 0]\t");
        if (this.theTimeiohmm.theDataSet.btakelog) {
            printWriter.println("Log normalize data");
        } else if (this.theTimeiohmm.theDataSet.badd0) {
            printWriter.println("No normalization/add 0");
        } else {
            printWriter.println("Normalize data");
        }
        printWriter.println("Spot_IDs_included_in_the_data_file\t" + this.theTimeiohmm.theDataSet.bspotincluded);
        printWriter.println();
        printWriter.println("#Repeat data");
        printWriter.print("Repeat_Data_Files(comma delimited list)\t");
        if (this.theTimeiohmm.theDataSet.otherInputFiles != null) {
            for (int i = 0; i < this.theTimeiohmm.theDataSet.otherInputFiles.length; ++i) {
                printWriter.print(this.theTimeiohmm.theDataSet.otherInputFiles[i]);
                if (i >= this.theTimeiohmm.theDataSet.otherInputFiles.length - 1) continue;
                printWriter.print(",");
            }
        }
        printWriter.println();
        printWriter.print("Repeat_Data_is_from[Different time periods,The same time period]\t");
        if (this.theTimeiohmm.theDataSet.bfullrepeat) {
            printWriter.println("Different time periods");
        } else {
            printWriter.println("The same time period");
        }
        printWriter.println();
        printWriter.println("#Filtering:");
        printWriter.println("Filter_Gene_If_It_Has_No_Static_Input_Data\t" + this.theTimeiohmm.bfilterbinding);
        printWriter.println("Maximum_Number_of_Missing_Values\t" + this.theTimeiohmm.theDataSet.nmaxmissing);
        printWriter.println("Minimum_Correlation_between_Repeats\t" + this.theTimeiohmm.theDataSet.dmincorrelation);
        printWriter.println("Minimum_Absolute_Log_Ratio_Expression\t" + this.theTimeiohmm.theDataSet.dthresholdvalue);
        printWriter.print("Change_should_be_based_on[Maximum-Minimum,Difference From 0]\t");
        if (this.theTimeiohmm.theDataSet.bmaxminval) {
            printWriter.println("Maximum-Minimum");
        } else {
            printWriter.println("Difference From 0");
        }
        printWriter.println("Pre-filtered_Gene_File\t" + this.theTimeiohmm.theDataSet.tga.szextraval);
        printWriter.println();
        printWriter.println("#Search Options");
        printWriter.println("Allow_Path_Merges\t" + this.theTimeiohmm.ballowmergeval);
        printWriter.println("Maximum_number_of_paths_out_of_split\t" + this.theTimeiohmm.nmaxchild);
        printWriter.println("Use_transcription_factor-gene_interaction_data_to_build\t" + !this.theTimeiohmm.BREGDREM);
        printWriter.print("Saved_Model[Use As Is/Start Search From/Do Not Use]\t");
        if (this.theTimeiohmm.ninitsearchval == 0) {
            printWriter.println("Use As Is");
        } else if (this.theTimeiohmm.ninitsearchval == 1) {
            printWriter.println("Start Search From");
        } else {
            printWriter.println("Do Not Use");
        }
        printWriter.println("Convergence_Likelihood_%\t" + this.theTimeiohmm.szconvergenceval);
        printWriter.println("Minimum_Standard_Deviation\t" + this.theTimeiohmm.dminstddev);
        printWriter.println();
        printWriter.println("#Model Selection Options");
        printWriter.println("Model_Selection_Framework[Penalized Likelihood,Train-Test]\tPenalized Likelihood");
        printWriter.println("Penalized_Likelihood_Node_Penalty\t" + this.theTimeiohmm.sznodepenaltyval);
        printWriter.println("Random_Seed\t" + this.theTimeiohmm.nrandomseed);
        printWriter.println("Main_search_score_%\t" + this.theTimeiohmm.EPSILON * 100.0);
        printWriter.println("Main_search_difference_threshold\t" + this.theTimeiohmm.EPSILONDIFF);
        printWriter.println("Delete_path_score_%\t" + this.theTimeiohmm.RESPLITMIN * 100.0);
        printWriter.println("Delete_path_difference_threshold\t" + this.theTimeiohmm.RESPLITMINDIFF);
        printWriter.println("Delay_split_score_%\t" + this.theTimeiohmm.DELAYMIN * 100.0);
        printWriter.println("Delay_split_difference_threshold\t" + this.theTimeiohmm.DELAYMINDIFF);
        printWriter.println("Merge_path_score_%\t" + this.theTimeiohmm.MERGEMIN * 100.0);
        printWriter.println("Merge_path_difference_threshold\t" + this.theTimeiohmm.MERGEMINDIFF);
        printWriter.println();
        printWriter.println("#Gene Annotations:");
        printWriter.println("Include_Biological_Process\t" + this.theTimeiohmm.theDataSet.tga.bpontoval);
        printWriter.println("Include_Molecular_Function\t" + this.theTimeiohmm.theDataSet.tga.bfontoval);
        printWriter.println("Include_Cellular_Process\t" + this.theTimeiohmm.theDataSet.tga.bcontoval);
        printWriter.println("Only_include_annotations_with_these_evidence_codes\t" + this.theTimeiohmm.theDataSet.tga.szevidenceval);
        printWriter.println("Only_include_annotations_with_these_taxon_IDs\t" + this.theTimeiohmm.theDataSet.tga.sztaxonval);
        printWriter.println("Category_ID_File\t" + this.theTimeiohmm.theDataSet.tga.szcategoryIDval);
        printWriter.println();
        printWriter.println("#GO Analysis:");
        printWriter.print("Multiple_hypothesis_correction_method_enrichment[Bonferroni,Randomization]\t");
        if (this.theTimeiohmm.theDataSet.tga.brandomgoval) {
            printWriter.println("Randomization");
        } else {
            printWriter.println("Bonferroni");
        }
        printWriter.println("Minimum_GO_level\t" + this.theTimeiohmm.theDataSet.tga.nmingolevel);
        printWriter.println("GO_Minimum_number_of_genes\t" + this.theTimeiohmm.theDataSet.tga.nmingo);
        printWriter.println("Number_of_samples_for_randomized_multiple_hypothesis_correction\t" + this.theTimeiohmm.theDataSet.tga.nsamplespval);
        printWriter.println();
        printWriter.println("#Interface Options");
        printWriter.println("X-axis_Scale_Factor\t" + this.dscalex);
        printWriter.println("Y-axis_Scale_Factor\t" + this.dscaley);
        printWriter.print("X-axis_scale_should_be[Uniform,Based on real time]\t");
        if (this.brealXaxis) {
            printWriter.println("Based on real time");
        } else {
            printWriter.println("Uniform");
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMaximumFractionDigits(1);
        printWriter.println("Key_Input_X_p-val_10^-X\t" + numberFormat.format(-Math.log(this.dkeyinputpvalue) / Math.log(10.0)));
        printWriter.println("Minimum_Split_Percent\t" + this.dsplitpercent * 100.0);
        printWriter.println("Scale_Node_Areas_By_The_Factor\t" + this.dnodek);
        printWriter.print("Key_Input_Significance_Based_On[Path Significance Conditional on Split,Path Significance Overall,Split Significance]\t");
        if (this.nKeyInputType == 0) {
            printWriter.println("Split Significance");
        } else if (this.nKeyInputType == 1) {
            printWriter.println("Path Significance Conditional on Split");
        } else {
            printWriter.println("Path Significance Overall");
        }
        printWriter.println();
        if (this.theTimeiohmm.miRNAInteractionDataFile != null && !this.theTimeiohmm.miRNAInteractionDataFile.equals("")) {
            printWriter.println("#DREM with miRNA Options");
            printWriter.println("miRNA-gene_Interaction_Source\t" + this.theTimeiohmm.miRNAInteractionDataFile);
            printWriter.println("miRNA_Expression_Data_File\t" + this.theTimeiohmm.miRNADataSet.szInputFile);
            printWriter.print("Regulator_Types_Used_For_Activity_Scoring[TF,miRNA,Both]\t");
            if (this.theTimeiohmm.scaleMIRNAExp && this.theTimeiohmm.scaleTFExp) {
                printWriter.println("Both");
            } else if (this.theTimeiohmm.scaleMIRNAExp) {
                printWriter.println("miRNA");
            } else if (this.theTimeiohmm.scaleTFExp) {
                printWriter.println("TF");
            }
            printWriter.print("Normalize_miRNA_Data[Log normalize data,Normalize data,No normalization/add 0]\t");
            if (this.theTimeiohmm.miRNADataSet.badd0) {
                printWriter.println("No normalization/add 0");
            } else if (this.theTimeiohmm.miRNADataSet.btakelog) {
                printWriter.println("Log normalize data");
            } else {
                printWriter.println("Normalize data");
            }
            printWriter.print("Repeat_miRNA_Data_Files(comma delimited list)\t");
            if (this.theTimeiohmm.miRNADataSet.otherInputFiles != null) {
                for (int i = 0; i < this.theTimeiohmm.miRNADataSet.otherInputFiles.length; ++i) {
                    printWriter.print(this.theTimeiohmm.miRNADataSet.otherInputFiles[i]);
                    if (i >= this.theTimeiohmm.miRNADataSet.otherInputFiles.length - 1) continue;
                    printWriter.print(",");
                }
            }
            printWriter.print("Repeat_miRNA_Data_is_from[Different time periods,The same time period]\t");
            if (this.theTimeiohmm.miRNADataSet.bfullrepeat) {
                printWriter.println("Different time periods");
            } else {
                printWriter.println("The same time period");
            }
            printWriter.println("Filter_miRNA_With_No_Expression_Data_From_Regulators\t" + this.theTimeiohmm.filterMIRNAExp);
            printWriter.println("miRNA_Expression_Scaling_Weight\t" + this.theTimeiohmm.expressionScalingFactor);
            printWriter.println("Minimum_TF_Expression_After_Scaling\t" + this.theTimeiohmm.minTFExpAfterScaling);
            printWriter.println();
        }
        if (this.theTimeiohmm.decodPath != null && !this.theTimeiohmm.decodPath.equals("")) {
            printWriter.println("#DECOD Options");
            printWriter.println("DECOD_Executable_Path\t" + this.theTimeiohmm.decodPath);
            printWriter.println("Gene_To_Fasta_Format_file\t" + this.theTimeiohmm.fastaDataFile);
            printWriter.println();
        }
        if (this.theTimeiohmm.regPriorsFile != null && !this.theTimeiohmm.regPriorsFile.equals("")) {
            printWriter.println("#SDREM Options");
            printWriter.println("Regulator_Score_File\t" + this.theTimeiohmm.regPriorsFile);
            printWriter.println("Active_TF_influence\t" + this.theTimeiohmm.dProbBindingFunctional);
            printWriter.println();
        }
        printWriter.println();
        printWriter.close();
    }

    public void batchSave(String string) {
        Container container;
        if (this.saveModelFrame == null) {
            this.saveModelFrame = new JFrame("Save Model to File");
            this.saveModelFrame.setDefaultCloseOperation(2);
            this.saveModelFrame.setLocation(400, 300);
            container = new DREMGui_SaveModel(this.theTimeiohmm, this.treecopy, this.saveModelFrame, this);
            this.saveModelFrame.setContentPane(container);
        }
        container = this.saveModelFrame.getContentPane();
        ((DREMGui_SaveModel)container).batchSave(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CircleRecCompare
    implements Comparator<CircleRec> {
        CircleRecCompare() {
        }

        @Override
        public int compare(CircleRec circleRec, CircleRec circleRec2) {
            if (circleRec.ddiameter > circleRec2.ddiameter) {
                return -1;
            }
            if (circleRec.ddiameter < circleRec2.ddiameter) {
                return 1;
            }
            if (circleRec.nid < circleRec2.nid) {
                return -1;
            }
            if (circleRec.nid > circleRec2.nid) {
                return 1;
            }
            return 0;
        }
    }

    static class CircleRec {
        double ddiameter;
        int nid;
        PNode circle;

        CircleRec(PNode pNode, double d, int n) {
            this.circle = pNode;
            this.ddiameter = d;
            this.nid = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SigTFRecv2Comp
    implements Comparator<DREM_Timeiohmm.SigTFRecv2> {
        SigTFRecv2Comp() {
        }

        @Override
        public int compare(DREM_Timeiohmm.SigTFRecv2 sigTFRecv2, DREM_Timeiohmm.SigTFRecv2 sigTFRecv22) {
            if (sigTFRecv2.dpval > sigTFRecv22.dpval) {
                return 1;
            }
            if (sigTFRecv2.dpval < sigTFRecv22.dpval) {
                return -1;
            }
            if (sigTFRecv2.dpercent > sigTFRecv22.dpercent) {
                return 1;
            }
            if (sigTFRecv2.dpercent < sigTFRecv22.dpercent) {
                return -1;
            }
            return sigTFRecv2.szname.compareTo(sigTFRecv22.szname);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SigInfoRec {
        TreeSet<DREM_Timeiohmm.SigTFRecv2> theSigTF;
        int ntype;
        PNode border;
        BigInteger npathscore;
        int ndepth;
        DREM_Timeiohmm.Treenode node;

        SigInfoRec(PNode pNode, TreeSet<DREM_Timeiohmm.SigTFRecv2> treeSet, int n, BigInteger bigInteger, int n2, DREM_Timeiohmm.Treenode treenode) {
            this.theSigTF = treeSet;
            this.ntype = n;
            this.border = pNode;
            this.npathscore = bigInteger;
            this.ndepth = n2;
            this.node = treenode;
        }
    }

    static class SelectedNodeRec {
        PNode selectedNode;
        boolean bcircle;
        CircleID theCircleID = null;

        SelectedNodeRec() {
        }
    }

    static class CircleID {
        int ndepth;
        int nminparentlevel;
        BigInteger nscore;
        int nid;
        int nprevminparentlevel;

        CircleID(int n, int n2, int n3, BigInteger bigInteger, int n4) {
            this.nminparentlevel = n2;
            this.nprevminparentlevel = n3;
            this.ndepth = n;
            this.nscore = bigInteger;
            this.nid = n4;
        }
    }

    private static class ToolTipTextUpdater
    extends PBasicInputEventHandler {
        private PCanvas canvas;
        private PNode node;
        String szText;

        public ToolTipTextUpdater(PCanvas pCanvas, PNode pNode, String string) {
            this.canvas = pCanvas;
            this.node = pNode;
            this.szText = string;
        }

        public void mouseEntered(PInputEvent pInputEvent) {
            if (this.node.getVisible()) {
                this.canvas.setToolTipText(this.szText);
            } else {
                this.canvas.setToolTipText(null);
            }
        }

        public void mouseExited(PInputEvent pInputEvent) {
            this.canvas.setToolTipText(null);
        }
    }
}

