/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.core;

import edu.cmu.cs.sb.core.StatUtil;
import edu.cmu.cs.sb.core.Util;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public class GoAnnotations {
    public static String SZGP = "gene_association.";
    public static String[] defaultxrefs = new String[]{"User provided", "No cross references"};
    public static String[] organisms = new String[]{"User provided", "No annotations", "Anaplasma phagocytophilum HZ (JCVI)", "Agrobacterium tumefaciensstr. C58 (PAMGO)", "Arabidopsis (EBI)", "Arabidopsis thaliana (TAIR/JCVI)", "Aspergillus nidulans (AspGD)", "Bacillus anthracis (JCVI)", "Caenorhabditis elegans (WormBase)", "Campylobacter jejuni RM1221 (JCVI)", "Candida albicans (CGD)", "Carboxydothermus hydrogenoformans Z-2901 (JCVI)", "Chicken (EBI)", "Clostridium perfringens ATCC13124 (JCVI)", "Colwellia psychrerythraea 34H (JCVI)", "Cow (EBI)", "Coxiella burnetti RSA (JCVI)", "Danio rerio (ZFIN)", "Dehalococcoides ethenogenes 195 (JCVI)", "Dictyostelim discoideum (DictyBase)", "Dickeya dadantii (PAMGO)", "Drosophila melanogaster (FlyBase)", "Ehrlichia chaffeensis Arkansas (JCVI)", "Escherichia coli (EcoCyc & EcoliHub)", "Geobacter sulfurreducens PCA (JCVI)", "Human (EBI)", "Hyphomonas neptunium ATCC 15444 (JCVI)", "Leishmania major (Sanger GeneDB)", "Listeria monocytogenes 4b F2365 (JCVI)", "Magnaporthe grisea (PAMGO)", "Methylococcus capsulatus Bath (JCVI)", "Mouse (EBI)", "Mus musculus (MGI)", "Neorickettsia sennetsu Miyayama (JCVI)", "OOmycetes (PAMGO)", "Oryza sativa (Gramene)", "PDB (EBI)", "Plasmodium falciparum (Sanger GeneDB)", "Pseudomonas aeruginosa PA01 (PseudoCAP)", "Pseudomonas fluorescens Pf-5 (JCVI)", "Pseudomonas syringae DC3000 (JCVI)", "Pseudomonas syringae pv. phaseolicola 1448A (JCVI)", "Rat (EBI)", "Rattus norvegicus (RGD)", "Reactome (CSHL&EBI)", "Saccharomyces cerevisiae (SGD)", "Schizosaccharomyces pombe (Sanger GeneDB)", "Shewanella oneidensis MR-1 (JCVI)", "Silicibacter pomeroyi DSS-3 (JCVI)", "Solanaceae (SGN)", "Trypanosoma brucei (Sanger GeneDB)", "UniProt (EBI)", "Vibrio cholera (JCVI)", "Zebrafish (EBI)"};
    public static String[] xreffile = new String[]{"", "", "", "", "", "", "", ""};
    public static String[] xreforgfile = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    public static String[] gannfile = new String[]{"", "", SZGP + "jcvi_Aphagocytophilum.gz", SZGP + "PAMGO_Atumefaciens.gz", SZGP + "goa_arabidopsis.gz", SZGP + "tair.gz", SZGP + "aspgd.gz", SZGP + "jcvi_Banthracis.gz", SZGP + "wb.gz", SZGP + "jcvi_Cjejuni.gz", SZGP + "cgd.gz", SZGP + "jcvi_Chydrogenoformans.gz", SZGP + "goa_chicken.gz", SZGP + "jcvi_Cperfringens.gz", SZGP + "jcvi_Cpsychrerythraea.gz", SZGP + "goa_cow.gz", SZGP + "jcvi_Cburnetii.gz", SZGP + "zfin.gz", SZGP + "jcvi_Dethenogenes.gz", SZGP + "dictyBase.gz", SZGP + "PAMGO_Ddadantii.gz", SZGP + "fb.gz", SZGP + "jcvi_Echaffeensis.gz", SZGP + "ecocyc.gz", SZGP + "jcvi_Gsulfurreducens.gz", SZGP + "goa_human.gz", SZGP + "jcvi_Hneptunium.gz", SZGP + "GeneDB_Lmajor.gz", SZGP + "jcvi_Lmonocytogenes.gz", SZGP + "PAMGO_Mgrisea.gz", SZGP + "jcvi_Mcapsulatus.gz", SZGP + "goa_mouse.gz", SZGP + "mgi.gz", SZGP + "jcvi_Nsennetsu.gz", SZGP + "PAMGO_Oomycetes.gz", SZGP + "gramene_oryza.gz", SZGP + "goa_pdb.gz", SZGP + "GeneDB_Pfalciparum.gz", SZGP + "pseudocap.gz", SZGP + "jcvi_Pfluorescens.gz", SZGP + "jcvi_Psyringae.gz", SZGP + "jcvi_Psyringae_phaseolicola.gz", SZGP + "goa_rat.gz", SZGP + "rgd.gz", SZGP + "reactome.gz", SZGP + "sgd.gz", SZGP + "GeneDB_Spombe.gz", SZGP + "jcvi_Soneidensis.gz", SZGP + "jcvi_Spomeroyi.gz", SZGP + "sgn.gz", SZGP + "GeneDB_Tbrucei.gz", SZGP + "goa_uniprot.gz", SZGP + "jcvi_Vcholerae.gz", SZGP + "goa_zebrafish.gz"};
    public String szorganismsourceval;
    public String szxrefsourceval;
    public String szcategoryIDval;
    public String szextraval;
    public String szxrefval;
    public HashMap htGoLabels;
    public HashMap htFullCount;
    public HashMap htGeneNames;
    public HashMap htGO;
    public HashMap htAlt;
    public HashMap htAncestors;
    public HashMap htIDCategory;
    public boolean bcluster = false;
    public int numcategory = 0;
    public int numtotalgenes = 0;
    public int nmaxsize;
    public int nGeneSet = 0;
    public int nlegalgo = 0;
    public String szsortcommand = "default";
    public String szSelectedGO = null;
    public boolean bactual = true;
    public int nsamplespval = 500;
    public int nmingo;
    public int nmingolevel;
    public boolean bpontoval;
    public boolean bcontoval;
    public boolean bfontoval;
    public String szevidenceval;
    public String sztaxonval;
    public boolean brandomgoval;
    public ArrayList extraprobes;
    public ArrayList extragenes;
    public ProfileGORankingRec[] tpgr;
    public ArrayList algoAllbase;
    public ArrayList algoAll;
    public HashSet[] goAll;
    public RecIDpval2[] theRecIDpval;
    public RecIDpval[] theClusterRecIDpval;
    public String szGoFile;
    public String szGoCategoryFile;
    public String szBatchGOoutput;

    public void printLevel() {
        for (String string : this.htAncestors.keySet()) {
            System.out.println(string + "\t" + this.getLevel(string, new HashSet()));
        }
    }

    public HashSet levelGO() {
        Object object;
        Iterator iterator = this.htGO.keySet().iterator();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            int n = this.getLevel((String)object, new HashSet());
            if (n >= this.nmingolevel) continue;
            hashSet.add(object);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            this.htGO.remove((String)object.next());
        }
        return hashSet;
    }

    public int getLevel(String string, HashSet hashSet) {
        int n = 0;
        if (hashSet.contains(string)) {
            System.out.println("Warning -- getLevel detected cycle with the term " + string);
            return 1;
        }
        hashSet.add(string);
        Rec rec = (Rec)this.htGO.get(string);
        if (rec == null) {
            throw new IllegalArgumentException("Dangling reference found in gene ontology with term ID " + string);
        }
        HashSet hashSet2 = rec.parents;
        for (String string2 : hashSet2) {
            int n2 = this.getLevel(string2, hashSet);
            hashSet.remove(string2);
            n = Math.max(n, n2);
        }
        return n + 1;
    }

    HashSet getAncestors(String string, HashSet hashSet) {
        if (hashSet.contains(string)) {
            System.out.println("Warning -- getAncestors detected cycle with the term " + string);
            return new HashSet();
        }
        HashSet<String> hashSet2 = (HashSet<String>)this.htAncestors.get(string);
        if (hashSet2 == null) {
            hashSet.add(string);
            hashSet2 = new HashSet<String>();
            Rec rec = (Rec)this.htGO.get(string);
            if (rec != null) {
                Object object;
                HashSet hashSet3 = rec.parents;
                if (hashSet3 == null && (object = (String)this.htAlt.get(string)) != null) {
                    hashSet3 = ((Rec)this.htGO.get((Object)object)).parents;
                }
                if (hashSet3 != null) {
                    for (String string2 : hashSet3) {
                        hashSet2.add(string2);
                        HashSet hashSet4 = this.getAncestors(string2, hashSet);
                        hashSet.remove(string2);
                        hashSet2.addAll(hashSet4);
                    }
                }
            }
            this.htAncestors.put(string, hashSet2);
        }
        return hashSet2;
    }

    public void buildxref(HashSet hashSet, HashMap hashMap) throws FileNotFoundException, IOException {
        if (this.szxrefval != null && !this.szxrefval.equals("")) {
            String string;
            BufferedReader bufferedReader;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.szxrefval))));
            }
            catch (IOException iOException) {
                bufferedReader = new BufferedReader(new FileReader(this.szxrefval));
            }
            while ((string = bufferedReader.readLine()) != null) {
                HashSet<Object> hashSet2 = new HashSet<Object>(3);
                HashSet<Object> hashSet3 = new HashSet<Object>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\"\t;|,");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim().toUpperCase(Locale.ENGLISH);
                    hashSet3.add(string2);
                    if (!hashSet.contains(string2)) continue;
                    hashSet2.add(string2);
                }
                if (hashSet2.isEmpty()) continue;
                for (String string3 : hashSet3) {
                    HashSet hashSet4 = (HashSet)hashMap.get(string3);
                    if (hashSet4 == null) {
                        hashSet4 = new HashSet();
                    }
                    hashSet4.addAll(hashSet2);
                    hashMap.put(string3, hashSet4);
                }
            }
            bufferedReader.close();
        }
    }

    public GoAnnotations(String string, String string2, String string3, String string4, String string5, String[] stringArray, String[] stringArray2, int n, int n2, int n3, String string6, String string7, boolean bl, String string8, String string9, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string10) throws FileNotFoundException, IOException, IllegalArgumentException {
        int n4;
        int n5;
        this.szBatchGOoutput = string10;
        this.szorganismsourceval = string;
        this.szxrefsourceval = string2;
        this.szGoFile = string4;
        this.szGoCategoryFile = string5;
        this.szevidenceval = string8;
        this.sztaxonval = string9;
        this.bpontoval = bl2;
        this.bcontoval = bl3;
        this.bfontoval = bl4;
        this.szxrefval = string3;
        this.szextraval = string6;
        this.brandomgoval = bl5;
        this.nmingo = n2;
        this.nmingolevel = n3;
        this.szcategoryIDval = string7;
        this.nsamplespval = n;
        this.htGoLabels = new HashMap();
        this.htFullCount = new HashMap();
        this.htGO = new HashMap(20000);
        this.htAlt = new HashMap();
        this.htAncestors = new HashMap();
        this.htGeneNames = new HashMap();
        this.extragenes = new ArrayList();
        this.extraprobes = new ArrayList();
        if (!string4.equalsIgnoreCase("")) {
            Object object7;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            String string11;
            String string12;
            HashSet<String> hashSet;
            Object object6;
            this.loadIDCategory();
            if (!string5.equalsIgnoreCase("")) {
                try {
                    try {
                        object6 = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string5))));
                    }
                    catch (IOException iOException) {
                        object6 = new BufferedReader(new FileReader(string5));
                    }
                    hashSet = new HashSet();
                    string12 = "";
                    string11 = "";
                    boolean bl6 = false;
                    while ((object5 = ((BufferedReader)object6).readLine()) != null) {
                        int n6 = ((String)object5).length();
                        if (n6 > 0 && ((String)object5).charAt(0) == '[' && ((String)object5).charAt(n6 - 1) == ']' && bl6) {
                            object4 = (Rec)this.htGO.get(string12);
                            if (object4 == null) {
                                this.htGO.put(string12, new Rec(hashSet, string11));
                            } else {
                                if (!string11.equals("")) {
                                    ((Rec)object4).sztermName = string11;
                                }
                                ((Rec)object4).parents.addAll(hashSet);
                            }
                            bl6 = false;
                        }
                        if (((String)object5).equals("[Term]")) {
                            hashSet = new HashSet<String>();
                            string12 = "";
                            string11 = "";
                            bl6 = true;
                            continue;
                        }
                        if (n6 > 0 && ((String)object5).charAt(0) == '[' && ((String)object5).charAt(n6 - 1) == ']') {
                            hashSet = new HashSet();
                            continue;
                        }
                        object4 = ((String)object5).trim();
                        if (((String)object4).startsWith("id:")) {
                            object3 = new StringTokenizer(((String)object4).substring(3).trim(), " !\t");
                            if (((StringTokenizer)object3).hasMoreTokens()) {
                                string12 = ((StringTokenizer)object3).nextToken();
                                continue;
                            }
                            throw new IllegalArgumentException("An id tag has no value");
                        }
                        if (((String)object4).startsWith("name:")) {
                            string11 = ((String)object4).substring(5).trim();
                            if (!string11.equals("")) continue;
                            throw new IllegalArgumentException("term " + string12 + " name tag has no value");
                        }
                        if (((String)object4).startsWith("is_a:")) {
                            object3 = new StringTokenizer(((String)object4).substring(5).trim(), " !\t");
                            if (((StringTokenizer)object3).hasMoreTokens()) {
                                hashSet.add(((StringTokenizer)object3).nextToken());
                                continue;
                            }
                            throw new IllegalArgumentException("term " + string12 + " is_a tag has no value");
                        }
                        if (((String)object4).startsWith("relationship:")) {
                            object3 = new StringTokenizer(((String)object4).substring(13).trim(), " !\t");
                            if (((StringTokenizer)object3).hasMoreTokens()) {
                                ((StringTokenizer)object3).nextToken();
                                if (((StringTokenizer)object3).hasMoreTokens()) {
                                    object2 = ((StringTokenizer)object3).nextToken();
                                    hashSet.add((String)object2);
                                    continue;
                                }
                                throw new IllegalArgumentException("term " + string12 + " relationship part_of tag has no value");
                            }
                            throw new IllegalArgumentException("term " + string12 + " relationship tag has no value");
                        }
                        if (!((String)object4).startsWith("alt_id:")) continue;
                        object3 = new StringTokenizer(((String)object4).substring(7).trim(), " !\t");
                        if (((StringTokenizer)object3).hasMoreTokens()) {
                            this.htAlt.put(((StringTokenizer)object3).nextToken(), string12);
                            continue;
                        }
                        throw new IllegalArgumentException("term " + string12 + " alt_id tag has no value");
                    }
                    if (bl6) {
                        Rec rec = (Rec)this.htGO.get(string12);
                        if (rec == null) {
                            this.htGO.put(string12, new Rec(hashSet, string11));
                        } else {
                            if (!string11.equals("")) {
                                rec.sztermName = string11;
                            }
                            rec.parents.addAll(hashSet);
                        }
                    }
                    ((BufferedReader)object6).close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace(System.out);
                }
            }
            object6 = this.levelGO();
            try {
                hashSet = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string4))));
            }
            catch (IOException iOException) {
                hashSet = new BufferedReader(new FileReader(string4));
            }
            string12 = ((BufferedReader)((Object)hashSet)).readLine();
            if (string12 == null) {
                throw new IllegalArgumentException("Annotation file is empty!");
            }
            while (string12.equals("") || string12.startsWith("!")) {
                string12 = ((BufferedReader)((Object)hashSet)).readLine();
                if (string12 != null) continue;
                throw new IllegalArgumentException("Annotation file is empty!");
            }
            object5 = new HashMap();
            HashSet hashSet2 = new HashSet();
            for (int i = 0; i < stringArray.length; ++i) {
                if (string10 != null && stringArray[i].startsWith("#")) continue;
                this.addprobegenemap(stringArray2[i], stringArray[i], (HashMap)object5, hashSet2);
            }
            if (string6 != null && !string6.equals("")) {
                BufferedReader bufferedReader;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string6))));
                }
                catch (IOException iOException) {
                    bufferedReader = new BufferedReader(new FileReader(string6));
                }
                bufferedReader.readLine();
                int n7 = 0;
                while ((object7 = bufferedReader.readLine()) != null) {
                    object4 = new StringTokenizer((String)object7, "\t", true);
                    if (!((StringTokenizer)object4).hasMoreTokens() && bl) continue;
                    if (bl) {
                        object2 = ((StringTokenizer)object4).nextToken().trim().toUpperCase(Locale.ENGLISH);
                        if (((String)object2).equals("\t")) {
                            throw new IllegalArgumentException("Missing spot symbol in pre-filtered file");
                        }
                        if (((StringTokenizer)object4).hasMoreTokens()) {
                            ((StringTokenizer)object4).nextToken();
                        }
                    } else {
                        object2 = "EID_" + n7;
                    }
                    ++n7;
                    object3 = "0";
                    if (((StringTokenizer)object4).hasMoreTokens()) {
                        object3 = ((StringTokenizer)object4).nextToken();
                    }
                    if (((String)object3).equals("\t") || ((String)object3).equals("0")) {
                        object3 = "0 (SPOT_" + (String)object2 + ")";
                    } else {
                        if (((String)object3).charAt(0) == '\"') {
                            object3 = ((String)object3).substring(1);
                        }
                        if (((String)object3).charAt(((String)object3).length() - 1) == '\"') {
                            object3 = ((String)object3).substring(0, ((String)object3).length() - 1);
                        }
                    }
                    object3 = ((String)object3).trim().toUpperCase(Locale.ENGLISH);
                    this.addprobegenemap((String)object2, (String)object3, (HashMap)object5, hashSet2);
                    this.extragenes.add(object3);
                    this.extraprobes.add(object2);
                }
                bufferedReader.close();
            }
            HashMap hashMap = new HashMap();
            this.buildxref(hashSet2, hashMap);
            StringTokenizer stringTokenizer = new StringTokenizer(string12, "\t", false);
            object4 = new StringTokenizer(string12, "\t", true);
            int n8 = ((StringTokenizer)object4).countTokens() - stringTokenizer.countTokens();
            if (n8 >= 14) {
                this.addOfficialLine((StringTokenizer)object4, (HashSet)object6, hashSet2, hashMap, (HashMap)object5);
                while ((string12 = ((BufferedReader)((Object)hashSet)).readLine()) != null) {
                    if (string12.equals("")) continue;
                    object4 = new StringTokenizer(string12, "\t", true);
                    this.addOfficialLine((StringTokenizer)object4, (HashSet)object6, hashSet2, hashMap, (HashMap)object5);
                }
            } else {
                while ((string12 = ((BufferedReader)((Object)hashSet)).readLine()) != null) {
                    if (string12.equals("")) continue;
                    stringTokenizer = new StringTokenizer(string12, "\t");
                    object2 = stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new IllegalArgumentException("Line:\n" + string12 + "\nis missing an argument");
                    }
                    object7 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer((String)object2, "\";|,");
                    while (stringTokenizer2.hasMoreElements()) {
                        string11 = stringTokenizer2.nextToken().trim();
                        String string13 = (String)((HashMap)object5).get(string11 = string11.toUpperCase(Locale.ENGLISH));
                        if (string13 != null) {
                            this.addgenesgo(string13, (String)object7, (HashSet)object6, hashSet2, hashMap);
                        }
                        this.addgenesgo(string11, (String)object7, (HashSet)object6, hashSet2, hashMap);
                    }
                }
            }
            ((BufferedReader)((Object)hashSet)).close();
            for (Object object7 : this.htGoLabels.values()) {
                for (String string13 : (HashSet)((HashSet)object7).clone()) {
                    HashSet hashSet3 = this.getAncestors(string13, new HashSet());
                    for (String string14 : hashSet3) {
                        if (((HashSet)object6).contains(string14)) continue;
                        ((HashSet)object7).add(string14);
                    }
                }
            }
        }
        this.nmaxsize = 1;
        this.algoAll = new ArrayList();
        for (n5 = 0; n5 < stringArray.length; ++n5) {
            if (string10 != null && stringArray[n5].startsWith("#")) continue;
            this.loadID(stringArray[n5]);
        }
        n5 = this.extragenes.size();
        for (n4 = 0; n4 < n5; ++n4) {
            this.loadID((String)this.extragenes.get(n4));
        }
        ++this.nmaxsize;
        this.goAll = new HashSet[this.algoAll.size()];
        n4 = this.algoAll.size();
        for (int i = 0; i < n4; ++i) {
            this.goAll[i] = (HashSet)this.algoAll.get(i);
        }
    }

    public void addprobegenemap(String string, String string2, HashMap hashMap, HashSet hashSet) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|;,\"");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            hashSet.add(string3);
        }
        hashSet.add(string2);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, "|;,\"");
        while (stringTokenizer2.hasMoreTokens()) {
            String string4 = stringTokenizer2.nextToken().trim();
            hashMap.put(string4, string2);
        }
    }

    public void addOfficialLine(StringTokenizer stringTokenizer, HashSet hashSet, HashSet hashSet2, HashMap hashMap, HashMap hashMap2) {
        String string = null;
        String string2 = null;
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken().trim().toUpperCase(Locale.ENGLISH);
        stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken().trim().toUpperCase(Locale.ENGLISH);
        stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        if (!string5.equals("\t")) {
            stringTokenizer.nextToken();
        }
        String string6 = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken().trim().toUpperCase(Locale.ENGLISH);
        stringTokenizer.nextToken();
        String string8 = stringTokenizer.nextToken();
        if (!string8.equals("\t")) {
            stringTokenizer.nextToken();
        }
        String string9 = stringTokenizer.nextToken().trim().toUpperCase(Locale.ENGLISH);
        stringTokenizer.nextToken();
        string8 = stringTokenizer.nextToken();
        if (!string8.equals("\t")) {
            string = string8.trim().toUpperCase(Locale.ENGLISH);
            stringTokenizer.nextToken();
        }
        if (!(string8 = stringTokenizer.nextToken()).equals("\t")) {
            string2 = string8.trim().toUpperCase(Locale.ENGLISH);
            stringTokenizer.nextToken();
        }
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string10 = stringTokenizer.nextToken();
        if (!string5.contains("NOT") && (this.bcontoval && string9.equals("C") || this.bpontoval && string9.equals("P") || this.bfontoval && string9.equals("F")) && (this.szevidenceval.equals("") || this.validEvidence(this.szevidenceval, string7)) && (this.sztaxonval.equals("") || this.containsTaxon(this.sztaxonval, string10))) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            HashSet hashSet3;
            String string11 = (String)hashMap2.get(string3);
            if (string11 != null) {
                hashSet3 = this.getgocategories(string11);
                this.addgenesgocategory(string6, hashSet, hashSet3);
            } else if (hashSet2.contains(string3)) {
                hashSet3 = this.getgocategories(string3);
                this.addgenesgocategory(string6, hashSet, hashSet3);
            } else {
                object7 = (HashSet)hashMap.get(string3);
                if (object7 != null) {
                    object6 = ((HashSet)object7).iterator();
                    while (object6.hasNext()) {
                        object5 = (String)object6.next();
                        hashSet3 = this.getgocategories((String)object5);
                        this.addgenesgocategory(string6, hashSet, hashSet3);
                    }
                }
            }
            object7 = (String)hashMap2.get(string4);
            if (object7 != null) {
                hashSet3 = this.getgocategories((String)object7);
                this.addgenesgocategory(string6, hashSet, hashSet3);
            } else if (hashSet2.contains(string4)) {
                hashSet3 = this.getgocategories(string4);
                this.addgenesgocategory(string6, hashSet, hashSet3);
            } else {
                object6 = (HashSet)hashMap.get(string4);
                if (object6 != null) {
                    object5 = ((HashSet)object6).iterator();
                    while (object5.hasNext()) {
                        object4 = (String)object5.next();
                        hashSet3 = this.getgocategories((String)object4);
                        this.addgenesgocategory(string6, hashSet, hashSet3);
                    }
                }
            }
            object6 = new StringTokenizer(string4, "_");
            if (((StringTokenizer)object6).countTokens() > 1) {
                object5 = ((StringTokenizer)object6).nextToken();
                object4 = (String)hashMap2.get(object5);
                if (object4 != null) {
                    hashSet3 = this.getgocategories((String)object4);
                    this.addgenesgocategory(string6, hashSet, hashSet3);
                } else if (hashSet2.contains(object5)) {
                    hashSet3 = this.getgocategories((String)object5);
                    this.addgenesgocategory(string6, hashSet, hashSet3);
                } else {
                    object3 = (HashSet)hashMap.get(object5);
                    if (object3 != null) {
                        object2 = ((HashSet)object3).iterator();
                        while (object2.hasNext()) {
                            object = (String)object2.next();
                            hashSet3 = this.getgocategories((String)object);
                            this.addgenesgocategory(string6, hashSet, hashSet3);
                        }
                    }
                }
            }
            if (string != null) {
                object5 = (String)hashMap2.get(string);
                if (object5 != null) {
                    hashSet3 = this.getgocategories((String)object5);
                    this.addgenesgocategory(string6, hashSet, hashSet3);
                } else if (hashSet2.contains(string)) {
                    hashSet3 = this.getgocategories(string);
                    this.addgenesgocategory(string6, hashSet, hashSet3);
                } else {
                    object4 = (HashSet)hashMap.get(string);
                    if (object4 != null) {
                        object3 = ((HashSet)object4).iterator();
                        while (object3.hasNext()) {
                            object2 = (String)object3.next();
                            hashSet3 = this.getgocategories((String)object2);
                            this.addgenesgocategory(string6, hashSet, hashSet3);
                        }
                    }
                }
            }
            if (string2 != null) {
                object5 = new StringTokenizer(string2, ":|;,\"");
                while (((StringTokenizer)object5).hasMoreTokens()) {
                    object4 = ((StringTokenizer)object5).nextToken().trim();
                    object3 = (String)hashMap2.get(object4);
                    if (object3 != null) {
                        hashSet3 = this.getgocategories((String)object3);
                        this.addgenesgocategory(string6, hashSet, hashSet3);
                        continue;
                    }
                    if (hashSet2.contains(object4)) {
                        hashSet3 = this.getgocategories((String)object4);
                        this.addgenesgocategory(string6, hashSet, hashSet3);
                        continue;
                    }
                    object2 = (HashSet)hashMap.get(object4);
                    if (object2 == null) continue;
                    object = ((HashSet)object2).iterator();
                    while (object.hasNext()) {
                        String string12 = (String)object.next();
                        hashSet3 = this.getgocategories(string12);
                        this.addgenesgocategory(string6, hashSet, hashSet3);
                    }
                }
            }
        }
    }

    public boolean validEvidence(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";,|");
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().equalsIgnoreCase(string2)) continue;
            return false;
        }
        return true;
    }

    public boolean containsTaxon(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, ";,|");
            while (stringTokenizer2.hasMoreTokens()) {
                String string4 = stringTokenizer2.nextToken();
                if (!string4.equalsIgnoreCase(string3) && !("taxon:" + string4).equalsIgnoreCase(string3)) continue;
                return true;
            }
        }
        return false;
    }

    public HashSet getgocategories(String string) {
        HashSet hashSet = (HashSet)this.htGoLabels.get(string);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.htGoLabels.put(string, hashSet);
        }
        return hashSet;
    }

    public void addgenesgocategory(String string, HashSet hashSet, HashSet hashSet2) {
        String string2 = (String)this.htAlt.get(string);
        if (string2 != null) {
            string = string2;
        }
        if (!hashSet.contains(string) && hashSet2.add(string) && this.htGO.get(string) == null) {
            String string3 = (String)this.htIDCategory.get(string);
            if (string3 == null) {
                string3 = string;
            }
            this.htGO.put(string, new Rec(new HashSet(), string3));
        }
    }

    public void loadIDCategory() {
        this.htIDCategory = new HashMap();
        if (!this.szcategoryIDval.equals("")) {
            try {
                String string;
                BufferedReader bufferedReader;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.szcategoryIDval))));
                }
                catch (IOException iOException) {
                    bufferedReader = new BufferedReader(new FileReader(this.szcategoryIDval));
                }
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                    if (stringTokenizer.countTokens() < 2) continue;
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    this.htIDCategory.put(string2, string3);
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(this.szcategoryIDval + " not found");
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
        }
    }

    public void addgenesgo(String string, String string2, HashSet hashSet, HashSet hashSet2, HashMap hashMap) {
        block4: {
            block3: {
                if (!hashSet2.contains(string)) break block3;
                HashSet hashSet3 = this.getgocategories(string);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t;,|\"");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().trim();
                    this.addgenesgocategory(string3, hashSet, hashSet3);
                }
                break block4;
            }
            HashSet hashSet4 = (HashSet)hashMap.get(string);
            if (hashSet4 == null) break block4;
            for (String string4 : hashSet4) {
                HashSet hashSet5 = this.getgocategories(string4);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t;,|\"");
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken().trim();
                    this.addgenesgocategory(string5, hashSet, hashSet5);
                }
            }
        }
    }

    public void loadIDbase(String string, HashMap hashMap, ArrayList arrayList) {
        HashSet hashSet = this.labelsForID(string);
        arrayList.add(hashSet);
        for (String string2 : hashSet) {
            Object v = this.htFullCount.get(string2);
            if (v == null) {
                hashMap.put(string2, new Integer(1));
                continue;
            }
            int n = (Integer)v;
            hashMap.put(string2, new Integer(++n));
        }
    }

    public void loadID(String string) {
        if (this.htGeneNames.get(string) == null) {
            this.htGeneNames.put(string, false);
            ++this.numtotalgenes;
            HashSet hashSet = this.labelsForID(string);
            this.algoAll.add(hashSet);
            for (String string2 : hashSet) {
                Object v = this.htFullCount.get(string2);
                if (v == null) {
                    this.htFullCount.put(string2, new Integer(1));
                    ++this.numcategory;
                    if (this.nmingo > 1) continue;
                    ++this.nlegalgo;
                    continue;
                }
                int n = (Integer)v;
                if (++n == this.nmingo) {
                    ++this.nlegalgo;
                }
                this.htFullCount.put(string2, new Integer(n));
                if (n <= this.nmaxsize) continue;
                this.nmaxsize = n;
            }
        }
    }

    public HashSet labelsForID(String string) {
        Object object;
        Object object2;
        Object object3;
        HashSet<Object> hashSet = new HashSet<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";|,");
        if (stringTokenizer.countTokens() > 1 && (object3 = (HashSet)this.htGoLabels.get(string)) != null) {
            object2 = ((HashSet)object3).iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                hashSet.add(object);
            }
        }
        while (stringTokenizer.hasMoreTokens()) {
            object3 = stringTokenizer.nextToken().trim();
            object2 = (HashSet)this.htGoLabels.get(object3);
            if (object2 == null) continue;
            object = ((HashSet)object2).iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public boolean isOrder(String string) {
        Boolean bl;
        if (this.szsortcommand.equals("go") || this.szsortcommand.equals("expgo")) {
            return this.geneIsOfType(string, this.szSelectedGO);
        }
        return (this.szsortcommand.equals("define") || this.szsortcommand.equals("expdefine")) && (bl = (Boolean)this.htGeneNames.get(string)) != null && bl != false;
    }

    public boolean geneIsOfType(String string, String string2) {
        HashSet hashSet;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";|,");
        if (stringTokenizer.countTokens() > 1 && (hashSet = (HashSet)this.htGoLabels.get(string)) != null && hashSet.contains(string2)) {
            return true;
        }
        while (stringTokenizer.hasMoreTokens()) {
            hashSet = (HashSet)this.htGoLabels.get(stringTokenizer.nextToken().trim());
            if (hashSet == null || !hashSet.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public GoResults getCategory(ArrayList arrayList, String[] stringArray, ArrayList[] arrayListArray, boolean bl, HashSet hashSet) {
        return this.getCategory(arrayList, stringArray, arrayListArray, bl, hashSet, -1.0);
    }

    public GoResults getCategory(String[] stringArray, boolean[] blArray, boolean[] blArray2) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        int n = 0;
        double d = 0.0;
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        this.algoAllbase = new ArrayList();
        for (int i = 0; i < blArray2.length; ++i) {
            if (!blArray[i]) continue;
            String string = stringArray[i];
            int n2 = 1;
            HashSet hashSet = this.labelsForID(string);
            this.algoAllbase.add(hashSet);
            n += n2;
            if (blArray2[i]) {
                d += (double)n2;
            }
            for (String string2 : hashSet) {
                Object v = hashMap2.get(string2);
                if (v == null) {
                    hashMap2.put(string2, new Integer(1));
                } else {
                    int n3 = (Integer)v;
                    hashMap2.put(string2, new Integer(++n3));
                }
                if (!blArray2[i]) continue;
                Object v2 = hashMap.get(string2);
                if (v2 == null) {
                    hashMap.put(string2, new Double(n2));
                    continue;
                }
                double d2 = (Double)v2;
                hashMap.put(string2, new Double(d2 + (double)n2));
            }
        }
        return this.computePValuesBase(hashMap, hashMap2, d, n, blArray);
    }

    public GoResults computePValuesBase(HashMap hashMap, HashMap hashMap2, double d, int n, boolean[] blArray) {
        String string;
        int n2;
        String string2;
        HashSet[] hashSetArray;
        HashMap<String, Double> hashMap3 = new HashMap<String, Double>();
        int n3 = 0;
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            double d2 = (Double)iterator.next().getValue();
            if (!(d2 >= (double)this.nmingo)) continue;
            ++n3;
        }
        iterator = hashMap.entrySet().iterator();
        GoRec[] goRecArray = new GoRec[n3];
        int n4 = 0;
        int n5 = (int)Math.ceil(d);
        while (iterator.hasNext()) {
            double d3;
            hashSetArray = iterator.next();
            double d4 = (Double)hashSetArray.getValue();
            if (!(d4 >= (double)this.nmingo)) continue;
            string2 = (String)hashSetArray.getKey();
            int n6 = (Integer)hashMap2.get(string2);
            n2 = (int)Math.ceil(d4 - 1.0);
            String string3 = n2 + "," + n6;
            Object v = hashMap3.get(string3);
            if (v == null) {
                d3 = StatUtil.hypergeometrictail(n2, n6, n - n6, n5);
                hashMap3.put(string3, new Double(d3));
            } else {
                d3 = (Double)v;
            }
            string = ((Rec)this.htGO.get((Object)string2)).sztermName;
            goRecArray[n4] = new GoRec(d4, n6, d3, string, string2);
            ++n4;
        }
        Arrays.sort(goRecArray, new RecCompare());
        if (this.brandomgoval) {
            hashSetArray = new HashSet[n];
            for (int i = 0; i < hashSetArray.length; ++i) {
                hashSetArray[i] = (HashSet)this.algoAllbase.get(i);
            }
            int[] nArray = new int[n5];
            double[] dArray = new double[this.nsamplespval];
            int[] nArray2 = new int[n5];
            for (n2 = 0; n2 < this.nsamplespval; ++n2) {
                int n7;
                int n8;
                for (n8 = 0; n8 < nArray2.length; ++n8) {
                    nArray2[n8] = this.nmaxsize + 1;
                }
                dArray[n2] = 1.0;
                for (n8 = 0; n8 < n5; ++n8) {
                    nArray[n8] = n8;
                }
                for (n8 = n5; n8 < n; ++n8) {
                    if (!(Math.random() < (double)n5 / (double)(n8 + 1))) continue;
                    nArray[(int)Math.floor((double)((double)n5 * Math.random()))] = n8;
                }
                hashMap = new HashMap<String, Integer>();
                for (n7 = 0; n7 < n5; ++n7) {
                    HashSet hashSet = hashSetArray[nArray[n7]];
                    for (String string4 : hashSet) {
                        string = hashMap.get(string4);
                        if (string == null) {
                            hashMap.put(string4, new Integer(1));
                            continue;
                        }
                        int n9 = (Integer)((Object)string);
                        hashMap.put(string4, new Integer(n9 + 1));
                    }
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    string2 = (String)entry.getKey();
                    int n10 = (Integer)entry.getValue();
                    int n11 = (Integer)hashMap2.get(string2);
                    if (nArray2[--n10] <= n11) continue;
                    nArray2[n10] = n11;
                }
                n7 = this.nmaxsize + 1;
                for (int i = nArray2.length - 1; i >= this.nmingo - 1; --i) {
                    double d5;
                    if (nArray2[i] >= n7) continue;
                    String string5 = i + "," + nArray2[i];
                    string = hashMap3.get(string5);
                    n7 = nArray2[i];
                    if (string == null) {
                        d5 = StatUtil.hypergeometrictail(i, nArray2[i], n - nArray2[i], n5);
                        hashMap3.put(string5, new Double(d5));
                    } else {
                        d5 = (Double)((Object)string);
                    }
                    if (!(d5 < dArray[n2])) continue;
                    dArray[n2] = d5;
                }
            }
            Arrays.sort(dArray);
            n2 = 0;
            for (int i = 0; i < goRecArray.length; ++i) {
                while (n2 < dArray.length && dArray[n2] <= goRecArray[i].dpvalue) {
                    ++n2;
                }
                goRecArray[i].dcorrectedpvalue = (double)n2 / (double)this.nsamplespval;
            }
        } else {
            for (int i = 0; i < goRecArray.length; ++i) {
                goRecArray[i].dcorrectedpvalue = Math.min(goRecArray[i].dpvalue * (double)this.nlegalgo, 1.0);
            }
        }
        return new GoResults(n, d, goRecArray);
    }

    public GoResults getCategory(String[] stringArray, double[] dArray) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 0.0)) continue;
            String string = stringArray[i];
            double d2 = dArray[i];
            HashSet hashSet = this.labelsForID(string);
            d += d2;
            for (String string2 : hashSet) {
                Object v = hashMap.get(string2);
                if (v == null) {
                    hashMap.put(string2, new Double(d2));
                    continue;
                }
                double d3 = (Double)v;
                hashMap.put(string2, new Double(d3 + d2));
            }
        }
        return this.computePValues(hashMap, d);
    }

    public GoResults getCategory(ArrayList arrayList, String[] stringArray, ArrayList[] arrayListArray, boolean bl, HashSet hashSet, double d) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        int n = arrayList.size();
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2 = (Integer)arrayList.get(i);
            if (!(!bl && hashSet == null || hashSet != null && hashSet.contains(stringArray[n2])) && (!bl || !this.isOrder(stringArray[n2]))) continue;
            String string = stringArray[n2];
            double d3 = 1.0 / (double)arrayListArray[n2].size();
            HashSet hashSet2 = this.labelsForID(string);
            d2 += d3;
            for (String string2 : hashSet2) {
                Object v = hashMap.get(string2);
                if (v == null) {
                    hashMap.put(string2, new Double(d3));
                    continue;
                }
                double d4 = (Double)v;
                hashMap.put(string2, new Double(d4 + d3));
            }
        }
        if (d < 0.0) {
            return this.computePValues(hashMap, d2);
        }
        return this.computePValues(hashMap, d2, d);
    }

    public GoResults computePValues(HashMap hashMap, double d) {
        int n;
        int n2;
        String string;
        Map.Entry entry;
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        int n3 = 0;
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            double d2 = (Double)iterator.next().getValue();
            if (!(d2 >= (double)this.nmingo)) continue;
            ++n3;
        }
        iterator = hashMap.entrySet().iterator();
        GoRec[] goRecArray = new GoRec[n3];
        int n4 = 0;
        int n5 = (int)Math.ceil(d);
        while (iterator.hasNext()) {
            double d3;
            entry = iterator.next();
            double d4 = (Double)entry.getValue();
            if (!(d4 >= (double)this.nmingo)) continue;
            string = (String)entry.getKey();
            n2 = (Integer)this.htFullCount.get(string);
            n = (int)Math.ceil(d4 - 1.0);
            String string2 = n + "," + n2;
            Object v = hashMap2.get(string2);
            if (v == null) {
                d3 = StatUtil.hypergeometrictail(n, n2, this.numtotalgenes - n2, n5);
                hashMap2.put(string2, new Double(d3));
            } else {
                d3 = (Double)v;
            }
            String string3 = ((Rec)this.htGO.get((Object)string)).sztermName;
            goRecArray[n4] = new GoRec(d4, n2, d3, string3, string);
            ++n4;
        }
        Arrays.sort(goRecArray, new RecCompare());
        if (this.brandomgoval) {
            entry = (Map.Entry)new int[n5];
            double[] dArray = new double[this.nsamplespval];
            int[] nArray = new int[n5];
            for (n2 = 0; n2 < this.nsamplespval; ++n2) {
                Object v;
                int n6;
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = this.nmaxsize + 1;
                }
                dArray[n2] = 1.0;
                for (n = 0; n < n5; ++n) {
                    entry[n] = n;
                }
                for (n = n5; n < this.numtotalgenes; ++n) {
                    if (!(Math.random() < (double)n5 / (double)(n + 1))) continue;
                    entry[(int)Math.floor((double)((double)n5 * Math.random()))] = n;
                }
                hashMap = new HashMap<String, Integer>();
                for (n6 = 0; n6 < n5; ++n6) {
                    HashSet hashSet = this.goAll[entry[n6]];
                    for (String string4 : hashSet) {
                        v = hashMap.get(string4);
                        if (v == null) {
                            hashMap.put(string4, new Integer(1));
                            continue;
                        }
                        int n7 = (Integer)v;
                        hashMap.put(string4, new Integer(n7 + 1));
                    }
                }
                for (Map.Entry entry2 : hashMap.entrySet()) {
                    string = (String)entry2.getKey();
                    int n8 = (Integer)entry2.getValue();
                    int n9 = (Integer)this.htFullCount.get(string);
                    if (nArray[--n8] <= n9) continue;
                    nArray[n8] = n9;
                }
                n6 = this.nmaxsize + 1;
                for (int i = nArray.length - 1; i >= this.nmingo - 1; --i) {
                    double d5;
                    if (nArray[i] >= n6) continue;
                    String string5 = i + "," + nArray[i];
                    v = hashMap2.get(string5);
                    n6 = nArray[i];
                    if (v == null) {
                        d5 = StatUtil.hypergeometrictail(i, nArray[i], this.numtotalgenes - nArray[i], n5);
                        hashMap2.put(string5, new Double(d5));
                    } else {
                        d5 = (Double)v;
                    }
                    if (!(d5 < dArray[n2])) continue;
                    dArray[n2] = d5;
                }
            }
            Arrays.sort(dArray);
            n2 = 0;
            for (n = 0; n < goRecArray.length; ++n) {
                while (n2 < dArray.length && dArray[n2] <= goRecArray[n].dpvalue) {
                    ++n2;
                }
                goRecArray[n].dcorrectedpvalue = (double)n2 / (double)this.nsamplespval;
            }
        } else {
            for (int i = 0; i < goRecArray.length; ++i) {
                goRecArray[i].dcorrectedpvalue = Math.min(goRecArray[i].dpvalue * (double)this.nlegalgo, 1.0);
            }
        }
        return new GoResults(this.numtotalgenes, d, goRecArray);
    }

    public GoResults computePValues(HashMap hashMap, double d, double d2) {
        int n;
        int n2;
        String string;
        Map.Entry entry;
        HashMap<String, PvalRec> hashMap2 = new HashMap<String, PvalRec>();
        double d3 = d2 / (double)this.numtotalgenes;
        int n3 = 0;
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            double d4 = (Double)iterator.next().getValue();
            if (!(d4 >= (double)this.nmingo)) continue;
            ++n3;
        }
        iterator = hashMap.entrySet().iterator();
        GoRec[] goRecArray = new GoRec[n3];
        int n4 = 0;
        int n5 = (int)Math.ceil(d);
        while (iterator.hasNext()) {
            double d5;
            double d6;
            entry = iterator.next();
            double d7 = (Double)entry.getValue();
            if (!(d7 >= (double)this.nmingo)) continue;
            string = (String)entry.getKey();
            n2 = (Integer)this.htFullCount.get(string);
            n = (int)Math.ceil(d7 - 1.0);
            String string2 = n + "," + n2;
            Object v = hashMap2.get(string2);
            if (v == null) {
                d6 = StatUtil.hypergeometrictail(n, n2, this.numtotalgenes - n2, n5);
                d5 = StatUtil.binomialtail(n, n2, d3);
                hashMap2.put(string2, new PvalRec(d6, d5));
            } else {
                d6 = ((PvalRec)v).dpvalhyper;
                d5 = ((PvalRec)v).dpvalbinom;
            }
            String string3 = ((Rec)this.htGO.get((Object)string)).sztermName;
            goRecArray[n4] = new GoRec(d7, n2, d6, d5, string3, string);
            ++n4;
        }
        if (this.brandomgoval) {
            entry = (Map.Entry)new int[n5];
            double[] dArray = new double[this.nsamplespval];
            int[] nArray = new int[n5];
            for (n2 = 0; n2 < this.nsamplespval; ++n2) {
                Object v;
                int n6;
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = this.nmaxsize + 1;
                }
                dArray[n2] = 1.0;
                for (n = 0; n < n5; ++n) {
                    entry[n] = n;
                }
                for (n = n5; n < this.numtotalgenes; ++n) {
                    if (!(Math.random() < (double)n5 / (double)(n + 1))) continue;
                    entry[(int)Math.floor((double)((double)n5 * Math.random()))] = n;
                }
                hashMap = new HashMap<String, Integer>();
                for (n6 = 0; n6 < n5; ++n6) {
                    HashSet hashSet = this.goAll[entry[n6]];
                    for (String string4 : hashSet) {
                        v = hashMap.get(string4);
                        if (v == null) {
                            hashMap.put(string4, new Integer(1));
                            continue;
                        }
                        int n7 = (Integer)v;
                        hashMap.put(string4, new Integer(n7 + 1));
                    }
                }
                for (Map.Entry entry2 : hashMap.entrySet()) {
                    string = (String)entry2.getKey();
                    int n8 = (Integer)entry2.getValue();
                    int n9 = (Integer)this.htFullCount.get(string);
                    if (nArray[--n8] <= n9) continue;
                    nArray[n8] = n9;
                }
                n6 = this.nmaxsize + 1;
                for (int i = nArray.length - 1; i >= this.nmingo - 1; --i) {
                    double d8;
                    if (nArray[i] >= n6) continue;
                    String string5 = i + "," + nArray[i];
                    v = hashMap2.get(string5);
                    n6 = nArray[i];
                    if (v == null) {
                        d8 = StatUtil.hypergeometrictail(i, nArray[i], this.numtotalgenes - nArray[i], n5);
                        hashMap2.put(string5, new PvalRec(d8, -1.0));
                    } else {
                        d8 = ((PvalRec)v).dpvalhyper;
                    }
                    if (!(d8 < dArray[n2])) continue;
                    dArray[n2] = d8;
                }
            }
            Arrays.sort(dArray);
            n2 = 0;
            for (n = 0; n < goRecArray.length; ++n) {
                while (n2 < dArray.length && dArray[n2] <= goRecArray[n].dpvalue) {
                    ++n2;
                }
                goRecArray[n].dcorrectedpvalue = (double)n2 / (double)this.nsamplespval;
            }
        } else {
            for (int i = 0; i < goRecArray.length; ++i) {
                goRecArray[i].dcorrectedpvalue = Math.min(goRecArray[i].dpvalue * (double)this.nlegalgo, 1.0);
            }
        }
        Arrays.sort(goRecArray, new RecCompareBinom());
        for (int i = 0; i < goRecArray.length; ++i) {
            goRecArray[i].dcorrectedpvaluebinom = Math.min(goRecArray[i].dpvaluebinom * (double)this.nlegalgo, 1.0);
        }
        return new GoResults(this.numtotalgenes, d, goRecArray);
    }

    protected RecCount incrementSelectData(ArrayList arrayList, String[] stringArray, ArrayList[] arrayListArray, boolean bl, String string) {
        int n = arrayList.size();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2 = (Integer)arrayList.get(i);
            String string2 = stringArray[n2];
            double d3 = 1.0 / (double)arrayListArray[n2].size();
            d2 += d3;
            if (bl) {
                Boolean bl2 = (Boolean)this.htGeneNames.get(string2);
                if (bl2 == null || !bl2.booleanValue()) continue;
                d += d3;
                continue;
            }
            if (!this.geneIsOfType(string2, string)) continue;
            d += d3;
        }
        return new RecCount(d, d2);
    }

    protected void hashtoList1(HashMap hashMap, RecIDpval[] recIDpvalArray) {
        Set set = hashMap.entrySet();
        Iterator iterator = set.iterator();
        int n = set.size();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            double d = (Double)entry.getValue();
            recIDpvalArray[i] = new RecIDpval(d, string);
        }
        Arrays.sort(recIDpvalArray, new RecIDpvalCompare());
    }

    protected void hashtoList2(HashMap hashMap, RecIDpval2[] recIDpval2Array) {
        Set set = hashMap.entrySet();
        Iterator iterator = set.iterator();
        int n = set.size();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            PvalRec pvalRec = (PvalRec)entry.getValue();
            recIDpval2Array[i] = new RecIDpval2(pvalRec.dpvalhyper, pvalRec.dpvalbinom, string);
        }
        Arrays.sort(recIDpval2Array, new RecIDpval2Compare());
    }

    protected void updateBest(HashMap hashMap, HashMap hashMap2, int n, HashMap hashMap3, double d) {
        Set set = hashMap.entrySet();
        Iterator iterator = set.iterator();
        int n2 = set.size();
        int n3 = (int)Math.ceil(d);
        for (int i = 0; i < n2; ++i) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            double d2 = (Double)entry.getValue();
            Double d3 = (Double)hashMap2.get(string);
            int n4 = (Integer)hashMap3.get(string);
            double d4 = StatUtil.hypergeometrictail((int)Math.ceil(d2 - 1.0), n4, n - n4, n3);
            if (d3 == null) {
                if (!(d4 <= 1.0)) continue;
                hashMap2.put(string, new Double(d4));
                continue;
            }
            if (!(d4 < d3)) continue;
            hashMap2.put(string, new Double(d4));
        }
    }

    protected void updateBestHyperBinom(HashMap hashMap, HashMap hashMap2, int n, HashMap hashMap3, double d, double d2) {
        Set set = hashMap.entrySet();
        Iterator iterator = set.iterator();
        int n2 = set.size();
        double d3 = d2 / (double)n;
        int n3 = (int)Math.ceil(d);
        for (int i = 0; i < n2; ++i) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            double d4 = (Double)entry.getValue();
            PvalRec pvalRec = (PvalRec)hashMap2.get(string);
            int n4 = (Integer)hashMap3.get(string);
            int n5 = (int)Math.ceil(d4 - 1.0);
            double d5 = StatUtil.hypergeometrictail(n5, n4, n - n4, n3);
            double d6 = StatUtil.binomialtail(n5, n4, d3);
            if (pvalRec == null) {
                if (!(d5 <= 1.0) && !(d6 <= 1.0)) continue;
                hashMap2.put(string, new PvalRec(d5, d6));
                continue;
            }
            if (!(d5 < pvalRec.dpvalhyper) && !(d6 < pvalRec.dpvalbinom)) continue;
            hashMap2.put(string, new PvalRec(Math.min(d5, pvalRec.dpvalhyper), Math.min(d6, pvalRec.dpvalbinom)));
        }
    }

    public void clusterFileResults(String string) throws Exception {
        GoResults goResults;
        String string2;
        double d = 0.0;
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        boolean bl = true;
        double d2 = 0.0;
        int n = 1;
        HashSet<String> hashSet = new HashSet<String>();
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.szBatchGOoutput));
        String string3 = "";
        while ((string2 = bufferedReader.readLine()) != null) {
            String string4;
            if (string2.startsWith("#") || bl) {
                if (!bl) {
                    goResults = this.computePValues(hashMap, d);
                    goResults.print(printWriter, this.brandomgoval, string3);
                    d = 0.0;
                    hashMap = new HashMap();
                    hashSet = new HashSet();
                    d2 = 0.0;
                } else {
                    bl = false;
                }
                printWriter.println(string2);
                string3 = string2;
                ++n;
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
            if (!stringTokenizer.hasMoreTokens() || hashSet.contains(string4 = stringTokenizer.nextToken().trim().toUpperCase(Locale.ENGLISH))) continue;
            hashSet.add(string4);
            d2 += 1.0;
            HashSet hashSet2 = this.labelsForID(string4);
            d += 1.0;
            for (String string5 : hashSet2) {
                Object v = hashMap.get(string5);
                if (v == null) {
                    hashMap.put(string5, new Double(1.0));
                    continue;
                }
                double d3 = (Double)v;
                hashMap.put(string5, new Double(d3 + 1.0));
            }
        }
        bufferedReader.close();
        goResults = this.computePValues(hashMap, d);
        goResults.print(printWriter, this.brandomgoval, string3);
        printWriter.close();
    }

    static class RecIDpval2Compare
    implements Comparator {
        RecIDpval2Compare() {
        }

        public int compare(Object object, Object object2) {
            RecIDpval2 recIDpval2 = (RecIDpval2)object;
            RecIDpval2 recIDpval22 = (RecIDpval2)object2;
            if (recIDpval2.dpvalhyper < recIDpval22.dpvalhyper) {
                return -1;
            }
            if (recIDpval2.dpvalhyper > recIDpval22.dpvalhyper) {
                return 1;
            }
            if (recIDpval2.dpvalbinom < recIDpval22.dpvalhyper) {
                return -1;
            }
            if (recIDpval2.dpvalbinom > recIDpval22.dpvalbinom) {
                return 1;
            }
            return recIDpval2.szid.compareTo(recIDpval22.szid);
        }
    }

    static class RecIDpvalCompare
    implements Comparator {
        RecIDpvalCompare() {
        }

        public int compare(Object object, Object object2) {
            RecIDpval recIDpval = (RecIDpval)object;
            RecIDpval recIDpval2 = (RecIDpval)object2;
            if (recIDpval.dpval < recIDpval2.dpval) {
                return -1;
            }
            if (recIDpval.dpval > recIDpval2.dpval) {
                return 1;
            }
            return recIDpval.szid.compareTo(recIDpval2.szid);
        }
    }

    public static class RecIDpval2 {
        public double dpvalbinom;
        public double dpvalhyper;
        public String szid;

        RecIDpval2(double d, double d2, String string) {
            this.dpvalhyper = d;
            this.dpvalbinom = d2;
            this.szid = string;
        }
    }

    public static class RecIDpval {
        public double dpval;
        public String szid;

        RecIDpval(double d, String string) {
            this.dpval = d;
            this.szid = string;
        }
    }

    public class GORankingComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            ProfileGORankingRec profileGORankingRec = (ProfileGORankingRec)object;
            ProfileGORankingRec profileGORankingRec2 = (ProfileGORankingRec)object2;
            if (GoAnnotations.this.bcluster) {
                if (profileGORankingRec.dclusterpval < profileGORankingRec2.dclusterpval) {
                    return -1;
                }
                if (profileGORankingRec.dclusterpval > profileGORankingRec2.dclusterpval) {
                    return 1;
                }
                if (profileGORankingRec.ncluster < profileGORankingRec2.ncluster) {
                    return -1;
                }
                if (profileGORankingRec.ncluster > profileGORankingRec2.ncluster) {
                    return 1;
                }
                if (profileGORankingRec.dpval < profileGORankingRec2.dpval) {
                    return -1;
                }
                if (profileGORankingRec.dpval > profileGORankingRec2.dpval) {
                    return 1;
                }
                if (profileGORankingRec.dgenes > profileGORankingRec2.dgenes) {
                    return -1;
                }
                if (profileGORankingRec.dgenes < profileGORankingRec2.dgenes) {
                    return 1;
                }
                if (profileGORankingRec.nprofile < profileGORankingRec2.nprofile) {
                    return -1;
                }
                if (profileGORankingRec.nprofile > profileGORankingRec2.nprofile) {
                    return 1;
                }
            } else {
                if (profileGORankingRec.dpval < profileGORankingRec2.dpval) {
                    return -1;
                }
                if (profileGORankingRec.dpval > profileGORankingRec2.dpval) {
                    return 1;
                }
                if (profileGORankingRec.ncluster < profileGORankingRec2.ncluster) {
                    return -1;
                }
                if (profileGORankingRec.ncluster > profileGORankingRec2.ncluster) {
                    return 1;
                }
                if (profileGORankingRec.dgenes > profileGORankingRec2.dgenes) {
                    return -1;
                }
                if (profileGORankingRec.dgenes < profileGORankingRec2.dgenes) {
                    return 1;
                }
                if (profileGORankingRec.nprofile < profileGORankingRec2.nprofile) {
                    return -1;
                }
                if (profileGORankingRec.nprofile > profileGORankingRec2.nprofile) {
                    return 1;
                }
            }
            return 0;
        }
    }

    public static class ProfileGORankingRec {
        public int nprofile;
        public int ncluster;
        public double dpval;
        public double dclusterpval;
        public double dgenes;
        public double dmaxselect;
        public double dgenescluster;
        public double dmaxselectcluster;
        public double dgenestotal;
        public double dmaxselecttotal;

        public ProfileGORankingRec(int n, int n2, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            this.nprofile = n;
            this.ncluster = n2;
            this.dpval = d;
            this.dclusterpval = d2;
            this.dgenes = d3;
            this.dmaxselect = d4;
            this.dgenescluster = d5;
            this.dmaxselectcluster = d6;
            this.dgenestotal = d7;
            this.dmaxselecttotal = d8;
        }
    }

    public static class RecCompareBinom
    implements Comparator {
        public int compare(Object object, Object object2) {
            GoRec goRec = (GoRec)object;
            GoRec goRec2 = (GoRec)object2;
            if (goRec.dpvaluebinom < goRec2.dpvaluebinom) {
                return -1;
            }
            if (goRec.dpvaluebinom > goRec2.dpvaluebinom) {
                return 1;
            }
            if (goRec.dcategoryselect > goRec2.dcategoryselect) {
                return -1;
            }
            if (goRec.dcategoryselect < goRec2.dcategoryselect) {
                return 1;
            }
            return 0;
        }
    }

    public static class RecCompare
    implements Comparator {
        public int compare(Object object, Object object2) {
            GoRec goRec = (GoRec)object;
            GoRec goRec2 = (GoRec)object2;
            if (goRec.dpvalue < goRec2.dpvalue) {
                return -1;
            }
            if (goRec.dpvalue > goRec2.dpvalue) {
                return 1;
            }
            if (goRec.dcategoryselect > goRec2.dcategoryselect) {
                return -1;
            }
            if (goRec.dcategoryselect < goRec2.dcategoryselect) {
                return 1;
            }
            return 0;
        }
    }

    static class PvalRec {
        double dpvalhyper;
        double dpvalbinom;

        PvalRec(double d, double d2) {
            this.dpvalhyper = d;
            this.dpvalbinom = d2;
        }
    }

    public static class GoResults {
        public double dall;
        public double dselect;
        public GoRec[] goRecArray;

        public GoResults(double d, double d2, GoRec[] goRecArray) {
            this.dall = d;
            this.dselect = d2;
            this.goRecArray = goRecArray;
        }

        public void print(PrintWriter printWriter, boolean bl, String string) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
            numberFormat.setMinimumFractionDigits(3);
            numberFormat.setMaximumFractionDigits(3);
            NumberFormat numberFormat2 = NumberFormat.getInstance(Locale.ENGLISH);
            numberFormat2.setMinimumFractionDigits(1);
            numberFormat2.setMaximumFractionDigits(1);
            numberFormat2.setGroupingUsed(false);
            printWriter.println("GeneSet\tCategoryID\tCategoryName\t#Genes Category\t#Genes assigned\t#Genes Expected\t#Genes Enriched\tp-value\tCorrected p-value\tfold\t#Genes in Set\t#Total Genes");
            for (int i = 0; i < this.goRecArray.length; ++i) {
                double d = this.dselect * this.goRecArray[i].dcategoryall / this.dall;
                double d2 = this.goRecArray[i].dcategoryselect - d;
                double d3 = this.goRecArray[i].dcategoryselect / this.dselect / (this.goRecArray[i].dcategoryall / this.dall);
                String string2 = this.goRecArray[i].dcorrectedpvalue < 0.001 ? (bl ? "<0.001" : Util.doubleToSz(this.goRecArray[i].dcorrectedpvalue)) : numberFormat.format(this.goRecArray[i].dcorrectedpvalue);
                String string3 = numberFormat2.format(d);
                String string4 = numberFormat2.format(d2);
                double d4 = Double.parseDouble(string4);
                if (d4 > 0.0) {
                    string4 = "+" + string4;
                } else if (d2 == 0.0) {
                    string4 = "0.0";
                }
                String string5 = Util.doubleToSz(this.goRecArray[i].dpvalue);
                printWriter.println(string + "\t" + this.goRecArray[i].szgoid + "\t" + this.goRecArray[i].szgocategory + "\t" + this.goRecArray[i].dcategoryall + "\t" + this.goRecArray[i].dcategoryselect + "\t" + string3 + "\t" + string4 + "\t" + string5 + "\t" + string2 + "\t" + numberFormat.format(d3) + "\t" + this.dselect + "\t" + this.dall);
            }
        }
    }

    public static class GoRec {
        public double dcategoryselect;
        public double dcategoryall;
        public double dpvalue;
        public double dpvaluebinom;
        public String szgoid;
        public String szgocategory;
        public double dcorrectedpvalue;
        public double dcorrectedpvaluebinom;

        public GoRec(double d, double d2, double d3, String string, String string2) {
            this.dcategoryselect = d;
            this.dcategoryall = d2;
            this.dpvalue = d3;
            this.szgoid = string2;
            this.szgocategory = string;
        }

        GoRec(double d, double d2, double d3, double d4, String string, String string2) {
            this.dcategoryselect = d;
            this.dcategoryall = d2;
            this.dpvalue = d3;
            this.dpvaluebinom = d4;
            this.szgoid = string2;
            this.szgocategory = string;
        }

        public void print() {
            System.out.print(this.szgoid + "\t" + this.szgocategory + "\t" + this.dcategoryselect + "\t" + this.dcategoryall + "\t" + this.dpvalue + "\t" + this.dcorrectedpvalue + "\t" + this.dpvaluebinom + "\t" + this.dcorrectedpvaluebinom);
        }
    }

    public static class RecCount {
        public double dmatch;
        public double dtotal;

        RecCount(double d, double d2) {
            this.dmatch = d;
            this.dtotal = d2;
        }
    }

    public static class Rec {
        public HashSet parents;
        public String sztermName;

        public Rec(HashSet hashSet, String string) {
            this.parents = hashSet;
            this.sztermName = string;
        }
    }
}

