/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.chromviewer;

import edu.cmu.cs.sb.chromviewer.Gene;
import edu.cmu.cs.sb.core.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;

public class GenomeFileParser {
    public String szchromval;
    public String szchromsourceval;
    private Hashtable m_allGenes = null;
    private HashSet hs_baseGenes = null;
    private Hashtable m_aliasedGenes = null;
    private HashSet hs_activeGenes = null;
    Gene[] m_chromArray = null;
    private boolean m_parsedOK = false;
    private String m_species = "";
    private int nchromLenMax;
    int[] sortMappingID;
    int[] sortMappingSize;
    HashSet[] basegenesets;
    boolean brandcorrectedpval;
    int nsamplespval;
    static int TYPE_ROMAN = 0;
    static int TYPE_NUMERIC = 1;
    static int TYPE_STRING = 2;

    public GenomeFileParser() {
    }

    public GenomeFileParser(String string, String string2, String[] stringArray, ArrayList arrayList, boolean bl, int n) throws IOException {
        this.szchromval = string.trim();
        this.szchromsourceval = string2;
        if (!string.equals("")) {
            int n2;
            BufferedReader bufferedReader;
            this.m_allGenes = new Hashtable();
            this.m_aliasedGenes = new Hashtable();
            this.brandcorrectedpval = bl;
            this.nsamplespval = n;
            File file = new File(string);
            String string3 = file.getName();
            String[] stringArray2 = string3.split("\\.");
            this.m_species = stringArray2[0];
            String string4 = stringArray2[1];
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))));
            }
            catch (IOException iOException) {
                bufferedReader = new BufferedReader(new FileReader(file));
            }
            Hashtable hashtable = new Hashtable();
            if (string4.startsWith("gff")) {
                this.m_parsedOK = this.parseGff(bufferedReader, hashtable);
            } else if (string4.startsWith("mart")) {
                this.m_parsedOK = this.parseBioMart(bufferedReader, hashtable);
            } else {
                this.m_parsedOK = false;
                throw new IllegalArgumentException(string3 + "is an invalid location file name. Beginning or entire file name " + "should have the form 'species.gff' or 'species.mart'");
            }
            bufferedReader.close();
            if (hashtable.size() == 0) {
                throw new IllegalArgumentException("No gene entries found in file " + string);
            }
            this.sortMappingID = this.sortChromsID(hashtable);
            this.sortMappingSize = this.sortChromsSize(hashtable);
            this.m_chromArray = new Gene[hashtable.size()];
            HashSet[] hashSetArray = hashtable.elements();
            while (hashSetArray.hasMoreElements()) {
                Gene gene;
                this.m_chromArray[gene.chromosome] = gene = (Gene)hashSetArray.nextElement();
            }
            this.hs_activeGenes = new HashSet();
            this.hs_baseGenes = new HashSet();
            hashSetArray = this.addBaseGenes(stringArray, arrayList);
            int n3 = 0;
            for (n2 = 0; n2 < hashSetArray.length; ++n2) {
                if (hashSetArray[n2] == null) continue;
                ++n3;
            }
            this.basegenesets = new HashSet[n3];
            n2 = 0;
            for (int i = 0; n2 < this.basegenesets.length && i < hashSetArray.length; ++i) {
                if (hashSetArray[i] == null) continue;
                this.basegenesets[n2] = hashSetArray[i];
                ++n2;
            }
        }
    }

    private int[] sortChromsID(Hashtable hashtable) {
        ChromIDRec[] chromIDRecArray = new ChromIDRec[hashtable.size()];
        Enumeration enumeration = hashtable.elements();
        for (int i = 0; i < chromIDRecArray.length; ++i) {
            Gene gene = (Gene)enumeration.nextElement();
            chromIDRecArray[i] = new ChromIDRec();
            chromIDRecArray[i].norigindex = gene.chromosome;
            chromIDRecArray[i].szchrom = gene.namechrom;
            if (gene.namechrom.equals("X")) {
                chromIDRecArray[i].ntype = TYPE_STRING;
                chromIDRecArray[i].szchrom = gene.namechrom;
                continue;
            }
            if (gene.namechrom.matches("^\\d+$")) {
                chromIDRecArray[i].ntype = TYPE_NUMERIC;
                chromIDRecArray[i].nchrom = Integer.parseInt(gene.namechrom);
                continue;
            }
            if (gene.namechrom.matches("^[iIvVxXlL]+$")) {
                chromIDRecArray[i].ntype = TYPE_ROMAN;
                chromIDRecArray[i].nchrom = Util.romanToNumeric(gene.namechrom);
                continue;
            }
            chromIDRecArray[i].ntype = TYPE_STRING;
            chromIDRecArray[i].szchrom = gene.namechrom;
        }
        Arrays.sort(chromIDRecArray, new ChromIDRecCompare());
        int[] nArray = new int[chromIDRecArray.length];
        for (int i = 0; i < chromIDRecArray.length; ++i) {
            nArray[chromIDRecArray[i].norigindex] = i;
        }
        return nArray;
    }

    private int[] sortChromsSize(Hashtable hashtable) {
        ChromLengthRec[] chromLengthRecArray = new ChromLengthRec[hashtable.size()];
        Enumeration enumeration = hashtable.elements();
        for (int i = 0; i < chromLengthRecArray.length; ++i) {
            Gene gene = (Gene)enumeration.nextElement();
            chromLengthRecArray[i] = new ChromLengthRec();
            chromLengthRecArray[i].nlength = gene.end;
            chromLengthRecArray[i].norigindex = gene.chromosome;
        }
        Arrays.sort(chromLengthRecArray, new ChromLengthRecCompare());
        int[] nArray = new int[chromLengthRecArray.length];
        for (int i = 0; i < chromLengthRecArray.length; ++i) {
            nArray[chromLengthRecArray[i].norigindex] = i;
        }
        return nArray;
    }

    private boolean parseBioMart(BufferedReader bufferedReader, Hashtable hashtable) throws IOException {
        String string;
        String string2 = "\t";
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        this.nchromLenMax = 0;
        this.m_species = bufferedReader.readLine();
        while ((string = bufferedReader.readLine()) != null) {
            HashSet<Gene> hashSet;
            String[] stringArray = string.split(string2);
            Gene gene = (Gene)hashtable.get(stringArray[n]);
            if (gene == null) {
                gene = new Gene();
                gene.namechrom = stringArray[n];
                gene.start = 1;
                gene.end = 1;
                gene.chromosome = hashtable.size();
                hashtable.put(stringArray[n], gene);
            }
            char c = Integer.parseInt(stringArray[n4]) == -1 ? (char)'-' : '+';
            String string3 = gene.chromosome + "|" + stringArray[n2] + "|" + stringArray[n3] + "|" + c;
            Gene gene2 = (Gene)this.m_allGenes.get(string3);
            if (gene2 == null) {
                gene2 = new Gene();
                gene2.chromosome = gene.chromosome;
                int n6 = Integer.parseInt(stringArray[n3]);
                gene2.start = Integer.parseInt(stringArray[n2]);
                gene2.end = n6;
                if (n6 > gene.end) {
                    gene.end = n6;
                    if (n6 > this.nchromLenMax) {
                        this.nchromLenMax = n6;
                    }
                }
                gene2.strand = c;
                this.m_allGenes.put(string3, gene2);
            }
            if ((hashSet = (HashSet<Gene>)this.m_aliasedGenes.get(stringArray[n5])) == null) {
                hashSet = new HashSet<Gene>(1);
                this.m_aliasedGenes.put(stringArray[n5], hashSet);
            }
            hashSet.add(gene2);
            for (int i = n5; i < stringArray.length; ++i) {
                if (stringArray[i].length() == 0) continue;
                hashSet = (HashSet<Gene>)this.m_aliasedGenes.get(stringArray[i]);
                if (hashSet == null) {
                    hashSet = new HashSet<Gene>(1);
                    this.m_aliasedGenes.put(stringArray[i], hashSet);
                }
                hashSet.add(gene2);
            }
        }
        if (hashtable.size() == 0) {
            throw new IllegalArgumentException("No gene entries found in the biomart location file");
        }
        return true;
    }

    private boolean parseGff(BufferedReader bufferedReader, Hashtable hashtable) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null && !string.startsWith("##FASTA")) {
            Object object;
            if (string.startsWith("#")) continue;
            String[] stringArray = string.split("\\t");
            if (stringArray[2].equals("chromosome")) {
                object = stringArray[0];
                Gene gene = (Gene)hashtable.get(object);
                if (gene == null) {
                    gene = new Gene();
                    gene.namechrom = object;
                    gene.start = Integer.parseInt(stringArray[3]);
                    gene.end = Integer.parseInt(stringArray[4]);
                    if (gene.end > this.nchromLenMax) {
                        this.nchromLenMax = gene.end;
                    }
                    gene.chromosome = hashtable.size();
                    hashtable.put(gene.namechrom, gene);
                    continue;
                }
                int n = Integer.parseInt(stringArray[4]);
                if (n <= gene.end) continue;
                gene.end = n;
                if (n <= this.nchromLenMax) continue;
                this.nchromLenMax = n;
                continue;
            }
            if (!stringArray[2].equals("gene")) continue;
            object = (Gene)hashtable.get(stringArray[0]);
            if (object == null) {
                object = new Gene();
                ((Gene)object).namechrom = stringArray[0];
                ((Gene)object).start = 1;
                ((Gene)object).end = 1;
                ((Gene)object).chromosome = hashtable.size();
                hashtable.put(stringArray[0], object);
            }
            char c = stringArray[6].charAt(0);
            String string2 = ((Gene)object).chromosome + "|" + stringArray[3] + "|" + stringArray[4] + "|" + c;
            Gene gene = (Gene)this.m_allGenes.get(string2);
            if (gene == null) {
                gene = new Gene();
                gene.chromosome = ((Gene)object).chromosome;
                int n = Integer.parseInt(stringArray[4]);
                gene.start = Integer.parseInt(stringArray[3]);
                gene.end = n;
                if (n > ((Gene)object).end) {
                    ((Gene)object).end = n;
                    if (n > this.nchromLenMax) {
                        this.nchromLenMax = n;
                    }
                }
                gene.strand = c;
                this.m_allGenes.put(string2, gene);
            }
            String[] stringArray2 = stringArray[8].split(";");
            for (int i = 0; i < stringArray2.length; ++i) {
                String[] stringArray3;
                String[] stringArray4 = stringArray2[i].split("=");
                if (stringArray4[0].compareTo("ID") == 0 || stringArray4[1].compareTo("Name") == 0) {
                    stringArray3 = (String[])this.m_aliasedGenes.get(stringArray4[1]);
                    if (stringArray3 == null) {
                        stringArray3 = new HashSet(1);
                        this.m_aliasedGenes.put(stringArray4[1], stringArray3);
                    }
                    stringArray3.add(gene);
                    continue;
                }
                if (stringArray4[0].compareTo("Alias") != 0) continue;
                stringArray3 = stringArray4[1].split(",");
                for (int j = 0; j < stringArray3.length; ++j) {
                    HashSet<Gene> hashSet = (HashSet<Gene>)this.m_aliasedGenes.get(stringArray3[j]);
                    if (hashSet == null) {
                        hashSet = new HashSet<Gene>(1);
                        this.m_aliasedGenes.put(stringArray3[j], hashSet);
                    }
                    hashSet.add(gene);
                }
            }
        }
        return true;
    }

    public String getSpecies() {
        return this.m_species;
    }

    public Gene[] getChromArray() {
        return this.m_chromArray;
    }

    public int getChromLenMax() {
        return this.nchromLenMax;
    }

    public Gene[] getChroms() {
        if (!this.m_parsedOK) {
            return null;
        }
        return this.m_chromArray;
    }

    public boolean parsedOK() {
        return this.m_parsedOK;
    }

    public void clearActiveGenes() {
        this.hs_activeGenes = new HashSet();
    }

    public HashSet[] addBaseGenes(String[] stringArray, ArrayList arrayList) {
        int n;
        if (arrayList == null) {
            return this.addGenesHelper(stringArray, this.hs_baseGenes);
        }
        int n2 = arrayList.size();
        String[] stringArray2 = new String[stringArray.length + n2];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n];
        }
        for (n = 0; n < n2; ++n) {
            stringArray2[n + stringArray.length] = (String)arrayList.get(n);
        }
        return this.addGenesHelper(stringArray2, this.hs_baseGenes);
    }

    public HashSet[] addActiveGenes(String[] stringArray) {
        return this.addGenesHelper(stringArray, this.hs_activeGenes);
    }

    private HashSet[] addGenesHelper(String[] stringArray, HashSet hashSet) {
        HashSet hashSet2 = null;
        HashSet[] hashSetArray = new HashSet[stringArray.length];
        block0: for (int i = 0; i < stringArray.length; ++i) {
            hashSetArray[i] = null;
            hashSet2 = (HashSet)this.m_aliasedGenes.get(stringArray[i]);
            if (hashSet2 != null) {
                hashSetArray[i] = hashSet2;
                hashSet.addAll(hashSetArray[i]);
                continue;
            }
            String[] stringArray2 = stringArray[i].split("[;|,]");
            for (int j = 0; j < stringArray2.length; ++j) {
                hashSet2 = (HashSet)this.m_aliasedGenes.get(stringArray2[j]);
                if (hashSet2 == null) continue;
                hashSetArray[i] = hashSet2;
                hashSet.addAll(hashSetArray[i]);
                continue block0;
            }
        }
        return hashSetArray;
    }

    int[] getBaseCountPerChrom() {
        return this.getCountPerChromHelper(this.hs_baseGenes);
    }

    int[] getActiveCountPerChrom() {
        return this.getCountPerChromHelper(this.hs_activeGenes);
    }

    private int[] getCountPerChromHelper(HashSet hashSet) {
        if (!this.m_parsedOK) {
            return null;
        }
        int[] nArray = new int[this.m_chromArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        for (Gene gene : hashSet) {
            int n = gene.chromosome;
            nArray[n] = nArray[n] + 1;
        }
        return nArray;
    }

    static class ChromLengthRecCompare
    implements Comparator {
        ChromLengthRecCompare() {
        }

        public int compare(Object object, Object object2) {
            ChromLengthRec chromLengthRec = (ChromLengthRec)object;
            ChromLengthRec chromLengthRec2 = (ChromLengthRec)object2;
            if (chromLengthRec.nlength > chromLengthRec2.nlength) {
                return -1;
            }
            if (chromLengthRec.nlength < chromLengthRec2.nlength) {
                return 1;
            }
            if (chromLengthRec.norigindex < chromLengthRec2.norigindex) {
                return -1;
            }
            if (chromLengthRec.norigindex > chromLengthRec2.norigindex) {
                return 1;
            }
            return 0;
        }
    }

    static class ChromLengthRec {
        int nlength;
        int norigindex;

        ChromLengthRec() {
        }
    }

    static class ChromIDRecCompare
    implements Comparator {
        ChromIDRecCompare() {
        }

        public int compare(Object object, Object object2) {
            ChromIDRec chromIDRec = (ChromIDRec)object;
            ChromIDRec chromIDRec2 = (ChromIDRec)object2;
            if (chromIDRec.ntype < chromIDRec2.ntype) {
                return -1;
            }
            if (chromIDRec.ntype > chromIDRec2.ntype) {
                return 1;
            }
            if (chromIDRec.ntype == TYPE_STRING) {
                return chromIDRec.szchrom.compareTo(chromIDRec2.szchrom);
            }
            if (chromIDRec.nchrom < chromIDRec2.nchrom) {
                return -1;
            }
            if (chromIDRec.nchrom > chromIDRec2.nchrom) {
                return 1;
            }
            return 0;
        }
    }

    static class ChromIDRec {
        int ntype;
        int nchrom;
        String szchrom;
        int norigindex;

        ChromIDRec() {
        }
    }
}

