/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.chromviewer;

import edu.cmu.cs.sb.chromviewer.ChromFrame;
import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class ChromGeneRejectTable
extends JPanel
implements ActionListener {
    private boolean DEBUG = false;
    ChromFrame cf;
    String[] columnNames;
    String[][] tabledata;
    JButton saveButton;
    JButton copyButton;
    JButton savenamesButton;
    JButton copynamesButton;
    ArrayList alprofiles;
    TableSorter sorter;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    boolean bprofileonly;
    boolean bquery;
    String szTitle;
    JFrame theFrame;

    public ChromGeneRejectTable(JFrame jFrame, HashSet hashSet, String string) {
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bg);
        this.setForeground(fg);
        this.theFrame = jFrame;
        int n = 1;
        this.columnNames = new String[n];
        this.columnNames[0] = string;
        boolean bl = false;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        int n2 = hashSet.size();
        this.tabledata = new String[n2][this.columnNames.length];
        boolean bl2 = false;
        Iterator iterator = hashSet.iterator();
        for (int i = 0; i < n2; ++i) {
            this.tabledata[i][0] = (String)iterator.next();
        }
        this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
        JTable jTable = new JTable(this.sorter);
        this.sorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(300, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 400)));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add(jScrollPane);
        this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setMinimumSize(new Dimension(800, 20));
        this.saveButton.addActionListener(this);
        this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMinimumSize(new Dimension(800, 20));
        this.copyButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.copyButton);
        jPanel.setBackground(Color.white);
        jPanel.add(this.saveButton);
        this.copynamesButton = new JButton("Copy Gene Names", Util.createImageIcon("Copy16.gif"));
        this.copynamesButton.setActionCommand("copynames");
        this.copynamesButton.setMinimumSize(new Dimension(800, 20));
        this.copynamesButton.addActionListener(this);
        this.savenamesButton = new JButton("Save Gene Names", Util.createImageIcon("Save16.gif"));
        this.savenamesButton.setActionCommand("savenames");
        this.savenamesButton.setMinimumSize(new Dimension(800, 20));
        this.savenamesButton.addActionListener(this);
        jPanel.add(this.copynamesButton);
        jPanel.add(this.savenamesButton);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel.add(jButton);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            printWriter.print(this.columnNames[n] + "\t");
        }
        printWriter.println(this.columnNames[this.columnNames.length - 1]);
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                printWriter.print(this.sorter.getValueAt(n, i) + "\t");
            }
            printWriter.println(this.sorter.getValueAt(n, this.columnNames.length - 1));
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            stringBuffer.append(this.columnNames[n] + "\t");
        }
        stringBuffer.append(this.columnNames[this.columnNames.length - 1] + "\n");
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                stringBuffer.append(this.sorter.getValueAt(n, i) + "\t");
            }
            stringBuffer.append(this.sorter.getValueAt(n, this.columnNames.length - 1) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void writenamesToClipboard() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.tabledata.length; ++i) {
            stringBuffer.append(this.sorter.getValueAt(i, 0) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void printGeneList(PrintWriter printWriter) {
        for (int i = 0; i < this.tabledata.length; ++i) {
            printWriter.println(this.sorter.getValueAt(i, 0));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("copynames")) {
            this.writenamesToClipboard();
        } else if (string.equals("save") || string.equals("savenames")) {
            try {
                int n = Util.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = Util.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    if (string.equals("save")) {
                        this.printFile(printWriter);
                    } else {
                        this.printGeneList(printWriter);
                    }
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                final FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException2.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("help")) {
            String string2 = "The table contains genes that were requested to currently plotted, but for which a chromosome location could not be found in the input. ";
            Util.renderDialog(this.theFrame, string2);
        }
    }
}

