/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.chromviewer;

import edu.cmu.cs.sb.chromviewer.ChromFrame;
import edu.cmu.cs.sb.chromviewer.Gene;
import edu.cmu.cs.sb.chromviewer.TableSorterRoman;
import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ChromGeneAcceptTable
extends JPanel
implements ActionListener {
    private boolean DEBUG = false;
    ChromFrame cf;
    String[] columnNames;
    String[][] tabledata;
    JButton saveButton;
    JButton copyButton;
    JButton savenamesButton;
    JButton copynamesButton;
    ArrayList alprofiles;
    TableSorter sorter;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    boolean bprofileonly;
    boolean bquery;
    String szTitle;
    JFrame theFrame;

    public ChromGeneAcceptTable(JFrame jFrame, HashMap hashMap, Gene[] geneArray, String string) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bg);
        this.setForeground(fg);
        this.theFrame = jFrame;
        int n = 5;
        this.columnNames = new String[n];
        this.columnNames[0] = string;
        this.columnNames[1] = "Chromosome";
        this.columnNames[2] = "Strand";
        this.columnNames[3] = "Begin";
        this.columnNames[4] = "End";
        boolean bl = false;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        int n2 = hashMap.size();
        Iterator iterator = hashMap.values().iterator();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            HashSet hashSet = (HashSet)iterator.next();
            n3 += hashSet.size();
        }
        this.tabledata = new String[n3][this.columnNames.length];
        Iterator iterator2 = hashMap.entrySet().iterator();
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            object3 = iterator2.next();
            object2 = (String)object3.getKey();
            serializable = (HashSet)object3.getValue();
            object = ((HashSet)serializable).iterator();
            while (object.hasNext()) {
                Gene gene = (Gene)object.next();
                this.tabledata[n4][0] = object2;
                this.tabledata[n4][1] = geneArray[gene.chromosome].namechrom;
                this.tabledata[n4][2] = "" + gene.strand;
                this.tabledata[n4][3] = "" + gene.start;
                this.tabledata[n4][4] = "" + gene.end;
                ++n4;
            }
        }
        this.sorter = new TableSorterRoman((TableModel)new TableModelST(this.tabledata, this.columnNames), 1);
        JTable jTable = new JTable(this.sorter);
        this.sorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(300, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 400)));
        object3 = jTable.getColumnModel().getColumn(0);
        ((TableColumn)object3).setPreferredWidth(100);
        object3 = jTable.getColumnModel().getColumn(1);
        ((TableColumn)object3).setPreferredWidth(75);
        object3 = jTable.getColumnModel().getColumn(2);
        ((TableColumn)object3).setPreferredWidth(40);
        object3 = jTable.getColumnModel().getColumn(3);
        ((TableColumn)object3).setPreferredWidth(100);
        object3 = jTable.getColumnModel().getColumn(3);
        ((TableColumn)object3).setPreferredWidth(100);
        object2 = new JScrollPane(jTable);
        this.add((Component)object2);
        this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setMinimumSize(new Dimension(800, 20));
        this.saveButton.addActionListener(this);
        this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMinimumSize(new Dimension(800, 20));
        this.copyButton.addActionListener(this);
        serializable = new JPanel();
        ((Container)serializable).add(this.copyButton);
        ((JComponent)serializable).setBackground(Color.white);
        ((Container)serializable).add(this.saveButton);
        this.copynamesButton = new JButton("Copy Gene Names", Util.createImageIcon("Copy16.gif"));
        this.copynamesButton.setActionCommand("copynames");
        this.copynamesButton.setMinimumSize(new Dimension(800, 20));
        this.copynamesButton.addActionListener(this);
        this.savenamesButton = new JButton("Save Gene Names", Util.createImageIcon("Save16.gif"));
        this.savenamesButton.setActionCommand("savenames");
        this.savenamesButton.setMinimumSize(new Dimension(800, 20));
        this.savenamesButton.addActionListener(this);
        ((Container)serializable).add(this.copynamesButton);
        ((Container)serializable).add(this.savenamesButton);
        object = new JButton(Util.createImageIcon("Help16.gif"));
        ((AbstractButton)object).addActionListener(this);
        ((AbstractButton)object).setActionCommand("help");
        ((Container)serializable).add((Component)object);
        ((JComponent)serializable).setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add((Component)serializable);
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            printWriter.print(this.columnNames[n] + "\t");
        }
        printWriter.println(this.columnNames[this.columnNames.length - 1]);
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                printWriter.print(this.sorter.getValueAt(n, i) + "\t");
            }
            printWriter.println(this.sorter.getValueAt(n, this.columnNames.length - 1));
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            stringBuffer.append(this.columnNames[n] + "\t");
        }
        stringBuffer.append(this.columnNames[this.columnNames.length - 1] + "\n");
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                stringBuffer.append(this.sorter.getValueAt(n, i) + "\t");
            }
            stringBuffer.append(this.sorter.getValueAt(n, this.columnNames.length - 1) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void writenamesToClipboard() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.tabledata.length; ++i) {
            stringBuffer.append(this.sorter.getValueAt(i, 2) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void printGeneList(PrintWriter printWriter) {
        for (int i = 0; i < this.tabledata.length; ++i) {
            printWriter.println(this.sorter.getValueAt(i, 2));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("copynames")) {
            this.writenamesToClipboard();
        } else if (string.equals("save") || string.equals("savenames")) {
            try {
                int n = Util.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = Util.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    if (string.equals("save")) {
                        this.printFile(printWriter);
                    } else {
                        this.printGeneList(printWriter);
                    }
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                final FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException2.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("help")) {
            String string2 = "The table contains genes currently displayed in the chromsome viewer and their locations including chromosome, strand, and beginning and end position. ";
            Util.renderDialog(this.theFrame, string2);
        }
    }
}

