/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.chromviewer;

import edu.cmu.cs.sb.chromviewer.ChromEnrichmentTable;
import edu.cmu.cs.sb.chromviewer.ChromGeneAcceptTable;
import edu.cmu.cs.sb.chromviewer.ChromGeneRejectTable;
import edu.cmu.cs.sb.chromviewer.ChromRectangle;
import edu.cmu.cs.sb.chromviewer.Gene;
import edu.cmu.cs.sb.chromviewer.GenomeFileParser;
import edu.cmu.cs.sb.core.Util;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.swing.PScrollPane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ChromFrame
extends JFrame
implements ScrollPaneConstants,
ActionListener {
    private static final int CHROM_RECT_GAP = 20;
    private static final int CHROM_RECT_WIDTH = 20;
    private static final int BOUND_GAPLEFT = 10;
    private static final int BOUND_GAPRIGHT = 20;
    private int frame_width = 800;
    private int frame_height = 600;
    private double scale = 0.0;
    private boolean inited = false;
    public GenomeFileParser genomeParser = null;
    private ChromRectangle[] chromRectangles;
    private PText[] chromNames;
    private PPath midLine;
    private PCanvas pc = null;
    private Color buttonColor = new Color(255, 246, 143);
    private Color geneColor = Color.RED;
    private JButton colorButton;
    private HashSet hsrejected;
    private HashMap hmaccepted;
    private HashMap hmcolor;
    private String szGeneHeader;
    private Gene[] chroms;
    private boolean bsortsize;
    private int[] sortMapping;
    private JButton buttonsort;

    public ChromFrame(String string, GenomeFileParser genomeFileParser, int n) {
        this.setVisible(false);
        this.setDefaultCloseOperation(1);
        this.genomeParser = genomeFileParser;
        if (!genomeFileParser.szchromval.equals("")) {
            this.setTitle(genomeFileParser.getSpecies() + " (" + n + ")");
            this.setSize(this.frame_width, this.frame_height);
            this.bsortsize = true;
            this.sortMapping = genomeFileParser.sortMappingSize;
            this.szGeneHeader = string;
            this.hsrejected = new HashSet();
            this.hmaccepted = new HashMap();
            this.hmcolor = new HashMap();
            this.genomeParser = genomeFileParser;
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            this.setContentPane(jPanel);
            this.pc = new PCanvas();
            PScrollPane pScrollPane = new PScrollPane(this.pc, 20, 31);
            pScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            jPanel.add(pScrollPane);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            jPanel2.setBackground(Color.white);
            this.colorButton = new JButton("Next Gene Color");
            this.colorButton.setBackground(this.buttonColor);
            this.colorButton.setForeground(this.geneColor);
            this.colorButton.setActionCommand("color");
            this.colorButton.addActionListener(this);
            jPanel2.add(this.colorButton);
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            JButton jButton = new JButton("Clear Genes");
            jButton.setBackground(this.buttonColor);
            jButton.setActionCommand("clear");
            jButton.addActionListener(this);
            jPanel2.add(jButton);
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            this.buttonsort = new JButton("Sort By ID");
            this.buttonsort.setBackground(this.buttonColor);
            this.buttonsort.setActionCommand("sort");
            this.buttonsort.addActionListener(this);
            jPanel2.add(this.buttonsort);
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            JButton jButton2 = new JButton("Chr. Enrichment");
            jButton2.setBackground(this.buttonColor);
            jButton2.setActionCommand("enrichment");
            jButton2.addActionListener(this);
            jPanel2.add(jButton2);
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            JButton jButton3 = new JButton("Gene Table");
            jButton3.setBackground(this.buttonColor);
            jButton3.setActionCommand("chromtable");
            jButton3.addActionListener(this);
            jPanel2.add(jButton3);
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            JButton jButton4 = new JButton("Unmatched Genes");
            jButton4.setBackground(this.buttonColor);
            jButton4.setActionCommand("missinggenes");
            jButton4.addActionListener(this);
            jPanel2.add(jButton4);
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            JButton jButton5 = new JButton(Util.createImageIcon("Help16.gif"));
            jButton5.addActionListener(this);
            jButton5.setActionCommand("help");
            jPanel2.add(jButton5);
            jPanel.add(jPanel2);
            this.drawChromosomes();
        }
    }

    private PCanvas getCanvas() {
        return this.pc;
    }

    public void initialize() {
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (!this.inited) {
            return;
        }
        if (componentEvent.getID() == 101) {
            this.redraw();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        String string = actionEvent.getActionCommand();
        if (string.equals("help")) {
            String string2 = "Each rectangular box in the above window corresponds to a chromosome, and the small lines in these boxes correspond to genes. The top half of the box corresponds to its positive strand and the bottom half its negative strand.When a 'Chromosome View' button on a gene table is pressed all genes on the table are plotted based on their location on the chromosome. The window accumulates genes until the 'Clear Genes' button is pressed. Mousing over a gene 'gives its ID. Clicking on a gene opens the Ensembl genome browser to that gene\n\nAlong the bottom of the window there are several buttons that function as follows The 'Next Gene Color' gives the option to change the color of the next genes displayed. Note that this does not change the color of the currently displayed genes.\n'Clear Genes' clears the current genes displayed in the chromosome viewer.\n'Sort by ID'/'Sort by Size'. If 'Sort by ID' button is visible then the chromosomes are currently sorted in decreasing order of size and pressing the button sorts them by increasing ID. If 'Sort by Size' button is visible then the chromosomes are currently sorted in increasing ID and pressing the button sorts them by decreasing size.\nThe 'Chr. Enrichment' button displays a table of chromosome enrichments for genes currently displayed.\n'Gene Table' button displays a table of the genes currently displayed in the chromosome viewer and their location.\n'Unmatched Genes' displays genes that were attempted to be displayed, but could not be matched to any chromosome location based on the chromosome location data.";
            Util.renderDialog(this, string2);
        } else if (string.equals("chromtable")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = "Table of Gene Locations";
                    JFrame jFrame = new JFrame(string);
                    jFrame.setDefaultCloseOperation(2);
                    jFrame.setLocation(25, 100);
                    ChromGeneAcceptTable chromGeneAcceptTable = new ChromGeneAcceptTable(jFrame, ChromFrame.this.hmaccepted, ChromFrame.this.chroms, ChromFrame.this.szGeneHeader);
                    chromGeneAcceptTable.setOpaque(true);
                    jFrame.setContentPane(chromGeneAcceptTable);
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            });
        } else if (string.equals("missinggenes")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = "Unmatched Genes";
                    JFrame jFrame = new JFrame(string);
                    jFrame.setDefaultCloseOperation(2);
                    jFrame.setLocation(25, 100);
                    ChromGeneRejectTable chromGeneRejectTable = new ChromGeneRejectTable(jFrame, ChromFrame.this.hsrejected, ChromFrame.this.szGeneHeader);
                    chromGeneRejectTable.setOpaque(true);
                    jFrame.setContentPane(chromGeneRejectTable);
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            });
        } else if (string.equals("sort")) {
            if (this.bsortsize) {
                this.buttonsort.setText("Sort by Size");
                this.bsortsize = false;
                this.sortMapping = this.genomeParser.sortMappingID;
            } else {
                this.buttonsort.setText("Sort by ID");
                this.bsortsize = true;
                this.sortMapping = this.genomeParser.sortMappingSize;
            }
            this.redraw();
        } else if (string.equals("enrichment")) {
            final ChromFrame chromFrame = this;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = "Chromosome Enrichment";
                    JFrame jFrame = new JFrame(string);
                    jFrame.setDefaultCloseOperation(2);
                    jFrame.setLocation(25, 100);
                    ChromEnrichmentTable chromEnrichmentTable = new ChromEnrichmentTable(jFrame, chromFrame.genomeParser, ChromFrame.this.hmaccepted.size());
                    chromEnrichmentTable.setOpaque(true);
                    jFrame.setContentPane(chromEnrichmentTable);
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            });
        } else if (string.equals("clear")) {
            this.clearGenes();
        } else if (string.equals("color") && (color = JColorChooser.showDialog(this, "Choose Color", this.geneColor)) != null) {
            this.geneColor = color;
            this.colorButton.setForeground(color);
        }
    }

    private void resetScale(double d) {
        if (d != 0.0) {
            this.scale *= d;
            return;
        }
        if (this.inited) {
            this.frame_width = this.getCanvas().getWidth();
        }
        this.scale = ((float)this.frame_width - 30.0f) / (float)this.genomeParser.getChromLenMax();
    }

    private void resizeChroms() {
        this.resetScale(0.0);
        for (int i = 0; i < this.chromRectangles.length; ++i) {
            this.chromRectangles[i].setWidthScale(this.scale);
            this.positionChromRectangle(this.chromRectangles[i]);
            this.chromNames[i].setOffset(this.chromRectangles[i].getXOffset(), this.chromRectangles[i].getYOffset() - this.chromNames[i].getHeight());
        }
        this.repaint();
    }

    private void positionChromRectangle(ChromRectangle chromRectangle) {
        int n = this.sortMapping[chromRectangle.mGeneInfo.chromosome];
        float f = 0.0f;
        float f2 = 0.0f;
        f = 10.0f;
        f2 = 20 + 40 * n;
        chromRectangle.setOffset(f, f2);
    }

    private void drawChromosomes() {
        this.chroms = this.genomeParser.getChroms();
        this.chromRectangles = new ChromRectangle[this.chroms.length];
        this.chromNames = new PText[this.chroms.length];
        float f = 0.0f;
        float f2 = 0.0f;
        PLayer pLayer = this.getCanvas().getLayer();
        this.resetScale(0.0);
        for (int i = 0; i < this.chroms.length; ++i) {
            this.chromRectangles[this.sortMapping[i]] = new ChromRectangle(this.chroms[i], 20.0f, this.scale, true, this.genomeParser);
            pLayer.addChild(this.chromRectangles[this.sortMapping[i]]);
            this.chromNames[this.sortMapping[i]] = new PText(this.chroms[i].namechrom);
            pLayer.addChild(this.chromNames[this.sortMapping[i]]);
        }
        this.resizeChroms();
        this.inited = true;
        this.resizeChroms();
    }

    public void drawGenes(String[] stringArray) {
        this.setVisible(true);
        this.drawChromosomes();
        this.drawGenes(stringArray, this.geneColor);
    }

    public void redraw() {
        PCanvas pCanvas = this.getCanvas();
        PLayer pLayer = pCanvas.getLayer();
        pLayer.removeAllChildren();
        this.drawChromosomes();
        for (String string : this.hmaccepted.keySet()) {
            HashSet hashSet = (HashSet)this.hmaccepted.get(string);
            Color color = (Color)this.hmcolor.get(string);
            for (Gene gene : hashSet) {
                this.chromRectangles[this.sortMapping[gene.chromosome]].addGene(gene, string, color);
            }
        }
    }

    public void drawGenes(String[] stringArray, Color color) {
        HashSet[] hashSetArray = this.genomeParser.addActiveGenes(stringArray);
        for (int i = 0; i < hashSetArray.length; ++i) {
            if (hashSetArray[i] == null) {
                this.hsrejected.add(stringArray[i]);
                continue;
            }
            if (this.hmaccepted.get(stringArray[i]) != null) continue;
            this.hmaccepted.put(stringArray[i], hashSetArray[i]);
            this.hmcolor.put(stringArray[i], color);
            for (Gene gene : hashSetArray[i]) {
                this.chromRectangles[this.sortMapping[gene.chromosome]].addGene(gene, stringArray[i], color);
            }
        }
        this.repaint();
    }

    public void clearGenes() {
        this.hsrejected = new HashSet();
        this.hmaccepted = new HashMap();
        this.hmcolor = new HashMap();
        for (int i = 0; i < this.chromRectangles.length; ++i) {
            this.chromRectangles[i].clearGenes();
        }
        this.genomeParser.clearActiveGenes();
        this.redraw();
    }
}

