/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.chromviewer;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;

public class BiomartAccess {
    static final String SZBIOMARTURL = "http://www.biomart.org/biomart/martservice";
    static final int NMAXATTR = 3;
    private File m_file = null;
    private int nline;
    private int numrecs;
    private int nsingleset;

    public BiomartAccess(String string) {
        this.m_file = new File(string);
    }

    public int executeCountQuery(String string) throws IOException {
        int n;
        URL uRL = new URL(SZBIOMARTURL);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
        outputStreamWriter.write("query=" + URLEncoder.encode(string, "UTF-8"));
        outputStreamWriter.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        outputStreamWriter.close();
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Count query did not return a number, instead returned " + string2);
        }
        if (n < 1) {
            throw new IllegalArgumentException("Count query returned " + n + " records. The number of " + "records must be positive!");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(BufferedOutputStream bufferedOutputStream, String string, int[] nArray, int n, Object object) throws IOException {
        String string2;
        URL uRL = new URL(SZBIOMARTURL);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
        outputStreamWriter.write("query=" + URLEncoder.encode(string, "UTF-8"));
        outputStreamWriter.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        int n2 = 0;
        int n3 = this.nsingleset;
        String string3 = System.getProperty("line.separator");
        while ((string2 = bufferedReader.readLine()) != null) {
            String string4 = string2 + string3;
            if (string4.startsWith("Query ERROR")) {
                System.out.println("Gene Location Download Error: " + string4);
            }
            byte[] byArray = string4.getBytes();
            bufferedOutputStream.write(byArray, 0, byArray.length);
            if (n3 > 0) {
                --n3;
                ++this.nline;
            }
            Object object2 = object;
            synchronized (object2) {
                int n4 = (int)((double)(100 * this.nline) / (double)this.numrecs);
                if (n4 <= 99) {
                    nArray[n] = n4;
                    if (n2 != nArray[n]) {
                        n2 = nArray[n];
                        object.notifyAll();
                    }
                }
            }
        }
        bufferedReader.close();
        outputStreamWriter.close();
    }

    public HashSet getValidAttributes(String string) throws IOException {
        String string2;
        HashSet<String> hashSet = new HashSet<String>();
        String string3 = "?virtualSchema=default&type=attributes&dataset=" + string;
        URL uRL = new URL(SZBIOMARTURL + string3);
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        while ((string2 = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string4 = stringTokenizer.nextToken();
            hashSet.add(string4);
        }
        bufferedReader.close();
        return hashSet;
    }

    public void updateGeneFile(String string, String string2, int[] nArray, int n, Object object) throws IOException {
        String string3;
        Object object2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_file));
        String string4 = "";
        String[] stringArray = null;
        boolean bl = false;
        while (!bl && (string4 = bufferedReader.readLine()) != null) {
            stringArray = string4.split(",");
            object2 = stringArray[0].split("_");
            if (!object2[0].equalsIgnoreCase(string)) continue;
            bl = true;
        }
        bufferedReader.close();
        if (!bl) {
            throw new IllegalArgumentException("The species provided - " + string + " - is not found in " + this.m_file);
        }
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("Line " + string4 + " in " + this.m_file + " only has one entry, no delimiting ',' found");
        }
        object2 = "<?xml version = \"1.0\" encoding = \"UTF-8\"?>";
        object2 = (String)object2 + "<!DOCTYPE Query>";
        String string5 = "<Query virtualSchemaName = \"default\" uniqueRows = \"1\" count = \"1\" softwareVersion = \"0.6\" >";
        String string6 = "<Query virtualSchemaName = \"default\" uniqueRows = \"1\" count = \"\" softwareVersion = \"0.6\" >";
        String string7 = "<Dataset name = \"" + stringArray[0] + "\" interface = \"default\" >";
        string7 = string7 + "<Attribute name = \"chromosome_name\" />";
        string7 = string7 + "<Attribute name = \"start_position\" />";
        string7 = string7 + "<Attribute name = \"end_position\" />";
        string7 = string7 + "<Attribute name = \"strand\" />";
        string7 = string7 + "<Attribute name = \"ensembl_gene_id\" />";
        String string8 = "</Dataset>";
        string8 = string8 + "</Query>";
        String string9 = (String)object2 + string5 + string7 + string8;
        this.nsingleset = this.executeCountQuery(string9);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(string2)));
        String string10 = System.getProperty("line.separator");
        String string11 = stringArray[1] + string10;
        byte[] byArray = string11.getBytes();
        bufferedOutputStream.write(byArray, 0, byArray.length);
        String string12 = (String)object2 + string6 + string7;
        boolean bl2 = true;
        this.nline = 0;
        HashSet hashSet = this.getValidAttributes(stringArray[0]);
        if (stringArray.length > 2) {
            String[] stringArray2 = stringArray[2].split(":");
            this.numrecs = this.nsingleset * (int)Math.ceil((double)stringArray2.length / 3.0);
            string3 = string12;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!hashSet.contains(stringArray2[i])) continue;
                string3 = string3 + "<Attribute name = \"" + stringArray2[i] + "\" />";
                bl2 = true;
                if (i % 3 != 2) continue;
                string3 = string3 + string8;
                this.executeQuery(bufferedOutputStream, string3, nArray, n, object);
                string3 = string12;
                bl2 = false;
            }
        } else {
            string3 = string12;
        }
        if (bl2) {
            string3 = string3 + string8;
            this.executeQuery(bufferedOutputStream, string3, nArray, n, object);
        }
        bufferedOutputStream.close();
    }
}

