/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable,
Serializable {
    private transient E[] elements;
    private transient int head;
    private transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;

    private void allocateElements(int n) {
        int n2 = 8;
        if (n >= n2) {
            n2 = n;
            n2 |= n2 >>> 1;
            n2 |= n2 >>> 2;
            n2 |= n2 >>> 4;
            n2 |= n2 >>> 8;
            n2 |= n2 >>> 16;
            if (++n2 < 0) {
                n2 >>>= 1;
            }
        }
        this.elements = new Object[n2];
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int n = this.head;
        int n2 = this.elements.length;
        int n3 = n2 - n;
        int n4 = n2 << 1;
        if (n4 < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        Object[] objectArray = new Object[n4];
        System.arraycopy(this.elements, n, objectArray, 0, n3);
        System.arraycopy(this.elements, 0, objectArray, n3, n);
        this.elements = objectArray;
        this.head = 0;
        this.tail = n2;
    }

    private <T> T[] copyElements(T[] TArray) {
        if (this.head < this.tail) {
            System.arraycopy(this.elements, this.head, TArray, 0, this.size());
        } else if (this.head > this.tail) {
            int n = this.elements.length - this.head;
            System.arraycopy(this.elements, this.head, TArray, 0, n);
            System.arraycopy(this.elements, 0, TArray, n, this.tail);
        }
        return TArray;
    }

    public ArrayDeque() {
        this.elements = new Object[16];
    }

    public ArrayDeque(int n) {
        this.allocateElements(n);
    }

    public ArrayDeque(Collection<? extends E> collection) {
        this.allocateElements(collection.size());
        this.addAll(collection);
    }

    @Override
    public void addFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    @Override
    public void addLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    @Override
    public E pollFirst() {
        int n = this.head;
        E e = this.elements[n];
        if (e == null) {
            return null;
        }
        this.elements[n] = null;
        this.head = n + 1 & this.elements.length - 1;
        return e;
    }

    @Override
    public E pollLast() {
        int n = this.tail - 1 & this.elements.length - 1;
        E e = this.elements[n];
        if (e == null) {
            return null;
        }
        this.elements[n] = null;
        this.tail = n;
        return e;
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        E e = this.pollFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E removeLast() {
        E e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E peekFirst() {
        return this.elements[this.head];
    }

    @Override
    public E peekLast() {
        return this.elements[this.tail - 1 & this.elements.length - 1];
    }

    @Override
    public E getFirst() {
        E e = this.elements[this.head];
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E getLast() {
        E e = this.elements[this.tail - 1 & this.elements.length - 1];
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        E e;
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.head;
        while ((e = this.elements[n2]) != null) {
            if (object.equals(e)) {
                this.delete(n2);
                return true;
            }
            n2 = n2 + 1 & n;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        E e;
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.tail - 1 & n;
        while ((e = this.elements[n2]) != null) {
            if (object.equals(e)) {
                this.delete(n2);
                return true;
            }
            n2 = n2 - 1 & n;
        }
        return false;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    private boolean delete(int n) {
        if (this.head < this.tail || this.tail == 0 || n >= this.head) {
            System.arraycopy(this.elements, this.head, this.elements, this.head + 1, n - this.head);
            this.elements[this.head] = null;
            this.head = this.head + 1 & this.elements.length - 1;
            return false;
        }
        --this.tail;
        System.arraycopy(this.elements, n + 1, this.elements, n, this.tail - n);
        this.elements[this.tail] = null;
        return true;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new DeqIterator();
    }

    @Override
    public boolean contains(Object object) {
        E e;
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.head;
        while ((e = this.elements[n2]) != null) {
            if (object.equals(e)) {
                return true;
            }
            n2 = n2 + 1 & n;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    @Override
    public void clear() {
        int n = this.head;
        int n2 = this.tail;
        if (n != n2) {
            this.tail = 0;
            this.head = 0;
            int n3 = n;
            int n4 = this.elements.length - 1;
            do {
                this.elements[n3] = null;
            } while ((n3 = n3 + 1 & n4) != n2);
        }
    }

    @Override
    public Object[] toArray() {
        return this.copyElements(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        this.copyElements(objectArray);
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public ArrayDeque<E> clone() {
        try {
            ArrayDeque arrayDeque = (ArrayDeque)super.clone();
            arrayDeque.elements = new Object[this.elements.length];
            System.arraycopy(this.elements, 0, arrayDeque.elements, 0, this.elements.length);
            return arrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.size();
        objectOutputStream.writeInt(n);
        int n2 = this.head;
        int n3 = this.elements.length - 1;
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeObject(this.elements[n2]);
            n2 = n2 + 1 & n3;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.allocateElements(n);
        this.head = 0;
        this.tail = n;
        for (int i = 0; i < n; ++i) {
            this.elements[i] = objectInputStream.readObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeqIterator
    implements Iterator<E> {
        private int cursor;
        private int fence;
        private int lastRet;

        private DeqIterator() {
            this.cursor = ArrayDeque.this.head;
            this.fence = ArrayDeque.this.tail;
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        @Override
        public E next() {
            Object object;
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            if (ArrayDeque.this.tail != this.fence || (object = ArrayDeque.this.elements[this.cursor]) == null) {
                throw new ConcurrentModificationException();
            }
            this.lastRet = this.cursor;
            this.cursor = this.cursor + 1 & ArrayDeque.this.elements.length - 1;
            return object;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (ArrayDeque.this.delete(this.lastRet)) {
                --this.cursor;
            }
            this.lastRet = -1;
            this.fence = ArrayDeque.this.tail;
        }
    }
}

