import Energy;
from Protein import Protein;
from Topology import Topology;
from Residue import Residue;
from RotamerLib import RotamerLib;
import random
import math


def computeRotamerPairs(p,repackList):
    """ This function computes the pairwise energy for each pair of rotamers.  It return a data structure that
        can be accessed using the syntax data[resNum1][rotamerNum1][resNum2][rotamerNum2].  IMPORTANT: only half
	the entries are computed in this table r1 > r2!!
    """
    residues = p.getResidues()

    r1Energies = {}
    for r1 in repackList:
	r1Energies[r1] = []
	for rot1 in range(residues[r1].numRotamers()):
	    sc1 = residues[r1].getSidechainAtoms(rot1,True)
	    r2Energies = {}
	    for r2 in repackList:
		if r1 > r2: #only compute once -> symmetric table
		    sc2list = [ residues[r2].getSidechainAtoms(rot2,True) for rot2 in range(residues[r2].numRotamers()) ]
		    energies = [ Energy.chainEnergy(sc1,sc2,Energy.lennardJones,lj) for sc2 in sc2list ]
		    r2Energies[r2] = energies
		    r1Energies[r1] += [r2Energies]
    return r1Energies


def computeRotamerSelfEnergy(resNum,rotamer,residues,repackList):
    """ This function computes the energy of a rotamer with the protein backbone (not its own), and
        sidechain residues that are not being repacked.
    """
    sc1 = residues[resNum].getSidechainAtoms(rotamer,True)
    group2 = []
    for res in range(len(residues)):
	if res != resNum:
	    group2 += residues[res].getBackboneAtoms(True)
	    if res not in repackList:
		group2 += residues[res].getSidechainAtoms(0,True)

    return Energy.chainEnergy(sc1,group2,Energy.lennardJones,lj)


def computeRotamerSelfEnergies(p,repackList):
    """ This function returns a dictionary with the 'self' energy for each rotamer.  The data structure can
        be accessed with data[resNum][rotamerNum].
    """
    residues = p.getResidues()
    selfE = {}
    for resNum in repackList:
	selfE[resNum] = [ computeRotamerSelfEnergy(resNum,rot,residues,repackList) for rot in range(residues[resNum].numRotamers()) ]
    return selfE


def initRepack(p,repackList):
    """ This function takes care of some basic housekeeping before we can 'repack' our protein.
    """
    for res in p.getResidues():
	res.selectRotamer(0)
    pairE = computeRotamerPairs(p,repackList)
    selfE = computeRotamerSelfEnergies(p,repackList)

    return pairE,selfE


def computeRotamerEnergy(resNum,rotamer,residues,repackList,pairEnergies,selfEnergies):
    """ This function returns the total energy associated with a certain rotamer.  This includes
        interactions with the backbone, and sidechains of other rotamers.  It uses a table of
	rotamer 'self' energies as well as pairwise interactions with other rotamers.
    """
    #Insert your code here
    #REMEMBER, pairEnergies includes only data where r1>r2 ( unless you've updated this yourself :)
    #Hint: use residues[index].selectedRotamer() to keep track of which rotamers are currently active.

    return E #return a scalar


def repack(p,repackList,pairE,selfE,RT):
    """ This function takes a protein and some lookup tables, and finds an optimal set of rotamers.
        It uses the 'Metropolis' criterion to accept or reject possible rotamers, where RT determines
	the stringency of the acceptance criterion.
    """
    p.toPDB("before.pdb") #lets take a look before

    #may want to use random.randrange(0,residues[resNum].numRotamers()) to pick a random rotamer
    #random.Random() returns a continuous random number from 0-1
    #math.exp((oldE-newE)/RT) computes the exponent of the scaled energy difference

    residues = p.getResidues()
    rotamerEnergies = {}
    for resNum in repackList:
	rotamerEnergies[resNum] = computeRotamerEnergy(resNum,residues[resNum].selectedRotamer(),residues,repackList,pairE,selfE)
    for iter in range(10000):

    # Insert your code here
    #
    #
		
    p.toPDB("after.pdb") #lets take a look after

top = Topology('top_all27_prot_na.inp');
rotolib = RotamerLib('bbind02.May.lib');
lj = Energy.loadLJParameters('lj_params.inp');

p = Protein( top, rotolib );
p.loadFromPDB( top, '1shfA.pdb')
p.buildMissingAtoms() #mostly hydrogens
p.buildRotamers(repackList) #use buildAnonymousRotamers to allow AA changes (SLOW!)

repackList = range(10,25) #repack a subset of residues to save time
pairE,selfE = initRepack(q,repackList)
repack(p,repackList,pairE,selfE)
