"""Test the luminance grating of a screen.

Instructions: The luminance of the first screen should equal the
average of the luminances of the darker and lighter bars in the 
second and third screens. Press 'q' or 'escape' to quit, 'space' to 
progress to the next screen"""

from psychopy import *

win = visual.Window(monitor='',fullscr=1,units ='pix',screen=) #Open Tools->Monitor Center to create a new / modify a pre-existing profile for
                                                                                                  #the monitor in question. Also enter the appropriate value for the 'screen' 
                                                                                                  #parameter (0=primary monitor, 1=secondary monitor etc.)

grating = visual.PatchStim(win,tex="sin",texRes=2, mask='none',
           units='pix', size=[1024,768], contrast=0.0, sf=[0.002,0])

stopExp = 0
currentScr = 0

while not stopExp:
    if currentScr == 0:
        grating.setContrast(0.0)
    elif currentScr == 1:
        grating.setContrast(0.5)
    elif currentScr == 2:
        grating.setContrast(1.0)
    else:
        currentScr = 0
    grating.draw()
    win.flip()
    for key in event.getKeys():
        if key in ['escape','q']:
            stopExp = 1
            break
        if key in ['space']:
            currentScr += 1