clear all
close all

halfwidth=2*30;

N=48;
mag=75;
for s=41:N
    path='e:\worm\5-25-2009_timelapse\';
%     filename='trackedWorm.stk';
%     im=tiffread2c([path filename], s);
    filename=sprintf('trans%03d.stk',s);
    im=tiffread2c([path filename]);

    %% load axis

    infile=sprintf('trans_ax_%d.mat', s)
    load([path infile], 'ax');

    %%
    xy=ax';
    x=xy(:,1);
    y=xy(:,2);
    yy=[x';y'];
    xx=1:length(x);
    plot(xy(:,1),xy(:,2),'o')
    xxx=1:0.0001:length(x);
    pp=spline(xx,yy,xxx);
    dx=diff(pp(1,:));
    dy=diff(pp(2,:));

    dr=sqrt(dx.^2+dy.^2);
    wormlength=cumsum(dr);
    totalwormlength=round(sum(dr));

    X=[]; Y=[];
    for i=1:totalwormlength
        minvec=abs(i-wormlength);
        [mindis j]=min(minvec);
        X(i)=pp(1,j);
        Y(i)=pp(2,j);
    end;
    subplot(2,1,1);
    imshow(mat2gray(im.data),[],'In', mag); hold on;
    plot(X,Y,'.')

    %%
    Nmax=1024;
    dr_long=[diff(X); diff(Y)];
    dr_trans=[];
    for j=1:size(dr_long,2)
        veclong=[dr_long(:,j);0];
        vecZ=[0; 0; 1];
        vectrans=cross(vecZ,veclong);
        dr_trans=[dr_trans vectrans(1:2,:)]; 

     end;

    repix1=[]; repix2=[]; repix=[];
    I=mat2gray(im.data);
    for k=1:size(dr_long,2)
        for l=1:halfwidth
            Xoff1(k,l)=l*dr_trans(1,k)+X(k);
            Yoff1(k,l)=l*dr_trans(2,k)+Y(k);
            Xoff2(k,l)=-l*dr_trans(1,k)+X(k);
            Yoff2(k,l)=-l*dr_trans(2,k)+Y(k);
            if (round(Xoff1(k,l))<Nmax && round(Yoff1(k,l))<Nmax && round(Xoff1(k,l))>0 && round(Yoff1(k,l))>0)
                repix1(l,k)=double(I(round(Yoff1(k,l)),round(Xoff1(k,l))));
            else
                repix1(l,k)=0;
            end
            if (round(Xoff2(k,l))<Nmax && round(Yoff2(k,l))<Nmax && round(Xoff2(k,l))>0 && round(Yoff2(k,l))>0)
                repix2(halfwidth-l+1,k)=double(I(round(Yoff2(k,l)),round(Xoff2(k,l))));
            else
                repix2(l,k)=0;
            end

        end
    end
    repix=[repix2; repix1];

    subplot(2,1,2);
    imshow(repix)
    axis equal;
    axis([0 totalwormlength 1 2*halfwidth]);
    axis equal;
    axis off;
    getframe
    
    %% save image and length

    outfile=sprintf('trans_straight_%d.mat', s)
    save([path outfile], 'repix', 'totalwormlength');
    
end