clear all; close all;

path='E:\worm\5-25-2009_timelapse\';
N=48;

Ltrans=[];
for s=1:N
    infile=sprintf('trans_straight_%d.mat', s);
    load([path infile], 'totalwormlength');
    Ltrans=[Ltrans totalwormlength];
end

LGFP=[];
for s=1:N
    infile=sprintf('GFP_straight_%d.mat', s);
    load([path infile], 'totalwormlength');
    LGFP=[LGFP totalwormlength];
end

%% find gonad/DTC position

% first for trans
for s=1:N
    infile=sprintf('trans_straight_%d.mat', s);
    load([path infile], 'repix');
    imshow(mat2gray(repix))
    [x,y]=ginput(2);
    xoff_trans(s)=sum(x)/2;
end
outfile=sprintf('trans_offset.mat');
save([path outfile], 'xoff_trans');

% infile=sprintf('trans_offset.mat');
% load([path infile], 'xoff_trans');
% infile=sprintf('GFP_offset.mat');
% load([path infile], 'xoff_GFP');
%%

for s=1:N
    infile=sprintf('GFP_straight_%d.mat', s);
    load([path infile], 'repix');
    th1=stretchlim(repix,1e-2);
    th2=stretchlim(repix,5e-3);
    th=[th1(1) th2(2)];
    imshow(imadjust(repix, th), 'In', 200);
    [x,y]=ginput(2);
    xoff_GFP(s)=sum(x)/2;
    DTC(s).x=x;
    DTC(s).y=y;
end
outfile=sprintf('DTC_GFP.mat');
save([path outfile], 'DTC', 'xoff_GFP');

% infile=sprintf('DTC_GFP.mat');
% load([path infile], 'DTC');

%% plot trans and GFP
LY=2*30;
% LX=max([Ltrans LGFP]);
LX=2*max([xoff_trans xoff_GFP]);

% imtot=zeros(2*LY,LX,3,N);
imtot=zeros(2*LY,LX,3);
for s=1:N
    
    im1=zeros(2*LY,LX);
    im2=zeros(2*LY,LX);

    % load trans data
    infile=sprintf('trans_straight_%d.mat', s);
    load([path infile], 'repix');
    S=round([1/4 3/4]*size(repix,2));
    th=stretchlim(repix(:,S(1):S(2)),0.005);
    y=1:(2*LY);
%     xoff=round((LX-Ltrans(s))/2);
    xoff=round(LX/2-xoff_trans(s));
    im1(:,xoff+(1:(Ltrans(s)-1)))=imadjust(repix, th);
%     imtot(y,:,:,s)=makeRGB(im1,im1,im1);
    imtot(y,:,:)=makeRGB(im1,im1,im1);
    
    % load GFP data
    infile=sprintf('GFP_straight_%d.mat', s);
    load([path infile], 'repix');
    S=round([1/4 3/4]*size(repix,2));
    th=stretchlim(repix(:,S(1):S(2)),0.005);
    y=(2*LY+1):(4*LY);
%     xoff=round((LX-LGFP(s))/2);
    xoff=round(LX/2-xoff_GFP(s));
    im2(:,xoff+(1:(LGFP(s)-1)))=imadjust(repix, th);
%     imtot(y,:,:,s)=makeRGB(im2,im2,im2);
    imtot(y,:,:)=makeRGB(im2,im2,im2);
    
    % make merge
    y=(4*LY+1):(6*LY);
%     imtot(y,:,:,s)=makeRGB(im1,im1+im2,im1);
    imtot(y,:,:)=makeRGB(im1,im1+im2,im1);
    
    imshow(imtot);
    imwrite(imtot, sprintf('c:\\tmp\\im%03d.png', s));
    getframe
end

%% plot GFP only

LY=2*30;

infile=sprintf('DTC_GFP.mat');
load([path infile], 'DTC');

for s=1:length(DTC)
    xoff_GFP(s)=(DTC(s).x(1)+DTC(s).x(2))/2;
    Ymean(s)=mean(DTC(s).y);
    if Ymean(s)>LY
        flipim(s)=0;
    else
        flipim(s)=1;
    end
end

LX=2*max(round(xoff_GFP));

for s=1:N
    
    im1=zeros(2*LY,LX);

    % load GFP data
    infile=sprintf('GFP_straight_%d.mat', s);
    load([path infile], 'repix');
    if flipim(s)
        repix=flipdim(repix,1);
    end
    S=round([1/4 3/4]*size(repix,2));
    th1=stretchlim(repix(:,S(1):S(2)),1e-2);
    th2=stretchlim(repix(:,S(1):S(2)),5e-3);
    th=[th1(1) th2(2)];
    y=(2*LY+1):(4*LY);
    xoff=round(LX/2-xoff_GFP(s));
    im1(:,xoff+(1:(LGFP(s)-1)))=imadjust(repix, th);
    
    imshow(im1);
   imwrite(im1, sprintf('c:\\tmp\\im%03d.png', s));
    getframe
end

%% make figure rather than frames for a movie

%% plot trans and GFP
LY=2*30;
LX=2*max([xoff_trans xoff_GFP]);

N=[1 6 11 16 21 26 31 36 41 46];
% N=1:48;
imtot=zeros(2*LY*length(N),LX,3);

for s=1:length(N)
    
    im1=zeros(2*LY,LX);
    im2=zeros(2*LY,LX);

%     % load trans data
    infile=sprintf('trans_straight_%d.mat', N(s));
    load([path infile], 'repix');
    S=round([1/4 3/4]*size(repix,2));
    th=stretchlim(repix(:,S(1):S(2)),0.005);
    y=((s-1)*2*LY)+(1:(2*LY));
    xoff=round(LX/2-xoff_trans(N(s)));
    im1(:,xoff+(1:(Ltrans(N(s))-1)))=imadjust(repix, th);
%     imtot(y,:,:)=makeRGB(im1,im1,im1);
    
%     % load GFP data
    infile=sprintf('GFP_straight_%d.mat', N(s));
    load([path infile], 'repix');
    S=round([1/4 3/4]*size(repix,2));
    th=stretchlim(repix(:,S(1):S(2)),0.005);
    y=((s-1)*2*LY)+(1:(2*LY));
    xoff=round(LX/2-xoff_GFP(N(s)));
    im2(:,xoff+(1:(LGFP(N(s))-1)))=imadjust(repix, th);
%     imtot(y,:,:)=makeRGB(im2,im2,im2);
    
    % make merge
    y=((s-1)*2*LY)+(1:(2*LY));
    imtot(y,:,:)=makeRGB(im1,im1+im2,im1);
end
