for s=26:32
    % load trans
    path='E:\worm\4-30-2009_timelapse\';
    filename='trackedWorm.stk';
    im1=tiffread2c([path filename], s);
    
    infile=sprintf('trans_ax_%d.mat', s)
    load([path infile], 'ax');
    axTrans=ax;
    
    % load GFP
    infile=sprintf('GFP_ax_%d.mat', s)
    load([path infile], 'ax', 'z');
    axGFP=ax;

    filename=[path sprintf('GFPstack%03d.tif',s)];
    im2=tiffread2c(filename,z);
    
    A=mat2gray(im1.data);
    A=makeRGB(A,A,A);
    clear im1
    
    th=stretchlim(im2.data, 1e-3);
    B=imadjust(im2.data, [th(1) 1e-2]);
    B=makeRGB([],B,[]);
    clear im2
    
    axes('position',[0 0 1 1]);
    imshow([A B], 'In', 33); hold on;
    plot(axTrans(1,:), axTrans(2,:), '-y',1024+axGFP(1,:), axGFP(2,:), '-y');
    
    text(1800,50, sprintf('%d mins', 10*(s-1)), 'color', 0.99*[1 1 1], 'Fontsize', 14);
    
    set(gcf,'PaperPositionMode','auto');
    print('-dpng','-r100',sprintf('c:\\tmp\\worm%03d.png',s));

    clear A B
    clf
end

%%

