clear all
close all

N=48;
path = 'E:\worm\5-25-2009_timelapse\';

z=1; Nz=10;
for s=1:N
    
    filename=[path sprintf('GFPstack%03d.tif',s)];
    im=tiffread2c(filename);

    %% get axis from max projection, from front to back

    outfile=sprintf('GFP_ax_%d.mat', s)

    if ~isempty(ls([path outfile]))
        load([path outfile], 'ax', 'z');
    else
        ax=[];
    end
    mag=85;

    cont=1;
    while cont==1

        th1=stretchlim(im(z).data,1e-2);
%         th1=stretchlim(im(z).data,1e-3);
        th2=stretchlim(im(z).data,1e-3);
        th=[th1(1) th2(2)];
        imshow(imadjust(im(z).data, th,[]), 'In', mag); hold on;
%         imshow(mat2gray(im(z).data),[],'In', mag); hold on;
        if ~isempty(ax)
            plot(ax(1,:), ax(2,:), '-sb');
        end

        [x,y,but]=ginput(1);

        if but == 1
            n=size(ax,2);
            ax(1,n+1)=x;
            ax(2,n+1)=y;
        end

        if but == 3
            n=size(ax,2);
            ax(:,n)=[];
        end

        if but == 27
            cont=0;
        end

        if but==113
            z=z-1;
            if z<1
                z=1;
            end
%             hold off;
%             th=stretchlim(data(chn).im(:,:,z), ths(chn));
%             imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
        end
        if but==119
            z=z+1;
            if z>Nz
                z=Nz;
            end
%             hold off;
%             th=stretchlim(data(chn).im(:,:,z), ths(chn));
%             imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
        end

        hold off;

    end
    
    % save axis
%     outfile=sprintf('trans_ax_%d.mat', s)
    
    save([path outfile], 'ax', 'z');
end
