clear all
close all

N=48;
path = 'E:\worm\5-25-2009_timelapse\';

for s=1:N
    
    filename=[path sprintf('trans%03d.stk',s)];
    im=tiffread2c(filename);

    %% get axis from max projection, from front to back

    outfile=sprintf('trans_ax_%d.mat', s)

    if ~isempty(ls([path outfile]))
        load([path outfile], 'ax');
    else
        ax=[];
    end
    mag=85;

    cont=1;
    while cont==1

        imshow(mat2gray(im.data),[],'In', mag); hold on;
        if ~isempty(ax)
            plot(ax(1,:), ax(2,:), '-sb');
        end

        [x,y,but]=ginput(1);

        if but == 1
            n=size(ax,2);
            ax(1,n+1)=x;
            ax(2,n+1)=y;
        end

        if but == 3
            n=size(ax,2);
            ax(:,n)=[];
        end

        if but == 27
            cont=0;
        end

        hold off;

    end
    
    % save axis
%     outfile=sprintf('trans_ax_%d.mat', s)
    
    save([path outfile], 'ax');
end
