#== Python script for generating logistic model python files, for the multi-gene trait-o-matic extension ==
#== Biophysics 101, JT // 12-17-09 ==


#== What to call the file? ==
filename = raw_input('Filename: ')
f = open(filename + '.py', 'w')

#== Feed in the rsid's, relevant nucleotide, expression mode and OR ==
RSIDs = []
Nucl = []
Mode = []
ORs = []
CIs = []
num_of_rsids = raw_input('How many SNPs to test? ')

for i in range(int(num_of_rsids)):
    rsid = raw_input('RSID #' + str(i+1) + ': ')
    nucleotide = raw_input('Relevant Nucleotide: ')
    mmode = raw_input('Mode (dominant(D)/recessive(R)/multiplicative(M)): ')
    OR = raw_input('Odds Ratio (OR): ')
    CI = raw_input('Confidence Interval: ')
    
    RSIDs.append(rsid)
    Nucl.append(nucleotide)
    Mode.append(mmode)
    ORs.append(OR)
    CIs.append(CI)

    f.write('# rsid:' + rsid + '\n')    
    
#== Details ==
Disease = raw_input('Official Disease Name: ')
Source = raw_input('Source paper and study: ')
PMID = raw_input('PMID of source paper: ')
Output = raw_input('Model output (e.g. relative risk of heart attack by age 53): ')
Caveats = raw_input('Caveat statement: ')

f.write('# Disease: ' + Disease + '\n')
f.write('# Source: ' + Source + '\n')
f.write('# PMID: ' + PMID + '\n')
f.write('# Author: Written with JTs Logistic Model Generator Program\n')
f.write('# Model: Logistic' + '\n')
f.write('# Output: ' + Output + '\n')
f.write('# Caveats: ' + Caveats + '\n')
f.write('# Output: ' + Output + '\n')

#== Code ==
f.write('\n')
f.write('# Import libraries' + '\n')
f.write('import sys' + '\n')
f.write('import math' + '\n')
f.write('\n')
f.write('# Check for all inputs' + '\n')

#== Check for 'x's' ==
f.write('if ')
f.write('sys.argv[1].count("x") ')
for i in range(int(num_of_rsids)-1):
    f.write('+ sys.argv[' + str(i+2) + '].count("x") ')
f.write('> 0: \n')
f.write('    print "ERROR" \n')
f.write('\n')

#== Initialize ==
f.write('# Calculate relative risk\n')
f.write('OR = [1')
for i in range(int(num_of_rsids)-1):
    f.write(',1')
f.write(']\n')
f.write('CI = [0')
for i in range(int(num_of_rsids)-1):
    f.write(',0')
f.write(']\n')
f.write('\n')

#== Add each contingency ==
for i in range(int(num_of_rsids)):
    if Mode[i] == 'R':
        f.write('if sys.argv[' + str(i+1) + '].count("' + Nucl[i] + '") > 1:\n')
        f.write('    OR[' + str(i) + '] = ' + ORs[i] + '\n')
        f.write('    CI[' + str(i) + '] = ' + CIs[i] + '\n')
    if Mode[i] == 'D':
        f.write('if sys.argv[' + str(i+1) + '].count("' + Nucl[i] + '") >= 1:\n')
        f.write('    OR[' + str(i) + '] = ' + ORs[i] + '\n')
        f.write('    CI[' + str(i) + '] = ' + CIs[i] + '\n')
    if Mode[i] == 'M':
        f.write('if sys.argv[' + str(i+1) + '].count("' + Nucl[i] + '") > 1:\n')
        f.write('    OR[' + str(i) + '] = ' + str(float(ORs[i])*float(ORs[i])) + '\n')
        f.write('    CI[' + str(i) + '] = ' + str(float(CIs[i])*pow(2,.5)) + '\n')
        f.write('if sys.argv[' + str(i+1) + '].count("' + Nucl[i] + '") == 1:\n')
        f.write('    OR[' + str(i) + '] = ' + ORs[i] + '\n')
        f.write('    CI[' + str(i) + '] = ' + CIs[i] + '\n')

#== Calculate final risk ==
f.write('\n')
f.write('Rel_Risk = (OR[0]')
for i in range(int(num_of_rsids)-1):
    f.write('*OR[' + str(i+1) + ']')
f.write(')\n')

f.write('Confidence_Interval = pow((pow(CI[0],2)')
for i in range(int(num_of_rsids)-1):
    f.write(' + pow(CI[' + str(i+1) + '],2)')
f.write('),.5)\n')
f.write('\n')
f.write('Rel_Lower = Rel_Risk\n')
f.write('Rel_Upper = Rel_Risk\n')
f.write('\n')
f.write('if Confidence_Interval > 0:\n')
f.write('    Rel_Lower = Rel_Risk / Confidence_Interval\n')
f.write('    Rel_Upper = Rel_Risk * Confidence_Interval\n')
f.write('\n')
f.write('print "RR",Rel_Risk,Rel_Lower,Rel_Upper')
