clear all;

halfwidth=2*75;           %approximate thickness of the worm
Npix=10;
Nmax=1024;                %camera pixel property (for 1024x1024 pixels)


im = tiffread2c;           %opens stack file(dapi)
n = length(im);           %counts the number of images in stack


dapi = cat(3, im.data);    %construct 3d array with stack images
dapi = double(dapi);       %convert to 'double'
clear im;


maxproj = double(zeros(Nmax, Nmax));                  %maximum Z-projection

for i=1:1:Nmax
    
    for j=1:1:Nmax
        
        
        m = max(dapi(i,j,:));
        maxproj(i,j) = m;
        
        
    end
end

clear dapi;

%%

imshow(maxproj, []);          %shows the resulting fish image  
title('Click along anteroposterior axis and hit enter - YOU NEED POINTS BEYOND ENDS!');


xybody = ginput;         
hold on;



x=xybody(:,1);        
y=xybody(:,2);
yy=[x';y'];               %transpose columns to rows and create a 2 by ? matrix
xx=1:length(x);
plot(xybody(:,1),xybody(:,2),'o')
xxx=1:0.0001:length(x);
pp=spline(xx,yy,xxx);
dx=diff(pp(1,:));
dy=diff(pp(2,:));

dr=sqrt(dx.^2+dy.^2);
wormlength=cumsum(dr);
totalwormlength=round(sum(dr));


for i=1:totalwormlength
    minvec=abs(i-wormlength);
    [mindis j]=min(minvec);
    X(i)=pp(1,j);
    Y(i)=pp(2,j);
end;
plot(X,Y,'.')


dr_long=[diff(X); diff(Y)];
dr_trans=[];                                       %start with an empty matrix dr_trans
for j=1:size(dr_long,2)                            %size of the 2nd row of dr_long
    veclong=[dr_long(:,j);0];                      %create infinitesimal vectors along the body axis (in 3-d)
    vecZ=[0; 0; 1];                                %vecZ is a vector sticking out of the image plane
    vectrans=cross(vecZ,veclong);                  %generate vectors perpendicular to the body axis via cross product
    dr_trans=[dr_trans vectrans(1:2,:)];           %dr_trans is a 3 by ? matrix with each 'vectrans' as each column

 end;





I = maxproj;

 
     
    for k=1:size(dr_long,2)
        for l=1:halfwidth
            Xoff1(k,l)=l*dr_trans(1,k)+X(k);           %Cartesian coordinates of the points to be mapped in the original image
            Yoff1(k,l)=l*dr_trans(2,k)+Y(k);
            Xoff2(k,l)=-l*dr_trans(1,k)+X(k);
            Yoff2(k,l)=-l*dr_trans(2,k)+Y(k);
            if (round(Xoff1(k,l))<Nmax && round(Yoff1(k,l))<Nmax && round(Xoff1(k,l))>0 && round(Yoff1(k,l))>0)
                repix1(l,k)=double(I(round(Yoff1(k,l)),round(Xoff1(k,l))));
            else
                repix1(l,k)=0;
            end
            if (round(Xoff2(k,l))<Nmax && round(Yoff2(k,l))<Nmax && round(Xoff2(k,l))>0 && round(Yoff2(k,l))>0)
                repix2(halfwidth-l+1,k)=double(I(round(Yoff2(k,l)),round(Xoff2(k,l))));
            else
                repix2(l,k)=0;
            end

        end
     end;
    repix=[repix2; repix1];

   axis equal;
    figure(2);
    %colormap('hot');
    imshow(repix,[]);
    axis([0 totalwormlength 1 2*halfwidth]);
    axis equal;
    axis off;
    %eval(['save ' fnameout ' repix']);
    %close all B
    %clear repix




