clear all

channels={'A594', 'Cy5'};

dir = uigetdir('e:\worm');
dir=[dir '\'];

useMask=1;
%% find worms to analyze

matlab_path=[dir '\analyzed\matlab_data\'];
files=ls(matlab_path);
to_analyze=[];
merged=[];

% first, find all data sets that are merged with other data sets: they have
% been straightened when they are merged
for i=1:size(files,1)
    if ~isempty(findstr(files(i,:), 'mergedata'))
        N=sscanf(files(i,:), 'mergedata%d_%d.mat');
        merged=[merged; N];
    end
end

% find all other data sets and add them to the list
for i=1:size(files,1)
    q=findstr(files(i,:), 'spotdata');
    if ~isempty(q)
        N=sscanf(files(i,q-4:q-2), '%d');
        if isempty(find(merged==N))
            for j=1:length(channels)
                if ~isempty(findstr(files(i,:), channels{j}))
                    to_analyze=[to_analyze; N j];
                end
            end
        end
    end
end
%% straighten spots and save
h=waitbar(0);
for i=1:size(to_analyze,1)
    
    % load spot data
    infile=sprintf('%s%03d_spotdata.mat', channels{to_analyze(i,2)}, to_analyze(i,1));
    load([matlab_path infile], 'merged_spot');
        
    % get worm axis spline
    infile=sprintf('celldata%03d.mat',to_analyze(i,1));
    load([matlab_path infile], 'ax');

    ax_dx=diff(ax(1,:));
    ax_dy=diff(ax(2,:));
    ax_dr=sqrt(ax_dx.^2+ax_dy.^2);
    ax_length=cumsum(ax_dr);
    ax_normal=-[ax_dx./ax_dr; ax_dy./ax_dr];

    % total length of worm in pixels.
    Ltot=ax_length(end);

    % for a resolution of ~2 points per pixel, calculate ds
    ds=1/(2*Ltot);

    % calculate a spline through axis with 0.5 pixel resolution
    x=ax(1,:);        
    y=ax(2,:);
    yy=[x; y];
    xx=1:length(x);
    xxx=1:(ds*length(x)):length(x);
    pp=spline(xx,yy,xxx);

    % calculate normal and lengtha of spline segments
    pp_dx=diff(pp(1,:));
    pp_dy=diff(pp(2,:));
    pp_dr=sqrt(pp_dx.^2+pp_dy.^2);
    pp_length=cumsum(pp_dr);
    pp_normal=-[pp_dx./pp_dr; pp_dy./pp_dr];

    if useMask
        % load VPC mask
        infile=sprintf('VPCmask%03d.mat', to_analyze(i,1));
        load([matlab_path infile], 'border');  
        VPCmask=roipoly(1024,1024,border(1,:), border(2,:));

        % load AC mask
        infile=sprintf('ACmask%03d.mat', to_analyze(i,1));
        load([matlab_path infile], 'border');  
        ACmask=roipoly(1024,1024,border(1,:), border(2,:));

        % exclude AC mask region from VPC mask
        VPCmask=VPCmask.*~ACmask;

        % find all spots in AC or VPC mask 
        q=[];
        for s=1:length(merged_spot)
            x=ceil(merged_spot(s,1));
            y=ceil(merged_spot(s,2));
            q(s,1)=ACmask(y,x);
            q(s,2)=VPCmask(y,x);
        end

        % select for AC and VPC spots
        rAC=find(q(:,1)==1);
        AC_spot=merged_spot(rAC,:);
        rVPC=find(q(:,2)==1);
        VPC_spot=merged_spot(rVPC,:);

        Nac=length(rAC); Nvpc=length(rVPC);
        merged_spot=[AC_spot; VPC_spot];
        id_spot=[]; id_spot(1:Nac)=1; id_spot(Nac+(1:Nvpc))=2;
    end
   
    mRNA_tot=merged_spot;

    % find coordinates with respect to body axis for VPCs
    for t=1:length(merged_spot)

        x2=merged_spot(t,1:2)';
        DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal,0);
        mRNA_tot(t,1)=DX(1);
        mRNA_tot(t,2)=DX(2);
        mRNA_tot(t,3)=merged_spot(t,3);
    end

    outfile=sprintf('%s%03d_mRNA_AC_straight.mat', channels{to_analyze(i,2)}, to_analyze(i,1));
    r=find(id_spot==1);
    mRNA=mRNA_tot(r,:);
    save([matlab_path outfile], 'mRNA');
    
    outfile=sprintf('%s%03d_mRNA_VPC_straight.mat', channels{to_analyze(i,2)}, to_analyze(i,1));
    r=find(id_spot==2);
    mRNA=mRNA_tot(r,:);
    save([matlab_path outfile], 'mRNA');
 
    waitbar(i/length(to_analyze),h);
end
close(h);

%% review results

button = questdlg('Review data?','title','Yes','No','default');

if strcmp(button, 'Yes')
    for i=1:size(to_analyze,1)
        
        infile=sprintf('%s%03d_mRNA_VPC_straight.mat', channels{to_analyze(i,2)}, to_analyze(i,1));
        VPC=load([matlab_path infile], 'mRNA')
        
        infile=sprintf('%s%03d_mRNA_AC_straight.mat', channels{to_analyze(i,2)}, to_analyze(i,1));
        AC=load([matlab_path infile], 'mRNA')
        
        plot(VPC.mRNA(:,1), VPC.mRNA(:,2), '.', AC.mRNA(:,1), AC.mRNA(:,2), '.');
        xlim([0 1300]); axis equal;

        ginput(1);
    end
end
