%%

clear all

channels={'A594', 'Cy5'};
extension='.tif';

dir = uigetdir('e:\worm');
dir=[dir '\'];

%% find worms to analyze

matlab_path=[dir '\analyzed\matlab_data\'];
files=ls(matlab_path);
to_analyze=[];

for i=1:size(files,1)
    % check whether the cell is annotated
    if ~isempty(findstr(files(i,:), 'celldata'))
        N=sscanf(files(i,:), 'celldata%d.mat');
        
        % figure out which channels are there
        for j=1:length(channels)
            infile=sprintf('%s%03d%s', channels{j}, N, extension);
            
            % check if a stack of the channel exists
            if ~isempty(ls([dir infile]))
                % if so, make sure spot data isn't already present
                outfile=sprintf('%s%03d_spotdata.mat', channels{j}, N);
                if isempty(ls([matlab_path outfile]))
                    to_analyze=[to_analyze; N j];
                end
            end
        end
    end
end

%% analyze worms

for i=1:size(to_analyze,1)
    findSpots(dir, channels{to_analyze(i,2)}, extension, to_analyze(i,1));
end

%% review results

button = questdlg('Review data?','title','Yes','No','default');

if strcmp(button, 'Yes')
    for i=1:size(to_analyze,1)
        infile=sprintf('%s%03d_spotdata.mat', channels{to_analyze(i,2)}, to_analyze(i,1));
        load([matlab_path infile], 'th_z', 'merged_spot');

        infile=sprintf('dapi%03d_max.tif', to_analyze(i,1));
        im=imread([dir 'analyzed\projections\' infile]);

        figure(1);
        plot(th_z);
        title(sprintf('%s%03d', channels{to_analyze(i,2)}, to_analyze(i,1)));

        figure(2);
        imshow(im, 'In', 50); hold on;
        c=jet(25);
        Nz=merged_spot(end,3);
        for z=1:Nz
            r=find(merged_spot(:,3)==z);
            plot(merged_spot(r,1),merged_spot(r,2), '.', 'color', c(z,:));
        end
        hold off;
        title(sprintf('%s%03d', channels{to_analyze(i,2)}, to_analyze(i,1)));

        ginput(1);
    end
end
