%%

%%

clear all
channels={'A594', 'Cy5'};

cont=1; n=1
while cont
    dir = uigetdir('e:\worm');
    if dir==0
        cont=0;
    else
        data{n}.dir=[dir '\'];
    end
    n=n+1;
end

%% find worms to analyze

to_analyze=[];

for n=1:length(data)
    matlab_path=[data{n}.dir '\analyzed\matlab_data\'];
    files=ls(matlab_path);

    N_chan_hist=zeros(1,length(channels)); % # histograms per channel

    merged=[];

    % first find all worms that consist of two merged data sets
    for i=1:size(files,1)
        if ~isempty(findstr(files(i,:), 'mergedata'))
            N=sscanf(files(i,:), 'mergedata%d_%d.mat');
            merged=[merged; N];

            to_analyze=[to_analyze; N(1) N(2) n];
        end

    end

    % next check unmerged worms
    for i=1:size(files,1)
        % check whether the cell is annotated
        if ~isempty(findstr(files(i,:), 'celldata'))
            N=sscanf(files(i,:), 'celldata%d.mat');

            % check that this worm is not merged with another data set
            if isempty(find(merged==N))

            to_analyze=[to_analyze; N 0 n];
            end
        end
    end

end

%% get gonad lengths and sort

Nvpc=3:8;

for s=1:length(to_analyze)
    
    N=to_analyze(s,1);
    M=to_analyze(s,2);
    dir=to_analyze(s,3);
    
    matlab_path=[data{dir}.dir '\analyzed\matlab_data\'];

    if M==0
        infile=sprintf('celldata%03d.mat', N);
        load([matlab_path infile], 'VPC', 'AC')
    else
        infile=sprintf('mergedata%03d_%03d.mat', N,M);
        load([matlab_path infile], 'VPC', 'AC')
    end

    % get gonad length for each histogram
    load([matlab_path infile], 'DTC');
    if exist('DTC')
        Lgnd(s)=abs(DTC(2).coord(4)-DTC(1).coord(4));
%         Xoffset(s)=(DTC(2).coord(4)+DTC(1).coord(4))/2;
    else
        load([matlab_path infile], 'GND');
        Lgnd(s)=abs(GND(4,1)-GND(4,2));
%         Xoffset(s)=(GND(4,1)+GND(4,2))/2;
    end
    clear DTC

    N=VPC(6).N;
    Xoffset(s)=mean(VPC(6).coord(4,1:N));
%     N1=VPC(5).N; N2=VPC(7).N;
%     Xoffset(s)=(mean(VPC(5).coord(4,1:N1))+mean(VPC(7).coord(4,1:N2)))/2;
    
    % get borders for each of the Pn.p decendents
    for i=1:length(Nvpc)-1
        m=Nvpc(i);
        Xb(s,i)=(VPC(m).coord(4,1)+VPC(m+1).coord(4,VPC(m+1).N))/2;
    end
end

% sort
Lsort=sort(Lgnd);
for i=1:length(Lgnd)
    pos(i)=find(Lsort==Lgnd(i));
end

%%

%% plot VPC mRNA vs length

sym='osyd^';
channel=1;
Nvpc=[6]; cm=lines(length(Nvpc));

make legend
for i=1:2 %length(Nvpc)
    plot(-100, -100, sym(1), 'color', cm(i,:), 'MarkerFaceColor', cm(i,:)); hold on
end
legend('A','B','C','D','E','F');

for s=1:length(to_analyze)
    
    N=to_analyze(s,1);
    M=to_analyze(s,2);
    chn=channel;
    dir=to_analyze(s,3);
    
    if chn==channel
        
        matlab_path=[data{dir}.dir '\analyzed\matlab_data\'];
        
        if M==0
            infile=sprintf('%s%03d_VPC_mRNA.mat', channels{chn}, N);
            load([matlab_path infile], 'VPCmRNA', 'VPCspotID');

            infile=sprintf('celldata%03d.mat', N);
            load([matlab_path infile], 'VPC', 'AC')
        else
            infile=sprintf('%s_merge%03d_%03d_VPC_mRNA.mat', channels{chn}, N,M);
            load([matlab_path infile], 'VPCmRNA', 'VPCspotID');

            infile=sprintf('mergedata%03d_%03d.mat', N,M);
            load([matlab_path infile], 'VPC', 'AC')
        end
        
        % get gonad length for each histogram
        load([matlab_path infile], 'DTC');
        if exist('DTC')
            Lgnd=abs(DTC(2).coord(4)-DTC(1).coord(4));
        else
            load([matlab_path infile], 'GND');
            Lgnd=abs(GND(4,1)-GND(4,2));
        end
        clear DTC

        for n=1:length(Nvpc)
            if VPC(Nvpc(n)).N > 0 
                for i=1:VPC(Nvpc(n)).N
                    for c=1:length(channels)
                        plot(Lgnd, VPCmRNA(Nvpc(n)).mRNA(chn,i), sym(VPC(Nvpc(n)).N), 'color', cm(n,:), 'MarkerFaceColor', cm(n,:)); hold on
                    end
                end
            end
        end
    end
end
xlabel('Gonad length (pixels)');
ylabel('# mRNA per VPC');
hold off;

%% plot AC mRNA vs length

sym='o';

cm=[1 0 0; 0 1 0];
% make legend
for i=1:2
    plot(-100, -100, sym(1), 'color', cm(i,:), 'MarkerFaceColor', cm(i,:)); hold on
end
legend('Lin-12','Lag-2');

for s=1:length(to_analyze)
    
    N=to_analyze(s,1);
    M=to_analyze(s,2);
    dir=to_analyze(s,3);
    
    matlab_path=[data{dir}.dir '\analyzed\matlab_data\'];

    if M==0
        infile=sprintf('%03d_AC_mRNA.mat', N);
        load([matlab_path infile], 'ACmRNA');

        infile=sprintf('celldata%03d.mat', N);
        load([matlab_path infile], 'AC')
    else
        infile=sprintf('merge%03d_%03d_AC_mRNA.mat', N,M);
        load([matlab_path infile], 'ACmRNA');

        infile=sprintf('mergedata%03d_%03d.mat', N,M);
        load([matlab_path infile], 'AC')
    end

%     for c=1:2
%         plot(Lgnd(s), ACmRNA.mRNA(c), sym, 'color', cm(c,:), 'MarkerFaceColor', cm(c,:)); hold on
%     end

    cm=jet(255);
    c=ceil(255*(Lgnd(s)-min(Lsort))/(max(Lsort)-min(Lsort)));
    if c==0
        c=1;
    end
    plot(ACmRNA.mRNA(1), ACmRNA.mRNA(2), sym, 'color', cm(c,:), 'MarkerFaceColor', cm(c,:)); hold on

end
xlabel('Gonad length (pixels)');
ylabel('# mRNA per AC');
hold off;
