%%
% v6 - here I try a different approach: plotting cells with red/green fill
% showing Lin-12/Lag-2 levels.

% v5 - this version also plots VPC fluorescence as a function of gonad
% length

% v4 - this one makes histograms from datasets in different directories

% v3 - this one tries to extract Pn.p data only, by using spots found with
% VPC mask and taking only into account spots close enough to annotated VPC
% positions

%%

clear all
channels={'A594', 'Cy5'};

cont=1; n=1
while cont
    dir = uigetdir('e:\worm');
    if dir==0
        cont=0;
    else
        data{n}.dir=[dir '\'];
    end
    n=n+1;
end

%% find worms to analyze

to_analyze=[];

for n=1:length(data)
    matlab_path=[data{n}.dir '\analyzed\matlab_data\'];
    files=ls(matlab_path);

    N_chan_hist=zeros(1,length(channels)); % # histograms per channel

    merged=[];

    % first find all worms that consist of two merged data sets
    for i=1:size(files,1)
        if ~isempty(findstr(files(i,:), 'mergedata'))
            N=sscanf(files(i,:), 'mergedata%d_%d.mat');
            merged=[merged; N];

            to_analyze=[to_analyze; N(1) N(2) n];
        end

    end

    % next check unmerged worms
    for i=1:size(files,1)
        % check whether the cell is annotated
        if ~isempty(findstr(files(i,:), 'celldata'))
            N=sscanf(files(i,:), 'celldata%d.mat');

            % check that this worm is not merged with another data set
            if isempty(find(merged==N))

            to_analyze=[to_analyze; N 0 n];
            end
        end
    end

end

%% get gonad lengths and sort

Nvpc=3:8;

for s=1:length(to_analyze)
    
    N=to_analyze(s,1);
    M=to_analyze(s,2);
    dir=to_analyze(s,3);
    
    matlab_path=[data{dir}.dir '\analyzed\matlab_data\'];

    if M==0
        infile=sprintf('celldata%03d.mat', N);
        load([matlab_path infile], 'VPC', 'AC')
    else
        infile=sprintf('mergedata%03d_%03d.mat', N,M);
        load([matlab_path infile], 'VPC', 'AC')
    end

    % get gonad length for each histogram
    load([matlab_path infile], 'DTC');
    if exist('DTC')
        Lgnd(s)=abs(DTC(2).coord(4)-DTC(1).coord(4));
%         Xoffset(s)=(DTC(2).coord(4)+DTC(1).coord(4))/2;
    else
        load([matlab_path infile], 'GND');
        Lgnd(s)=abs(GND(4,1)-GND(4,2));
%         Xoffset(s)=(GND(4,1)+GND(4,2))/2;
    end
    clear DTC

    N=VPC(6).N;
    Xoffset(s)=mean(VPC(6).coord(4,1:N));
%     N1=VPC(5).N; N2=VPC(7).N;
%     Xoffset(s)=(mean(VPC(5).coord(4,1:N1))+mean(VPC(7).coord(4,1:N2)))/2;
    
    % get borders for each of the Pn.p decendents
    for i=1:length(Nvpc)-1
        m=Nvpc(i);
        Xb(s,i)=(VPC(m).coord(4,1)+VPC(m+1).coord(4,VPC(m+1).N))/2;
    end
end

% sort
Lsort=sort(Lgnd);
for i=1:length(Lgnd)
    pos(i)=find(Lsort==Lgnd(i));
end
%% plot VPCs

clf;

subplot(1,2,1);
hold on;

col=[1 1 1; 0.7 0.7 0.7];
for i=1:length(Nvpc)-1
    X1=[]; X2=[];
    Y1=[]; Y2=[];
    for s=1:length(to_analyze)
        if i==0
            X1(s)=-1000;
            Y1(s)=s;
        else
            u=find(pos==s);
            X1(s)=Xb(u,i)-Xoffset(u);
            Y1(s)=s;
        end
        if i==length(Nvpc)-1
            r=length(to_analyze)-s+1;
            X2(s)=1000;
            Y2(s)=r;
        else
            r=length(to_analyze)-s+1;
            v=find(pos==r);
            X2(s)=Xb(v,i+1)-Xoffset(v);
            Y2(s)=r;
        end
    end
    
    X1=[X1(1) X1 X1(end)];
    Y1=[0 Y1 Y1(end)+1];
    X2=[X2(1) X2 X2(end)];
    Y2=[Y2(1)+1 Y2 0];
    
    c=1+mod(i,2);
    patch([X1 X2], [Y1 Y2], col(c,:), 'edgecolor', col(c,:));
%     patch([X1 X2], [Y1 Y2], 'w', 'edgecolor', 'k');
%       plot([X1 X2], [Y1 Y2], '-o');
end

RX=[30 15 7 7]; RY=0.4;
t=0:pi/25:2*pi;

for s=1:length(to_analyze)
    
    N=to_analyze(s,1);
    M=to_analyze(s,2);
    dir=to_analyze(s,3);
    
    matlab_path=[data{dir}.dir '\analyzed\matlab_data\'];

    if M==0
        infile=sprintf('%s%03d_VPC_mRNA.mat', channels{2}, N);
        load([matlab_path infile], 'VPCmRNA', 'VPCspotID');

        infile=sprintf('celldata%03d.mat', N);
        load([matlab_path infile], 'VPC', 'AC')
    else
        infile=sprintf('%s_merge%03d_%03d_VPC_mRNA.mat', channels{2}, N,M);
        load([matlab_path infile], 'VPCmRNA', 'VPCspotID');

        infile=sprintf('mergedata%03d_%03d.mat', N,M);
        load([matlab_path infile], 'VPC', 'AC')
    end

%     % get gonad length for each histogram
%     load([matlab_path infile], 'DTC');
%     if exist('DTC')
%         Lgnd=abs(DTC(2).coord(4)-DTC(1).coord(4));
%         Xoffset=(DTC(2).coord(4)+DTC(1).coord(4))/2;
%     else
%         load([matlab_path infile], 'GND');
%         Lgnd=abs(GND(4,1)-GND(4,2));
%         Xoffset=(GND(4,1)+GND(4,2))/2;
%     end
%     clear DTC

    max1=20; max2=30;
    cole=[0 0 0; 0 0 1];
    for n=1:length(Nvpc)
        qrs=1+mod(n,2);
        m=VPC(Nvpc(n)).N;
        if m > 0 
            for i=1:m
                x=VPC(Nvpc(n)).coord(4,i);
                mRNA=VPCmRNA(Nvpc(n)).mRNA(1,i);
                f=min(mRNA,max1)/max1;
%                 col1=[1 1-f 1-f];
                col1=[f 0 0 ];
                mRNA=VPCmRNA(Nvpc(n)).mRNA(2,i);
                f=min(mRNA,max2)/max2;
%                 col2=[1-f 1 1-f];
                col2=[0 f 0];
                col=col1+col2;
%                 col=(col1+col2)/2;
                patch(x+RX(m)*sin(t)-Xoffset(s), pos(s)+RY*cos(t), col, 'linewidth', 1, 'edgecolor', 'k')
            end
        end
    end

end
xlim([-600 500]);
set(gca,'YDir','reverse')
hold off;

%% plot ACs

subplot(1,2,2);
hold on;

col=[1 1 1; 0.7 0.7 0.7];

RX=30; RY=0.4;
t=0:pi/25:2*pi;

for s=1:length(to_analyze)
    
    N=to_analyze(s,1);
    M=to_analyze(s,2);
    dir=to_analyze(s,3);
    
    matlab_path=[data{dir}.dir '\analyzed\matlab_data\'];

    if M==0
        infile=sprintf('%03d_AC_mRNA.mat', N);
        load([matlab_path infile], 'ACmRNA');

        infile=sprintf('celldata%03d.mat', N);
        load([matlab_path infile], 'AC')
    else
        infile=sprintf('merge%03d_%03d_AC_mRNA.mat', N,M);
        load([matlab_path infile], 'ACmRNA');

        infile=sprintf('mergedata%03d_%03d.mat', N,M);
        load([matlab_path infile], 'AC')
    end

    max1=60; max2=60;
    cole=[0 0 0; 0 0 1];
    x=AC(4);
    mRNA=ACmRNA.mRNA(1);
    f=min(mRNA,max1)/max1;
    col1=[f 0 0 ];
    mRNA=ACmRNA.mRNA(2)
    f=min(mRNA,max2)/max2;
    col2=[0 f 0];
    col=col1+col2;
    patch(x+RX*sin(t)-Xoffset(s), pos(s)+RY*cos(t), col, 'linewidth', 1, 'edgecolor', 'k')

end
xlim([-600 500]);
set(gca,'YDir','reverse')
hold off;
