%%
% v4 - this one makes histograms from datasets in different directories

% v3 - this one tries to extract Pn.p data only, by using spots found with
% VPC mask and taking only into account spots close enough to annotated VPC
% positions

%%

clear all
channels={'A594', 'Cy5'};

cont=1; n=1
while cont
    dir = uigetdir('e:\worm');
    if dir==0
        cont=0;
    else
        data{n}.dir=[dir '\'];
    end
    n=n+1;
end

%% find worms to analyze

matlab_path=[dir '\analyzed\matlab_data\'];
files=ls(matlab_path);
to_analyze=[];

N_chan_hist=zeros(1,length(channels)); % # histograms per channel

merged=[];

% first find all worms that consist of two merged data sets
for i=1:size(files,1)
    if ~isempty(findstr(files(i,:), 'mergedata'))
        N=sscanf(files(i,:), 'mergedata%d_%d.mat');
        merged=[merged; N];

        % figure out which channels are there
        for j=1:length(channels)
            infile=sprintf('%s_merge%03d_%03d_mRNA_straight.mat', channels{j}, N(1), N(2));

            % check if a stack of the channel exists
            if ~isempty(ls([matlab_path infile]))
                to_analyze=[to_analyze; N(1) N(2) j];
            end
        end
    end

end

% next check unmerged worms
for i=1:size(files,1)
    % check whether the cell is annotated
    if ~isempty(findstr(files(i,:), 'celldata'))
        N=sscanf(files(i,:), 'celldata%d.mat');
        
        % check that this worm is not merged with another data set
        if isempty(find(merged==N))
            
            % figure out which channels are there
            for j=1:length(channels)
                infile=sprintf('%s%03d_mRNA_straight.mat', channels{j}, N);

                % check if a stack of the channel exists
                if ~isempty(ls([matlab_path infile]))
                    to_analyze=[to_analyze; N 0 j];
                end
            end
        end
    end
end

%%

l=-1000:10:1000;
maxDist=100;

% allocate space for histograms
for i=1:length(channels)
    data{i}.hist=zeros(N_chan_hist(i),length(l));
    data{i}.sorthist=zeros(N_chan_hist(i),length(l));
    data{i}.Nhist=0;
    data{i}.Lgnd=zeros(1,N_chan_hist(i));
    data{i}.lVPC=[];
    data{i}.VPC_id=[];
    data{i}.VPC_N=[];
    data{i}.infiles=[];
    data{i}.sortinfiles=[];
end

wb=waitbar(0);
for i=1:length(to_analyze)
    
    N=to_analyze(i,1);
    M=to_analyze(i,2);
    chn=to_analyze(i,3);
    
    % load VPC, AC and gonad positions along worm axis
    if M==0
        infile=sprintf('celldata%03d.mat', N);
    else
        infile=sprintf('mergedata%03d_%03d.mat', N, M);
    end
    load([matlab_path infile], 'VPC', 'AC');

    data{chn}.Nhist=data{chn}.Nhist+1;
    
    % get gonad length for each histogram
    load([matlab_path infile], 'DTC');
    if exist('DTC')
        data{chn}.Lgnd(data{chn}.Nhist)=abs(DTC(2).coord(4)-DTC(1).coord(4));
        offset=(DTC(2).coord(4)+DTC(1).coord(4))/2;
    else
        load([matlab_path infile], 'GND');
        data{chn}.Lgnd(data{chn}.Nhist)=abs(GND(4,1)-GND(4,2));
        offset=(GND(4,1)+GND(4,2))/2;
    end
    
    % get VPC position for each histogram
    for t=1:length(VPC)
        if VPC(t).N > 0
            for i=1:VPC(t).N
                data{chn}.lVPC=[data{chn}.lVPC VPC(t).coord(4,i)-offset];
                data{chn}.VPC_id=[data{chn}.VPC_id t];
                data{chn}.VPC_N=[data{chn}.VPC_N data{chn}.Nhist];
            end
        end
    end
    
    % load mRNA positions along worm axis
    if M==0
        infile=sprintf('%s%03d_mRNA_straight.mat', channels{chn}, N);
        load([matlab_path infile], 'mRNA');
        infile=sprintf('%s%03d_VPC_mRNA.mat', channels{chn}, N);
        load([matlab_path infile], 'VPCmRNA', 'VPCspotID');
    else
        infile=sprintf('%s_merge%03d_%03d_mRNA_straight.mat', channels{chn}, N, M);
        load([matlab_path infile], 'mRNA');
        infile=sprintf('%s_merge%03d_%03d_VPC_mRNA.mat', channels{chn}, N, M);
        load([matlab_path infile], 'VPCmRNA', 'VPCspotID');
    end
    
    h=hist(mRNA(VPCspotID,1)-offset,l);
    data{chn}.hist(data{chn}.Nhist,:)=h;
    data{chn}.infile(data{chn}.Nhist,1:length(infile))=char(infile);
    
%     subplot(2,1,2)
%     plot(l,h);
%     ginput(1);

    waitbar(i/length(to_analyze),wb);
end
close(wb);

%% sort histograms according to gonad length

for j=1:length(channels)
    
    % get sorted lengths
    L=sort(data{j}.Lgnd);
    
    % find positions of sorted length elements in original array
    for n=1:length(L)
        pos(n)=find(data{j}.Lgnd==L(n));
    end
    
    % sort histograms by gonad length
    for n=1:length(pos)
        data{j}.sorthist(n,:)=data{j}.hist(pos(n),:);
        data{j}.sortinfile(n,:)=data{j}.infile(pos(n),:);
    end
end

%% plot results

subplot(1,2,1)
colmap=jet(15);
colmap(1,:)=0;
imshow(ind2rgb(data{1}.sorthist, colmap), 'Xdata', l), axis on, axis normal
hold on;

% plot VPCs
col=lines(10);
for n=1:length(pos)
    r=find(data{1}.VPC_N==pos(n));
    
    x=data{1}.lVPC(r); id=data{1}.VPC_id(r);
    
    % draw VPC positions
    for i=2:10
        q=find(id==i);
        if ~isempty(q)
            m=length(q);
            plot(x(q),n*ones(1,m), '.', 'color', col(i,:));
        end
    end
    
    % draw lines connecting VPCs
    if n~=1
        for i=2:10
            q1=find(id==i);
            q2=find(id_old==i);
            m1=length(q1); m2=length(q2);
            if m1==1 && m2==1
                plot([x_old(q2) x(q1)], [n-1 n], 'color', col(i,:)); 
            end
            if m1==1 && m2==2
                plot([x_old(q2(1)) x(q1)], [n-1 n], 'color', col(i,:)); 
                plot([x_old(q2(2)) x(q1)], [n-1 n], 'color', col(i,:)); 
            end
            if m1==2 && m2==1
                plot([x_old(q2) x(q1(1))], [n-1 n], 'color', col(i,:)); 
                plot([x_old(q2) x(q1(2))], [n-1 n], 'color', col(i,:)); 
            end
            if m1==2 && m2==2
                plot([x_old(q2(1)) x(q1(1))], [n-1 n], 'color', col(i,:)); 
                plot([x_old(q2(2)) x(q1(2))], [n-1 n], 'color', col(i,:)); 
            end
            if m1==4 && m2==2
                plot([x_old(q2(1)) x(q1(1))], [n-1 n], 'color', col(i,:)); 
                plot([x_old(q2(1)) x(q1(2))], [n-1 n], 'color', col(i,:)); 
                plot([x_old(q2(2)) x(q1(3))], [n-1 n], 'color', col(i,:)); 
                plot([x_old(q2(2)) x(q1(4))], [n-1 n], 'color', col(i,:)); 
            end
            if m1==2 && m2==4
                plot([x_old(q2(1)) x(q1(1))], [n-1 n], 'color', col(i,:)); 
                plot([x_old(q2(2)) x(q1(1))], [n-1 n], 'color', col(i,:)); 
                plot([x_old(q2(3)) x(q1(2))], [n-1 n], 'color', col(i,:)); 
                plot([x_old(q2(4)) x(q1(2))], [n-1 n], 'color', col(i,:)); 
            end
            if m1==4 && m2==4
                plot([x_old(q2(1)) x(q1(1))], [n-1 n], 'color', col(i,:)); 
                plot([x_old(q2(2)) x(q1(2))], [n-1 n], 'color', col(i,:)); 
                plot([x_old(q2(3)) x(q1(3))], [n-1 n], 'color', col(i,:)); 
                plot([x_old(q2(4)) x(q1(4))], [n-1 n], 'color', col(i,:)); 
            end
        end
    end
    
    x_old=x; id_old=id;
end
hold off;
xlim([-1000 1000]);

subplot(1,2,2)
imshow(ind2rgb(data{2}.sorthist, colmap), 'Xdata', l), axis on, axis normal
hold on;

% plot VPCs
for n=1:length(pos)
    r=find(data{1}.VPC_N==pos(n));
    
    x=data{1}.lVPC(r); id=data{1}.VPC_id(r);
    
    % draw VPC positions
    for i=2:10
        q=find(id==i);
        if ~isempty(q)
            m=length(q);
            plot(x(q),n*ones(1,m), '.', 'color', col(m,:));
        end
    end
    
    % draw lines connecting VPCs
    if n~=1
        for i=2:10
            q1=find(id==i);
            q2=find(id_old==i);
            m1=length(q1); m2=length(q2);
            if m1==1 && m2==1
                plot([x_old(q2) x(q1)], [n-1 n], 'color', col(m1,:)); 
            end
            if m1==1 && m2==2
                plot([x_old(q2(1)) x(q1)], [n-1 n], 'color', col(m2,:)); 
                plot([x_old(q2(2)) x(q1)], [n-1 n], 'color', col(m2,:)); 
            end
            if m1==2 && m2==1
                plot([x_old(q2) x(q1(1))], [n-1 n], 'color', col(m1,:)); 
                plot([x_old(q2) x(q1(2))], [n-1 n], 'color', col(m1,:)); 
            end
            if m1==2 && m2==2
                plot([x_old(q2(1)) x(q1(1))], [n-1 n], 'color', col(m1,:)); 
                plot([x_old(q2(2)) x(q1(2))], [n-1 n], 'color', col(m1,:)); 
            end
        end
    end
    
    x_old=x; id_old=id;
end
hold off;
xlim([-700 700]);

%% plot VPC mRNA vs length

sym='osxy';
channel=2;
Nvpc=6;
cm=[0 0 1]
% cm=jet(length(Nvpc));
for s=1:length(to_analyze)
    
    N=to_analyze(s,1);
    chn=to_analyze(s,2);
    
    if chn==channel
        infile=sprintf('%s%03d_VPC_mRNA.mat', channels{chn}, N);
        load([matlab_path infile], 'VPCmRNA', 'VPCspotID');

        infile=sprintf('celldata%03d.mat', N);
        load([matlab_path infile], 'VPC', 'AC', 'GND')

        Lgnd=abs(GND(4,1)-GND(4,2));

        for n=1:length(Nvpc)
            if VPC(Nvpc(n)).N > 0 
                for i=1:VPC(Nvpc(n)).N
                    for c=1:length(channels)
                        plot(Lgnd, VPCmRNA(Nvpc(n)).mRNA(chn,i), sym(i), 'color', cm(n,:), 'MarkerFaceColor', cm(n,:)); hold on
                    end
                end
            end
        end
    end
end
xlabel('Gonad length (pixels)');
ylabel('# mRNA per VPC');
hold off;
