clear all;
channel={'A594', 'Cy5'};
cont = 1;

while cont
    [filename,path]=uigetfile('dapi*', 'DialogTitle', 'e:/worm/4-13-2009/lin12A594_lag2Cy5_12.30pm/');
    
    if filename ~= 0
        
        N=sscanf(filename,'dapi%d');
        proj_path=[path 'analyzed\projections\'];
        mask_path=[path 'analyzed\masks\'];
    
        for i=1:length(channel)
            
            % check which channels are available
            infile = sprintf('%s%03d_mean.tif',channel{i},N);
            if ~isempty(ls([proj_path infile]))
                
                % read mean projection
                A=imread([proj_path infile]);
                immean=mat2gray(A(1:1024,3:1024));
                
                % get mask for current channel
                mask=roipoly(immean);

                % save mask
                outfile=sprintf('%s%03d_mask.tif', channel{i},N);
                imwrite(mask,[mask_path outfile],'Compression', 'none');
            end
        end
    else
        cont=0;
    end
end