%%

clear all
channels={'A594', 'Cy5'};
extension='.tif';

dir = uigetdir('e:\worm');
dir=[dir '\'];

%% find worms to analyze

matlab_path=[dir '\analyzed\matlab_data\'];
files=ls(matlab_path);
to_analyze=[];
merged=[];

% N_chan_hist=zeros(1,length(channels)); % # histograms per channel

% first find all worms that consist of two merged data sets
for i=1:size(files,1)
    if ~isempty(findstr(files(i,:), 'mergedata'))
        N=sscanf(files(i,:), 'mergedata%d_%d.mat');
        merged=[merged; N];

        % figure out which channels are there
        for j=1:length(channels)
            infile=sprintf('%s_merge%03d_%03d_mRNA_straight.mat', channels{j}, N(1), N(2));

            % check if a stack of the channel exists
            if ~isempty(ls([matlab_path infile]))
                to_analyze=[to_analyze; N(1) N(2) j];
            end
        end
    end

end

% next check unmerged worms
for i=1:size(files,1)
    % check whether the cell is annotated
    if ~isempty(findstr(files(i,:), 'celldata'))
        N=sscanf(files(i,:), 'celldata%d.mat');
        
        % check that this worm is not merged with another data set
        if isempty(find(merged==N))
            
            % figure out which channels are there
            for j=1:length(channels)
                infile=sprintf('%s%03d_mRNA_straight.mat', channels{j}, N);

                % check if a stack of the channel exists
                if ~isempty(ls([matlab_path infile]))
                    to_analyze=[to_analyze; N 0 j];
                end
            end
        end
    end
end

%%

for s=1:length(to_analyze)
    
    N=to_analyze(s,1);
    M=to_analyze(s,2);
    chn=to_analyze(s,3);

    if M==0
        infile=sprintf('%s%03d_mRNA_VPC_straight.mat', channels{chn}, N);
        load([matlab_path infile], 'mRNA');

        infile=sprintf('celldata%03d.mat', N);
        load([matlab_path infile], 'VPC');
    else
        infile=sprintf('%s_merge%03d_%03d_mRNA_VPC_straight.mat', channels{chn}, N, M);
        load([matlab_path infile], 'mRNA');

        infile=sprintf('mergedata%03d_%03d.mat', N,M);
        load([matlab_path infile], 'VPC');
    end
    
    %% put VPC coordinates in easier form
    Nvpc=0;
    Xvpc=[];
    IDvpc=[];
    for n=1:length(VPC)
        if VPC(n).N > 0 
            for i=1:VPC(n).N
                Nvpc=Nvpc+1;
                Xvpc(Nvpc,1)=VPC(n).coord(4,i);
                Xvpc(Nvpc,2)=VPC(n).coord(5,i);
                Xvpc(Nvpc,3)=VPC(n).coord(3,i);
                IDvpc(Nvpc,1)=n;
                IDvpc(Nvpc,2)=i;
            end
        end
    end

    %% match mRNAs and VPCs
    S=[];
    for i=1:length(mRNA)

        % find closest VPC
        dist=6e66;
        for n=1:Nvpc
            dx=Xvpc(n,1)-mRNA(i,1);
            dy=Xvpc(n,2)-mRNA(i,2);
            D=sqrt(dx^2+dy^2);
            if D<dist
                dist=D;
                S(i)=n;
            end
        end

        % reject if z-coordinate is too different
        dz=mRNA(i,3)-Xvpc(S(i),3);
        if abs(dz)>4
            S(i)=Nvpc+1;
        end
    end

    %% get VPC data
    for n=1:length(VPC)
        if VPC(n).N > 0 
            for i=1:VPC(n).N
                r=find(IDvpc(:,1)==n & IDvpc(:,2)==i);
                VPCmRNA(n).mRNA(chn,i)=length(find(S==r));
            end
        end
    end
    
    %% get spot data
    VPCspotID=find(S~=Nvpc+1);
    
    %% save data
    if M==0
        outfile=sprintf('%s%03d_VPC_mRNA.mat', channels{chn}, N);
        save([matlab_path outfile], 'VPCmRNA', 'VPCspotID');
    else
        outfile=sprintf('%s_merge%03d_%03d_VPC_mRNA.mat', channels{chn}, N,M);
        save([matlab_path outfile], 'VPCmRNA', 'VPCspotID');
    end
end
%%

% button = questdlg('Review data?','title','Yes','No','default');
button='Yes';

if strcmp(button, 'Yes')

    for s=1:length(to_analyze)

        N=to_analyze(s,1);
        M=to_analyze(s,2);
        chn=to_analyze(s,3);

        if M==0
            infile=sprintf('%s%03d_mRNA_VPC_straight.mat', channels{chn}, N);
            load([matlab_path infile], 'mRNA');

            infile=sprintf('%s%03d_VPC_mRNA.mat', channels{chn}, N);
            load([matlab_path infile], 'VPCmRNA', 'VPCspotID');

            infile=sprintf('celldata%03d.mat', N);
            load([matlab_path infile], 'VPC');
        else
            infile=sprintf('%s_merge%03d_%03d_mRNA_VPC_straight.mat', channels{chn}, N, M);
            load([matlab_path infile], 'mRNA');

            infile=sprintf('%s_merge%03d_%03d_VPC_mRNA.mat', channels{chn}, N, M);
            load([matlab_path infile], 'VPCmRNA', 'VPCspotID');

            infile=sprintf('mergedata%03d_%03d.mat', N, M);
            load([matlab_path infile], 'VPC');
        end
        
        % m1=1;m2=2;v1=4;v2=5;
        m1=1;m2=3;v1=4;v2=3;

        cm=jet(25);

        subplot(4,1,1);
        for i=1:length(mRNA)
            plot(mRNA(i,1), mRNA(i,2), '.', 'color', cm(mRNA(i,3),:)); hold on;
        end

        for n=1:length(VPC)
            if VPC(n).N > 0 
                for i=1:VPC(n).N
                    plot(VPC(n).coord(4,i), VPC(n).coord(5,i), 'ok');
                end
            end
        end

        hold off;

        subplot(4,1,2);
        for i=1:length(mRNA)
            plot(mRNA(i,1), mRNA(i,3), '.', 'color', cm(mRNA(i,3),:)); hold on;
        end

        for n=1:length(VPC)
            if VPC(n).N > 0 
                for i=1:VPC(n).N
                    plot(VPC(n).coord(4,i), VPC(n).coord(3,i), 'ok');
                end
            end
        end
        hold off;
        ylim([-1 26]);

        subplot(4,1,3);
        cm=jet(Nvpc+1);
        for i=1:length(VPCspotID)
            plot(mRNA(VPCspotID(i),m1), mRNA(VPCspotID(i),m2), '.', 'color', 'r'); hold on;
        end

        for n=1:length(VPC)
            if VPC(n).N > 0 
                for i=1:VPC(n).N
                    plot(VPC(n).coord(v1,i), VPC(n).coord(v2,i), 'ok');
                end
            end
        end
        hold off;
        ylim([-1 26]);

        subplot(4,1,4)

        for n=1:length(VPC)
            if VPC(n).N > 0 
                for i=1:VPC(n).N
                    for c=1:length(channels)
                        plot(n, VPCmRNA(n).mRNA(chn,i), 'o'); hold on
                    end
                end
            end
        end
        hold off;
    
        ginput(1);

    end
end