%%

clear all
channels={'A594', 'Cy5'};
extension='.tif';

dir = uigetdir('e:\worm');
dir=[dir '\'];

%% find worms to analyze

matlab_path=[dir '\analyzed\matlab_data\'];
files=ls(matlab_path);
to_analyze=[];
merged=[];

% N_chan_hist=zeros(1,length(channels)); % # histograms per channel

% first find all worms that consist of two merged data sets
for i=1:size(files,1)
    if ~isempty(findstr(files(i,:), 'mergedata'))
        N=sscanf(files(i,:), 'mergedata%d_%d.mat');
        merged=[merged; N];

        % add to list of worms to analyze, only if both Cy5 and A594
        % channels are there
        analyze=1;
        for j=1:length(channels)
            infile=sprintf('%s_merge%03d_%03d_mRNA_AC_straight.mat', channels{j}, N(1), N(2));

            % check if a stack of the channel exists
            if isempty(ls([matlab_path infile]))
               analyze=0; 
            end
        end
        if analyze
            to_analyze=[to_analyze; N(1) N(2)];
        end
    end

end

% next check unmerged worms
for i=1:size(files,1)
    % check whether the cell is annotated
    if ~isempty(findstr(files(i,:), 'celldata'))
        N=sscanf(files(i,:), 'celldata%d.mat');
        
        % check that this worm is not merged with another data set
        if isempty(find(merged==N))
            
            % add to list of worms to analyze, only if both Cy5 and A594
            % channels are there
            analyze=1;
            for j=1:length(channels)
                infile=sprintf('%s%03d_mRNA_AC_straight.mat', channels{j}, N);

                % check if a stack of the channel exists
                if isempty(ls([matlab_path infile]))
                   analyze=0; 
                end
            end
            if analyze
                to_analyze=[to_analyze; N 0];
            end
        end
    end
end

%%

for s=1:length(to_analyze)
    
    N=to_analyze(s,1);
    M=to_analyze(s,2);

    clear data
    if M==0
        for chn=1:2
            infile=sprintf('%s%03d_mRNA_AC_straight.mat', channels{chn}, N);
            data(chn)=load([matlab_path infile], 'mRNA');
        end
        
        infile=sprintf('celldata%03d.mat', N);
        load([matlab_path infile], 'AC');
    else
        for chn=1:2
            infile=sprintf('%s_merge%03d_%03d_mRNA_AC_straight.mat', channels{chn}, N, M);
            data(chn)=load([matlab_path infile], 'mRNA');
        end
        
        infile=sprintf('mergedata%03d_%03d.mat', N,M);
        load([matlab_path infile], 'AC');
    end
    
    %% put AC coordinates in easier form
    Xac(1)=AC(4);
    Xac(2)=AC(5);
    Xac(3)=AC(3);

    % find min and max z value of Cy5 point cloud so that 90% of points
    % fall within that z range
    x=1:30;
    H=hist(data(2).mRNA(:,3),x);
    c=cumsum(H)/sum(H);
    r=find(c>0.05); z(1)=x(r(1));
    r=find(c<=0.85); z(2)=x(r(end));
    r=find(data(1).mRNA(:,3)>=z(1) & data(1).mRNA(:,3)<=z(2));
    
    %% get AC data
    ACmRNA.mRNA(1)=size((data(1).mRNA(r,:)),1);
    ACmRNA.mRNA(2)=size((data(2).mRNA),1);
    
    %% save data
    if M==0
        outfile=sprintf('%03d_AC_mRNA.mat', N);
        save([matlab_path outfile], 'ACmRNA');
    else
        outfile=sprintf('merge%03d_%03d_AC_mRNA.mat', N,M);
        save([matlab_path outfile], 'ACmRNA');
    end
end
%%

button = questdlg('Review data?','title','Yes','No','default');
% button='Yes';

if strcmp(button, 'Yes')
    for s=1:length(to_analyze)

        N=to_analyze(s,1);
        M=to_analyze(s,2);

        if M==0
            for chn=1:2
                infile=sprintf('%s%03d_mRNA_AC_straight.mat', channels{chn}, N);
                data(chn)=load([matlab_path infile], 'mRNA');
            end

            infile=sprintf('celldata%03d.mat', N);
            load([matlab_path infile], 'AC');
        else
            for chn=1:2
                infile=sprintf('%s_merge%03d_%03d_mRNA_AC_straight.mat', channels{chn}, N, M);
                data(chn)=load([matlab_path infile], 'mRNA');
            end

            infile=sprintf('mergedata%03d_%03d.mat', N,M);
            load([matlab_path infile], 'AC');
        end

        %% put AC coordinates in easier form
        Xac(1)=AC(4);
        Xac(2)=AC(5);
        Xac(3)=AC(3);

        % find min and max z value of Cy5 point cloud so that 90% of points
        % fall within that z range
        x=1:30;
        H=hist(data(2).mRNA(:,3),x);
        c=cumsum(H)/sum(H);
        r=find(c>0.05); z(1)=x(r(1));
        r=find(c<=0.85); z(2)=x(r(end));
        r=find(data(1).mRNA(:,3)>=z(1) & data(1).mRNA(:,3)<=z(2));

        %     plot3(data(1).mRNA(:,1),data(1).mRNA(:,2), data(1).mRNA(:,3), '.r', data(2).mRNA(:,1), data(2).mRNA(:,2), data(2).mRNA(:,3), '.g', Xac(1), Xac(2), Xac(3), 'ob');
        
        subplot(2,2,1);
        plot(data(1).mRNA(:,1), data(1).mRNA(:,2), '.r', data(2).mRNA(:,1), data(2).mRNA(:,2), '.g', Xac(1), Xac(2), 'ob');
        subplot(2,2,3);
        plot(data(1).mRNA(:,1), data(1).mRNA(:,3), '.r', data(2).mRNA(:,1), data(2).mRNA(:,3), '.g', Xac(1), Xac(3), 'ob');
        ylim([0 25]);
        subplot(2,2,2);
        plot(data(1).mRNA(r,1), data(1).mRNA(r,2), '.r', data(2).mRNA(:,1), data(2).mRNA(:,2), '.g', Xac(1), Xac(2), 'ob');
        subplot(2,2,4);
        plot(data(1).mRNA(r,1), data(1).mRNA(r,3), '.r', data(2).mRNA(:,1), data(2).mRNA(:,3), '.g', Xac(1), Xac(3), 'ob');
        ylim([0 25]);

        ginput(1);
    end
end