function findSpots(path, channel, extension, N)

% N=14;
% channel='A594';
% path='E:\WORM\4-2-2009\';

filename=sprintf('%s%03d%s', channel, N, extension);

stk=tiffread2c([path filename]);

im_min=inf; im_max=-inf;
for i=1:length(stk)
    min_I=double(min(stk(i).data(:)));
    max_I=double(max(stk(i).data(:)));
    if min_I < im_min
        im_min=min_I;
    end
    if max_I > im_max
        im_max=max_I;
    end
end

im=zeros(stk(1).width, stk(1).height-2,length(stk));
for i=1:length(stk)
    im(:,:,i)=mat2gray(stk(i).data(1:1024,3:1024), [im_min im_max]);
end
clear stk
%%
inpath=[path 'analyzed\masks\'];
infile=sprintf('%s%03d_mask.tif', channel, N);
mask=imread([inpath infile]);

inpath=[path 'analyzed\projections\'];
infile=sprintf('%s%03d_mean.tif', channel, N);
tmp=imread([inpath infile]);
immean=mat2gray(tmp(1:1024,3:1024));

inpath=[path 'analyzed\matlab_data\'];
infile=sprintf('celldata%03d.mat',N);
load([inpath infile],'ax');

tmp=bwlabel(im2bw(immean,graythresh(immean)));
n=round(size(ax,2)/2);
worm_id=tmp(round(ax(2,n)),round(ax(1,n)));
wormmask=ismember(tmp,worm_id);
final_mask=mask.*wormmask;

%%
H = -fspecial('log',15,1.5);
spot=[];
th_z=[];

Nmask=length(find(final_mask>0));
for i=1:size(im,3)
    A=squeeze(im(:,:,i));
    B = imfilter(A,H,'replicate');
    B(find(B<0))=0;
    B=mat2gray(B);    
    % imshow(B)

    %
    dmin=0.01;
    cont=1; th=0.5; 
    th_l=0; th_h=1;
    dth=(th_h-th_l)/2;
    while dth>dmin/2
        tmp=im2bw(final_mask.*B,th);
        r=find(tmp>0);
        f=length(find(tmp>0))/Nmask;

        Nspots=length(r);
        if Nspots/Nmask<1e-4
            th_h=th;
            dth=(th_h-th_l)/2;
            th=th-dth;
        else
            th_l=th;
            dth=(th_h-th_l)/2;
            th=th+dth;
        end
    end
    th_z(i)=th_h;
    plot(th_z); 
    title(filename);
    getframe;

    C=logical(wormmask.*im2bw(B,th_z(i)));
    bwl=bwlabel(C);
    rp=regionprops(bwl, 'centroid');
    for j=1:length(rp)
        spot=[spot; rp(j).Centroid i];
    end
    
end

%% 
chk=zeros(1,size(spot,1));
merged_spot=[];

spfound=1;
for i=1:size(spot,1)
    
    if chk(i) ~= 1
        % find other spots that can merge with this spot
        mergelist=i;
        z1=spot(i,3);
        for j=1:size(spot,1)
            if i ~= j
                z2=spot(j,3);
                if abs(z2-z1)<=2
                    dx=spot(i,1)-spot(j,1);
                    dy=spot(i,2)-spot(j,2);
                    if dx^2+dy^2<4
                        mergelist=[mergelist j];
                        chk(j)=1;
                    end
                end
            end
        end

        %
        if length(mergelist>1)
    %         mergelist
            merged_spot(spfound,1)=mean(spot(mergelist,1));
            merged_spot(spfound,2)=mean(spot(mergelist,2));
            merged_spot(spfound,3)=round(mean(spot(mergelist,3)));
            spfound=spfound+1;
        end
    end
end

%%

outpath=[path 'analyzed\matlab_data\'];
outfile=sprintf('%s%03d_spotdata.mat', channel, N);
save([outpath outfile], 'th_z', 'spot', 'merged_spot'); 
