file='E:\WORM\3-6-2009\lin-12\A594009.stk';

stk=tiffread2c(file);
%%
im_min=inf; im_max=-inf;
for i=1:length(stk)
    min_I=double(min(stk(i).data(:)));
    max_I=double(max(stk(i).data(:)));
    if min_I < im_min
        im_min=min_I;
    end
    if max_I > im_max
        im_max=max_I;
    end
end

%%

im=zeros(stk(1).width, stk(1).height-2,length(stk));
for i=1:length(stk)
    im(:,:,i)=mat2gray(stk(i).data(1:1024,3:1024), [im_min im_max]);
end

%%
% The images are now contained in the variable "ims"

% Now run the data through a linear filter to enhance particles
ims2 = LOG_filter(im);

% Normalize ims2
ims2 = ims2/max(ims2(:));

% This function call will find the number of mRNAs for all thresholds
thresholdfn = multithreshstack(ims2);

% These are the thresholds
thresholds = (1:100)/100;

%%

% Let's plot the threshold as a function of the number of mRNAs
figure(1)
plot(thresholds, thresholdfn);
xlabel('Threshold');
ylabel('Number of spots counted');
% Zoom in on important area
ylim([0 1000]);

% In this case, the appropriate threshold is around 0.23 or so.

% This code helps extract the number of mRNA from the graph

title('Click at appropriate x/threshold value and hit return')

[x,y] = getpts;
line([x x],[0 4000]);

x = round(x*100);  % 100 is the number of thresholds
number_of_mrna = thresholdfn(x)

%%

bwl = ims2 > x/100;
[lab,n] = bwlabeln(bwl);  
rp=regionprops(lab, 'Centroid','PixelIdxList');

X=[];Y=[];Z=[];
for i=1:length(rp)
    X=[X rp(i).Centroid(1)];
    Y=[Y rp(i).Centroid(2)];
    Z=[Z rp(i).Centroid(3)];
end

%%
I_spot=zeros(1,length(rp));
for z=1:size(im,3)
    imp=im(:,:,z);
    imshow(mat2gray(imp));
    hold on;
    r=find(round(Z)==z);
    if (length(r)>0 )
        plot(X(r), Y(r), 'ob', 'MarkerSize', 12);
        getframe;
        hold off
    end
    
end

%%
file='E:\WORM\12-3-2008\lin12\lin12_fmm30_worm3_dapi.stk';

stk=tiffread2c(file);
%%
imp=mat2gray(stk(15).data);
imshow(mat2gray(imp));
hold on;
for m=1:length(X)
    plot(X(m), Y(m), 'ob', 'MarkerSize', 2);
end
getframe;
hold off
