filename='A59402.stk';
path='E:\WORM\3-25-2009\lin12_11am\';

stk=tiffread2c([path filename]);

N=sscanf(filename, 'A594%d');
outfile=sprintf('spotdata%03d.mat',N);

im_min=inf; im_max=-inf;
for i=1:length(stk)
    min_I=double(min(stk(i).data(:)));
    max_I=double(max(stk(i).data(:)));
    if min_I < im_min
        im_min=min_I;
    end
    if max_I > im_max
        im_max=max_I;
    end
end

im=zeros(stk(1).width, stk(1).height-2,length(stk));
immean=zeros(1024,1022);
for i=1:length(stk)
    im(:,:,i)=mat2gray(stk(i).data(1:1024,3:1024), [im_min im_max]);
    immean=immean+im(:,:,i);
end
immean=mat2gray(immean);
clear stk
%%
% mask=roipoly(im(:,:,7));
mask=roipoly(immean);

infile=sprintf('celldata%03d.mat',N);
load([path infile],'ax');

tmp=bwlabel(im2bw(immean,graythresh(immean)));
n=round(size(ax,2)/2);
worm_id=tmp(round(ax(2,n)),round(ax(1,n)));
wormmask=ismember(tmp,worm_id);
%%
H = -fspecial('log',15,1.5);
spot=[];
ths=[];

Nmask=length(find(mask>0));
% C=zeros(1024,1022,25);
for i=1:25
    A=squeeze(im(:,:,i));
    B = imfilter(A,H,'replicate');
    B(find(B<0))=0;
    B=mat2gray(B);    
    % imshow(B)

    %
    dmin=0.01;
    cont=1; th=0.5; 
    th_l=0; th_h=1;
    dth=(th_h-th_l)/2;
    while dth>dmin/2
%         tmp=im2bw(B(X,Y),th);
        tmp=im2bw(mask.*B,th);
        r=find(tmp>0);
        f=length(find(tmp>0))/Nmask;

%         if isempty(r)
%         if f<4e-4
        Nspots=length(r);
        if Nspots/Nmask<2e-4
            th_h=th;
            dth=(th_h-th_l)/2;
            th=th-dth;
        else
            th_l=th;
            dth=(th_h-th_l)/2;
            th=th+dth;
        end
    %     [th_l th_h]
    end
    ths(i)=th_h;
    plot(ths); getframe;

    C=logical(wormmask.*im2bw(B,ths(i)));
    bwl=bwlabel(C);
    rp=regionprops(bwl, 'centroid');
    for j=1:length(rp)
        spot=[spot; rp(j).Centroid i];
    end
    
%     C(:,:,i)=logical(im2bw(B(:,:,i),th));
end
% imshow([A C(:,:,i)])
%%
for i=1:25
    imshow(im(:,:,i));
    hold on;
    r=find(spot(:,3)==i);
    plot(spot(r,1),spot(r,2), 'o');
    hold off;
    getframe
end

%% 
chk=zeros(1,size(spot,1));
sp=[];

spfound=1;
for i=1:size(spot,1)
    
    if chk(i) ~= 1
        % find other spots that can merge with this spot
        mergelist=i;
        z1=spot(i,3);
        for j=1:size(spot,1)
            if i ~= j
                z2=spot(j,3);
                if abs(z2-z1)<=2
                    dx=spot(i,1)-spot(j,1);
                    dy=spot(i,2)-spot(j,2);
                    if dx^2+dy^2<4
                        mergelist=[mergelist j];
                        chk(j)=1;
                    end
                end
            end
        end

        %
        if length(mergelist>1)
    %         mergelist
            sp(spfound,1)=mean(spot(mergelist,1));
            sp(spfound,2)=mean(spot(mergelist,2));
            sp(spfound,3)=round(mean(spot(mergelist,3)));
            spfound=spfound+1;
        end
    end
end

%%

c=jet(25);
for i=1:25
    imshow(im(:,:,i));
    hold on;
    for j=1:i
        r=find(sp(:,3)==j);
        plot(sp(r,1),sp(r,2), '.', 'color', c(j,:));
    end
    hold off;
    getframe
end

%% make spline of worm axis

% calculate normals and lengths of each segment of user generated axis
% r=find(VPC(1,:)>0);
% ax_dx=diff(VPC(1,r));
% ax_dy=diff(VPC(2,r));
ax_dx=diff(ax(1,:));
ax_dy=diff(ax(2,:));
ax_dr=sqrt(ax_dx.^2+ax_dy.^2);
ax_length=cumsum(ax_dr);
ax_normal=-[ax_dx./ax_dr; ax_dy./ax_dr];

% total length of worm in pixels.
Ltot=ax_length(end);

% for a resolution of ~2 points per pixel, calculate ds
ds=1/(2*Ltot);

% calculate a spline through axis with 0.5 pixel resolution
% x=VPC(1,r);        
% y=VPC(2,r);
x=ax(1,:);        
y=ax(2,:);
yy=[x; y];
xx=1:length(x);
xxx=1:(ds*length(x)):length(x);
pp=spline(xx,yy,xxx);

% calculate normal and lengtha of spline segments
pp_dx=diff(pp(1,:));
pp_dy=diff(pp(2,:));
pp_dr=sqrt(pp_dx.^2+pp_dy.^2);
pp_length=cumsum(pp_dr);
pp_normal=-[pp_dx./pp_dr; pp_dy./pp_dr];

imshow(immean, 'In', 75);
hold on;

plot(ax(1,:), ax(2,:), 'sr');
% plot(VPC(1,r), VPC(2,r), 'sr');
plot(pp(1,:), pp(2,:), '-r');
plot(sp(:,1),sp(:,2), 'o');

mRNA=sp;

% ax=VPC(1:2,r);
% find coordinates with respect to body axis for VPCs
for t=1:length(sp)

    x2=sp(t,1:2)';
    DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal);
    mRNA(t,1)=DX(1);
    mRNA(t,2)=DX(2);
    mRNA(t,3)=sp(t,3);
end
% save([path outfile],'sp', 'mRNA');

%% for use with coordinates with respect to body axis
load([path infile], 'VPC');
q=find(VPC(4,:)>0);

% determine orientation of VPCs with respect to axis
if VPC(5,q(1))<0
    r=find(mRNA(:,2)<0);
else
    r=find(mRNA(:,2)>0);
end

subplot(2,1,1);
plot(mRNA(r,1), mRNA(r,2), '.');
xlim([0 1300]);
subplot(2,1,2);
% plot(mRNA(r,1))
x=0:10:1300;
h=hist(mRNA(r,1),x);
plot(x,h); hold on;
for i=1:11
    plot(VPC(4,i)*[1 1], [0 100], '--k');
end
hold off;
ylim([0 max(h)]);
xlim([0 1300]);
%% for use with coordinates with respect to VPCs
% r=find(abs(mRNA(:,2))<10);
% subplot(2,1,1);
% plot(mRNA(r,1), mRNA(r,2), '.');
% xlim([0 1200]);
% subplot(2,1,2);
% % plot(mRNA(r,1))
% x=0:50:1100;
% h=hist(mRNA(r,1),x);
% plot(x,h); hold on;
% for i=1:11
%     plot(VPC(4,i)*[1 1], [0 100], '--k');
% end
% hold off;
% ylim([0 max(h)]);
% xlim([0 1200]);
% 

