% this version is used to find VPCs, AC and DTCs, using Lag-2 Cy5 in one of
% the channels

clear all;

mag=85;
channels={'dapi','A594','Cy5'};

[filename,path]=uigetfile('dapi*', 'DialogTitle', 'E:\worm\4-13-2009\lin12A594_lag2Cy5_12.30pm/');

N=sscanf(filename, 'dapi%d');
extension=['.tif'];

%% load all channels

for i=1:length(channels)
    infile=sprintf(['%s%03d' extension], channels{i}, N)
    
    tmp = tiffread2c([path infile]);
    data(i).im = cat(3, tmp.data);
end

%% read in projections, get threshold limits
proj_path=[path 'analyzed\projections\'];

N=sscanf(filename, 'dapi%d');
infile=sprintf('dapi%03d_max.tif',N);
dapi_proj=mat2gray(imread([proj_path infile]));
th(1).dat=stretchlim(dapi_proj, 1e-3);
dapi_proj=mat2gray(dapi_proj,th(1).dat);

infile=sprintf('cy5%03d_mean.tif',N);
cy5_proj=mat2gray(imread([proj_path infile]));
th(2).dat=stretchlim(cy5_proj, 1e-5);
cy5_proj=mat2gray(cy5_proj,th(2).dat);

infile=sprintf('A594%03d_mean.tif',N);
A594_proj=mat2gray(imread([proj_path infile]));
th(3).dat=stretchlim(A594_proj, 1e-3);
A594_proj=mat2gray(A594_proj,th(3).dat);

%% get axis from max projection, from front to back

ax=[];

cont=1;
while cont==1

    imshow(dapi_proj,[],'In', mag); hold on;
    if ~isempty(ax)
        plot(ax(1,:), ax(2,:), '-sb');
    end

    [x,y,but]=ginput(1);
    
    if but == 1
        n=size(ax,2);
        ax(1,n+1)=x;
        ax(2,n+1)=y;
    end
    
    if but == 3
        n=size(ax,2);
        ax(:,n)=[];
    end
    
    if but == 27
        cont=0;
    end
    
    hold off;

end

%%
% for i=1:11
%     VPC(i).N=0;
%     VPC(i).coord=zeros(5,8);
% end
% AC=zeros(5,1);
% 
% for i=1:2
%     DTC(i).coord=[];
% end
% NDTC=0;

outfile=sprintf('celldata%03d.mat',N);
outpath=[path 'analyzed\matlab_data\'];
load([outpath outfile],'DTC','VPC','AC','ax');
NDTC=1;

%%
Nz=size(data(1).im,3);
z=round(Nz/2);
chn=1;
% ths=[5e-4 1e-5 1e-5];
ths=[5e-4 50e-5 1e-5];

cont=1;
plot_lbl=1;

% th=stretchlim(data(chn).im(:,:,z), ths(chn));
% imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;

z=10;
th=stretchlim(data(2).im(:,:,z), ths(2));
R=imadjust(data(2).im(:,:,z), th,[]);
th=stretchlim(data(3).im(:,:,z), ths(3));
G=imadjust(data(3).im(:,:,z), th,[]);
imshow(makeRGB(R,G,[]), 'In', mag); hold on;
while cont==1
    
    for n=1:length(VPC)
        if VPC(n).N > 0 
            for i=1:VPC(n).N
                plot(VPC(n).coord(1,i), VPC(n).coord(2,i), '.r');
                
                % make and print correct label
                if plot_lbl
                    lbl=dec2bin(i-1,ceil(VPC(n).N/2));
                    r=findstr(lbl,'0'); lbl(r)='p';
                    r=findstr(lbl,'1'); lbl(r)='a';
                    if VPC(n).N==1
                        lbl=[];
                    end
                    lbl=['.p' lbl];
                else
                    lbl=[];
                end
                plot(VPC(n).coord(1,i)+[0 0], VPC(n).coord(2,i)+[0 -40*i+20], 'r', 'linewidth', 2);
                text(VPC(n).coord(1,i)-10, VPC(n).coord(2,i)-40*i, [sprintf('%d', n) lbl], 'Color', [1 0 0], 'Fontsize', 14);
            end
        end
    end
    
    if AC(3,1)~=0
        plot(AC(1,1), AC(2,1), '.r');
        text(AC(1,1)+5, AC(2,1)+5, 'A', 'Color', [1 0 0], 'Fontsize', 14);
    end
    
    for n=1:NDTC
        if ~isempty(DTC(n).coord)
            plot(DTC(n).coord(:,1),DTC(n).coord(:,2), '.r');
            text(DTC(n).coord(1)+5, DTC(n).coord(2)+5, [sprintf('DTC%d', n)], 'Color', [1 0 0], 'Fontsize', 14);
        end
    end
    
    [x,y,but]=ginput(1);
    
    if but >= 48 && but <=57
        if but>48
            n=but-48;
        else
            n=10;
        end
        VPC(n).N=VPC(n).N+1;
        
        m=VPC(n).N;
        VPC(n).coord(1,m)=x;
        VPC(n).coord(2,m)=y;
        VPC(n).coord(3,m)=z;
    end
    
    if but==97
        AC(1,1)=x;
        AC(2,1)=y;
        AC(3,1)=z;
    end
    
    if but==100
        if NDTC<2
            NDTC=NDTC+1;
            DTC(NDTC).coord=[x y z 0 0];
        end
    end

    if but==113
        z=z-1;
        if z<1
            z=1;
        end
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    if but==119
        z=z+1;
        if z>Nz
            z=Nz;
        end
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    
    if but==101
        z=z-5;
        if z<1
            z=1;
        end
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    if but==114
        z=z+5;
        if z>Nz
            z=Nz;
        end
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    
    if but==127
        % delete closest point

        del=[-1 -1 -1]; mindist=666666;
        
        % check distance to AC
        xp=AC(1,1); yp=AC(2,1);
        dist=(xp-x)^2+(yp-y)^2;
        if dist<mindist
            mindist=dist;
            del=[1 -1 -1];
        end
        
        % check distance to VPCs
        for n=1:length(VPC)
            if VPC(n).N > 0 
                for i=1:VPC(n).N
                    xp=VPC(n).coord(1,i);
                    yp=VPC(n).coord(2,i);
                    dist=(xp-x)^2+(yp-y)^2;
                    if dist<mindist
                        mindist=dist;
                        del=[2 n i];
                    end
                end
            end
        end
        
        % check distance to DTCs
        for n=1:NDTC
            if (~isempty(DTC(n).coord))
                xp=DTC(n).coord(1);
                yp=DTC(n).coord(2);
                dist=(xp-x)^2+(yp-y)^2;
                if dist<mindist
                    mindist=dist;
                    del=[2+n n n];
                end
            end
        end

        if del(1)==1
            % delete AC
            AC=zeros(5,1);
        elseif del(1)==2
            % delete VPC
            n=del(2); i=del(3);
            m=VPC(n).N;
            VPC(n).coord(:,i)=VPC(n).coord(:,m);
            VPC(n).coord(:,m)=zeros(5,1);
            VPC(n).N=VPC(n).N-1;
        elseif del(1)>2
            % delete mRNA containing cell
            n=del(2); i=del(3);
            m=NDTC;
            DTC(n).coord=DTC(m).coord;
            DTC(m).coord=zeros(5,1);
            NDTC=NDTC-1;
        end
        
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
        
    end

    if but==122
        chn=1;
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    
    if but==120
        chn=2;
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end

    if but==99
        chn=3;
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end

    if but==108
        if plot_lbl==1
            plot_lbl=0;
        else
            plot_lbl=1;
        end
    end
        
    if but==27
        cont=0;
    end
end
%% make spline of worm axis

% calculate normals and lengths of each segment of user generated axis
ax_dx=diff(ax(1,:));
ax_dy=diff(ax(2,:));
ax_dr=sqrt(ax_dx.^2+ax_dy.^2);
ax_length=cumsum(ax_dr);
ax_normal=-[ax_dx./ax_dr; ax_dy./ax_dr];

% total length of worm in pixels.
Ltot=ax_length(end);

% for a resolution of ~2 points per pixel, calculate ds
ds=1/(2*Ltot);

% calculate a spline through axis with 0.5 pixel resolution
x=ax(1,:);        
y=ax(2,:);
yy=[x; y];
xx=1:length(x);
xxx=1:(ds*length(x)):length(x);
pp=spline(xx,yy,xxx);

% calculate normal and lengtha of spline segments
pp_dx=diff(pp(1,:));
pp_dy=diff(pp(2,:));
pp_dr=sqrt(pp_dx.^2+pp_dy.^2);
pp_length=cumsum(pp_dr);
pp_normal=-[pp_dx./pp_dr; pp_dy./pp_dr];

imshow(mat2gray(dapi_proj), 'In', mag); hold on;

plot(ax(1,:), ax(2,:), 'sr');
plot(pp(1,:), pp(2,:), '-r');

for n=1:length(VPC)
    if VPC(n).N > 0 
        for i=1:VPC(n).N
            plot(VPC(n).coord(1,i), VPC(n).coord(2,i), '.r');

            % make and print correct label
            if plot_lbl
                lbl=dec2bin(i-1,ceil(VPC(n).N/2));
                r=findstr(lbl,'0'); lbl(r)='p';
                r=findstr(lbl,'1'); lbl(r)='a';
                if VPC(n).N==1
                    lbl=[];
                end
                lbl=['.p' lbl];
            else
                lbl=[];
            end
            text(VPC(n).coord(1,i)+5, VPC(n).coord(2,i)+5, [sprintf('%d', n) lbl], 'Color', [1 0 0]);
        end
    end
end

if AC(3,1)~=0
    plot(AC(1,1), AC(2,1), '.r');
    text(AC(1,1)+5, AC(2,1)+5, 'A', 'Color', [1 0 0]);
end

for n=1:NDTC
    plot(DTC(n).coord(1),DTC(n).coord(2), '.m');
    text(DTC(n).coord(1)+5, DTC(n).coord(2)+5, [sprintf('D%d', n)], 'Color', [1 0 1]);
end


% find coordinates with respect to body axis for VPCs
for t=1:length(VPC)

    if VPC(t).N > 0

        for i=1:VPC(t).N
            x2=VPC(t).coord(1:2,i);
            DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal,1);

            VPC(t).coord(4,i)=DX(1);
            VPC(t).coord(5,i)=DX(2);
        end
    end
end

% find coordinates with respect to body axis for ACs
x2=AC(1:2,1);
DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal,1);

AC(4,1)=DX(1);
AC(5,1)=DX(2);

% find coordinates with respect to body axis for gonad
for n=1:NDTC
    x2=DTC(n).coord(1:2)';
    DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal,1);

    DTC(n).coord(4)=DX(1);
    DTC(n).coord(5)=DX(2);
end

%%
% figure(2)
% title(filename)
% 
% plot([0 ax_length], zeros(1,length(ax_length)+1),'-ob');
% hold on;
% 
% col=hsv(4);
% for t=1:length(VPC)
% 
%     if VPC(t).N > 0
%         for i=1:VPC(t).N
%             if t~=6
%                 plot(VPC(t).coord(4,i),-VPC(t).coord(5,i), 'o', 'Color', col(VPC(t).N,:));
%             else
%                 plot(VPC(t).coord(4,i),-VPC(t).coord(5,i), 's', 'Color', col(VPC(t).N,:));
%             end
%         end
%     end
% end
% 
% plot(AC(4,1), -AC(5,1), 'sg');
% 
% xlim([0 ax_length(end)]);
% ylim(ax_length(end)/4*[-1 1]);

%%
outfile=sprintf('celldata%03d.mat',N);
outpath=[path 'analyzed\matlab_data\'];
save([outpath outfile],'DTC','VPC','AC','ax');
