% this version is used to find *all* cells that show fluorescence, not just
% Pn.ps, AC and DTCs.

clear all;

mag=85;
channels={'dapi','A594','Cy5'};

[filename,path]=uigetfile('dapi*', 'DialogTitle', 'e:/worm/4-13-2009/lin12A594_lag2Cy5_10.30am/');

N=sscanf(filename, 'dapi%d');
extension=['.tif'];

%% load all channels

for i=1:length(channels)
    infile=sprintf(['%s%03d' extension], channels{i}, N)
    
    tmp = tiffread2c([path infile]);
    data(i).im = cat(3, tmp.data);
end

%% read in projections, get threshold limits
proj_path=[path 'analyzed\projections\'];

N=sscanf(filename, 'dapi%d');
infile=sprintf('dapi%03d_max.tif',N);
dapi_proj=mat2gray(imread([proj_path infile]));
th(1).dat=stretchlim(dapi_proj, 1e-3);
dapi_proj=mat2gray(dapi_proj,th(1).dat);

infile=sprintf('cy5%03d_mean.tif',N);
cy5_proj=mat2gray(imread([proj_path infile]));
th(2).dat=stretchlim(cy5_proj, 1e-5);
cy5_proj=mat2gray(cy5_proj,th(2).dat);

infile=sprintf('A594%03d_mean.tif',N);
A594_proj=mat2gray(imread([proj_path infile]));
th(3).dat=stretchlim(A594_proj, 1e-3);
A594_proj=mat2gray(A594_proj,th(3).dat);

%% get axis from max projection, from front to back

ax=[];

cont=1;
while cont==1

    imshow(dapi_proj,[],'In', mag); hold on;
    if ~isempty(ax)
        plot(ax(1,:), ax(2,:), '-sb');
    end

    [x,y,but]=ginput(1);
    
    if but == 1
        n=size(ax,2);
        ax(1,n+1)=x;
        ax(2,n+1)=y;
    end
    
    if but == 3
        n=size(ax,2);
        ax(:,n)=[];
    end
    
    if but == 27
        cont=0;
    end
    
    hold off;

end

%% get gonad from max projection

GND=zeros(5,2);

imshow(cy5_proj,'In', mag); hold on;
[x,y]=ginput(2);
for i=1:2
    GND(1,i)=x(i);
    GND(2,i)=y(i);
end
hold off;
clear im

%%
for i=1:11
    VPC(i).N=0;
    VPC(i).coord=zeros(5,8);
end
AC=zeros(5,1);

for i=1:length(channels)-1
    nucl(i).coord=[];
end

%%
Nz=size(data(1).im,3);
z=round(Nz/2);
chn=1;
ths=[5e-4 1e-5 1e-5];

cont=1;
plot_lbl=1;

th=stretchlim(data(chn).im(:,:,z), ths(chn));
imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;

while cont==1
    
    for n=1:length(VPC)
        if VPC(n).N > 0 
            for i=1:VPC(n).N
                plot(VPC(n).coord(1,i), VPC(n).coord(2,i), '.r');
                
                % make and print correct label
                if plot_lbl
                    lbl=dec2bin(i-1,ceil(VPC(n).N/2));
                    r=findstr(lbl,'0'); lbl(r)='p';
                    r=findstr(lbl,'1'); lbl(r)='a';
                    if VPC(n).N==1
                        lbl=[];
                    end
                    lbl=['.p' lbl];
                else
                    lbl=[];
                end
                text(VPC(n).coord(1,i)+5, VPC(n).coord(2,i)+5, [sprintf('%d', n) lbl], 'Color', [1 0 0]);
            end
        end
    end
    
    if AC(3,1)~=0
        plot(AC(1,1), AC(2,1), '.y');
        text(AC(1,1)+5, AC(2,1)+5, 'A', 'Color', [1 0 0]);
    end
    
    c=hsv(2);
    for n=1:length(channels)-1
        if ~isempty(nucl(n).coord)
            r=find(nucl(n).coord(:,3)==z);
            plot(nucl(n).coord(:,1),nucl(n).coord(:,2), '.', 'color',c(n,:));
            plot(nucl(n).coord(r,1),nucl(n).coord(r,2), 'o', 'color', c(n,:));
        end
    end
    
    [x,y,but]=ginput(1);
    
    if but >= 48 && but <=57
        if but>48
            n=but-48;
        else
            n=10;
        end
        VPC(n).N=VPC(n).N+1;
        
        m=VPC(n).N;
        VPC(n).coord(1,m)=x;
        VPC(n).coord(2,m)=y;
        VPC(n).coord(3,m)=z;
    end
    
    if but==97
        AC(1,1)=x;
        AC(2,1)=y;
        AC(3,1)=z;
    end
    
    if but==110
        nucl(1).coord=[nucl(1).coord; x y z 0 0];
    end

    if but==109
        nucl(2).coord=[nucl(2).coord; x y z 0 0];
    end

    if but==113
        z=z-1;
        if z<1
            z=1;
        end
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    if but==119
        z=z+1;
        if z>Nz
            z=Nz;
        end
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    
    if but==101
        z=z-5;
        if z<1
            z=1;
        end
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    if but==114
        z=z+5;
        if z>Nz
            z=Nz;
        end
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    
    if but==100
        % delete closest point

        del=[-1 -1 -1]; mindist=666666;
        
        % check distance to AC
        xp=AC(1,1); yp=AC(2,1);
        dist=(xp-x)^2+(yp-y)^2;
        if dist<mindist
            mindist=dist;
            del=[1 -1 -1];
        end
        
        % check distance to VPCs
        for n=1:length(VPC)
            if VPC(n).N > 0 
                for i=1:VPC(n).N
                    xp=VPC(n).coord(1,i);
                    yp=VPC(n).coord(2,i);
                    dist=(xp-x)^2+(yp-y)^2;
                    if dist<mindist
                        mindist=dist;
                        del=[2 n i];
                    end
                end
            end
        end
        
        % check distance to other mRNA expressing cells
        for n=1:length(channels)-1
            if (~isempty(nucl(n).coord))
                for i=1:size(nucl(n).coord,1)
                    xp=nucl(n).coord(i,1);
                    yp=nucl(n).coord(i,2);
                    dist=(xp-x)^2+(yp-y)^2;
                    if dist<mindist
                        mindist=dist;
                        del=[2+n n i];
                    end
                end
            end
        end

        if del(1)==1
            % delete AC
            AC=zeros(5,1);
        elseif del(1)==2
            % delete VPC
            n=del(2); i=del(3);
            m=VPC(n).N;
            VPC(n).coord(:,i)=VPC(n).coord(:,m);
            VPC(n).coord(:,m)=zeros(5,1);
            VPC(n).N=VPC(n).N-1;
        elseif del(1)>2
            % delete mRNA containing cell
            n=del(2); i=del(3);
            m=size(nucl(n).coord,1);
            nucl(n).coord(i,:)=nucl(n).coord(m,:);
            nucl(n).coord(m,:)=zeros(5,1);
            nucl(n).coord(m,:)=[];            
        end
        
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
        
    end

    if but==122
        chn=1;
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    
    if but==120
        chn=2;
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end

    if but==99
        chn=3;
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end

    if but==108
        if plot_lbl==1
            plot_lbl=0;
        else
            plot_lbl=1;
        end
    end
        
    if but==27
        cont=0;
    end
end
%% make spline of worm axis

% calculate normals and lengths of each segment of user generated axis
ax_dx=diff(ax(1,:));
ax_dy=diff(ax(2,:));
ax_dr=sqrt(ax_dx.^2+ax_dy.^2);
ax_length=cumsum(ax_dr);
ax_normal=-[ax_dx./ax_dr; ax_dy./ax_dr];

% total length of worm in pixels.
Ltot=ax_length(end);

% for a resolution of ~2 points per pixel, calculate ds
ds=1/(2*Ltot);

% calculate a spline through axis with 0.5 pixel resolution
x=ax(1,:);        
y=ax(2,:);
yy=[x; y];
xx=1:length(x);
xxx=1:(ds*length(x)):length(x);
pp=spline(xx,yy,xxx);

% calculate normal and lengtha of spline segments
pp_dx=diff(pp(1,:));
pp_dy=diff(pp(2,:));
pp_dr=sqrt(pp_dx.^2+pp_dy.^2);
pp_length=cumsum(pp_dr);
pp_normal=-[pp_dx./pp_dr; pp_dy./pp_dr];

imshow(mat2gray(dapi_proj), 'In', mag); hold on;

plot(ax(1,:), ax(2,:), 'sr');
plot(pp(1,:), pp(2,:), '-r');

for n=1:length(VPC)
    if VPC(n).N > 0 
        for i=1:VPC(n).N
            plot(VPC(n).coord(1,i), VPC(n).coord(2,i), '.y');

            % make and print correct label
            lbl=dec2bin(i-1,VPC(n).N-1);
            r=findstr(lbl,'0'); lbl(r)='p';
            r=findstr(lbl,'1'); lbl(r)='a';
            text(VPC(n).coord(1,i)+5, VPC(n).coord(2,i)+5, [sprintf('%d', n) '.p' lbl], 'Color', [1 1 0]);
        end
    end
end

plot(GND(1,:), GND(2,:), '-ob');
plot(AC(1,1), AC(2,1), '.y');
text((AC(1,1)+5), (AC(2,1)+5), 'A', 'Color', [1 1 0]);

for n=1:length(channels)-1
    if ~isempty(nucl(n).coord)
        plot(nucl(n).coord(:,1),nucl(n).coord(:,2), '.b');
    end
end


% find coordinates with respect to body axis for VPCs
for t=1:length(VPC)

    if VPC(t).N > 0

        for i=1:VPC(t).N
            x2=VPC(t).coord(1:2,i);
            DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal,1);

            VPC(t).coord(4,i)=DX(1);
            VPC(t).coord(5,i)=DX(2);
        end
    end
end

% find coordinates with respect to body axis for ACs
x2=AC(1:2,1);
DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal,1);

AC(4,1)=DX(1);
AC(5,1)=DX(2);

% find coordinates with respect to body axis for gonad
for t=1:2

    x2=GND(1:2,t);
    DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal,1);

    GND(4,t)=DX(1);
    GND(5,t)=DX(2);
end

% find coordinates with respect to body axis for gonad
for t=1:2

    x2=GND(1:2,t);
    DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal,1);

    GND(4,t)=DX(1);
    GND(5,t)=DX(2);
end

% find coordinates with respect to body axis for gonad
for n=1:length(channels)-1
    for t=1:size(nucl(n).coord,1)

        x2=nucl(n).coord(t,1:2)';
        DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal,1);

        nucl(n).coord(t,4)=DX(1);
        nucl(n).coord(t,5)=DX(2);
    end
end

%%
figure(2)
title(filename)

plot([0 ax_length], zeros(1,length(ax_length)+1),'-ob');
hold on;

col=hsv(4);
for t=1:length(VPC)

    if VPC(t).N > 0
        for i=1:VPC(t).N
            if t~=6
                plot(VPC(t).coord(4,i),-VPC(t).coord(5,i), 'o', 'Color', col(VPC(t).N,:));
            else
                plot(VPC(t).coord(4,i),-VPC(t).coord(5,i), 's', 'Color', col(VPC(t).N,:));
            end
        end
    end
end

plot(AC(4,1), -AC(5,1), 'sg');

plot(GND(4,:), -GND(5,:), '-k');

c=hsv(length(channels)-1);
for n=1:length(channels)-1
    if ~isempty(nucl(n).coord)
        plot(nucl(n).coord(:,4),-nucl(n).coord(:,5), '.', 'color',c(n,:));
    end
end


xlim([0 ax_length(end)]);
ylim(ax_length(end)/4*[-1 1]);

%%
outfile=sprintf('celldata%03d.mat',N);
outpath=[path 'analyzed\matlab_data\'];
save([outpath outfile],'GND','VPC','AC','ax', 'nucl');
