% this version uses lag-2 to label DTC and AC. All mean or max projections
% are read from file, rather than constructed on the spot

clear all;

[filename,path]=uigetfile('dapi*', 'DialogTitle', 'e:/worm/4-13-2009/lin12A594_lag2Cy5_10.30am/');
im = tiffread2c([path filename]);           %opens stack file(dapi)
n = length(im);           %counts the number of images in stack

mag=85;

%%
proj_path='analyzed\projections\';

N=sscanf(filename, 'dapi%d');
infile=sprintf('dapi%03d_max.tif',N);
dapi_maxproj=imread([path proj_path infile]);

infile=sprintf('cy5%03d_mean.tif',N);
lag2_meanproj=mat2gray(imread([path proj_path infile]));
infile=sprintf('cy5%03d_max.tif',N);
lag2_meanproj=lag2_meanproj+mat2gray(imread([path proj_path infile]));
lag2_meanproj=lag2_meanproj/2;

th=stretchlim(dapi_maxproj, 1e-3);
dapi_maxproj=mat2gray(dapi_maxproj,255*th);

%%

dapi = cat(3, im.data);
Imax=double(max(max(max(dapi))));
dapi = mat2gray(dapi, Imax*th);
clear im;

%% get axis from max projection, from front to back


ax=[];

cont=1;
imshow(dapi_maxproj,[],'In', mag); hold on;
while cont==1

    if ~isempty(ax)
        plot(ax(1,:), ax(2,:), '-sb');
    end

    [x,y,but]=ginput(1);
    
    if but == 1
        n=size(ax,2);
        ax(1,n+1)=x;
        ax(2,n+1)=y;
    end
    
    if but == 27
        cont=0;
    end
end
hold off;

%% get gonad from max projection

GND=zeros(5,2);

im=makeRGB(dapi_maxproj,mat2gray(lag2_meanproj,[graythresh(lag2_meanproj) 0.8])+dapi_maxproj,dapi_maxproj);
imshow(im,[],'In', mag); hold on;
[x,y]=ginput(2);
for i=1:2
    GND(1,i)=x(i);
    GND(2,i)=y(i);
end
hold off;
clear im
%%
for i=1:11
    VPC(i).N=0;
    VPC(i).coord=zeros(5,8);
end
AC=zeros(5,1);

%%
Nz=size(dapi,3);
z=round(Nz/2);

cont=1;

imshow(dapi(:,:,z), 'In', mag); hold on;

while cont==1
    
    plot(ax(1,:), ax(2,:), '-sb');
    plot(GND(1,:), GND(2,:), '-og');
    
    for n=1:length(VPC)
        if VPC(n).N > 0 
            for i=1:VPC(n).N
                plot(VPC(n).coord(1,i), VPC(n).coord(2,i), '.y');
                
                % make and print correct label
                lbl=dec2bin(i-1,VPC(n).N-1);
                r=findstr(lbl,'0'); lbl(r)='p';
                r=findstr(lbl,'1'); lbl(r)='a';
                text(VPC(n).coord(1,i)+5, VPC(n).coord(2,i)+5, [sprintf('%d', n) '.p' lbl], 'Color', [1 1 0]);
            end
        end
    end
    
    if AC(3,1)~=0
        plot(AC(1,1), AC(2,1), '.y');
        text(AC(1,1)+5, AC(2,1)+5, 'A', 'Color', [1 1 0]);
    end
    
    [x,y,but]=ginput(1);
    
    if but >= 48 && but <=57
        if but>48
            n=but-48;
        else
            n=10;
        end
        VPC(n).N=VPC(n).N+1;
        
        m=VPC(n).N;
        VPC(n).coord(1,m)=x;
        VPC(n).coord(2,m)=y;
        VPC(n).coord(3,m)=z;
    end
    
    if but==97
        AC(1,1)=x;
        AC(2,1)=y;
        AC(3,1)=z;
    end
    
    if but==113
        z=z-1;
        if z<1
            z=1;
        end
        hold off;
        imshow(dapi(:,:,z),'In', mag); hold on;
    end
    if but==119
        z=z+1;
        if z>Nz
            z=Nz;
        end
        hold off;
        imshow(dapi(:,:,z), 'In', mag); hold on;
    end
    
    if but==101
        z=z-5;
        if z<1
            z=1;
        end
        hold off;
        imshow(dapi(:,:,z), 'In', mag); hold on;
    end
    if but==114
        z=z+5;
        if z>Nz
            z=Nz;
        end
        hold off;
        imshow(dapi(:,:,z), 'In', mag); hold on;
    end
    
    if but==100
        % delete closest point

        del=[-1 -1]; mindist=666666;
        % find closest VPC
        for n=1:length(VPC)
            if VPC(n).N > 0 
                for i=1:VPC(n).N
                    xp=VPC(n).coord(1,i);
                    yp=VPC(n).coord(2,i);
                    dist=(xp-x)^2+(yp-y)^2;
                    if dist<mindist
                        mindist=dist;
                        del=[n i];
                    end
                end
            end
        end
        
        % if AC is closer delete that, otherwise delete closest VPC
        xp=AC(1,1); yp=AC(2,1);
        dist=(xp-x)^2+(yp-y)^2;
        if dist<mindist
            % delete AC
            AC=zeros(5,1);
        else
            % delete VPC
            n=del(1); i=del(2);
            m=VPC(n).N;
            VPC(n).coord(:,i)=VPC(n).coord(:,m);
            VPC(n).coord(:,m)=zeros(5,1);
            VPC(n).N=VPC(n).N-1;
%             del
        end
        
        hold off;
        imshow(dapi(:,:,z), 'In', mag); hold on;
        
    end
    
    if but==32
        imshow(makeRGB(dapi(:,:,z),mat2gray(lag2_meanproj,[graythresh(lag2_meanproj) 0.9])+dapi(:,:,z),dapi(:,:,z)), 'In', mag); hold on;
    end
    
    if but==27
        cont=0;
    end
end
% VPC(1:2,:)=VPC(1:2,:)/0.75;
% AC(1:2,:)=AC(1:2,:)/0.75;
%% make spline of worm axis

% calculate normals and lengths of each segment of user generated axis
ax_dx=diff(ax(1,:));
ax_dy=diff(ax(2,:));
ax_dr=sqrt(ax_dx.^2+ax_dy.^2);
ax_length=cumsum(ax_dr);
ax_normal=-[ax_dx./ax_dr; ax_dy./ax_dr];

% total length of worm in pixels.
Ltot=ax_length(end);

% for a resolution of ~2 points per pixel, calculate ds
ds=1/(2*Ltot);

% calculate a spline through axis with 0.5 pixel resolution
x=ax(1,:);        
y=ax(2,:);
yy=[x; y];
xx=1:length(x);
xxx=1:(ds*length(x)):length(x);
pp=spline(xx,yy,xxx);

% calculate normal and lengtha of spline segments
pp_dx=diff(pp(1,:));
pp_dy=diff(pp(2,:));
pp_dr=sqrt(pp_dx.^2+pp_dy.^2);
pp_length=cumsum(pp_dr);
pp_normal=-[pp_dx./pp_dr; pp_dy./pp_dr];
%%
imshow(mat2gray(dapi_maxproj), 'In', mag); hold on;

plot(ax(1,:), ax(2,:), 'sr');
plot(pp(1,:), pp(2,:), '-r');

for n=1:length(VPC)
    if VPC(n).N > 0 
        for i=1:VPC(n).N
            plot(VPC(n).coord(1,i), VPC(n).coord(2,i), '.y');

            % make and print correct label
            lbl=dec2bin(i-1,VPC(n).N-1);
            r=findstr(lbl,'0'); lbl(r)='p';
            r=findstr(lbl,'1'); lbl(r)='a';
            text(VPC(n).coord(1,i)+5, VPC(n).coord(2,i)+5, [sprintf('%d', n) '.p' lbl], 'Color', [1 1 0]);
        end
    end
end

plot(GND(1,:), GND(2,:), '-ob');
plot(AC(1,1), AC(2,1), '.y');
text((AC(1,1)+5), (AC(2,1)+5), 'A', 'Color', [1 1 0]);

% find coordinates with respect to body axis for VPCs
for t=1:length(VPC)

    if VPC(t).N > 0

        for i=1:VPC(t).N
            [t i]
            x2=VPC(t).coord(1:2,i);
            DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal);

            VPC(t).coord(4,i)=DX(1);
            VPC(t).coord(5,i)=DX(2);
        end
    end
end

% find coordinates with respect to body axis for ACs
x2=AC(1:2,1);
DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal);

AC(4,1)=DX(1);
AC(5,1)=DX(2);

% find coordinates with respect to body axis for gonad
for t=1:2

    x2=GND(1:2,t);
    DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal);

    GND(4,t)=DX(1);
    GND(5,t)=DX(2);
end


%%
figure(2)

plot([0 ax_length], zeros(1,length(ax_length)+1),'-ob');
hold on;

col=hsv(4);
for t=1:length(VPC)

    if VPC(t).N > 0
        for i=1:VPC(t).N
            if t~=6
                plot(VPC(t).coord(4,i),-VPC(t).coord(5,i), 'o', 'Color', col(VPC(t).N,:));
            else
                plot(VPC(t).coord(4,i),-VPC(t).coord(5,i), 's', 'Color', col(VPC(t).N,:));
            end
        end
    end
end

plot(AC(4,1), -AC(5,1), 'sg');

plot(GND(4,:), -GND(5,:), '-k');


xlim([0 ax_length(end)]);
ylim(ax_length(end)/4*[-1 1]);

%%
N=sscanf(filename, 'dapi%d');
outfile=sprintf('celldata%03d.mat',N);
save([path outfile],'GND','VPC','AC','ax');
