% this version is used to separate the VPCs and AC in the worm from the
% rest of the worm so that they can be analyzed separatedly

clear all;

mag=85;
channels={'dapi','A594','Cy5'};

[filename,path]=uigetfile('dapi*', 'DialogTitle', 'e:/worm/4-13-2009/lin12A594_lag2Cy5_12.30pm/');

extension='.tif';
N=sscanf(filename, 'dapi%d');

%% load all channels

for i=1:length(channels)
    infile=sprintf('%s%03d%s', channels{i}, N, extension)
    
    tmp = tiffread2c([path infile]);
    data(i).im = cat(3, tmp.data);
end

%% read in projections, get threshold limits
proj_path=[path 'analyzed\projections\'];

N=sscanf(filename, 'dapi%d');
infile=sprintf('dapi%03d_max.tif',N);
dapi_proj=mat2gray(imread([proj_path infile]));
th(1).dat=stretchlim(dapi_proj, 1e-3);
dapi_proj=mat2gray(dapi_proj,th(1).dat);

infile=sprintf('cy5%03d_mean.tif',N);
cy5_proj=mat2gray(imread([proj_path infile]));
th(2).dat=stretchlim(cy5_proj, 1e-5);
cy5_proj=mat2gray(cy5_proj,th(2).dat);

infile=sprintf('A594%03d_mean.tif',N);
A594_proj=mat2gray(imread([proj_path infile]));
th(3).dat=stretchlim(A594_proj, 1e-3);
A594_proj=mat2gray(A594_proj,th(3).dat);

%%
border=[];

%%
Nz=size(data(1).im,3);
z=round(Nz/2);
chn=1;
ths=[5e-4 1e-5 1e-5];

cont=1;

th=stretchlim(data(chn).im(:,:,z), ths(chn));
imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;

while cont==1
    
    if ~isempty(border)
        plot(border(1,:), border(2,:), '-sb');
    end
    
    [x,y,but]=ginput(1);
    
    if but == 1
        n=size(border,2);
        border(1,n+1)=x;
        border(2,n+1)=y;
    end
    
    if but == 3
        n=size(border,2);
        border(:,n)=[];
    end

    if but==113
        z=z-1;
        if z<1
            z=1;
        end
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    if but==119
        z=z+1;
        if z>Nz
            z=Nz;
        end
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    
    if but==101
        z=z-5;
        if z<1
            z=1;
        end
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    if but==114
        z=z+5;
        if z>Nz
            z=Nz;
        end
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    
    if but==122
        chn=1;
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
    
    if but==120
        chn=2;
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end

    if but==99
        chn=3;
        hold off;
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        imshow(imadjust(data(chn).im(:,:,z), th,[]), 'In', mag); hold on;
    end
   
    if but==27
        cont=0;
    end
end
%%
SX=size(data(chn).im,1);
SY=size(data(chn).im,2);
tmp=data(1).im(:,:,14);

VPCmask=roipoly(SX,SY,border(1,:), border(2,:));

%%
infile=sprintf('%s%03d_spotdata.mat',channels{2},N);
inpath=[path 'analyzed\matlab_data\'];
load([inpath infile], 'merged_spot');

infile=sprintf('celldata%03d.mat',N);
inpath=[path 'analyzed\matlab_data\'];
load([inpath infile], 'VPC');

%%
cm=jet(25);
imshow(tmp); hold on;
for i=1:length(merged_spot)
    x=ceil(merged_spot(i,1));
    y=ceil(merged_spot(i,2));
    z=ceil(merged_spot(i,3));
    if VPCmask(y,x)
        plot(x,y,'.','color', cm(z,:))
    end
end

for n=1:length(VPC)
    if VPC(n).N > 0 
        for i=1:VPC(n).N
            plot(VPC(n).coord(1,i), VPC(n).coord(2,i), 'ow');
        end
    end
end

hold off;

%%
outfile=sprintf('VPCmask%03d.mat',N);
outpath=[path 'analyzed\matlab_data\'];
save([outpath outfile],'border');
