% clear all;

halfwidth=2*75;           %approximate thickness of the worm
Npix=10;
Nmax=1024;                %camera pixel property (for 1024x1024 pixels)

[filename,path]=uigetfile('dapi*.stk', 'DialogTitle', 'e:/worm/3-25-2009/lin12_11am/');
im = tiffread2c([path filename]);           %opens stack file(dapi)
n = length(im);           %counts the number of images in stack
%%

dapi = cat(3, im.data);    %construct 3d array with stack images
dapi = double(dapi);       %convert to 'double'
clear im;


maxproj = double(zeros(Nmax, Nmax));                  %maximum Z-projection

for i=1:1:Nmax
    
    for j=1:1:Nmax
        
        
        m = max(dapi(i,j,:));
        maxproj(i,j) = m;
        
        
    end
end

dapi2=[];
for i=1:size(dapi,3)
    dapi2(:,:,i)=uint8(255*mat2gray(imresize(squeeze(dapi(:,:,i)),0.75)));
end
clear dapi
%% get axis from max projection, from front to back


ax=[];

cont=1;
imshow(maxproj,[],'In', 75); hold on;
while cont==1

    if ~isempty(ax)
        plot(ax(1,:), ax(2,:), '-sb');
    end

    [x,y,but]=ginput(1);
    
    if but == 1
        n=size(ax,2);
        ax(1,n+1)=x;
        ax(2,n+1)=y;
    end
    
    if but == 27
        cont=0;
    end
end
hold off;

%% get gonad from max projection

GND=zeros(5,2);

imshow(maxproj,[],'In', 75); hold on;
[x,y]=ginput(2);
for i=1:2
    GND(1,i)=x(i);
    GND(2,i)=y(i);
end
hold off;

%%
Nz=size(dapi2,3);
z=round(Nz/2);

cont=1;

VPC=zeros(5,11);
AC=zeros(5,1);
imshow(dapi2(:,:,z),gray(255)); hold on;

while cont==1
    
    plot(0.75*ax(1,:), 0.75*ax(2,:), '-sb');
    plot(0.75*GND(1,:), 0.75*GND(2,:), '-og');
    
    for n=1:size(VPC,2)
        if VPC(3,n) ~= 0 
            plot(VPC(1,n), VPC(2,n), '.y');
            text(VPC(1,n)+5, VPC(2,n)+5, sprintf('%d', n), 'Color', [1 1 0]);
        end
    end
    
    if AC(3,1)~=0
        plot(AC(1,1), AC(2,1), '.y');
        text(AC(1,1)+5, AC(2,1)+5, 'A', 'Color', [1 1 0]);
    end
    
    [x,y,but]=ginput(1);
    
    if but >= 48 && but <=57
        if but>48
            n=but-48;
        else
            n=10;
        end
        VPC(1,n)=x;
        VPC(2,n)=y;
        VPC(3,n)=z;
    end
    
    if but==97
        AC(1,1)=x;
        AC(2,1)=y;
        AC(3,1)=z;
    end
    
    if but==113
        z=z-1;
        if z<1
            z=1;
        end
        imshow(dapi2(:,:,z),gray(255)); hold on;
    end
    if but==119
        z=z+1;
        if z>Nz
            z=Nz;
        end
        imshow(dapi2(:,:,z),gray(255)); hold on;
    end
    
    if but==101
        z=z-5;
        if z<1
            z=1;
        end
        imshow(dapi2(:,:,z),gray(255)); hold on;
    end
    if but==114
        z=z+5;
        if z>Nz
            z=Nz;
        end
        imshow(dapi2(:,:,z),gray(255)); hold on;
    end
    
    if but==27
        cont=0;
    end
end
VPC(1:2,:)=VPC(1:2,:)/0.75;
AC(1:2,:)=AC(1:2,:)/0.75;
hold off;
%% make spline of worm axis

% calculate normals and lengths of each segment of user generated axis
ax_dx=diff(ax(1,:));
ax_dy=diff(ax(2,:));
ax_dr=sqrt(ax_dx.^2+ax_dy.^2);
ax_length=cumsum(ax_dr);
ax_normal=-[ax_dx./ax_dr; ax_dy./ax_dr];

% total length of worm in pixels.
Ltot=ax_length(end);

% for a resolution of ~2 points per pixel, calculate ds
ds=1/(2*Ltot);

% calculate a spline through axis with 0.5 pixel resolution
x=ax(1,:);        
y=ax(2,:);
yy=[x; y];
xx=1:length(x);
xxx=1:(ds*length(x)):length(x);
pp=spline(xx,yy,xxx);

% calculate normal and lengtha of spline segments
pp_dx=diff(pp(1,:));
pp_dy=diff(pp(2,:));
pp_dr=sqrt(pp_dx.^2+pp_dy.^2);
pp_length=cumsum(pp_dr);
pp_normal=-[pp_dx./pp_dr; pp_dy./pp_dr];
%%
imshow(mat2gray(maxproj), 'In', 75); hold on;

plot(ax(1,:), ax(2,:), 'sr');
plot(pp(1,:), pp(2,:), '-r');
for i=1:size(VPC,2)
    if VPC(3,i) ~= 0 
        plot(VPC(1,i), VPC(2,i), '.y');
        text((VPC(1,i)+5), (VPC(2,i)+5), sprintf('%d', i), 'Color', [1 1 0]);
    end
end
plot(GND(1,:), GND(2,:), '-ob');
plot(AC(1,1), AC(2,1), '.y');
text((AC(1,1)+5), (AC(2,1)+5), 'A', 'Color', [1 1 0]);

% find coordinates with respect to body axis for VPCs
for t=1:11

    if VPC(3,t) ~= 0

        x2=VPC(1:2,t);
        DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal);
        
        VPC(4,t)=DX(1);
        VPC(5,t)=DX(2);
        
    end
end
%%
% find coordinates with respect to body axis for ACs
x2=AC(1:2,1);
DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal);

AC(4,1)=DX(1);
AC(5,1)=DX(2);

% find coordinates with respect to body axis for gonad
for t=1:2

    x2=GND(1:2,t);
    DX = findAxisIntersection (x2, ax, ax_dr, ax_length, ax_normal, pp, pp_dr, pp_length, pp_normal);

    GND(4,t)=DX(1);
    GND(5,t)=DX(2);
end


%%
figure(2)

plot([0 ax_length], zeros(1,length(ax_length)+1),'-ob');
hold on;

plot(VPC(4,:), -VPC(5,:), 'ok');
plot(VPC(4,6), -VPC(5,6), 'or');

plot(AC(4,1), -AC(5,1), 'og');

plot(GND(4,:), -GND(5,:), '-k');


xlim([0 ax_length(end)]);
ylim(ax_length(end)/4*[-1 1]);

%%
N=sscanf(filename, 'dapi%d');
outfile=sprintf('celldata%03d.mat',N);
save([path outfile],'maxproj','GND','VPC','AC','ax');
