function [ dSdt ] = chemostat_2nutrient_dynamics(t,S,params)
% this function defines the chemostat differential equation
%
% get the individual parameters from the vector
%
q    = params(1);
u    = params(2);
r    = params(3);
K    = params(4);
E    = params(5);
L    = params(6);
F    = params(7);
v    = params(8);
%
% initialize the state's derivative
%
dSdt = zeros(size(S));
%
% put things in terms of individual variables
%
x = S(1); % cells
y = S(2); % glucose
z = S(3); % ammonium
%
% form the differential equation formulae
%
dxdt = r*y*((y*z))/((y+K)*(z+L))-q*x;
dydt  = -E*r*x*((y*z))/((y+K)*(z+L))-q*y+q*u;
dzdt  =-F*r*x*((y*z))/((y+K)*(z+L))-q*z+q*v;
%
% put things back in terms of state vector variable
%
dSdt(1) = dxdt;
dSdt(2) = dydt;
dSdt(3) = dzdt;
end