close all;
shortnoise = load('shortnoise.txt');
% conversion_factor = 173.5826; %(nm/V)
conversion_factor = 0.0070;
conversion_factor2 = conversion_factor*.1; %(Angstroms/V)
f = shortnoise(:,1);
raw_specd = shortnoise(:,2); %V^2/hz
% specd = conversion_factor2^2*raw_specd; %A^2/hz
specd = conversion_factor2^2*raw_specd/1000; %A^2/hz, gain of 1000
figure(1);
loglog(f,specd,'k');
hold on;
loglog(f(25:end),specd(25:end),'b')
xlabel('Frequency (hz)');
ylabel('Power spectral density (A/hz^{1/2})');

xdata = f(25:end);
ydata = specd(25:end);

f_guess = 15000;
Q_guess = 29;
options=optimset('TolFun',1e-50,'tolX',1e-30);
p=lsqcurvefit('scaling',[f_guess Q_guess], xdata, ydata, [], [], options, ydata);

A=(transfunc(p,f))\specd;

Gfit = A*transfunc(p,f);
% figure(2);
% loglog(f, Gfit);
% xlabel('Frequency (hz)');
% ylabel('Power spectral density (A^2/hz)');
% title('Fitted PSD curve, G(\omega)');

figure(1);
% loglog(f(floor(end/24):end), Gfit(floor(end/24):end),'r','LineWidth',2);
loglog(f,Gfit,'r','LineWidth',2);
legend('Raw PSD','Cropped PSD','G(\omega), fitted curve');
title('Power spectral densities for calculation of Boltzmann''s constant, short cantilever');

Q = p(2); % unitless
f_0 = p(1); % hz
omega_0 = 2*pi*f_0; % angular frequency

E = 250e9; % Pa
rho_c = 3400; % kg/m3
L = 275e-6; % m
b = 50e-6;
h = .8e-6;
T = 298; % Kelvin
f_0_vac = f_0 / .98; % vacuum is 2% higher than air
k_s1 = (E*b*h^3)/(4*L^3); % beam theory
k_s2 = .2427*rho_c*h*b*L*omega_0^2; % sader
k_s = (k_s1+k_s2)/2; % avg constant
k_b = (Q*k_s*omega_0*A^2)/(4*T)