close all;
clear all;

calib = load('short_calib.txt');
begin=120;
stop=370;
lambda = 635; % nm
gain = 2;
v_p = calib(:,1);
v_pd = calib(:,2)/gain;
lambda_4 = lambda/4; % quarter wavelength
l_id = (175+93)/2*1000; % nm
l_t = 275*1000; % nm
m = l_id/l_t;
Acorr = 2/(3*m^2-m^3); % correction factor
C1 = lambda_4/(v_p(248)-v_p(255)); % conversion factor, nm/V
v_pd = v_pd * Acorr;
pos = C1*v_p; % position vector
plot(pos(begin:stop),v_pd(begin:stop));
hold on;
plot(pos(248:263),v_pd(248:263),'r');
% plot(pos(248:255),v_pd(248:255),'g');
xlabel('Distance traveled by probe (nm)');
ylabel('Observed intensity (V)');
legend('Z-mod scan','Slope derived from section',0);
title('Short cantilever calibration');

grad = (pos(248)-pos(263))/(v_pd(248)-v_pd(263));
C2 = abs(1/grad) %nm/V
