close all;
clear all;
calib = load('long_calib.txt');
begin=120;
stop=370;
lambda = 635; % nm
gain = 2;
v_p = calib(:,1);
v_pd = calib(:,2)/gain;
lambda_4 = lambda/4; % quarter wavelength
l_id = (140+250)/2*1000; % nm
l_t = 350*1000; % nm
m = l_id/l_t;
Acorr = 2/(3*m^2-m^3); % correction factor
C1 = lambda_4/(v_p(228)-v_p(240)); % conversion factor, nm/V
v_pd = v_pd * Acorr;
pos = C1*v_p; % position vector
plot(pos(begin:stop),v_pd(begin:stop));
hold on;
plot(pos(228:252),v_pd(228:252),'r');
% plot(pos(228:240),v_pd(228:240),'g');
xlabel('Distance traveled by probe (nm)');
ylabel('Observed intensity (V)');
legend('Z-mod scan','Slope derived from section',0);
title('Long cantilever calibration');

grad = (pos(234)-pos(258))/(v_pd(234)-v_pd(258));
C2 = abs(1/grad) %nm/V