close all;
shortnoise = load('thermalnoise2.txt');
conversion_factor = 0.0033; % nm/V
conversion_factor2 = conversion_factor*.1; %(Angstroms/V)
gain = 500;
f2 = shortnoise(:,1);
raw_specd = shortnoise(:,2); %V^2/hz
% specd = conversion_factor2^2*raw_specd; %A^2/hz
specd = conversion_factor2^2*raw_specd/gain; %A^2/hz

xdata = f2(25:end);
ydata = specd(25:end);

f_guess = 15000;
Q_guess = 30;
options=optimset('TolFun',1e-50,'tolX',1e-30);
p=lsqcurvefit('scaling',[f_guess Q_guess], xdata, ydata, [], [], options, ydata);

A=(transfunc(p,f2))\specd;

Gfit_long = A*transfunc(p,f2);

%%%%%%%%%%%%%%%%

shortnoise = load('shortnoise.txt');
% conversion_factor = 173.5826; %(nm/V)
conversion_factor = 0.0070;
conversion_factor2 = conversion_factor*.1; %(Angstroms/V)
f1 = shortnoise(:,1);
raw_specd = shortnoise(:,2); %V^2/hz
% specd = conversion_factor2^2*raw_specd; %A^2/hz
specd = conversion_factor2^2*raw_specd/1000; %A^2/hz, gain of 1000

xdata = f1(25:end);
ydata = specd(25:end);

f_guess = 15000;
Q_guess = 29;
options=optimset('TolFun',1e-50,'tolX',1e-30);
p=lsqcurvefit('scaling',[f_guess Q_guess], xdata, ydata, [], [], options, ydata);

A=(transfunc(p,f1))\specd;

Gfit_short = A*transfunc(p,f1);

%%%%%%%%%%%%%%%%

figure(1);
loglog(f1,Gfit_short,'r');
hold on;
loglog(f2,Gfit_long,'b');
legend('G(\omega), short cantilever','G(\omega), long cantilever',0);
xlabel('Frequency (hz)');
ylabel('Power spectral density (A/hz^2)');
title('Comparison of characteristic transfer functions of short and long cantilevers');