source('cims.R')


### get analysis for EXP3
infile='fullmodel.9APR.csv'
cims.3 = load_cims_model(infile)

### get analysis for EXP4
infile='exp2.10APR.csv'
cims.4 = load_cims_model(infile)

sd3 = cims.3$spars[,2:5]
sd4 = cims.4$spars[,2:5]




###test increase in sd.x
sigtest = data.frame(blur=factor(rep(c('no','mx'), each=16+21, times=2)), vi=factor(rep(c('hi','lo'), each=(16+21)*2)))
sigtest$subj = factor(rep(1:37, times=4))
sigtest$exp = factor(rep(c(rep(1, 16),rep(2,21)), 4))


sigtest$sdx = c(sd3[,1], sd4[,1], sd3[,2], sd4[,2], sd3[,3], sd4[,3], sd3[,4], sd4[,4])

library(ez)
anova1 = ezANOVA(data=sigtest, dv=.(sdx), wid=.(subj), within=.(blur, vi), between = .(exp), detailed=F, type=2)
print(anova1)


#### correlations across sigmas

allsd = rbind(sd3, sd4)

cor.test(allsd[,1], allsd[,3])
cor.test(allsd[,2], allsd[,4])


plot(allsd[,2], allsd[,4])
plot(allsd[,1], allsd[,3])

blurEffect = rowMeans(cbind(allsd[,2] - allsd[,1], allsd[,4] - allsd[,3]))
intelEffect = rowMeans(cbind(allsd[,3] - allsd[,1], allsd[,4] - allsd[,2])) 

cor.test(blurEffect, intelEffect)
plot(blurEffect, intelEffect)
#text(blurEffect, intelEffect, 1:37, pos=1)
#summary(lm(intelEffect ~ blurEffect))


#### par plot
pdf_sigPlot = to_pdf(sigPlot, w=3, h=2.5)
pdf_sigPlot(file='../figures/exp3_par_changes.pdf', sds=sd3)
pdf_sigPlot(file='../figures/exp4_par_changes.pdf', sds=sd4)


to_pdf = function(f, w, h)
{
	function (file, ...) {
		pdf(file=file, width=w, height=h)
		par(mar=rep(1,4))
		f(...)
		dev.off()
	}
}

sigPlot = function(sds, ylim=c(100, 175)) {
	ebar_plot(1:2, sds[,1:2], col='darkgreen', ylim=ylim, xlim=c(0.75,2.25), axes=F, ylab='', xlab='')
	ebar_plot(1:2, sds[,3:4], col='purple', overlay=T)
	axis(1, at=1:2, labels=F)
	axis(2, at=c(ylim, mean(ylim)), labels=F)
}


