source('basic_helper.R')

###Computes D = B - A, so that D > 0 means evidence for A
plotNegLL = function(negLL.A, negLL.B, col=c('orange', 'blue'))
{
	t = sort(negLL.B - negLL.A, index.return=T)
	idx = t$ix
	diff = t$x

	par(mar=c(1,.5,.5,1))
	clr = rep(col[1], length(diff))
	clr[diff < 0] = col[2]

	barplot(diff, axes=F, col=clr, horiz=T, xlim=c(min(-1, diff-1), max(diff)+1), xlab='Relative Log-Likelihood')

	axis(1, at=c(floor(min(diff)), 0, -round(min(diff)), ceiling(max(diff))))
	abline(v=0)
	
	return(list(idx=idx, diff=diff))
}

plotComparison = function(pC1, cims, gauss, type='RMSE', ylim=c(-10,55))
{
	yc = rep(0, nrow(pC1))
	yg = rep(0, nrow(pC1))		
	if(type == 'nLL'){
		yc = calcNegLL(pC1*MAX_COUNT, cims, N=MAX_COUNT)
		yg = calcNegLL(pC1*MAX_COUNT, gauss, N=MAX_COUNT)
	} else {
		for(i in 1:nrow(pC1)){
			yc[i] = rmsd.p(cims[i,]*MAX_COUNT, pC1[i,]*MAX_COUNT)
			yg[i] = rmsd.p(gauss[i,]*MAX_COUNT, pC1[i,]*MAX_COUNT)
		}
	}

	d = (yg - yc)
	colors = rep('blue', length(d))
	colors[d > 0 ] = 'orange'
	print(d)

	barplot(d, col=colors, axes=F, horiz=F, names.arg=F, border=NA, ylim=ylim)
	abline(h=0, col='black')
	axis(2, at = c(-10, 0, max(ylim), 55/2, 55))
	
	
	return(d)
}

barplot.mse_q = function (y, sem, col, ylim=c(0,1))
{
	a = barplot(y, col=col, names.arg=NA, horiz=F, axes=F, ylim=ylim, 	border=NA)

	for(i in 1:length(y))
		ebars.y(a[i], y[i], sem[i], lwd=2, col=col[i])
}

barplot.mse = function(mat, names=colnames(mat), col=c('orange', 'blue'), ylim=c(0,1), yat=c(0, 0.5, 1), axis.col='black', lwd=2, ...)
{
	m = m_sem(mat)
	
	a = barplot(m[,1], col=col, names.arg=NA, horiz=F, axes=F, ylim=ylim, border=NA, ...)

	axis(2, at=yat, labels=F, col=axis.col)
	axis(1, at=c(0:(ncol(mat)+1)), labels=F, lwd.ticks=0, , col=axis.col)
	
	for(i in 1:nrow(m))
		ebars.y(a[i], m[i,1], m[i,2], lwd=lwd, col=col[i], down=F)
		
		
	invisible(a)
}

plotIndividualWithFitted = function(x, y, yh1, yh2, col = c('black', 'orange', 'blue'), lty=1, ...)
{
	plotClean(x, y, col=col[1], lty=lty, ...)
	lines(x, yh1, col=col[2], lwd=3, lty=lty)
	lines(x, yh2, col=col[3], lwd=3, lty=lty)

	doAxes(labels=F)
}

doAxes = function(doX=T, doY=T, xAt=c(-300, 0, 300, 500), yAt=c(0, 0.5, 1), ...)
{
	if (doX) axis(1, at=xAt, ...)
	if (doY) axis(2, at=yAt, ...)
}

plotMeanWithFitted = function(x, ymat, yh1mat, yh2mat, col = c('black', 'orange', 'blue'), ylim=c(0,1), withAxes=T, lty=1, alpha.fit=255, border=NA, axis.col='black', poly=F, pch=1)
{
	yh1 = m_sem(yh1mat)
	yh2 = m_sem(yh2mat)

	#setup axes	
	plotClean(x, ymat[1,], ylim=ylim, col=col[1], type='n')
	if(withAxes) doAxes(labels=F, col=axis.col)

	#plot actual data with error bars
	ebar_plot(x, ymat, overlay=T, lwd=2, col=col[1], type='p', lty=lty, ebar.lwd=2, pch=pch)
	
	#fitted values as polygons
	if(poly) {
		ebar_polygon(x, yh1[,1], yh1[,2], col=getAlphaRGB(col[2], alpha.fit), border=border)
		ebar_polygon(x, yh2[,1], yh2[,2], col=getAlphaRGB(col[3], alpha.fit), border=border)
	} else {
		lines(x, yh1[,1], col=getAlphaRGB(col[2], alpha.fit), lwd=2, type='l', lty=lty)
		lines(x, yh2[,1], col=getAlphaRGB(col[3], alpha.fit), lwd=2, type='l', lty=lty)
	}
}

plotClean = function(x, y, ylim=c(0,1), ...)
{
	plot(x, y, xlab='', ylab='', axes=F, ylim=ylim, ...)
}

addFittedPoly = function(x, yhmat, col='red', alpha=.5*255, border=NA)
{
	yh1 = m_sem(yhmat)
	ebar_polygon(x, yh1[,1], yh1[,2], col=getAlphaRGB(col, alpha), border=border)
}


getSDCorr = function(pC, cims.fitted, doPlot=T, doPrint=T, doLine=T)
{
	## How did sensory noise change?
	iSD = cims.fitted[,10] - cims.fitted[,5]

	ad = rowMeans(pC[,16:17]) - rowMeans(pC[,1:2])
	vd = rowMeans(pC[,29:30]) - rowMeans(pC[,14:15])
	
	if(doPlot) {
		#stack for plotting
		
		r = range(c(ad, vd))
		
		plotClean(iSD,ad, ylim=r, xlim=range(iSD), col='navy')
		points(iSD, vd, col='deepskyblue')
		
		axis(2, at = c(r, 0, mean(r)), las=1)
		axis(1, at=c(0, range(iSD), mean(range(iSD))), labels=F)

		abline(h=0, lty=2)
		abline(v=0, lty=2)
			
		if(doLine) {
			abline(lm(ad ~ iSD), col='navy')
			abline(lm(vd ~ iSD), col='deepskyblue')
		}
	}
	
	if(doPrint) {
		print(cor.test(iSD, ad, method='spearman'))
		print(cor.test(iSD, vd, method='spearman'))
	}
}


SDRho_NoPrint = function(pC, cims)
{
	rhos = rep(0, 8)
	ps = rep(0, 8)

	### Effect of blurring
	iSD = cbind(cims[,10] - cims[,5], cims[,20] - cims[,15])
	ad = cbind(rowMeans(pC[,16:17]) - rowMeans(pC[,1:2]), rowMeans(pC[,46:47]) - rowMeans(pC[,31:32]))
	vd = cbind(rowMeans(pC[,29:30]) - rowMeans(pC[,14:15]), rowMeans(pC[,59:60]) - rowMeans(pC[,44:45]))

	rhos[1] = cor.test(iSD[,1], ad[,1], method='spearman')$estimate
	rhos[2] = cor.test(iSD[,1], vd[,1], method='spearman')$estimate
	rhos[3] = cor.test(iSD[,2], ad[,2], method='spearman')$estimate
	rhos[4] = cor.test(iSD[,2], vd[,2], method='spearman')$estimate
	
	ps[1] = cor.test(iSD[,1], ad[,1], method='spearman')$p.value
	ps[2] = cor.test(iSD[,1], vd[,1], method='spearman')$p.value
	ps[3] = cor.test(iSD[,2], ad[,2], method='spearman')$p.value
	ps[4] = cor.test(iSD[,2], vd[,2], method='spearman')$p.value

	## Effect of VI
	iSD = cbind(cims[,15] - cims[,5], cims[,20] - cims[,10])
	ad = cbind(rowMeans(pC[,31:33]) - rowMeans(pC[,1:3]), rowMeans(pC[,46:48]) - rowMeans(pC[,16:18]))
	vd = cbind(rowMeans(pC[,43:45]) - rowMeans(pC[,13:15]), rowMeans(pC[,58:60]) - rowMeans(pC[,28:30]))

	rhos[5] = cor.test(iSD[,1], ad[,1], method='spearman')$estimate
	rhos[6] = cor.test(iSD[,1], vd[,1], method='spearman')$estimate
	rhos[7] = cor.test(iSD[,2], ad[,2], method='spearman')$estimate
	rhos[8] = cor.test(iSD[,2], vd[,2], method='spearman')$estimate

	ps[5] = cor.test(iSD[,1], ad[,1], method='spearman')$p.value
	ps[6] = cor.test(iSD[,1], vd[,1], method='spearman')$p.value
	ps[7] = cor.test(iSD[,2], ad[,2], method='spearman')$p.value
	ps[8] = cor.test(iSD[,2], vd[,2], method='spearman')$p.value
	
	round(cbind(rhos, ps), 5)
	
	round(cbind(ad, vd), 5)
	
	plot(rhos, ps)
	
	t.test(vd[,2] - ad[,2])
}



catScatter = function(ymat, doMean=T, doMedian=T, col='darkgray', yR = c(0,1), pch=1, lbl=F, flag=c(0), fcol=rep('blue', length(flag)) ) 
{
	ymat = as.matrix(ymat)
	
	n = ncol(ymat)
	
	plot(c(1,n), c(0, max(ymat)), type='n', ylab='', xlab='', axes=F, ylim=yR)

	if (doMean) {
		for(i in 1:n) {
			ebar_plot(1:n, ymat, type='p', col='red', pch=19, overlay=T)
		}
		print(paste0('m: ', colMeans(ymat)))
	}

	if (doMedian) {
		medians = apply(ymat, 2, median)
		print(paste0('med: ', medians))

		for(i in 1:n) {
			points(i, medians[i], col='black', pch=19, cex=1)
		}
	}

	axis(1, at=1:n)
	axis(2, at=round(c(yR, colMeans(ymat), .5*max(yR)), 2),las=1)
	
	for(i in 1:n) {
		for(j in 1:nrow(ymat)) {
			.pch = pch
			.col = col
			if(sum(j == flag)) {
				.pch = 19
				.col = fcol[which(j == flag)]
			}
			
			points(i, ymat[j, i], col=.col, pch=.pch)
			if(lbl) {
				text(i, ymat[j,i], j, pos=2)
			}
		}
	}
}

parPlot = function(y1, y2, x=1:length(y1), ylim=c(0,1), ...)
{	
	ebar_plot(1:2, cims.fitted[,y1], col='darkgreen', xlim=c(0.75,2.25), axes=F, ylim=ylim, ...)
	ebar_plot(1:2, cims.fitted[,y2], col='purple', o=T, ...)
	axis(1, at = c(1,2))
	axis(2, at=c(min(ylim), median(ylim), max(ylim)), las=1)
	
	invisible(m_sem(cbind(cims.fitted[,y1], cims.fitted[,y2])))
}

