# ensure you've installed the parallel package
library('parallel')

#go to the right directory
setwd('~/Dropbox/CausalInferenceSpeechPaper/rcode')

# Load the fitting functions
source('cims.R')

# rows are subjects, columns are asynchronies, cells are counts
count_mat = read.csv(file='../data/exp1_count_matrix.csv')

# number of trials at each asynchrony
max_count = 12

# this must match the column order in count_mat
asyncs = c(-300, -267, -200, -133, -100, -67, 0, 67, 100, 133, 200, 267, 300, 400, 500)

#
# FITTING

# create a cluster to speed up computation
cl = makeCluster(detectCores())

# obtain CIMS fitted values
#sd2 = sd(asyncs[asyncs!=0])
#cims.model = cims(n.reps=2, sd2=sd2)
cims.model = load_cims_model('fullmodel.9APR.csv')
# obtain Gaussian fitted values
gauss.model = gauss()

#
# ANALYSES
within_condition_tests(cims.model, gauss.model)
across_condition_tests(cims.model, gauss.model)
