#--Within-Condition Comparisons--#
within_condition_tests = function(cims.model, gauss.model)
{
	# calculate nLL for each model in each condition
	nLL.c = - logLik(cims.model, separate=T)
	nLL.g = - logLik(gauss.model, separate=T)
	
	colnames(nLL.c) = paste('CIMS_nLL', 1:.k, sep='.')
	colnames(nLL.g) = paste('GAUSS_nLL', 1:.k, sep='.')
	
	cat('\n\n##Mean and SEM for nLL:\n')
	print(m_sem(cbind(nLL.c, nLL.g)))

	# get mean difference per condition
	nLL.d = nLL.g - nLL.c
	colnames(nLL.d) = paste('G_minus_C_nLL', 1:.k, sep='.')
	cat('\n\n##Mean and SEM for nLL difference\n')
	print(m_sem(nLL.d))

	# get the odds ratios from the mean nLL per condition
	cat('\n\n##Odds-ratios per condition, >1 favors CIMS\n')
	or = as.matrix(exp(colMeans(nLL.d)))
	row.names(or) = paste('Condition', 1:.k, sep='.')
	colnames(or) = 'Odds-Ratio'
	print(or)
	
	cat('\n')
}

#--Overall Comparisions--#
across_condition_tests = function(cims.model, gauss.model)
{
	# BIC
	bics =cbind(BIC(cims.model), BIC(gauss.model))
	colnames(bics) = paste(c("CIMS", "GAUSS"), "BIC", sep=".")
	
	cat('\n\n##Mean and SEM BIC values:\n')
	print(m_sem(bics))
	
	cat('\n\n##Mean and SEM BIC difference, > 0 favors CIMS:\n')
	print(m_sem(bics[,2] - bics[,1]))
	

	cat('\n\n##Range of BIC difference, > 0 favors CIMS:\n')	
	print(range(BIC(gauss.model)-BIC(cims.model)))

	cat('\n\n##Testing BIC...\n')
	print(wilcox.test(BIC(gauss.model) - BIC(cims.model)))

	cat('\n\n##Testing RMSD...\n')
	# RMSD from Massaro
	# get predictions from both models
	gauss.p = predict(gauss.model)
	cims.p = predict(cims.model)

	rmsd.c = sapply(seq(n.sub), function(i) rmsd(cims.p[i,]*max_count, count_mat[i,], 5 + 2/n.sub))
	rmsd.g = sapply(seq(n.sub), function(i) rmsd(gauss.p[i,]*max_count, count_mat[i,], 8))
	print(t.test(rmsd.g - rmsd.c))
}
