logLik.gauss = function(object, ..., separate=F)
{
	n = nrow(count_mat)
	gauss.p = predict(object)

	ll = array(0, c(n, .k))
	for(i in 1:.k) {
		ll[,i] = rowSums(LL.binomial(gauss.p[,.idx[,i]], count_mat[,.idx[,i]], max_count))
	}

	if(!separate) {
		ll = rowSums(ll)
		n = max_count*ncol(count_mat)
		attributes(ll) = list(df = (2/3) * ncol(object), nobs=n, nall=n)
		class(ll) = 'logLik'
	}
	
	return (ll)
}

negLL.gauss = function(y, msd)
{
	p = pred.gauss(asyncs, msd)
	ll = LL.binomial(p, y, max_count)
	
	return(-sum(ll))
}

pred.gauss = function(x, msd)
{
	if(msd[2] < 1e-6) {
		msd[2] = 1e-6
	}
	
	p = dnorm(x, msd[1], msd[2])
	p = p / max(p)

	#handle [max(p) == 0] edge case
	p[is.na(p)] = 0

	return(p)
}

gauss = function()
{
	setupClust()

	fitted = t(array(parRapply(cl, count_mat, gauss.fit, asyncs=asyncs), c(3*.k, nrow(count_mat))))

	colnames(fitted) = paste(rep(c('mean', 'sd', 'nLL'), .k), rep(1:.k, each=3), sep='_')
	row.names(fitted) = row.names(count_mat)
	class(fitted) = 'gauss'
	
	invisible(fitted)
}

# does a bit of preprocessing before fitting
gauss.fit = function(counts, asyncs)
{
	source("cims.R")

	cmat = array(as.numeric(counts), dim=c(length(asyncs), .k))

	# fit a model for each column
	results = apply(cmat, 2, .gauss.fit)
	
	# return c(...) to flatten results matrix
	return(c(results))
}

# does the actual fitting
.gauss.fit = function(counts, rMu=c(0,200), rSD=c(10, 450), n.reps=256)
{
	guesses = cbind(runif(n.reps, rMu[1], rMu[2]), runif(n.reps, rSD[1], rSD[2]))
	res = apply(guesses, 1, optim, fn=negLL.gauss, y=counts) 

	idx = which.min(sapply(res, function(x)x$value))

	pars = res[[idx]]$par
	nLL = res[[idx]]$value

	return(c(mean=pars[1], sd=pars[2], nLL=nLL))
}

predict.gauss = function(object, ...)
{
	rem.idx = seq(3, .k*3, by=3)
	pars = object[,-rem.idx]
	
	pred = array(0, c(nrow(count_mat), .k*length(asyncs)))
	for(i in 1:.k) {
		j = (i-1)*2 + 1
		pred[,.idx[,i]] = t(apply(pars[,j:(j+1)], 1, pred.gauss, x=asyncs))
	}

	return(pred)
}


