########Common functions and plotting helpers########

###Ebar function
ebars = function (x, y, sem, length=0.05, ...)
{
    ebars.y(x, y, sem, length, ...)
}

ebars.x = function(x, y, sem, length=0.05, ...)
{
	arrows(x-sem, y, x+sem, y, angle=90, code=3,length=length, ...)
}

ebars.y = function(x, y, sem, length=0.05, up=T, down=T, ...)
{
	if(up) {
		arrows(x0=x, y0=as.numeric(y), y1=as.numeric(y+sem), angle=90, code=2,length=length, ...)
	}
	if(down) {
		arrows(x0=x, y0=as.numeric(y), y1=as.numeric(y-sem), angle=90, code=2,length=length, ...)
	}
}

ebar_polygon = function(x, y, sem, col, border=NA)
{
	polygon(c(x, rev(x)), c(y+sem, rev(y-sem)), border=border, col=col)
}

simpleBars = function(heights, col=c('blue', 'darkgreen', 'gray', 'black'), ...) {

	barplot(heights, col=col, border=NA, axes=F, axisnames=F, ...)
	axis(2, labels=F, at = c(0, .5*max(heights), max(heights)))
}

m_sem = function (mat) {
	mat = as.matrix(mat)
	res = cbind(colMeans(mat, na.rm=T), apply(mat, 2, se))

	colnames(res) = rep(c('mean', 'sem'), length.out=ncol(res))
	
	return (res)
}

se = function(x) {
	d = sqrt(sum(!is.na(x)))
	return (sd(x, na.rm=T) / d)
}


#Plots line with error bars, each column is point
ebar_plot = function (x, mat, overlay=F, type='o', lwd=3, col='black', ebar.lwd=(lwd-1), ...)
{
	summ = m_sem(mat)

	if (overlay==F) {
		plot(x, summ[,1], type=type, lwd=lwd, col=col,...)
	} else {
		lines(x, summ[,1], type=type, lwd=lwd, col=col, ...)
	}

	ebars.y(x, summ[,1], summ[,2], lwd=ebar.lwd, col=col)
	
	invisible(summ)
}

plotManyLines = function(x, mat, col='black', ...)
{	
	plot(x, mat[1,], type='n', ...)
	for(i in 1:nrow(mat))
		lines(x, mat[i,], col=col)
}

getAlphaRGB = function(colname, alpha)
{
	c = col2rgb(colname)
	rgb(c[1], c[2], c[3], alpha, maxColorValue=255)
}

poly = function(x,lower, upper, col='gray', ...)
{
	lower = rep(lower, length.out=length(x))
	upper = rep(upper, length.out=length(x))
	polygon(c(x, rev(x)), c(upper, rev(lower)), col=col, ...)
}

bplot = function (x, heights, sems, width, col = rep('gray', length(heights)), base=rep(0, length.out=length(heights)))
{
	for(i in 1:length(heights)) {
		xp = c(x[i] - width, x[i] + width)	
		poly(xp, base[i], heights[i], col[i], border=NA)	
	}
	ebars(x, heights, sems, col=col, lwd=3)
}

barplot.group = function(y1, y2, col=c('orange', 'blue'))
{
	col = rep(col, length.out=ncol(y1) + ncol(y2))
	
	m1 = m_sem(y1)
	m2 = m_sem(y2)
	
	a = barplot(t(cbind(m1[,1], m2[,1])), beside=T, col=col, names.arg=ASYNCS, xlim=c(1,40), space=c(0,.75), border=F, ylim=c(0,.06))
	
	for(i in 1:nrow(m1)) {
		ebars.y(a[1,i], m1[i,1], m1[i,2], lwd=2, col=col[1], down=F)	
		ebars.y(a[2,i], m2[i,1], m2[i,2], lwd=2, col=col[2], down=F)	
	}
}

stack.plot = function(group, y, col, xAt=c(0, 10, 20, 30, 40), ...)
{
	groups = sort(unique(group))
	y.uni = sort(unique(y))
	counts = sapply(y.uni, function(g) max(sum(y[group==groups[1]]==g, na.rm=T), sum(y[group==groups[1]]==g, na.rm=T)))
	plot(range(y.uni, na.rm=T), range(c(0, 5+counts), na.rm=T), type='n', axes=F, ylab='', xlab='', ...)
	axis(1, at=xAt, labels=F)
	for( i in 1:length(groups)) {
		yg = y[group == groups[i]]
		y.uni = sort(unique(yg))
		counts = sapply(y.uni, function(g) sum(yg==g, na.rm=T))
	
		putStack(y.uni, counts, col=col[i])	
		
		abline(v=median(rep(y.uni, counts)), col=col[i], lwd=3)
	}
}

putStack = function(y.uni, counts, col, pch=20)
{
	for(i in 1:length(counts)) {
		points(rep(y.uni[i], counts[i]), 1:counts[i], col=col, pch=pch)
	}
}
