load("estBoot-post.RData")

print("Ests for text description of baseline:")

#lapply(estData$fit$admb$coeflist, function(x) x[1])
lapply(estData$fit$admb$coeflist, function(x) exp(x[1]))
exp(res_tab[, c("hat_ctr.1_bootLower", "hat_ctr.1_bootUpper")])
res_tab[, c("hat_ctr.1_bootLower_se", "hat_ctr.1_bootUpper_se")]
exp(res_tab[, c("hat_cgr.1_bootLower", "hat_cgr.1_bootUpper")])
res_tab[, c("hat_cgr.1_bootLower_se", "hat_cgr.1_bootUpper_se")]

exp(estData$ip_fit$coefs["(Intercept)", "Estimate"])
exp(res_tab[, c("hat_.Intercept._bootLower", "hat_.Intercept._bootUpper")])
res_tab[, c("hat_.Intercept._bootLower_se", "hat_.Intercept._bootUpper_se")]

estData$ip_fit$disp
res_tab[, c("hat_disp_bootLower", "hat_disp_bootUpper")]
res_tab[, c("hat_disp_bootLower_se", "hat_disp_bootUpper_se")]

print("All estimates for table:")

pointEsts <- estData$fit$admb$coeflist
pointEsts$ip <- c(unname(coef(estData$ip_fit$m)), estData$ip_fit$disp)
               
tmpf <- function(subPattern){
  paster <- function(x) {
     paste('^hat_', subPattern, x, sep='')
  }
  endings <- list(lower='.*_bootLower$', upper='.*_bootUpper$')
  pattern <-lapply(endings, paster) 
  ind <- lapply(pattern, grep, x=names(res_tab))
  # We're assuming the values are ordered from left-to-right with the names
  vals <- lapply(ind, function(x) as.numeric(res_tab[, x]))
  do.call(cbind.data.frame, vals)  
}
subPatterns <- list(tr='ctr', gr='cgr', ip='[^(ctr)(cgr)]')
bounds <- lapply(subPatterns, tmpf)

tmpf <- function(x,point) cbind(x, point)
ests <- mapply(tmpf, x=bounds, point=pointEsts, SIMPLIFY=FALSE)

nms <- estData$coefnames
nms$ip <- c(names(coef(estData$ip_fit$m)), 'dispersion')

tmpf <- function(rn, df) {
  rownames(df) <- rn
  df
}
ests <- mapply(tmpf, rn=nms, df=ests, SIMPLIFY=FALSE)

library(texreg)

tmpf <- function(df){
  tr <- createTexreg(
          coef.names = rownames(df),
          coef = df$point,
          se = df$lower,
          gof.names = c("Num. obs.", "Log Likelihood"),
          gof = c(0, 0),
          gof.decimal = c(FALSE, TRUE))
  tr
}
trl <- lapply(ests, tmpf)

ccnms <- c('(Intercept)', 'LTCF', 'small', 'spring-summer', 'staff', 'dispersion')
cmnms <- c('transmission rate', 'initial growth rate', 'symptomatic period')
texreg(trl, file='tab_est.tex', single.row=T, stars=numeric(0), custom.model.names=cmnms,
          custom.coef.names=ccnms)

tmpf <- function(y) apply(y, 2, function(x) round(x, 2))[, c('point', 'lower', 'upper')]
lapply(ests, tmpf)
