#!/usr/bin/Rscript --vanilla

library(plyr)
library(ggplot2)
library(AvonData)
library(EpiGLM)

data("case-records-filtered")
data("staticData")

J <- ddply(paso, .(OutbreakNumber), summarise,
           OutbreakNumber=OutbreakNumber,
           xmin=infective_start,
           xmax=recovered_start,
           isSeed=infective_start==min(infective_start),
           CaseID=rank(infective_start*1e4 + symp_imp,
             ties.method="random"))

J2 <- ddply(J, .(OutbreakNumber), transform,
            ymin=CaseID - sum(isSeed) - 1,
            ymax=CaseID - sum(isSeed))

facet_data <- ddply(J, .(OutbreakNumber), summarize,
                    nInfected =length(xmin) - sum(isSeed),
                    duration = max(xmax))

grid_rows <- 9
size_ranks <- with(facet_data, rank(nInfected, ties="random"))
facet_data$size_class <- with(facet_data, cut(size_ranks, breaks=grid_rows))
facet_data <- ddply(facet_data, .(size_class), transform,
                   col_no=rank(duration, ties="random"))

J3 <- join(J2,
           facet_data[,c("OutbreakNumber", "col_no", "size_class")],
           by="OutbreakNumber")
J3 <- join(J3, xx4[, c("facility", "OutbreakNumber")], by="OutbreakNumber")

xscale <- 7
g <- ggplot(data=J3)
g <- g + geom_rect(aes(xmin=xmin/xscale, xmax=xmax/xscale,
                       ymin=ymin, ymax=ymax, fill=facility, color=facility))
g <- g + labs(x="\nTime (weeks)", y="Case ID number")
g <- g + geom_hline(yintercept=0, linetype=1, size=0.1)
g <- g + scale_y_continuous(breaks=seq(from=-30, to=80, by=10))
g <- g + scale_x_continuous(breaks=seq(from=0, to=40, by=2))
g <- g + scale_color_grey() + scale_fill_grey()
g <- g + facet_grid(size_class ~ col_no, space='free', scales='free')
g <- g + theme_bw(base_size=12)
g <- g + theme(
       strip.text.x=element_blank(),
       strip.text.y=element_blank(),
       strip.background=element_blank(),
       legend.position="none",
       plot.background = element_blank(),
       panel.grid.major = element_blank(),
       panel.grid.minor = element_blank(),
       panel.border = element_blank(),
       panel.background = element_blank())
g <- g + theme(axis.line = element_line(color = 'black'))

#g <- g + opts(axis.text.x=theme_text(angle=90, hjust=1, size=the_pointsize*0.8))
#g <- g + opts(panel.margin = unit(0.5, "lines"))
#g <- g + opts(plot.margin=unit(c(-0.125, -0.25, -0.25, -0.125), "lines"))
ggsave(g, filename="cases.eps", pointsize=12, width=5.5, height=5.5)
