library(EpiGLM)
library(plyr)
library(ggplot2)

simpleStyle <- function(g){
  g <- g + theme_bw(base_size=12)
  g <- g + theme(panel.grid.minor=element_blank())
  g <- g + theme(panel.grid.major=element_blank())
  g <- g + theme(panel.background=element_blank())
  g <- g + theme(strip.background=element_blank())
  g <- g + theme(panel.border=element_blank())
  g <- g + theme(axis.line=element_line())
  g <- g + theme(strip.text.y=element_text())
  g
}

data(estData)
load('estBoot-reduction.RData')

predNames <- c('facility', 'is_small', 'season', 'CaseType')
predictions <- xx4[, c('outbreak_code', predNames)]

tmpf <- function(x) any(is.na(x))
test <- apply(predictions, 1, tmpf)
## Rows with missing predictors will not have any predictions
predictions <- predictions[!test,]

mmat <- model.matrix(~1 + facility + is_small + season + CaseType,
                           data=predictions)

predictions$tr <- mmat %*% estData$fit$admb$coeflist$ctr
predictions$gr <- mmat %*% estData$fit$admb$coeflist$cgr
predictions$ip <- mmat %*% coef(estData$ip_fit$m)

data('case-records-filtered', package='AvonData')

test <- !is.na(paso$symp_obs)
symps <- paso[test, c('outbreak_code', 'symp_obs')]

get_cum_hazard <- function(piece){
  function(time) {
    test <- piece$recovered_start < time
    end <- ifelse(test, piece$recovered_start, time)
    dif <- end - piece$infective_start
    if (any(dif > 0)) {
        ret <- sum(dif[dif > 0])
        ret <- unname(ret)
    }
    else {
        ret <- 0
    }
    ret
  }
}

tmpf <- function(piece){
  latent_period <- 1L
  ch <- get_cum_hazard(piece)
  latent_start <- piece$infective_start - latent_period
  test <- latent_start > min(latent_start)
  latent_start <- latent_start[test]
  exposure <- sapply(latent_start, ch)
  data.frame(OutbreakNumber=piece$OutbreakNumber[test],
             outbreak_code=piece$outbreak_code[test],
             exposure=exposure)
}
exposures <- ddply(paso, 'OutbreakNumber', tmpf)

splt <- split(exposures, exposures$outbreak_code, drop=TRUE)

codes <- intersect(predictions$outbreak_code, names(splt))
splt <- splt[codes]

key <- match(codes, predictions$outbreak_code)
preds <- predictions[key,]

getExposureQuantiles <- function(df, gr, tr){
  X0 <- round(exp(gr - tr))*1.01
  qData <- sort(df$exposure)
  pData <- seq_along(qData) / X0
  delt <- diff(c(0, pData))
  n <- length(delt)
  pDataContinuous <- pData - delt * runif(n)  
  qTheory <- qexp(pDataContinuous, rate=exp(tr))
  pTheory <- pexp(qData, rate=exp(tr))
  res <- data.frame(qTheory=qTheory, pTheory=pTheory,
                    qData=qData, pData=pData,
                    pDataContinuous=pDataContinuous)
  res
}
qqdata <- mapply(getExposureQuantiles, df=splt, gr=preds$gr, tr=preds$tr,
                 SIMPLIFY=FALSE)

qqdf <- do.call(rbind, qqdata)
hist(qqdf$pTheory)

rows <- vapply(qqdata, nrow, integer(1))
inds <- seq_len(nrow(preds))
inds <- rep(inds, rows)
qqdf$outbreak_code <- preds$outbreak_code[inds]

g <- ggplot(data=qqdf, aes(x=qTheory, y=qData, group=outbreak_code))
g <- g + geom_line(alpha=0.1)
g <- g + geom_point(alpha=0.1)
g <- g + geom_abline(intercept=0, slope=1)
g <- g + ylab('Observed exposure before infection\n')
g <- g + xlab('\nExpected exposure before infection')
g <- simpleStyle(g)

ggsave(g, filename="qq-exposure.eps",
       device=grDevices::cairo_ps, pointsize=12, width=5.5, height=5.5)

## qq plot for symptomatic period

splt <- split(symps, symps$outbreak_code, drop=TRUE)

codes <- intersect(predictions$outbreak_code, names(splt))
splt <- splt[codes]

key <- match(codes, predictions$outbreak_code)
preds <- predictions[key,]

disp <- estData$ip_fit$disp
getSymptomaticPeriodQuantiles <- function(df, ip){
  mu <- exp(ip)
  qData <- sort(df$symp_obs)
  pData <- seq_along(qData) / nrow(df)
  delt <- diff(c(0, pData))
  pDataContinuous <- pData - delt * runif(delt)
  qDataContinuous <- qData + runif(qData)
  qTheory <- qgamma(pDataContinuous, shape=1/disp, scale = mu * disp)
  pTheory <- pgamma(qDataContinuous, shape=1/disp, scale = mu * disp)
  res <- data.frame(qTheory=qTheory, pTheory=pTheory,
                    qData=qData, pData=pData,
                    qDataContinuous=qDataContinuous,
                    pDataContinuous=pDataContinuous)
  res
}
qqdata <- mapply(getSymptomaticPeriodQuantiles, df=splt, ip=preds$ip,
                 SIMPLIFY=FALSE)

qqdf <- do.call(rbind, qqdata)
hist(qqdf$pTheory)

rows <- vapply(qqdata, nrow, integer(1))
inds <- seq_len(nrow(preds))
inds <- rep(inds, rows)
qqdf$outbreak_code <- preds$outbreak_code[inds]

g <- ggplot(data=qqdf, aes(x=qTheory, y=qData, group=outbreak_code))
g <- g + geom_line(alpha=0.1)
g <- g + geom_point(alpha=0.1)
g <- g + geom_abline(intercept=0, slope=1)
g <- g + ylab('Observed symptomatic period\n')
g <- g + xlab('\nExpected symptomatic period')
g <- simpleStyle(g)

ggsave(g, filename="qq-symptomatic.eps",
       device=grDevices::cairo_ps, pointsize=12, width=5.5, height=5.5)

## Plot observed and expected incidence

splt <- split(exposures, exposures$outbreak_code, drop=TRUE)

codes <- intersect(predictions$outbreak_code, names(splt))
splt <- splt[codes]

key <- match(codes, predictions$outbreak_code)
preds <- predictions[key,]

getObservedExpectedCases <- function(df, tr, gr){
  beta <- exp(tr)
  X0 <- round(exp(gr - tr))
  transTimeTally <- rle(sort(df$exposure))
  intervals <- diff(c(0, transTimeTally$values))
  observedCases <- transTimeTally$lengths
  n <- length(observedCases)
  nSusceptible <- X0 - c(0, cumsum(observedCases)[-n])
  expectedCases <- intervals * beta * nSusceptible
  res <- data.frame(expectedCases=expectedCases, observedCases=observedCases,
                    cumExpectedCases=cumsum(expectedCases),
                    cumObservedCases=cumsum(observedCases))
  res[order(res$cumExpectedCases), ]
}
qqdata <- mapply(getObservedExpectedCases, df=splt, tr=preds$tr, gr=preds$gr,
                 SIMPLIFY=FALSE)

qqdf <- do.call(rbind, qqdata)

rows <- vapply(qqdata, nrow, integer(1))
inds <- seq_len(nrow(preds))
inds <- rep(inds, rows)
qqdf$outbreak_code <- preds$outbreak_code[inds]

g <- ggplot(data=qqdf, aes(x=cumExpectedCases, y=cumObservedCases, group=outbreak_code))
g <- g + geom_line(alpha=0.1)
g <- g + geom_point(alpha=0.1)
g <- g + geom_abline(intercept=0, slope=1)
g <- g + ylab('Observed number of cases\n')
g <- g + xlab('\nExpected number of cases')
g <- simpleStyle(g)

ggsave(g, filename="obs-vs-exp-counts.eps",
       device=grDevices::cairo_ps, pointsize=12, width=5.5, height=5.5)

q('no')
