library(plyr)
library(reshape2)
library(ggplot2)
library(AvonData)

load("estBoot-reduction.RData")

predNames <- c('facility', 'is_small', 'season', 'CaseType')
predictors <- xx4[, predNames]
dups <- duplicated(predictors)
predUniq <- predictors[!dups, ]
containsMissing <- function(x) any(is.na(x))
nas <- apply(predUniq, 1, containsMissing)
predClean <- predUniq[!nas, ]

mmatUnique <- model.matrix(~1 + facility + is_small + season + CaseType,
                           data=predClean)

tmpf <- function(x) paste(x, 1:5, sep=".")
cNames <- lapply(c(tr="hat_ctr", gr="hat_cgr"), tmpf)
cNames$ip <- c("hat_.Intercept.", "hat_facility2", "hat_is_smallTRUE",
               "hat_seasonspring.summer", "hat_CaseTypestaff")


tmpf <- function(x) {
  ests <- reduction[, x]
  ests <- data.matrix(ests)
  mmatUnique %*% t(ests)
}
preds <- lapply(cNames, tmpf)
preds$R0 <- preds$gr + preds$ip

R0 <- exp(preds$R0)
bar <- aggregate(x=R0, by=predClean[, c('facility', 'is_small', 'season')],
                 FUN=sum)

baz <- melt(bar, id=c('facility', 'is_small', 'season'))

dat <- ddply(baz, c('facility', 'is_small', 'season'), summarize,
             lower=quantile(value, probs=.25, na.rm=TRUE),
             upper=quantile(value, probs=.95, na.rm=TRUE))

data(estData, package='EpiGLM')
stopifnot(colnames(mmatUnique) == estData$coefnames$mmat_gr)
foo <- mmatUnique %*% estData$fit$admb$coeflist$cgr

stopifnot(colnames(mmatUnique) == names(coef(estData$ip_fit$m)))
bar <- mmatUnique %*% coef(estData$ip_fit$m)

R0 <- exp(foo + bar)
pointEsts <- aggregate(R0, by=predClean[, c('facility', 'is_small', 'season')],
                       FUN=sum)
tab <- merge(dat, pointEsts)
ord <- order(as.integer(tab$facility) *-1, tab$season, tab$is_small * -1)
tab <- tab[ord,]
tab <- with(tab, data.frame(facility=facility, season=season,
                            is_small=is_small, R0=V1, lower=lower,
                            upper=upper))

spruceLabels <- function(df){
  df$facility <- factor(df$facility, levels=2:1, labels=c("LTCF", "Hospital"))
  df$is_small <- factor(df$is_small, levels=c(TRUE, FALSE),
                         labels=c('Small', 'Large'))
  df
}
tab <- spruceLabels(tab)

cleanf <- function(x){
    ## source: http://stackoverflow.com/q/5465314/548147
    oldx <- c(FALSE, x[-1]==x[-length(x)])
      ## is the value equal to the previous?
      res <- x
      res[oldx] <- NA
      return(res)
  }
tab$facility <- cleanf(tab$facility)
tab$facility <- factor(tab$facility,
                       levels=c('LTCF', 'Hospital'),
                       labels=c('LTCF', 'hospital'))
tab$season <- cleanf(tab$season)
tab$is_small <- factor(tab$is_small,
                       levels=c('Small', 'Large'),
                       labels=c('small', 'large'))

colnames(tab)[3] <- 'size class'
xtab <- xtable::xtable(tab)
print(xtab, include.rownames=FALSE, file='tab_R0_predictions.tex')
